/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.xmss;

import org.bouncycastle.pqc.crypto.xmss.WOTSPlusParameters;
import org.bouncycastle.pqc.crypto.xmss.XMSSUtil;

final class WOTSPlusSignature {
    private byte[][] signature;

    protected WOTSPlusSignature(WOTSPlusParameters params, byte[][] signature) {
        if (params == null) {
            throw new NullPointerException("params == null");
        }
        if (signature == null) {
            throw new NullPointerException("signature == null");
        }
        if (XMSSUtil.hasNullPointer(signature)) {
            throw new NullPointerException("signature byte array == null");
        }
        if (signature.length != params.getLen()) {
            throw new IllegalArgumentException("wrong signature size");
        }
        int i = 0;
        while (i < signature.length) {
            if (signature[i].length != params.getDigestSize()) {
                throw new IllegalArgumentException("wrong signature format");
            }
            ++i;
        }
        this.signature = XMSSUtil.cloneArray(signature);
    }

    public byte[][] toByteArray() {
        return XMSSUtil.cloneArray(this.signature);
    }
}

