/*
 * Decompiled with CFR 0.152.
 */
package org.nick.abe;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Console;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.params.KeyParameter;

public class AndroidBackup {
    private static final int BACKUP_MANIFEST_VERSION = 1;
    private static final String BACKUP_FILE_HEADER_MAGIC = "ANDROID BACKUP\n";
    private static final int BACKUP_FILE_V1 = 1;
    private static final int BACKUP_FILE_V2 = 2;
    private static final int BACKUP_FILE_V3 = 3;
    private static final int BACKUP_FILE_V4 = 4;
    private static final String ENCRYPTION_MECHANISM = "AES/CBC/PKCS5Padding";
    private static final int PBKDF2_HASH_ROUNDS = 10000;
    private static final int PBKDF2_KEY_SIZE = 256;
    private static final int MASTER_KEY_SIZE = 256;
    private static final int PBKDF2_SALT_SIZE = 512;
    private static final String ENCRYPTION_ALGORITHM_NAME = "AES-256";
    private static final SecureRandom random = new SecureRandom();

    private AndroidBackup() {
    }

    private static void require_jceu() {
        int maxKeyLen = -1;
        try {
            maxKeyLen = Cipher.getMaxAllowedKeyLength("AES");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        if (maxKeyLen < 256) {
            System.err.println("Password is set but strong AES encryption is not allowed\nPlease install Java Cryptography Extension (JCE) Unlimited Strength Jurisdiction Policy Files 7 or 8\nhttp://www.oracle.com/technetwork/java/javase/downloads/jce-7-download-432124.html\nhttp://www.oracle.com/technetwork/java/javase/downloads/jce8-download-2133166.html\nExiting.");
            System.exit(1);
        }
    }

    public static String requirePassword(String password) throws IOException {
        if (password == null || "".equals(password)) {
            Console console = System.console();
            if (console != null) {
                System.err.println("Backup encrypted, enter password (will NOT be displayed):");
                password = new String(console.readPassword("Password:", new Object[0]));
            } else {
                String input;
                System.err.println("Backup encrypted, enter password (will be displayed):");
                System.err.print("Password:");
                BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
                password = input = reader.readLine();
                reader.close();
            }
            if (password == null || "".equals(password)) {
                System.err.println("Password is required but null or empty was read. Exiting.");
                System.exit(1);
            }
        }
        return password;
    }

    public static void infoBackup(String backupFilename, String password, boolean debug) {
        try {
            boolean isCompressed;
            String magic;
            InputStream rawInStream = AndroidBackup.getInputStream(backupFilename);
            CipherInputStream cipherStream = null;
            long abfileSizelong = new File(backupFilename).length();
            if (debug) {
                System.err.printf("\"%s\" size is %d bytes\n", backupFilename, abfileSizelong);
            }
            if ((magic = AndroidBackup.readHeaderLine(rawInStream)).equals("MIUI BACKUP")) {
                String line2 = AndroidBackup.readHeaderLine(rawInStream);
                String line3 = AndroidBackup.readHeaderLine(rawInStream);
                String line4 = AndroidBackup.readHeaderLine(rawInStream);
                String line5 = AndroidBackup.readHeaderLine(rawInStream);
                if (debug) {
                    System.err.println("Magic: " + magic);
                    System.err.println("Header segment 2 (unknown purpose): " + line2);
                    String package_id_name = new String(line3.getBytes("iso8859-1"), "UTF-8");
                    System.err.println("Package ID + display name in the device's language at the time of backup: " + package_id_name);
                    System.err.println("Header segment 4 (unknown purpose): " + line4);
                    System.err.println("Header segment 5 (unknown purpose): " + line5);
                }
                magic = AndroidBackup.readHeaderLine(rawInStream);
            }
            if (debug) {
                System.err.println("Magic: " + magic);
            }
            if (!magic.equals("ANDROID BACKUP")) {
                System.err.println("Invlaid Magic: " + magic);
                throw new IllegalArgumentException("Invalid Magic " + magic);
            }
            String versionStr = AndroidBackup.readHeaderLine(rawInStream);
            if (debug) {
                System.err.println("Version: " + versionStr);
            }
            int version = Integer.parseInt(versionStr);
            String compressed = AndroidBackup.readHeaderLine(rawInStream);
            boolean bl = isCompressed = Integer.parseInt(compressed) == 1;
            if (debug) {
                System.err.println("Compressed: " + compressed);
            }
            String encryptionAlg = AndroidBackup.readHeaderLine(rawInStream);
            if (debug) {
                System.err.println("Algorithm: " + encryptionAlg);
            }
            boolean isEncrypted = false;
            if (encryptionAlg.equals(ENCRYPTION_ALGORITHM_NAME)) {
                isEncrypted = true;
                AndroidBackup.require_jceu();
                password = AndroidBackup.requirePassword(password);
                String userSaltHex = AndroidBackup.readHeaderLine(rawInStream);
                byte[] userSalt = AndroidBackup.hexToByteArray(userSaltHex);
                if (userSalt.length != 64) {
                    throw new IllegalArgumentException("Invalid salt length: " + userSalt.length);
                }
                String ckSaltHex = AndroidBackup.readHeaderLine(rawInStream);
                byte[] ckSalt = AndroidBackup.hexToByteArray(ckSaltHex);
                int rounds = Integer.parseInt(AndroidBackup.readHeaderLine(rawInStream));
                String userIvHex = AndroidBackup.readHeaderLine(rawInStream);
                String masterKeyBlobHex = AndroidBackup.readHeaderLine(rawInStream);
                Cipher c = Cipher.getInstance(ENCRYPTION_MECHANISM);
                SecretKey userKey = AndroidBackup.buildPasswordKey(password, userSalt, rounds, false);
                byte[] IV = AndroidBackup.hexToByteArray(userIvHex);
                IvParameterSpec ivSpec = new IvParameterSpec(IV);
                c.init(2, (Key)new SecretKeySpec(userKey.getEncoded(), "AES"), ivSpec);
                byte[] mkCipher = AndroidBackup.hexToByteArray(masterKeyBlobHex);
                byte[] mkBlob = c.doFinal(mkCipher);
                int offset = 0;
                byte len = mkBlob[offset++];
                IV = Arrays.copyOfRange(mkBlob, offset, offset + len);
                if (debug) {
                    System.err.println("IV: " + AndroidBackup.toHex(IV));
                }
                offset += len;
                len = mkBlob[offset++];
                byte[] mk = Arrays.copyOfRange(mkBlob, offset, offset + len);
                if (debug) {
                    System.err.println("MK: " + AndroidBackup.toHex(mk));
                }
                offset += len;
                len = mkBlob[offset++];
                byte[] mkChecksum = Arrays.copyOfRange(mkBlob, offset, offset + len);
                if (debug) {
                    System.err.println("MK checksum: " + AndroidBackup.toHex(mkChecksum));
                }
                boolean useUtf = version >= 2;
                byte[] calculatedCk = AndroidBackup.makeKeyChecksum(mk, ckSalt, rounds, useUtf, debug);
                if (debug) {
                    System.err.printf("Calculated MK checksum (use UTF-8: %s): %s\n", useUtf, AndroidBackup.toHex(calculatedCk));
                }
                if (!Arrays.equals(calculatedCk, mkChecksum)) {
                    if (debug) {
                        System.err.println("Checksum does not match.");
                    }
                    calculatedCk = AndroidBackup.makeKeyChecksum(mk, ckSalt, rounds, !useUtf, debug);
                    if (debug) {
                        System.err.printf("Calculated MK checksum (use UTF-8: %s): %s\n", useUtf, AndroidBackup.toHex(calculatedCk));
                    }
                }
                if (Arrays.equals(calculatedCk, mkChecksum)) {
                    ivSpec = new IvParameterSpec(IV);
                    c.init(2, (Key)new SecretKeySpec(mk, "AES"), ivSpec);
                    cipherStream = new CipherInputStream(rawInStream, c);
                }
            }
            if (isEncrypted && cipherStream == null) {
                throw new IllegalStateException("Invalid password or master key checksum.");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void extractAsTar(String backupFilename, String filename, String password, boolean debug) {
        try {
            InputStream in;
            boolean isCompressed;
            InputStream rawInStream = AndroidBackup.getInputStream(backupFilename);
            InputStream cipherStream = null;
            String magic = AndroidBackup.readHeaderLine(rawInStream);
            if (magic.equals("MIUI BACKUP")) {
                String line2 = AndroidBackup.readHeaderLine(rawInStream);
                String line3 = AndroidBackup.readHeaderLine(rawInStream);
                String line4 = AndroidBackup.readHeaderLine(rawInStream);
                String line5 = AndroidBackup.readHeaderLine(rawInStream);
                if (debug) {
                    System.err.println("Magic: " + magic);
                    System.err.println("Header segment 2 (unknown purpose): " + line2);
                    String package_id_name = new String(line3.getBytes("iso8859-1"), "UTF-8");
                    System.err.println("Package ID + display name in the device's language at the time of backup: " + package_id_name);
                    System.err.println("Header segment 4 (unknown purpose): " + line4);
                    System.err.println("Header segment 5 (unknown purpose): " + line5);
                }
                magic = AndroidBackup.readHeaderLine(rawInStream);
            }
            if (debug) {
                System.err.println("Magic: " + magic);
            }
            if (!magic.equals("ANDROID BACKUP")) {
                System.err.println("Invlaid Magic: " + magic);
                throw new IllegalArgumentException("Invalid Magic " + magic);
            }
            String versionStr = AndroidBackup.readHeaderLine(rawInStream);
            if (debug) {
                System.err.println("Version: " + versionStr);
            }
            int version = Integer.parseInt(versionStr);
            String compressed = AndroidBackup.readHeaderLine(rawInStream);
            boolean bl = isCompressed = Integer.parseInt(compressed) == 1;
            if (debug) {
                System.err.println("Compressed: " + compressed);
            }
            String encryptionAlg = AndroidBackup.readHeaderLine(rawInStream);
            if (debug) {
                System.err.println("Algorithm: " + encryptionAlg);
            }
            boolean isEncrypted = false;
            if (encryptionAlg.equals(ENCRYPTION_ALGORITHM_NAME)) {
                isEncrypted = true;
                AndroidBackup.require_jceu();
                password = AndroidBackup.requirePassword(password);
                String userSaltHex = AndroidBackup.readHeaderLine(rawInStream);
                byte[] userSalt = AndroidBackup.hexToByteArray(userSaltHex);
                if (userSalt.length != 64) {
                    throw new IllegalArgumentException("Invalid salt length: " + userSalt.length);
                }
                String ckSaltHex = AndroidBackup.readHeaderLine(rawInStream);
                byte[] ckSalt = AndroidBackup.hexToByteArray(ckSaltHex);
                int rounds = Integer.parseInt(AndroidBackup.readHeaderLine(rawInStream));
                String userIvHex = AndroidBackup.readHeaderLine(rawInStream);
                String masterKeyBlobHex = AndroidBackup.readHeaderLine(rawInStream);
                Cipher c = Cipher.getInstance(ENCRYPTION_MECHANISM);
                SecretKey userKey = AndroidBackup.buildPasswordKey(password, userSalt, rounds, false);
                byte[] IV = AndroidBackup.hexToByteArray(userIvHex);
                IvParameterSpec ivSpec = new IvParameterSpec(IV);
                c.init(2, (Key)new SecretKeySpec(userKey.getEncoded(), "AES"), ivSpec);
                byte[] mkCipher = AndroidBackup.hexToByteArray(masterKeyBlobHex);
                byte[] mkBlob = c.doFinal(mkCipher);
                int offset = 0;
                byte len = mkBlob[offset++];
                IV = Arrays.copyOfRange(mkBlob, offset, offset + len);
                if (debug) {
                    System.err.println("IV: " + AndroidBackup.toHex(IV));
                }
                offset += len;
                len = mkBlob[offset++];
                byte[] mk = Arrays.copyOfRange(mkBlob, offset, offset + len);
                if (debug) {
                    System.err.println("MK: " + AndroidBackup.toHex(mk));
                }
                offset += len;
                len = mkBlob[offset++];
                byte[] mkChecksum = Arrays.copyOfRange(mkBlob, offset, offset + len);
                if (debug) {
                    System.err.println("MK checksum: " + AndroidBackup.toHex(mkChecksum));
                }
                boolean useUtf = version >= 2;
                byte[] calculatedCk = AndroidBackup.makeKeyChecksum(mk, ckSalt, rounds, useUtf, debug);
                if (debug) {
                    System.err.printf("Calculated MK checksum (use UTF-8: %s): %s\n", useUtf, AndroidBackup.toHex(calculatedCk));
                }
                if (!Arrays.equals(calculatedCk, mkChecksum)) {
                    if (debug) {
                        System.err.println("Checksum does not match.");
                    }
                    calculatedCk = AndroidBackup.makeKeyChecksum(mk, ckSalt, rounds, !useUtf, debug);
                    if (debug) {
                        System.err.printf("Calculated MK checksum (use UTF-8: %s): %s\n", useUtf, AndroidBackup.toHex(calculatedCk));
                    }
                }
                if (Arrays.equals(calculatedCk, mkChecksum)) {
                    ivSpec = new IvParameterSpec(IV);
                    c.init(2, (Key)new SecretKeySpec(mk, "AES"), ivSpec);
                    cipherStream = new CipherInputStream(rawInStream, c);
                }
            }
            if (isEncrypted && cipherStream == null) {
                throw new IllegalStateException("Invalid password or master key checksum.");
            }
            double abfileSize = new File(backupFilename).length();
            double percentDone = -1.0;
            OutputStream out = null;
            InputStream baseStream = isEncrypted ? cipherStream : rawInStream;
            Inflater inf = null;
            if (isCompressed) {
                inf = new Inflater();
                in = new InflaterInputStream(baseStream, inf);
            } else {
                in = baseStream;
            }
            try {
                out = AndroidBackup.getOutputStream(filename);
                byte[] buff = new byte[10240];
                int read = -1;
                long totalRead = 0L;
                while ((read = in.read(buff)) > 0) {
                    long bytesRead;
                    double currentPercent;
                    out.write(buff, 0, read);
                    if (!debug || (currentPercent = (double)Math.round((double)(bytesRead = inf == null ? (totalRead += (long)read) : inf.getBytesRead()) / abfileSize * 100.0)) == percentDone) continue;
                    System.err.print(String.format("%.0f%% ", currentPercent));
                    percentDone = currentPercent;
                }
                if (debug) {
                    System.err.printf("\n", new Object[0]);
                    long abfileSizelong = new File(backupFilename).length();
                    System.err.printf("%d bytes read from \"%s\"\n", abfileSizelong, backupFilename);
                    System.err.printf("%d bytes written to \"%s\"\n", totalRead, filename);
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.flush();
                    out.close();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void packTar(String tarFilename, String backupFilename, String password, boolean isKitKat, boolean debug) {
        boolean encrypting = password != null && !"".equals(password);
        boolean compressing = true;
        if (encrypting) {
            AndroidBackup.require_jceu();
        }
        StringBuilder headerbuf = new StringBuilder(1024);
        headerbuf.append(BACKUP_FILE_HEADER_MAGIC);
        headerbuf.append(isKitKat ? 2 : 1);
        headerbuf.append(compressing ? "\n1\n" : "\n0\n");
        double tarfileSize = new File(tarFilename).length();
        double percentDone = -1.0;
        OutputStream out = null;
        try {
            try {
                OutputStream ofstream;
                InputStream in = AndroidBackup.getInputStream(tarFilename);
                OutputStream finalOutput = ofstream = AndroidBackup.getOutputStream(backupFilename);
                if (encrypting) {
                    finalOutput = AndroidBackup.emitAesBackupHeader(headerbuf, finalOutput, password, isKitKat, debug);
                } else {
                    headerbuf.append("none\n");
                }
                byte[] header = headerbuf.toString().getBytes("UTF-8");
                ofstream.write(header);
                if (compressing) {
                    Deflater deflater = new Deflater(9);
                    finalOutput = new DeflaterOutputStream(finalOutput, deflater, true);
                }
                out = finalOutput;
                int read = -1;
                long totalRead = 0L;
                byte[] buff = new byte[10240];
                while ((read = in.read(buff)) > 0) {
                    long bytesRead;
                    double currentPercent;
                    out.write(buff, 0, read);
                    if (!debug || (currentPercent = (double)Math.round((double)(bytesRead = (totalRead += (long)read)) / tarfileSize * 100.0)) == percentDone) continue;
                    System.err.print(String.format("%.0f%% ", currentPercent));
                    percentDone = currentPercent;
                }
                if (debug) {
                    System.err.printf("\n", new Object[0]);
                    System.err.printf("%d bytes read from \"%s\"\n", totalRead, tarFilename);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                    long abfileSize = new File(backupFilename).length();
                    System.err.printf("%d bytes written to \"%s\"\n", abfileSize, backupFilename);
                }
                catch (IOException abfileSize) {
                    // empty catch block
                }
            }
            throw throwable;
        }
        if (out != null) {
            try {
                out.flush();
                out.close();
                long abfileSize = new File(backupFilename).length();
                System.err.printf("%d bytes written to \"%s\"\n", abfileSize, backupFilename);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static InputStream getInputStream(String filename) throws IOException {
        if (filename.equals("-")) {
            return System.in;
        }
        return new FileInputStream(filename);
    }

    private static OutputStream getOutputStream(String filename) throws IOException {
        if (filename.equals("-")) {
            return System.out;
        }
        return new FileOutputStream(filename);
    }

    private static byte[] randomBytes(int bits) {
        byte[] array = new byte[bits / 8];
        random.nextBytes(array);
        return array;
    }

    private static OutputStream emitAesBackupHeader(StringBuilder headerbuf, OutputStream ofstream, String encryptionPassword, boolean useUtf8, boolean debug) throws Exception {
        byte[] newUserSalt = AndroidBackup.randomBytes(512);
        SecretKey userKey = AndroidBackup.buildPasswordKey(encryptionPassword, newUserSalt, 10000, useUtf8);
        byte[] masterPw = new byte[32];
        random.nextBytes(masterPw);
        byte[] checksumSalt = AndroidBackup.randomBytes(512);
        Cipher c = Cipher.getInstance(ENCRYPTION_MECHANISM);
        SecretKeySpec masterKeySpec = new SecretKeySpec(masterPw, "AES");
        c.init(1, masterKeySpec);
        CipherOutputStream finalOutput = new CipherOutputStream(ofstream, c);
        headerbuf.append(ENCRYPTION_ALGORITHM_NAME);
        headerbuf.append('\n');
        headerbuf.append(AndroidBackup.toHex(newUserSalt));
        headerbuf.append('\n');
        headerbuf.append(AndroidBackup.toHex(checksumSalt));
        headerbuf.append('\n');
        headerbuf.append(10000);
        headerbuf.append('\n');
        Cipher mkC = Cipher.getInstance(ENCRYPTION_MECHANISM);
        mkC.init(1, userKey);
        byte[] IV = mkC.getIV();
        headerbuf.append(AndroidBackup.toHex(IV));
        headerbuf.append('\n');
        IV = c.getIV();
        byte[] mk = masterKeySpec.getEncoded();
        byte[] checksum = AndroidBackup.makeKeyChecksum(masterKeySpec.getEncoded(), checksumSalt, 10000, useUtf8, debug);
        ByteArrayOutputStream blob = new ByteArrayOutputStream(IV.length + mk.length + checksum.length + 3);
        DataOutputStream mkOut = new DataOutputStream(blob);
        mkOut.writeByte(IV.length);
        mkOut.write(IV);
        mkOut.writeByte(mk.length);
        mkOut.write(mk);
        mkOut.writeByte(checksum.length);
        mkOut.write(checksum);
        mkOut.flush();
        byte[] encryptedMk = mkC.doFinal(blob.toByteArray());
        headerbuf.append(AndroidBackup.toHex(encryptedMk));
        headerbuf.append('\n');
        return finalOutput;
    }

    public static String toHex(byte[] bytes) {
        StringBuffer buff = new StringBuffer();
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            buff.append(String.format("%02X", b));
            ++n2;
        }
        return buff.toString();
    }

    private static String readHeaderLine(InputStream in) throws IOException {
        int c;
        StringBuilder buffer = new StringBuilder(80);
        while ((c = in.read()) >= 0) {
            if (c == 10) break;
            buffer.append((char)c);
        }
        return buffer.toString();
    }

    public static byte[] hexToByteArray(String digits) {
        int bytes = digits.length() / 2;
        if (2 * bytes != digits.length()) {
            throw new IllegalArgumentException("Hex string must have an even number of digits");
        }
        byte[] result = new byte[bytes];
        int i = 0;
        while (i < digits.length()) {
            result[i / 2] = (byte)Integer.parseInt(digits.substring(i, i + 2), 16);
            i += 2;
        }
        return result;
    }

    public static byte[] makeKeyChecksum(byte[] pwBytes, byte[] salt, int rounds, boolean useUtf8, boolean debug) {
        if (debug) {
            System.err.println("key bytes: " + AndroidBackup.toHex(pwBytes));
            System.err.println("salt bytes: " + AndroidBackup.toHex(salt));
        }
        char[] mkAsChar = new char[pwBytes.length];
        int i = 0;
        while (i < pwBytes.length) {
            mkAsChar[i] = (char)pwBytes[i];
            ++i;
        }
        if (debug) {
            System.err.printf("MK as string: [%s]\n", new String(mkAsChar));
        }
        SecretKey checksum = AndroidBackup.buildCharArrayKey(mkAsChar, salt, rounds, useUtf8);
        if (debug) {
            System.err.println("Key format: " + checksum.getFormat());
        }
        return checksum.getEncoded();
    }

    public static SecretKey buildCharArrayKey(char[] pwArray, byte[] salt, int rounds, boolean useUtf8) {
        return AndroidBackup.androidPBKDF2(pwArray, salt, rounds, useUtf8);
    }

    public static SecretKey androidPBKDF2(char[] pwArray, byte[] salt, int rounds, boolean useUtf8) {
        PKCS5S2ParametersGenerator generator = new PKCS5S2ParametersGenerator();
        byte[] pwBytes = useUtf8 ? PBEParametersGenerator.PKCS5PasswordToUTF8Bytes(pwArray) : PBEParametersGenerator.PKCS5PasswordToBytes(pwArray);
        generator.init(pwBytes, salt, rounds);
        KeyParameter params = (KeyParameter)((PBEParametersGenerator)generator).generateDerivedParameters(256);
        return new SecretKeySpec(params.getKey(), "AES");
    }

    private static SecretKey buildPasswordKey(String pw, byte[] salt, int rounds, boolean useUtf8) {
        return AndroidBackup.buildCharArrayKey(pw.toCharArray(), salt, rounds, useUtf8);
    }
}

