import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
/**
 * (experimental) Statement provider for service [cloudtrail](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscloudtrail.html).
 *
 * @experimental
 */
export declare class Cloudtrail extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [cloudtrail](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscloudtrail.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to add one or more tags to a trail, up to a limit of 10.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_AddTags.html
     *
     * @experimental
     */
    toAddTags(): this;
    /**
     * (experimental) Grants permission to create a trail that specifies the settings for delivery of log data to an Amazon S3 bucket.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - s3:PutObject
     *
     * https://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_CreateTrail.html
     *
     * @experimental
     */
    toCreateTrail(): this;
    /**
     * (experimental) Grants permission to delete a trail.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_DeleteTrail.html
     *
     * @experimental
     */
    toDeleteTrail(): this;
    /**
     * (experimental) Grants permission to list settings for the trails associated with the current region for your account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_DescribeTrails.html
     *
     * @experimental
     */
    toDescribeTrails(): this;
    /**
     * (experimental) Grants permission to list settings for event selectors configured for a trail.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_GetEventSelectors.html
     *
     * @experimental
     */
    toGetEventSelectors(): this;
    /**
     * (experimental) Grants permission to list CloudTrail Insights selectors that are configured for a trail.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_GetInsightSelectors.html
     *
     * @experimental
     */
    toGetInsightSelectors(): this;
    /**
     * (experimental) Grants permission to list settings for the trail.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_GetTrail.html
     *
     * @experimental
     */
    toGetTrail(): this;
    /**
     * (experimental) Grants permission to retrieve a JSON-formatted list of information about the specified trail.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_GetTrailStatus.html
     *
     * @experimental
     */
    toGetTrailStatus(): this;
    /**
     * (experimental) Grants permission to list the public keys whose private keys were used to sign trail digest files within a specified time range.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_ListPublicKeys.html
     *
     * @experimental
     */
    toListPublicKeys(): this;
    /**
     * (experimental) Grants permission to list the tags for trails in the current region.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_ListTags.html
     *
     * @experimental
     */
    toListTags(): this;
    /**
     * (experimental) Grants permission to list trails associated with the current region for your account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_ListTrails.html
     *
     * @experimental
     */
    toListTrails(): this;
    /**
     * (experimental) Grants permission to look up API activity events captured by CloudTrail that create, update, or delete resources in your account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_LookupEvents.html
     *
     * @experimental
     */
    toLookupEvents(): this;
    /**
     * (experimental) Grants permission to create and update event selectors for a trail.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_PutEventSelectors.html
     *
     * @experimental
     */
    toPutEventSelectors(): this;
    /**
     * (experimental) Grants permission to create and update CloudTrail Insights selectors for a trail.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_PutInsightSelectors.html
     *
     * @experimental
     */
    toPutInsightSelectors(): this;
    /**
     * (experimental) Grants permission to remove tags from a trail.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_RemoveTags.html
     *
     * @experimental
     */
    toRemoveTags(): this;
    /**
     * (experimental) Grants permission to start the recording of AWS API calls and log file delivery for a trail.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_StartLogging.html
     *
     * @experimental
     */
    toStartLogging(): this;
    /**
     * (experimental) Grants permission to stop the recording of AWS API calls and log file delivery for a trail.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_StopLogging.html
     *
     * @experimental
     */
    toStopLogging(): this;
    /**
     * (experimental) Grants permission to update the settings that specify delivery of log files.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_UpdateTrail.html
     *
     * @experimental
     */
    toUpdateTrail(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type trail to the statement.
     *
     * https://docs.aws.amazon.com/awscloudtrail/latest/userguide/how-cloudtrail-works.html
     *
     * @param trailName - Identifier for the trailName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onTrail(trailName: string, account?: string, region?: string, partition?: string): this;
}
