import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
/**
 * (experimental) Statement provider for service [lakeformation](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awslakeformation.html).
 *
 * @experimental
 */
export declare class Lakeformation extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [lakeformation](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awslakeformation.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to attach lakeformation tags to catalog resources.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-AddLFTagsToResource
     *
     * @experimental
     */
    toAddLFTagsToResource(): this;
    /**
     * (experimental) Grants permission to data lake permissions to one or more principals in a batch.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-BatchGrantPermissions
     *
     * @experimental
     */
    toBatchGrantPermissions(): this;
    /**
     * (experimental) Grants permission to revoke data lake permissions from one or more principals in a batch.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-BatchRevokePermissions
     *
     * @experimental
     */
    toBatchRevokePermissions(): this;
    /**
     * (experimental) Grants permission to create a Lakeformation tag.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-CreateLFTag
     *
     * @experimental
     */
    toCreateLFTag(): this;
    /**
     * (experimental) Grants permission to delete a Lakeformation tag.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-DeleteLFTag
     *
     * @experimental
     */
    toDeleteLFTag(): this;
    /**
     * (experimental) Grants permission to deregister a registered location.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-DeregisterResource
     *
     * @experimental
     */
    toDeregisterResource(): this;
    /**
     * (experimental) Grants permission to describe a registered location.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-DescribeResource
     *
     * @experimental
     */
    toDescribeResource(): this;
    /**
     * (experimental) Grants permission to virtual data lake access.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-GetDataAccess
     *
     * @experimental
     */
    toGetDataAccess(): this;
    /**
     * (experimental) Grants permission to retrieve data lake settings such as the list of data lake administrators and database and table default permissions.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-GetDataLakeSettings
     *
     * @experimental
     */
    toGetDataLakeSettings(): this;
    /**
     * (experimental) Grants permission to retrive permissions attached to resources in the given path.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-GetEffectivePermissionsForPath
     *
     * @experimental
     */
    toGetEffectivePermissionsForPath(): this;
    /**
     * (experimental) Grants permission to retrive a Lakeformation tag.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-GetLFTag
     *
     * @experimental
     */
    toGetLFTag(): this;
    /**
     * (experimental) Grants permission to retrieve lakeformation tags on a catalog resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-GetResourceLFTags
     *
     * @experimental
     */
    toGetResourceLFTags(): this;
    /**
     * (experimental) Grants permission to data lake permissions to a principal.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-GrantPermissions
     *
     * @experimental
     */
    toGrantPermissions(): this;
    /**
     * (experimental) Grants permission to list Lakeformation tags.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-ListLFTags
     *
     * @experimental
     */
    toListLFTags(): this;
    /**
     * (experimental) Grants permission to list permissions filtered by principal or resource.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-ListPermissions
     *
     * @experimental
     */
    toListPermissions(): this;
    /**
     * (experimental) Grants permission to List registered locations.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-ListResources
     *
     * @experimental
     */
    toListResources(): this;
    /**
     * (experimental) Grants permission to overwrite data lake settings such as the list of data lake administrators and database and table default permissions.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-PutDataLakeSettings
     *
     * @experimental
     */
    toPutDataLakeSettings(): this;
    /**
     * (experimental) Grants permission to register a new location to be managed by Lake Formation.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-RegisterResource
     *
     * @experimental
     */
    toRegisterResource(): this;
    /**
     * (experimental) Grants permission to remove lakeformation tags from catalog resources.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-RemoveLFTagsFromResource
     *
     * @experimental
     */
    toRemoveLFTagsFromResource(): this;
    /**
     * (experimental) Grants permission to revoke data lake permissions from a principal.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-RevokePermissions
     *
     * @experimental
     */
    toRevokePermissions(): this;
    /**
     * (experimental) Grants permission to list catalog databases with lakeformation tags.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-SearchDatabasesByLFTags
     *
     * @experimental
     */
    toSearchDatabasesByLFTags(): this;
    /**
     * (experimental) Grants permission to list catalog tables with lakeformation tags.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-SearchTablesByLFTags
     *
     * @experimental
     */
    toSearchTablesByLFTags(): this;
    /**
     * (experimental) Grants permission to update a Lakeformation tag.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-UpdateLFTag
     *
     * @experimental
     */
    toUpdateLFTag(): this;
    /**
     * (experimental) Grants permission to update a registered location.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-UpdateResource
     *
     * @experimental
     */
    toUpdateResource(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
}
