"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LexV2 = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * (experimental) Statement provider for service [lex-v2](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonlexv2.html).
 *
 * @experimental
 */
class LexV2 extends shared_1.PolicyStatement {
    /**
     * (experimental) Statement provider for service [lex-v2](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonlexv2.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid) {
        super(sid);
        /**
         * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
         *
         * @experimental
         */
        this.servicePrefix = 'lex';
        /**
         * @experimental
         */
        this.accessLevelList = {
            "Write": [
                "BuildBotLocale",
                "CreateBot",
                "CreateBotAlias",
                "CreateBotChannel",
                "CreateBotLocale",
                "CreateBotVersion",
                "CreateExport",
                "CreateIntent",
                "CreateResourcePolicy",
                "CreateSlot",
                "CreateSlotType",
                "CreateUploadUrl",
                "DeleteBot",
                "DeleteBotAlias",
                "DeleteBotChannel",
                "DeleteBotLocale",
                "DeleteBotVersion",
                "DeleteExport",
                "DeleteImport",
                "DeleteIntent",
                "DeleteResourcePolicy",
                "DeleteSession",
                "DeleteSlot",
                "DeleteSlotType",
                "PutSession",
                "RecognizeText",
                "RecognizeUtterance",
                "StartConversation",
                "StartImport",
                "UpdateBot",
                "UpdateBotAlias",
                "UpdateBotLocale",
                "UpdateExport",
                "UpdateIntent",
                "UpdateResourcePolicy",
                "UpdateSlot",
                "UpdateSlotType"
            ],
            "Read": [
                "DescribeBot",
                "DescribeBotAlias",
                "DescribeBotChannel",
                "DescribeBotLocale",
                "DescribeBotVersion",
                "DescribeExport",
                "DescribeImport",
                "DescribeIntent",
                "DescribeResourcePolicy",
                "DescribeSlot",
                "DescribeSlotType",
                "GetSession",
                "ListTagsForResource"
            ],
            "List": [
                "ListBotAliases",
                "ListBotChannels",
                "ListBotLocales",
                "ListBotVersions",
                "ListBots",
                "ListBuiltInIntents",
                "ListBuiltInSlotTypes",
                "ListExports",
                "ListImports",
                "ListIntents",
                "ListSlotTypes",
                "ListSlots"
            ],
            "Tagging": [
                "TagResource",
                "UntagResource"
            ]
        };
    }
    /**
     * (experimental) Grants permission to build an existing bot locale in a bot.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_BuildBotLocale.html
     *
     * @experimental
     */
    toBuildBotLocale() {
        return this.to('BuildBotLocale');
    }
    /**
     * (experimental) Grants permission to create a new bot and a test bot alias pointing to the DRAFT bot version.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateBot.html
     *
     * @experimental
     */
    toCreateBot() {
        return this.to('CreateBot');
    }
    /**
     * (experimental) Grants permission to create a new bot alias in a bot.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateBotAlias.html
     *
     * @experimental
     */
    toCreateBotAlias() {
        return this.to('CreateBotAlias');
    }
    /**
     * (experimental) Grants permission to create a bot channel in an existing bot.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/deploying-messaging-platform.html
     *
     * @experimental
     */
    toCreateBotChannel() {
        return this.to('CreateBotChannel');
    }
    /**
     * (experimental) Grants permission to create a new bot locale in an existing bot.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateBotLocale.html
     *
     * @experimental
     */
    toCreateBotLocale() {
        return this.to('CreateBotLocale');
    }
    /**
     * (experimental) Grants permission to create a new version of an existing bot.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateBotVersion.html
     *
     * @experimental
     */
    toCreateBotVersion() {
        return this.to('CreateBotVersion');
    }
    /**
     * (experimental) Grants permission to create an export for an existing resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateExport.html
     *
     * @experimental
     */
    toCreateExport() {
        return this.to('CreateExport');
    }
    /**
     * (experimental) Grants permission to create a new intent in an existing bot locale.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateIntent.html
     *
     * @experimental
     */
    toCreateIntent() {
        return this.to('CreateIntent');
    }
    /**
     * (experimental) Grants permission to create a new resource policy for a Lex resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateResourcePolicy.html
     *
     * @experimental
     */
    toCreateResourcePolicy() {
        return this.to('CreateResourcePolicy');
    }
    /**
     * (experimental) Grants permission to create a new slot in an intent.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateSlot.html
     *
     * @experimental
     */
    toCreateSlot() {
        return this.to('CreateSlot');
    }
    /**
     * (experimental) Grants permission to create a new slot type in an existing bot locale.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateSlotType.html
     *
     * @experimental
     */
    toCreateSlotType() {
        return this.to('CreateSlotType');
    }
    /**
     * (experimental) Grants permission to create an upload url for import file.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateUploadUrl.html
     *
     * @experimental
     */
    toCreateUploadUrl() {
        return this.to('CreateUploadUrl');
    }
    /**
     * (experimental) Grants permission to delete an existing bot.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - lex:DeleteBotAlias
     * - lex:DeleteBotChannel
     * - lex:DeleteBotLocale
     * - lex:DeleteBotVersion
     * - lex:DeleteIntent
     * - lex:DeleteSlot
     * - lex:DeleteSlotType
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_DeleteBot.html
     *
     * @experimental
     */
    toDeleteBot() {
        return this.to('DeleteBot');
    }
    /**
     * (experimental) Grants permission to delete an existing bot alias in a bot.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_DeleteBotAlias.html
     *
     * @experimental
     */
    toDeleteBotAlias() {
        return this.to('DeleteBotAlias');
    }
    /**
     * (experimental) Grants permission to delete an existing bot channel.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/deploying-messaging-platform.html
     *
     * @experimental
     */
    toDeleteBotChannel() {
        return this.to('DeleteBotChannel');
    }
    /**
     * (experimental) Grants permission to delete an existing bot locale in a bot.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - lex:DeleteIntent
     * - lex:DeleteSlot
     * - lex:DeleteSlotType
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_DeleteBotLocale.html
     *
     * @experimental
     */
    toDeleteBotLocale() {
        return this.to('DeleteBotLocale');
    }
    /**
     * (experimental) Grants permission to delete an existing bot version.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_DeleteBotVersion.html
     *
     * @experimental
     */
    toDeleteBotVersion() {
        return this.to('DeleteBotVersion');
    }
    /**
     * (experimental) Grants permission to delete an existing export.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_DeleteExport.html
     *
     * @experimental
     */
    toDeleteExport() {
        return this.to('DeleteExport');
    }
    /**
     * (experimental) Grants permission to delete an existing import.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_DeleteImport.html
     *
     * @experimental
     */
    toDeleteImport() {
        return this.to('DeleteImport');
    }
    /**
     * (experimental) Grants permission to delete an existing intent in a bot locale.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_DeleteIntent.html
     *
     * @experimental
     */
    toDeleteIntent() {
        return this.to('DeleteIntent');
    }
    /**
     * (experimental) Grants permission to delete an existing resource policy for a Lex resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_DeleteResourcePolicy.html
     *
     * @experimental
     */
    toDeleteResourcePolicy() {
        return this.to('DeleteResourcePolicy');
    }
    /**
     * (experimental) Grants permission to delete session information for a bot alias and user ID.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_runtime_DeleteSession.html
     *
     * @experimental
     */
    toDeleteSession() {
        return this.to('DeleteSession');
    }
    /**
     * (experimental) Grants permission to delete an existing slot in an intent.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_DeleteSlot.html
     *
     * @experimental
     */
    toDeleteSlot() {
        return this.to('DeleteSlot');
    }
    /**
     * (experimental) Grants permission to delete an existing slot type in a bot locale.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_DeleteSlotType.html
     *
     * @experimental
     */
    toDeleteSlotType() {
        return this.to('DeleteSlotType');
    }
    /**
     * (experimental) Grants permission to retrieve an existing bot.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeBot.html
     *
     * @experimental
     */
    toDescribeBot() {
        return this.to('DescribeBot');
    }
    /**
     * (experimental) Grants permission to retrieve an existing bot alias.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeBotAlias.html
     *
     * @experimental
     */
    toDescribeBotAlias() {
        return this.to('DescribeBotAlias');
    }
    /**
     * (experimental) Grants permission to retrieve an existing bot channel.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/deploying-messaging-platform.html
     *
     * @experimental
     */
    toDescribeBotChannel() {
        return this.to('DescribeBotChannel');
    }
    /**
     * (experimental) Grants permission to retrieve an existing bot locale.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeBotLocale.html
     *
     * @experimental
     */
    toDescribeBotLocale() {
        return this.to('DescribeBotLocale');
    }
    /**
     * (experimental) Grants permission to retrieve an existing bot version.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeBotVersion.html
     *
     * @experimental
     */
    toDescribeBotVersion() {
        return this.to('DescribeBotVersion');
    }
    /**
     * (experimental) Grants permission to retrieve an existing export.
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - lex:DescribeBot
     * - lex:DescribeBotLocale
     * - lex:DescribeIntent
     * - lex:DescribeSlot
     * - lex:DescribeSlotType
     * - lex:ListBotLocales
     * - lex:ListIntents
     * - lex:ListSlotTypes
     * - lex:ListSlots
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeExport.html
     *
     * @experimental
     */
    toDescribeExport() {
        return this.to('DescribeExport');
    }
    /**
     * (experimental) Grants permission to retrieve an existing import.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeImport.html
     *
     * @experimental
     */
    toDescribeImport() {
        return this.to('DescribeImport');
    }
    /**
     * (experimental) Grants permission to retrieve an existing intent.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeIntent.html
     *
     * @experimental
     */
    toDescribeIntent() {
        return this.to('DescribeIntent');
    }
    /**
     * (experimental) Grants permission to retrieve an existing resource policy for a Lex resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeResourcePolicy.html
     *
     * @experimental
     */
    toDescribeResourcePolicy() {
        return this.to('DescribeResourcePolicy');
    }
    /**
     * (experimental) Grants permission to retrieve an existing slot.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeSlot.html
     *
     * @experimental
     */
    toDescribeSlot() {
        return this.to('DescribeSlot');
    }
    /**
     * (experimental) Grants permission to retrieve an existing slot type.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeSlotType.html
     *
     * @experimental
     */
    toDescribeSlotType() {
        return this.to('DescribeSlotType');
    }
    /**
     * (experimental) Grants permission to retrieve session information for a bot alias and user ID.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_runtime_GetSession.html
     *
     * @experimental
     */
    toGetSession() {
        return this.to('GetSession');
    }
    /**
     * (experimental) Grants permission to list bot aliases in an bot.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_ListBotAliases.html
     *
     * @experimental
     */
    toListBotAliases() {
        return this.to('ListBotAliases');
    }
    /**
     * (experimental) Grants permission to list bot channels.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/deploying-messaging-platform.html
     *
     * @experimental
     */
    toListBotChannels() {
        return this.to('ListBotChannels');
    }
    /**
     * (experimental) Grants permission to list bot locales in a bot.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_ListBotLocales.html
     *
     * @experimental
     */
    toListBotLocales() {
        return this.to('ListBotLocales');
    }
    /**
     * (experimental) Grants permission to list existing bot versions.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_ListBotVersions.html
     *
     * @experimental
     */
    toListBotVersions() {
        return this.to('ListBotVersions');
    }
    /**
     * (experimental) Grants permission to list existing bots.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_ListBots.html
     *
     * @experimental
     */
    toListBots() {
        return this.to('ListBots');
    }
    /**
     * (experimental) Grants permission to list built-in intents.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_ListBuiltInIntents.html
     *
     * @experimental
     */
    toListBuiltInIntents() {
        return this.to('ListBuiltInIntents');
    }
    /**
     * (experimental) Grants permission to list built-in slot types.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_ListBuiltInSlotTypes.html
     *
     * @experimental
     */
    toListBuiltInSlotTypes() {
        return this.to('ListBuiltInSlotTypes');
    }
    /**
     * (experimental) Grants permission to list existing exports.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_ListExports.html
     *
     * @experimental
     */
    toListExports() {
        return this.to('ListExports');
    }
    /**
     * (experimental) Grants permission to list existing imports.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_ListImports.html
     *
     * @experimental
     */
    toListImports() {
        return this.to('ListImports');
    }
    /**
     * (experimental) Grants permission to list intents in a bot.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_ListIntents.html
     *
     * @experimental
     */
    toListIntents() {
        return this.to('ListIntents');
    }
    /**
     * (experimental) Grants permission to list slot types in a bot.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_ListSlotTypes.html
     *
     * @experimental
     */
    toListSlotTypes() {
        return this.to('ListSlotTypes');
    }
    /**
     * (experimental) Grants permission to list slots in an intent.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_ListSlots.html
     *
     * @experimental
     */
    toListSlots() {
        return this.to('ListSlots');
    }
    /**
     * (experimental) Grants permission to lists tags for a Lex resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * (experimental) Grants permission to create a new session or modify an existing session for a bot alias and user ID.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_runtime_PutSession.html
     *
     * @experimental
     */
    toPutSession() {
        return this.to('PutSession');
    }
    /**
     * (experimental) Grants permission to send user input (text-only) to an bot alias.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_runtime_RecognizeText.html
     *
     * @experimental
     */
    toRecognizeText() {
        return this.to('RecognizeText');
    }
    /**
     * (experimental) Grants permission to send user input (text or speech) to an bot alias.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_runtime_RecognizeUtterance.html
     *
     * @experimental
     */
    toRecognizeUtterance() {
        return this.to('RecognizeUtterance');
    }
    /**
     * (experimental) Grants permission to stream user input (speech/text/DTMF) to a bot alias.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_runtime_StartConversation.html
     *
     * @experimental
     */
    toStartConversation() {
        return this.to('StartConversation');
    }
    /**
     * (experimental) Grants permission to start a new import with the uploaded import file.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * Dependent actions:
     * - lex:CreateBot
     * - lex:CreateBotLocale
     * - lex:CreateIntent
     * - lex:CreateSlot
     * - lex:CreateSlotType
     * - lex:DeleteBotLocale
     * - lex:DeleteIntent
     * - lex:DeleteSlot
     * - lex:DeleteSlotType
     * - lex:UpdateBot
     * - lex:UpdateBotLocale
     * - lex:UpdateIntent
     * - lex:UpdateSlot
     * - lex:UpdateSlotType
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_StartImport.html
     *
     * @experimental
     */
    toStartImport() {
        return this.to('StartImport');
    }
    /**
     * (experimental) Grants permission to add or overwrite tags of a Lex resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_TagResource.html
     *
     * @experimental
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * (experimental) Grants permission to remove tags from a Lex resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * (experimental) Grants permission to update an existing bot.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_UpdateBot.html
     *
     * @experimental
     */
    toUpdateBot() {
        return this.to('UpdateBot');
    }
    /**
     * (experimental) Grants permission to update an existing bot alias.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_UpdateBotAlias.html
     *
     * @experimental
     */
    toUpdateBotAlias() {
        return this.to('UpdateBotAlias');
    }
    /**
     * (experimental) Grants permission to update an existing bot locale.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_UpdateBotLocale.html
     *
     * @experimental
     */
    toUpdateBotLocale() {
        return this.to('UpdateBotLocale');
    }
    /**
     * (experimental) Grants permission to update an existing export.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_UpdateExport.html
     *
     * @experimental
     */
    toUpdateExport() {
        return this.to('UpdateExport');
    }
    /**
     * (experimental) Grants permission to update an existing intent.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_UpdateIntent.html
     *
     * @experimental
     */
    toUpdateIntent() {
        return this.to('UpdateIntent');
    }
    /**
     * (experimental) Grants permission to update an existing resource policy for a Lex resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_UpdateResourcePolicy.html
     *
     * @experimental
     */
    toUpdateResourcePolicy() {
        return this.to('UpdateResourcePolicy');
    }
    /**
     * (experimental) Grants permission to update an existing slot.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_UpdateSlot.html
     *
     * @experimental
     */
    toUpdateSlot() {
        return this.to('UpdateSlot');
    }
    /**
     * (experimental) Grants permission to update an existing slot type.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_UpdateSlotType.html
     *
     * @experimental
     */
    toUpdateSlotType() {
        return this.to('UpdateSlotType');
    }
    /**
     * (experimental) Adds a resource of type bot to the statement.
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/how-it-works.html
     *
     * @param botId - Identifier for the botId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onBot(botId, account, region, partition) {
        var arn = 'arn:${Partition}:lex:${Region}:${Account}:bot/${BotId}';
        arn = arn.replace('${BotId}', botId);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * (experimental) Adds a resource of type bot alias to the statement.
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/how-it-works.html
     *
     * @param botId - Identifier for the botId.
     * @param botAliasId - Identifier for the botAliasId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onBotAlias(botId, botAliasId, account, region, partition) {
        var arn = 'arn:${Partition}:lex:${Region}:${Account}:bot-alias/${BotId}/${BotAliasId}';
        arn = arn.replace('${BotId}', botId);
        arn = arn.replace('${BotAliasId}', botAliasId);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
}
exports.LexV2 = LexV2;
_a = JSII_RTTI_SYMBOL_1;
LexV2[_a] = { fqn: "iam-floyd.LexV2", version: "0.266.0" };
//# sourceMappingURL=data:application/json;base64,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