import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
/**
 * (experimental) Statement provider for service [es](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonopensearchservicesuccessortoamazonelasticsearchservice.html).
 *
 * @experimental
 */
export declare class Es extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [es](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonopensearchservicesuccessortoamazonelasticsearchservice.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to the destination domain owner to accept an inbound cross-cluster search connection request.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-accept-inbound-cross-cluster-search-connection
     *
     * @experimental
     */
    toAcceptInboundConnection(): this;
    /**
     * (experimental) Grants permission to the destination domain owner to accept an inbound cross-cluster search connection request.
     *
     * This permission is deprecated. Use AcceptInboundConnection instead
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-accept-inbound-cross-cluster-search-connection
     *
     * @experimental
     */
    toAcceptInboundCrossClusterSearchConnection(): this;
    /**
     * (experimental) Grants permission to attach resource tags to an OpenSearch Service domain.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-addtags
     *
     * @experimental
     */
    toAddTags(): this;
    /**
     * (experimental) Grants permission to associate a package with an OpenSearch Service domain.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-associatepackage
     *
     * @experimental
     */
    toAssociatePackage(): this;
    /**
     * (experimental) Grants permission to cancel a service software update of a domain. This permission is deprecated. Use CancelServiceSoftwareUpdate instead.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-stopupdate
     *
     * @experimental
     */
    toCancelElasticsearchServiceSoftwareUpdate(): this;
    /**
     * (experimental) Grants permission to cancel a service software update of a domain.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-stopupdate
     *
     * @experimental
     */
    toCancelServiceSoftwareUpdate(): this;
    /**
     * (experimental) Grants permission to create an Amazon OpenSearch Service domain.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-createdomain
     *
     * @experimental
     */
    toCreateDomain(): this;
    /**
     * (experimental) Grants permission to create an OpenSearch Service domain. This permission is deprecated. Use CreateDomain instead.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-createdomain
     *
     * @experimental
     */
    toCreateElasticsearchDomain(): this;
    /**
     * (experimental) Grants permission to create the service-linked role required for OpenSearch Service domains that use VPC access.
     *
     * This permission is deprecated. OpenSearch Service creates the service-linked role for you
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-createservicerole
     *
     * @experimental
     */
    toCreateElasticsearchServiceRole(): this;
    /**
     * (experimental) Grants permission to create a new cross-cluster search connection from a source domain to a destination domain.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-create-outbound-cross-cluster-search-connection
     *
     * @experimental
     */
    toCreateOutboundConnection(): this;
    /**
     * (experimental) Grants permission to create a new cross-cluster search connection from a source domain to a destination domain.
     *
     * This permission is deprecated. Use CreateOutboundConnection instead
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-create-outbound-cross-cluster-search-connection
     *
     * @experimental
     */
    toCreateOutboundCrossClusterSearchConnection(): this;
    /**
     * (experimental) Grants permission to add a package for use with OpenSearch Service domains.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-createpackage
     *
     * @experimental
     */
    toCreatePackage(): this;
    /**
     * (experimental) Grants permission to create the service-linked role required for Amazon OpenSearch Service domains that use VPC access.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-createservicerole
     *
     * @experimental
     */
    toCreateServiceRole(): this;
    /**
     * (experimental) Grants permission to delete an Amazon OpenSearch Service domain and all of its data.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-deletedomain
     *
     * @experimental
     */
    toDeleteDomain(): this;
    /**
     * (experimental) Grants permission to delete an OpenSearch Service domain and all of its data.
     *
     * This permission is deprecated. Use DeleteDomain instead
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-deleteelasticsearchdomain
     *
     * @experimental
     */
    toDeleteElasticsearchDomain(): this;
    /**
     * (experimental) Grants permission to delete the service-linked role required for OpenSearch Service domains that use VPC access.
     *
     * This permission is deprecated. Use the IAM API to delete service-linked roles
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-deleteservicerole
     *
     * @experimental
     */
    toDeleteElasticsearchServiceRole(): this;
    /**
     * (experimental) Grants permission to the destination domain owner to delete an existing inbound cross-cluster search connection.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-delete-inbound-cross-cluster-search-connection
     *
     * @experimental
     */
    toDeleteInboundConnection(): this;
    /**
     * (experimental) Grants permission to the destination domain owner to delete an existing inbound cross-cluster search connection.
     *
     * This permission is deprecated. Use DeleteInboundConnection instead
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-delete-inbound-cross-cluster-search-connection
     *
     * @experimental
     */
    toDeleteInboundCrossClusterSearchConnection(): this;
    /**
     * (experimental) Grants permission to the source domain owner to delete an existing outbound cross-cluster search connection.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-delete-outbound-cross-cluster-search-connection
     *
     * @experimental
     */
    toDeleteOutboundConnection(): this;
    /**
     * (experimental) Grants permission to the source domain owner to delete an existing outbound cross-cluster search connection.
     *
     * This permission is deprecated. Use DeleteOutboundConnection instead
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-delete-outbound-cross-cluster-search-connection
     *
     * @experimental
     */
    toDeleteOutboundCrossClusterSearchConnection(): this;
    /**
     * (experimental) Grants permission to delete a package from OpenSearch Service. The package cannot be associated with any domains.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-deletepackage
     *
     * @experimental
     */
    toDeletePackage(): this;
    /**
     * (experimental) Grants permission to view a description of the domain configuration for the specified OpenSearch Service domain, including the domain ID, service endpoint, and ARN.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-describedomain
     *
     * @experimental
     */
    toDescribeDomain(): this;
    /**
     * (experimental) Grants permission to view the Auto-Tune configuration of the domain for the specified OpenSearch Service domain, including the Auto-Tune state and maintenance schedules.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-describeautotune
     *
     * @experimental
     */
    toDescribeDomainAutoTunes(): this;
    /**
     * (experimental) Grants permission to view a description of the configuration options and status of an OpenSearch Service domain.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-describedomainconfig
     *
     * @experimental
     */
    toDescribeDomainConfig(): this;
    /**
     * (experimental) Grants permission to view a description of the domain configuration for up to five specified OpenSearch Service domains.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-describedomains
     *
     * @experimental
     */
    toDescribeDomains(): this;
    /**
     * (experimental) Grants permission to view a description of the domain configuration for the specified OpenSearch Service domain, including the domain ID, service endpoint, and ARN.
     *
     * This permission is deprecated. Use DescribeDomain instead
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-describedomain
     *
     * @experimental
     */
    toDescribeElasticsearchDomain(): this;
    /**
     * (experimental) Grants permission to view a description of the configuration and status of an OpenSearch Service domain.
     *
     * This permission is deprecated. Use DescribeDomainConfig instead.s
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-describedomainconfig
     *
     * @experimental
     */
    toDescribeElasticsearchDomainConfig(): this;
    /**
     * (experimental) Grants permission to view a description of the domain configuration for up to five specified Amazon OpenSearch domains.
     *
     * This permission is deprecated. Use DescribeDomains instead
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-describedomains
     *
     * @experimental
     */
    toDescribeElasticsearchDomains(): this;
    /**
     * (experimental) Grants permission to view the instance count, storage, and master node limits for a given OpenSearch version and instance type.
     *
     * This permission is deprecated. Use DescribeInstanceTypeLimits instead
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-describeinstancetypelimits
     *
     * @experimental
     */
    toDescribeElasticsearchInstanceTypeLimits(): this;
    /**
     * (experimental) Grants permission to list all the inbound cross-cluster search connections for a destination domain.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-describe-inbound-cross-cluster-search-connections
     *
     * @experimental
     */
    toDescribeInboundConnections(): this;
    /**
     * (experimental) Grants permission to list all the inbound cross-cluster search connections for a destination domain.
     *
     * This permission is deprecated. Use DescribeInboundConnections instead
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-describe-inbound-cross-cluster-search-connections
     *
     * @experimental
     */
    toDescribeInboundCrossClusterSearchConnections(): this;
    /**
     * (experimental) Grants permission to view the instance count, storage, and master node limits for a given engine version and instance type.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-describeinstancetypelimits
     *
     * @experimental
     */
    toDescribeInstanceTypeLimits(): this;
    /**
     * (experimental) Grants permission to list all the outbound cross-cluster search connections for a source domain.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-describe-outbound-cross-cluster-search-connections
     *
     * @experimental
     */
    toDescribeOutboundConnections(): this;
    /**
     * (experimental) Grants permission to list all the outbound cross-cluster search connections for a source domain.
     *
     * This permission is deprecated. Use DescribeOutboundConnections instead
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-describe-outbound-cross-cluster-search-connections
     *
     * @experimental
     */
    toDescribeOutboundCrossClusterSearchConnections(): this;
    /**
     * (experimental) Grants permission to describe all packages available to OpenSearch Service domains.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-describepackages
     *
     * @experimental
     */
    toDescribePackages(): this;
    /**
     * (experimental) Grants permission to fetch Reserved Instance offerings for Amazon OpenSearch Service. This permission is deprecated. Use DescribeReservedInstanceOfferings instead.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-describereservedinstanceofferings.
     *
     * @experimental
     */
    toDescribeReservedElasticsearchInstanceOfferings(): this;
    /**
     * (experimental) Grants permission to fetch OpenSearch Service Reserved Instances that have already been purchased.
     *
     * This permission is deprecated. Use DescribeReservedInstances instead
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-describereservedinstances
     *
     * @experimental
     */
    toDescribeReservedElasticsearchInstances(): this;
    /**
     * (experimental) Grants permission to fetch Reserved Instance offerings for OpenSearch Service.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-describereservedinstanceofferings
     *
     * @experimental
     */
    toDescribeReservedInstanceOfferings(): this;
    /**
     * (experimental) Grants permission to fetch OpenSearch Service Reserved Instances that have already been purchased.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-describereservedinstances
     *
     * @experimental
     */
    toDescribeReservedInstances(): this;
    /**
     * (experimental) Grants permission to disassociate a package from the specified OpenSearch Service domain.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-dissociatepackage
     *
     * @experimental
     */
    toDissociatePackage(): this;
    /**
     * (experimental) Grants permission to send cross-cluster requests to a destination domain.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/ac.html#ac-reference
     *
     * @experimental
     */
    toESCrossClusterGet(): this;
    /**
     * (experimental) Grants permission to send HTTP DELETE requests to the OpenSearch APIs.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/ac.html#ac-reference
     *
     * @experimental
     */
    toESHttpDelete(): this;
    /**
     * (experimental) Grants permission to send HTTP GET requests to the OpenSearch APIs.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/es-ac.html#es-ac-reference
     *
     * @experimental
     */
    toESHttpGet(): this;
    /**
     * (experimental) Grants permission to send HTTP HEAD requests to the OpenSearch APIs.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/ac.html#ac-reference
     *
     * @experimental
     */
    toESHttpHead(): this;
    /**
     * (experimental) Grants permission to send HTTP PATCH requests to the OpenSearch APIs.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/ac.html#ac-reference
     *
     * @experimental
     */
    toESHttpPatch(): this;
    /**
     * (experimental) Grants permission to send HTTP POST requests to the OpenSearch APIs.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/ac.html#ac-reference
     *
     * @experimental
     */
    toESHttpPost(): this;
    /**
     * (experimental) Grants permission to send HTTP PUT requests to the OpenSearch APIs.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/ac.html#ac-reference
     *
     * @experimental
     */
    toESHttpPut(): this;
    /**
     * (experimental) Grants permission to fetch a list of compatible OpenSearch and Elasticsearch versions to which an OpenSearch Service domain can be upgraded.
     *
     * This permission is deprecated. Use GetCompatibleVersions instead
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-get-compat-vers
     *
     * @experimental
     */
    toGetCompatibleElasticsearchVersions(): this;
    /**
     * (experimental) Grants permission to fetch list of compatible engine versions to which an OpenSearch Service domain can be upgraded.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-get-compat-vers
     *
     * @experimental
     */
    toGetCompatibleVersions(): this;
    /**
     * (experimental) Grants permission to fetch the version history for a package.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-get-pac-ver-hist
     *
     * @experimental
     */
    toGetPackageVersionHistory(): this;
    /**
     * (experimental) Grants permission to fetch the upgrade history of a given OpenSearch Service domain.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-get-upgrade-hist
     *
     * @experimental
     */
    toGetUpgradeHistory(): this;
    /**
     * (experimental) Grants permission to fetch the upgrade status of a given OpenSearch Service domain.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-get-upgrade-stat
     *
     * @experimental
     */
    toGetUpgradeStatus(): this;
    /**
     * (experimental) Grants permission to display the names of all OpenSearch Service domains that the current user owns.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-listdomainnames
     *
     * @experimental
     */
    toListDomainNames(): this;
    /**
     * (experimental) Grants permission to list all OpenSearch Service domains that a package is associated with.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-listdomainsforpackage
     *
     * @experimental
     */
    toListDomainsForPackage(): this;
    /**
     * (experimental) Grants permission to list all instance types and available features for a given OpenSearch version.
     *
     * This permission is deprecated. Use ListInstanceTypeDetails instead
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-listinstancetypedetails
     *
     * @experimental
     */
    toListElasticsearchInstanceTypeDetails(): this;
    /**
     * (experimental) Grants permission to list all EC2 instance types that are supported for a given OpenSearch version.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html
     *
     * @experimental
     */
    toListElasticsearchInstanceTypes(): this;
    /**
     * (experimental) Grants permission to list all supported OpenSearch versions on Amazon OpenSearch Service. This permission is deprecated. Use ListVersions instead.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-listversions
     *
     * @experimental
     */
    toListElasticsearchVersions(): this;
    /**
     * (experimental) Grants permission to list all instance types and available features for a given OpenSearch or Elasticsearch version.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-listinstancetypedetails
     *
     * @experimental
     */
    toListInstanceTypeDetails(): this;
    /**
     * (experimental) Grants permission to list all packages associated with the OpenSearch Service domain.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-listpackagesfordomain
     *
     * @experimental
     */
    toListPackagesForDomain(): this;
    /**
     * (experimental) Grants permission to display all resource tags for an OpenSearch Service domain.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-listtags
     *
     * @experimental
     */
    toListTags(): this;
    /**
     * (experimental) Grants permission to list all supported OpenSearch and Elasticsearch versions in Amazon OpenSearch Service.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-listversions
     *
     * @experimental
     */
    toListVersions(): this;
    /**
     * (experimental) Grants permission to purchase OpenSearch Service Reserved Instances. This permission is deprecated. Use PurchaseReservedInstanceOffering instead.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-purchasereservedinstance
     *
     * @experimental
     */
    toPurchaseReservedElasticsearchInstanceOffering(): this;
    /**
     * (experimental) Grants permission to purchase OpenSearch reserved instances.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-purchasereservedinstance
     *
     * @experimental
     */
    toPurchaseReservedInstanceOffering(): this;
    /**
     * (experimental) Grants permission to the destination domain owner to reject an inbound cross-cluster search connection request.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-reject-inbound-cross-cluster-search-connection
     *
     * @experimental
     */
    toRejectInboundConnection(): this;
    /**
     * (experimental) Grants permission to the destination domain owner to reject an inbound cross-cluster search connection request.
     *
     * This permission is deprecated. Use RejectInboundConnection instead
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-reject-inbound-cross-cluster-search-connection
     *
     * @experimental
     */
    toRejectInboundCrossClusterSearchConnection(): this;
    /**
     * (experimental) Grants permission to remove resource tags from an OpenSearch Service domain.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-removetags
     *
     * @experimental
     */
    toRemoveTags(): this;
    /**
     * (experimental) Grants permission to start a service software update of a domain. This permission is deprecated. Use StartServiceSoftwareUpdate instead.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-startupdate
     *
     * @experimental
     */
    toStartElasticsearchServiceSoftwareUpdate(): this;
    /**
     * (experimental) Grants permission to start a service software update of a domain.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-startupdate
     *
     * @experimental
     */
    toStartServiceSoftwareUpdate(): this;
    /**
     * (experimental) Grants permission to modify the configuration of an OpenSearch Service domain, such as the instance type or number of instances.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-updatedomainconfig
     *
     * @experimental
     */
    toUpdateDomainConfig(): this;
    /**
     * (experimental) Grants permission to modify the configuration of an OpenSearch Service domain, such as the instance type or number of instances.
     *
     * This permission is deprecated. Use UpdateDomainConfig instead
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-updatedomainconfig
     *
     * @experimental
     */
    toUpdateElasticsearchDomainConfig(): this;
    /**
     * (experimental) Grants permission to update a package for use with OpenSearch Service domains.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-updatepackage
     *
     * @experimental
     */
    toUpdatePackage(): this;
    /**
     * (experimental) Grants permission to initiate upgrade of an OpenSearch Service domain to a given version.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-upgrade-domain
     *
     * @experimental
     */
    toUpgradeDomain(): this;
    /**
     * (experimental) Grants permission to initiate upgrade of an OpenSearch Service domain to a specified version.
     *
     * This permission is deprecated. Use UpgradeDomain instead
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/configuration-api.html#configuration-api-actions-upgrade-domain
     *
     * @experimental
     */
    toUpgradeElasticsearchDomain(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type domain to the statement.
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/ac.html
     *
     * @param domainName - Identifier for the domainName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onDomain(domainName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type es_role to the statement.
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/slr.html
     *
     * @param account - Account of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onEsRole(account?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type opensearchservice_role to the statement.
     *
     * https://docs.aws.amazon.com/opensearch-service/latest/developerguide/slr.html
     *
     * @param account - Account of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onOpensearchserviceRole(account?: string, partition?: string): this;
}
