import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
/**
 * (experimental) Statement provider for service [route53-recovery-control-config](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonroute53recoverycontrols.html).
 *
 * @experimental
 */
export declare class Route53RecoveryControlConfig extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [route53-recovery-control-config](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonroute53recoverycontrols.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to create a cluster.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/recovery-cluster/latest/api/cluster.html
     *
     * @experimental
     */
    toCreateCluster(): this;
    /**
     * (experimental) Grants permission to create a control panel.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/recovery-cluster/latest/api/controlpanel.html
     *
     * @experimental
     */
    toCreateControlPanel(): this;
    /**
     * (experimental) Grants permission to create a routing control.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/recovery-cluster/latest/api/routingcontrol.html
     *
     * @experimental
     */
    toCreateRoutingControl(): this;
    /**
     * (experimental) Grants permission to create a safety rule.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/recovery-cluster/latest/api/safetyrule.html
     *
     * @experimental
     */
    toCreateSafetyRule(): this;
    /**
     * (experimental) Grants permission to delete a cluster.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/recovery-cluster/latest/api/cluster-clusterarn.html
     *
     * @experimental
     */
    toDeleteCluster(): this;
    /**
     * (experimental) Grants permission to delete a control panel.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/recovery-cluster/latest/api/controlpanel-controlpanelarn.html
     *
     * @experimental
     */
    toDeleteControlPanel(): this;
    /**
     * (experimental) Grants permission to delete a routing control.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/recovery-cluster/latest/api/routingcontrol-routingcontrolarn.html
     *
     * @experimental
     */
    toDeleteRoutingControl(): this;
    /**
     * (experimental) Grants permission to delete a safety rule.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/recovery-cluster/latest/api/safetyrule-safetyrulearn.html
     *
     * @experimental
     */
    toDeleteSafetyRule(): this;
    /**
     * (experimental) Grants permission to describe a cluster.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/recovery-cluster/latest/api/cluster-clusterarn.html
     *
     * @experimental
     */
    toDescribeCluster(): this;
    /**
     * (experimental) Grants permission to describe a control panel.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/recovery-cluster/latest/api/controlpanel-controlpanelarn.html
     *
     * @experimental
     */
    toDescribeControlPanel(): this;
    /**
     * (experimental) Grants permission to describe a routing control.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/recovery-cluster/latest/api/routingcontrol-routingcontrolarn.html
     *
     * @experimental
     */
    toDescribeRoutingControl(): this;
    /**
     * (experimental) Grants permission to describe a routing control.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/recovery-cluster/latest/api/routingcontrol-routingcontrolarn.html
     *
     * @experimental
     */
    toDescribeRoutingControlByName(): this;
    /**
     * (experimental) Grants permission to describe a safety rule.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/recovery-cluster/latest/api/safetyrule-safetyrulearn.html
     *
     * @experimental
     */
    toDescribeSafetyRule(): this;
    /**
     * (experimental) Grants permission to list associated Route 53 health checks.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/recovery-cluster/latest/api/routingcontrol-routingcontrolarn-associatedroute53healthchecks.html
     *
     * @experimental
     */
    toListAssociatedRoute53HealthChecks(): this;
    /**
     * (experimental) Grants permission to list clusters.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/recovery-cluster/latest/api/cluster.html
     *
     * @experimental
     */
    toListClusters(): this;
    /**
     * (experimental) Grants permission to list control panels.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/recovery-cluster/latest/api/controlpanels.html
     *
     * @experimental
     */
    toListControlPanels(): this;
    /**
     * (experimental) Grants permission to list routing controls.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/recovery-cluster/latest/api/controlpanel-controlpanelarn-routingcontrols.html
     *
     * @experimental
     */
    toListRoutingControls(): this;
    /**
     * (experimental) Grants permission to list safety rules.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/recovery-cluster/latest/api/controlpanel-controlpanelarn-safetyrules.html
     *
     * @experimental
     */
    toListSafetyRules(): this;
    /**
     * (experimental) Grants permission to update a cluster.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/recovery-cluster/latest/api/controlpanel.html
     *
     * @experimental
     */
    toUpdateControlPanel(): this;
    /**
     * (experimental) Grants permission to update a routing control.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/recovery-cluster/latest/api/controlpanel-controlpanelarn-routingcontrols.html
     *
     * @experimental
     */
    toUpdateRoutingControl(): this;
    /**
     * (experimental) Grants permission to update a safety rule.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/recovery-cluster/latest/api/safetyrule.html
     *
     * @experimental
     */
    toUpdateSafetyRule(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type cluster to the statement.
     *
     * https://docs.aws.amazon.com/recovery-cluster/latest/api/cluster.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onCluster(resourceId: string, account?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type controlpanel to the statement.
     *
     * https://docs.aws.amazon.com/recovery-cluster/latest/api/controlpanel.html
     *
     * @param controlPanelId - Identifier for the controlPanelId.
     * @param account - Account of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onControlpanel(controlPanelId: string, account?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type routingcontrol to the statement.
     *
     * https://docs.aws.amazon.com/recovery-cluster/latest/api/routingcontrol.html
     *
     * @param controlPanelId - Identifier for the controlPanelId.
     * @param routingControlId - Identifier for the routingControlId.
     * @param account - Account of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onRoutingcontrol(controlPanelId: string, routingControlId: string, account?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type safetyrule to the statement.
     *
     * https://docs.aws.amazon.com/recovery-cluster/latest/api/safetyrule.html
     *
     * @param controlPanelId - Identifier for the controlPanelId.
     * @param safetyRuleId - Identifier for the safetyRuleId.
     * @param account - Account of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onSafetyrule(controlPanelId: string, safetyRuleId: string, account?: string, partition?: string): this;
}
