"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Textract = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * (experimental) Statement provider for service [textract](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazontextract.html).
 *
 * @experimental
 */
class Textract extends shared_1.PolicyStatement {
    /**
     * (experimental) Statement provider for service [textract](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazontextract.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid) {
        super(sid);
        /**
         * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
         *
         * @experimental
         */
        this.servicePrefix = 'textract';
        /**
         * @experimental
         */
        this.accessLevelList = {
            "Read": [
                "AnalyzeDocument",
                "AnalyzeExpense",
                "DetectDocumentText",
                "GetDocumentAnalysis",
                "GetDocumentTextDetection"
            ],
            "Write": [
                "StartDocumentAnalysis",
                "StartDocumentTextDetection"
            ]
        };
    }
    /**
     * (experimental) Grants permission to detect instances of real-world document entities within an image provided as input.
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_AnalyzeDocument.html
     *
     * @experimental
     */
    toAnalyzeDocument() {
        return this.to('AnalyzeDocument');
    }
    /**
     * (experimental) Grants permission to detect instances of real-world document entities within an image provided as input.
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_AnalyzeExpense.html
     *
     * @experimental
     */
    toAnalyzeExpense() {
        return this.to('AnalyzeExpense');
    }
    /**
     * (experimental) Grants permission to detect text in document images.
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_DetectDocumentText.html
     *
     * @experimental
     */
    toDetectDocumentText() {
        return this.to('DetectDocumentText');
    }
    /**
     * (experimental) Grants permission to return information about a document analysis job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_GetDocumentAnalysis.html
     *
     * @experimental
     */
    toGetDocumentAnalysis() {
        return this.to('GetDocumentAnalysis');
    }
    /**
     * (experimental) Grants permission to return information about a document text detection job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_GetDocumentTextDetection.html
     *
     * @experimental
     */
    toGetDocumentTextDetection() {
        return this.to('GetDocumentTextDetection');
    }
    /**
     * (experimental) Grants permission to start an asynchronous job to detect instances of real-world document entities within an image or pdf provided as input.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_StartDocumentAnalysis.html
     *
     * @experimental
     */
    toStartDocumentAnalysis() {
        return this.to('StartDocumentAnalysis');
    }
    /**
     * (experimental) Grants permission to start an asynchronous job to detect text in document images or pdfs.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_StartDocumentTextDetection.html
     *
     * @experimental
     */
    toStartDocumentTextDetection() {
        return this.to('StartDocumentTextDetection');
    }
}
exports.Textract = Textract;
_a = JSII_RTTI_SYMBOL_1;
Textract[_a] = { fqn: "iam-floyd.Textract", version: "0.266.0" };
//# sourceMappingURL=data:application/json;base64,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