import { Project } from "projen";
import { SmithyApiGatewayProjectOptions } from "../types";
/**
 * Result from setting up a smithy based project
 */
export interface SmithyBuildProjectResult {
    /**
     * Path to the generated OpenAPI spec to use as input for an OpenApiGateway<Language>Project
     */
    readonly generatedSpecFilePath: string;
}
/**
 * Adds the common subprojects for building a Smithy model into an OpenAPI spec
 */
export declare const setupSmithyBuild: (project: Project, options: SmithyApiGatewayProjectOptions) => SmithyBuildProjectResult;
