# mypy-boto3-robomaker

[![PyPI - mypy-boto3-robomaker](https://img.shields.io/pypi/v/mypy-boto3-robomaker.svg?color=blue)](https://pypi.org/project/mypy-boto3-robomaker)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-robomaker.svg?color=blue)](https://pypi.org/project/mypy-boto3-robomaker)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

- [mypy-boto3-robomaker](#mypy-boto3-robomaker)
  - [How to use](#how-to-use)
  - [Automated type discovery](#automated-type-discovery)


Type annotations for
[boto3.RoboMaker 1.13.26](https://boto3.amazonaws.com/v1/documentation/api/1.13.26/reference/services/robomaker.html#RoboMaker) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 2.0.3](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-robomaker](#mypy-boto3-robomaker)
  - [How to use](#how-to-use)
    - [Type checking](#type-checking)
  - [How it works](#how-it-works)

## How to use

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `RoboMaker` service.

```bash
python -m pip install boto3-stubs[robomaker]

# update installed packages index for automated type discovery
python -m mypy_boto3
```

Use `boto3` with `mypy_boto3_robomaker` in your project and enjoy type checking and auto-complete.

```python
import boto3

from mypy_boto3_robomaker import RoboMakerClient

# Now mypy can check if your code is valid.
client: RoboMakerClient = boto3.client("robomaker")

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: RoboMakerClient = session.client("robomaker")



# Annotated paginators are included as well

import mypy_boto3_robomaker.paginator as robomaker_paginators

list_deployment_jobs_paginator: robomaker_paginators.ListDeploymentJobsPaginator = client.get_paginator("list_deployment_jobs")
list_fleets_paginator: robomaker_paginators.ListFleetsPaginator = client.get_paginator("list_fleets")
list_robot_applications_paginator: robomaker_paginators.ListRobotApplicationsPaginator = client.get_paginator("list_robot_applications")
list_robots_paginator: robomaker_paginators.ListRobotsPaginator = client.get_paginator("list_robots")
list_simulation_applications_paginator: robomaker_paginators.ListSimulationApplicationsPaginator = client.get_paginator("list_simulation_applications")
list_simulation_job_batches_paginator: robomaker_paginators.ListSimulationJobBatchesPaginator = client.get_paginator("list_simulation_job_batches")
list_simulation_jobs_paginator: robomaker_paginators.ListSimulationJobsPaginator = client.get_paginator("list_simulation_jobs")
```

## Automated type discovery

`mypy_boto3` package can generate index for `mypy_boto3_robomaker` and other installed services.

```bash
# Run this command when you add or remove service packages
python -m mypy_boto3
```

Generated index provides overloads for `boto3.client` and `boto3.service`,
`boto3.Session.client` and `boto3.Session.resource` functions,
so explicit type annotations are not needed.

- `mypy` supports function overloads as expected
- `PyCharm` also supports function overloads, but consumes a lot of RAM, use carefully
- `VSCode` does not currently support function overloads

Also, generated index allows you to import types from `mypy_boto3`:

```python
# you can replace imports
import mypy_boto3_robomaker as robomaker
from mypy_boto3_robomaker import RoboMakerClient

# with these
from mypy_boto3 import robomaker
from mypy_boto3.robomaker import RoboMakerClient
```