# Generated by Django 2.2.16 on 2020-10-15 19:26

from django.db import migrations, models

import dj_smail.fields


class Migration(migrations.Migration):
    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='CaCertificate',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('certificate_txt', models.TextField(help_text='A PEM-encoded X.509 Certificate.', unique=True,
                                                     verbose_name='Certificate')),
                ('serial_number', models.CharField(db_index=True, default='0', editable=False,
                                                   help_text='The serial number of the certificate.', max_length=48,
                                                   verbose_name='serial number')),
            ],
            options={
                'verbose_name_plural': 'Root and Intermediate Certificates',
            },
        ),
        migrations.CreateModel(
            name='Certificate',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('certificate_txt', models.TextField(help_text='A PEM-encoded X.509 Certificate.', unique=True,
                                                     verbose_name='Certificate')),
                ('serial_number', models.CharField(db_index=True, default='0', editable=False,
                                                   help_text='The serial number of the certificate.', max_length=48,
                                                   verbose_name='serial number')),
            ],
            options={
                'verbose_name_plural': 'Certificates',
            },
        ),
        migrations.CreateModel(
            name='CertificateWithKey',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('certificate_txt', models.TextField(help_text='A PEM-encoded X.509 Certificate.', unique=True,
                                                     verbose_name='Certificate')),
                ('serial_number', models.CharField(db_index=True, default='0', editable=False,
                                                   help_text='The serial number of the certificate.', max_length=48,
                                                   verbose_name='serial number')),
                ('private_key_txt',
                 models.TextField(help_text='A PEM-encoded Private Key that will be stored in database in as is.',
                                  unique=True, verbose_name='Private Key')),
                ('private_key_passphrase', dj_smail.fields.EncryptedCharField(blank=True,
                                                                              help_text='The Passphrase to '
                                                                                        'decrypt the PEM-encoded '
                                                                                        'Private Key.',
                                                                              max_length=255, null=True,
                                                                              verbose_name='Enter Passphrase')),
                ('ca_certs',
                 models.ManyToManyField(blank=True, help_text='List of Root or Intermediate Certificate Authorities.',
                                        to='dj_smail.CaCertificate', verbose_name='CA Certs')),
            ],
            options={
                'verbose_name_plural': 'Certificates with Key',
            },
        ),
    ]
