from django.apps import AppConfig
from django.core.checks import Warning, Error, register


class AllianceAuthConfig(AppConfig):
    name = 'allianceauth'


@register()
def check_settings(app_configs, **kwargs):
    from django.conf import settings

    errors = []
    if hasattr(settings, "SITE_URL"):
        if settings.SITE_URL[-1] == "/":
            errors.append(Warning(
                "'SITE_URL' Has a trailing slash. This may lead to incorrect links being generated by Auth."))
    else:
        errors.append(Error(
            "No 'SITE_URL' found is settings. This may lead to incorrect links being generated by Auth or Errors in 3rd party modules."))
    if hasattr(settings, "CSRF_TRUSTED_ORIGINS"):
        if hasattr(settings, "SITE_URL"):
            if settings.SITE_URL not in settings.CSRF_TRUSTED_ORIGINS:
                errors.append(Warning(
                    "'SITE_URL' not found in 'CSRF_TRUSTED_ORIGINS'. Auth may not load pages correctly until this is rectified."))
    else:
        errors.append(Error(
            "No 'CSRF_TRUSTED_ORIGINS' found is settings, Auth may not load pages correctly until this is rectified"))

    return errors
