import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [rolesanywhere](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsidentityandaccessmanagementrolesanywhere.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Rolesanywhere extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [rolesanywhere](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsidentityandaccessmanagementrolesanywhere.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to create a profile
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_CreateProfile.html
     */
    toCreateProfile(): this;
    /**
     * Grants permission to create a trust anchor
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_CreateTrustAnchor.html
     */
    toCreateTrustAnchor(): this;
    /**
     * Grants permission to delete a certificate revocation list (crl)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_DeleteCrl.html
     */
    toDeleteCrl(): this;
    /**
     * Grants permission to delete a profile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_DeleteProfile.html
     */
    toDeleteProfile(): this;
    /**
     * Grants permission to delete a trust anchor
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_DeleteTrustAnchor.html
     */
    toDeleteTrustAnchor(): this;
    /**
     * Grants permission to disable a certificate revocation list (crl)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_DisableCrl.html
     */
    toDisableCrl(): this;
    /**
     * Grants permission to disable a profile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_DisableProfile.html
     */
    toDisableProfile(): this;
    /**
     * Grants permission to disable a trust anchor
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_DisableTrustAnchor.html
     */
    toDisableTrustAnchor(): this;
    /**
     * Grants permission to enable a certificate revocation list (crl)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_EnableCrl.html
     */
    toEnableCrl(): this;
    /**
     * Grants permission to enable a profile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_EnableProfile.html
     */
    toEnableProfile(): this;
    /**
     * Grants permission to enable a trust anchor
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_EnableTrustAnchor.html
     */
    toEnableTrustAnchor(): this;
    /**
     * Grants permission to get a certificate revocation list (crl)
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_GetCrl.html
     */
    toGetCrl(): this;
    /**
     * Grants permission to get a profile
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_GetProfile.html
     */
    toGetProfile(): this;
    /**
     * Grants permission to get a subject
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_GetSubject.html
     */
    toGetSubject(): this;
    /**
     * Grants permission to get a trust anchor
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_GetTrustAnchor.html
     */
    toGetTrustAnchor(): this;
    /**
     * Grants permission to import a certificate revocation list (crl)
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_ImportCrl.html
     */
    toImportCrl(): this;
    /**
     * Grants permission to list certificate revocation lists (crls)
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_ListCrls.html
     */
    toListCrls(): this;
    /**
     * Grants permission to list profiles
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_ListProfiles.html
     */
    toListProfiles(): this;
    /**
     * Grants permission to list subjects
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_ListSubjects.html
     */
    toListSubjects(): this;
    /**
     * Grants permission to list tags for a resource
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to list trust anchors
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_ListTrustAnchors.html
     */
    toListTrustAnchors(): this;
    /**
     * Grants permission to tag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to untag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update a certificate revocation list (crl)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_UpdateCrl.html
     */
    toUpdateCrl(): this;
    /**
     * Grants permission to update a profile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_UpdateProfile.html
     */
    toUpdateProfile(): this;
    /**
     * Grants permission to update a trust anchor
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_UpdateTrustAnchor.html
     */
    toUpdateTrustAnchor(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type trust-anchor to the statement
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/userguide/introduction.html#first-time-user
     *
     * @param trustAnchorId - Identifier for the trustAnchorId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onTrustAnchor(trustAnchorId: string, account?: string, partition?: string): this;
    /**
     * Adds a resource of type profile to the statement
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/userguide/introduction.html#first-time-user
     *
     * @param profileId - Identifier for the profileId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onProfile(profileId: string, account?: string, partition?: string): this;
    /**
     * Adds a resource of type subject to the statement
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/userguide/introduction.html#first-time-user
     *
     * @param subjectId - Identifier for the subjectId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onSubject(subjectId: string, account?: string, partition?: string): this;
    /**
     * Adds a resource of type crl to the statement
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/userguide/introduction.html#first-time-user
     *
     * @param crlId - Identifier for the crlId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onCrl(crlId: string, account?: string, partition?: string): this;
}
