import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement, Operator } from '../shared';
/**
 * Statement provider for service [redshift-serverless](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonredshiftserverless.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class RedshiftServerless extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [redshift-serverless](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonredshiftserverless.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to convert a recovery point to a snapshot
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_ConvertRecoveryPointToSnapshot.html
     */
    toConvertRecoveryPointToSnapshot(): this;
    /**
     * Grants permission to create an Amazon Redshift Serverless managed VPC endpoint
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_CreateEndpointAccess.html
     */
    toCreateEndpointAccess(): this;
    /**
     * Grants permission to create an Amazon Redshift Serverless namespace
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_CreateNamespace.html
     */
    toCreateNamespace(): this;
    /**
     * Grants permission to create a snapshot of all databases in a namespace
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_CreateSnapshot.html
     */
    toCreateSnapshot(): this;
    /**
     * Grants permission to create a usage limit for a specified Amazon Redshift Serverless usage type
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_CreateUsageLimit.html
     */
    toCreateUsageLimit(): this;
    /**
     * Grants permission to create a workgroup in Amazon Redshift Serverless
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_CreateWorkgroup.html
     */
    toCreateWorkgroup(): this;
    /**
     * Grants permission to delete an Amazon Redshift Serverless managed VPC endpoint
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_DeleteEndpointAccess.html
     */
    toDeleteEndpointAccess(): this;
    /**
     * Grants permission to delete a namespace from Amazon Redshift Serverless
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_DeleteNamespace.html
     */
    toDeleteNamespace(): this;
    /**
     * Grants permission to delete the specified resource policy
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_DeleteResourcePolicy.html
     */
    toDeleteResourcePolicy(): this;
    /**
     * Grants permission to delete a snapshot from Amazon Redshift Serverless
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_DeleteSnapshot.html
     */
    toDeleteSnapshot(): this;
    /**
     * Grants permission to delete a usage limit from Amazon Redshift Serverless
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_DeleteUsageLimit.html
     */
    toDeleteUsageLimit(): this;
    /**
     * Grants permission to delete a workgroup
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_DeleteWorkgroup.html
     */
    toDeleteWorkgroup(): this;
    /**
     * Grants permission to get a database user name and temporary password with temporary authorization to log on to Amazon Redshift Serverless
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_GetCredentials.html
     */
    toGetCredentials(): this;
    /**
     * Grants permission to create an Amazon Redshift Serverless managed VPC endpoint
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_GetEndpointAccess.html
     */
    toGetEndpointAccess(): this;
    /**
     * Grants permission to get information about a namespace in Amazon Redshift Serverless
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_GetNamespace.html
     */
    toGetNamespace(): this;
    /**
     * Grants permission to get information about a recovery point
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_GetRecoveryPoint.html
     */
    toGetRecoveryPoint(): this;
    /**
     * Grants permission to get a resource policy
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_GetResourcePolicy.html
     */
    toGetResourcePolicy(): this;
    /**
     * Grants permission to get information about a specific snapshot
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_GetSnapshot.html
     */
    toGetSnapshot(): this;
    /**
     * Grants permission to get information about a usage limit in Amazon Redshift Serverless
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_GetUsageLimit.html
     */
    toGetUsageLimit(): this;
    /**
     * Grants permission to get information about a specific workgroup
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_GetWorkgroup.html
     */
    toGetWorkgroup(): this;
    /**
     * Grants permission to list EndpointAccess objects and relevant information
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_ListEndpointAccess.html
     */
    toListEndpointAccess(): this;
    /**
     * Grants permission to list namespaces in Amazon Redshift Serverless
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_ListNamespaces.html
     */
    toListNamespaces(): this;
    /**
     * Grants permission to list an array of recovery points
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_ListRecoveryPoints.html
     */
    toListRecoveryPoints(): this;
    /**
     * Grants permission to list snapshots
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_ListSnapshots.html
     */
    toListSnapshots(): this;
    /**
     * Grants permission to list the tags assigned to a resource
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to list all usage limits within Amazon Redshift Serverless
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_ListUsageLimits.html
     */
    toListUsageLimits(): this;
    /**
     * Grants permission to list workgroups in Amazon Redshift Serverless
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_ListWorkgroups.html
     */
    toListWorkgroups(): this;
    /**
     * Grants permission to create or update a resource policy
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_PutResourcePolicy.html
     */
    toPutResourcePolicy(): this;
    /**
     * Grants permission to restore the data from a recovery point
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_RestoreFromRecoveryPoint.html
     */
    toRestoreFromRecoveryPoint(): this;
    /**
     * Grants permission to restore a namespace from a snapshot
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_RestoreFromSnapshot.html
     */
    toRestoreFromSnapshot(): this;
    /**
     * Grants permission to assign one or more tags to a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove a tag or set of tags from a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update an Amazon Redshift Serverless managed VPC endpoint
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_UpdateEndpointAccess.html
     */
    toUpdateEndpointAccess(): this;
    /**
     * Grants permission to update a namespace with the specified configuration settings
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_UpdateNamespace.html
     */
    toUpdateNamespace(): this;
    /**
     * Grants permission to update a snapshot
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_UpdateSnapshot.html
     */
    toUpdateSnapshot(): this;
    /**
     * Grants permission to update a usage limit in Amazon Redshift Serverless
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_UpdateUsageLimit.html
     */
    toUpdateUsageLimit(): this;
    /**
     * Grants permission to update an Amazon Redshift Serverless workgroup with the specified configuration settings
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_UpdateWorkgroup.html
     */
    toUpdateWorkgroup(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type namespace to the statement
     *
     * https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-workgroup-namespace.html
     *
     * @param namespaceId - Identifier for the namespaceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onNamespace(namespaceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type snapshot to the statement
     *
     * https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-snapshots-recovery.html
     *
     * @param snapshotId - Identifier for the snapshotId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onSnapshot(snapshotId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type workgroup to the statement
     *
     * https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-workgroup-namespace.html
     *
     * @param workgroupId - Identifier for the workgroupId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onWorkgroup(workgroupId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type recoveryPoint to the statement
     *
     * https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-snapshots-recovery.html
     *
     * @param recoveryPointId - Identifier for the recoveryPointId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onRecoveryPoint(recoveryPointId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type endpointAccess to the statement
     *
     * https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-connecting.html
     *
     * @param endpointAccessId - Identifier for the endpointAccessId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onEndpointAccess(endpointAccessId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the endpoint access identifier
     *
     * https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-policy-resources.resource-permissions.html
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifEndpointAccessId(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the namespace identifier
     *
     * https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-policy-resources.resource-permissions.html
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifNamespaceId(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the recovery point identifier
     *
     * https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-policy-resources.resource-permissions.html
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifRecoveryPointId(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the snapshot identifier
     *
     * https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-policy-resources.resource-permissions.html
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifSnapshotId(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the workgroup identifier
     *
     * https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-policy-resources.resource-permissions.html
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifWorkgroupId(value: string | string[], operator?: Operator | string): this;
}
