"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Route53RecoveryReadiness = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [route53-recovery-readiness](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonroute53recoveryreadiness.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Route53RecoveryReadiness extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [route53-recovery-readiness](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonroute53recoveryreadiness.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'route53-recovery-readiness';
        this.accessLevelList = {
            Write: [
                'CreateCell',
                'CreateCrossAccountAuthorization',
                'CreateReadinessCheck',
                'CreateRecoveryGroup',
                'CreateResourceSet',
                'DeleteCell',
                'DeleteCrossAccountAuthorization',
                'DeleteReadinessCheck',
                'DeleteRecoveryGroup',
                'DeleteResourceSet',
                'UpdateCell',
                'UpdateReadinessCheck',
                'UpdateRecoveryGroup',
                'UpdateResourceSet'
            ],
            Read: [
                'GetArchitectureRecommendations',
                'GetCell',
                'GetCellReadinessSummary',
                'GetReadinessCheck',
                'GetReadinessCheckResourceStatus',
                'GetReadinessCheckStatus',
                'GetRecoveryGroup',
                'GetRecoveryGroupReadinessSummary',
                'GetResourceSet',
                'ListCells',
                'ListCrossAccountAuthorizations',
                'ListReadinessChecks',
                'ListRecoveryGroups',
                'ListResourceSets',
                'ListRules',
                'ListTagsForResources'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * Grants permission to create a new cell
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/cells.html
     */
    toCreateCell() {
        return this.to('CreateCell');
    }
    /**
     * Grants permission to create a cross account authorization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/crossaccountauthorizations.html
     */
    toCreateCrossAccountAuthorization() {
        return this.to('CreateCrossAccountAuthorization');
    }
    /**
     * Grants permission to create a readiness check
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/readinesschecks.html
     */
    toCreateReadinessCheck() {
        return this.to('CreateReadinessCheck');
    }
    /**
     * Grants permission to create a recovery group
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/recoverygroups.html
     */
    toCreateRecoveryGroup() {
        return this.to('CreateRecoveryGroup');
    }
    /**
     * Grants permission to create a resource set
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/resourcesets.html
     */
    toCreateResourceSet() {
        return this.to('CreateResourceSet');
    }
    /**
     * Grants permission to delete a cell
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/cells-cellname.html
     */
    toDeleteCell() {
        return this.to('DeleteCell');
    }
    /**
     * Grants permission to delete a cross account authorization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/crossaccountauthorizations-crossaccountauthorization.html
     */
    toDeleteCrossAccountAuthorization() {
        return this.to('DeleteCrossAccountAuthorization');
    }
    /**
     * Grants permission to delete a readiness check
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/readinesschecks-readinesscheckname.html
     */
    toDeleteReadinessCheck() {
        return this.to('DeleteReadinessCheck');
    }
    /**
     * Grants permission to delete a recovery group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/recoverygroups-recoverygroupname.html
     */
    toDeleteRecoveryGroup() {
        return this.to('DeleteRecoveryGroup');
    }
    /**
     * Grants permission to delete a resource set
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/resourcesets-resourcesetname.html
     */
    toDeleteResourceSet() {
        return this.to('DeleteResourceSet');
    }
    /**
     * Grants permission to get architecture recommendations for a recovery group
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/recoverygroups-recoverygroupname-architecturerecommendations.html
     */
    toGetArchitectureRecommendations() {
        return this.to('GetArchitectureRecommendations');
    }
    /**
     * Grants permission to get information about a cell
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/cells-cellname.html
     */
    toGetCell() {
        return this.to('GetCell');
    }
    /**
     * Grants permission to get a readiness summary for a cell
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/cellreadiness-cellname.html
     */
    toGetCellReadinessSummary() {
        return this.to('GetCellReadinessSummary');
    }
    /**
     * Grants permission to get information about a readiness check
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/readinesschecks-readinesscheckname.html
     */
    toGetReadinessCheck() {
        return this.to('GetReadinessCheck');
    }
    /**
     * Grants permission to get the readiness status for an individual resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/readinesschecks-readinesscheckname-resource-resourceidentifier-status.html
     */
    toGetReadinessCheckResourceStatus() {
        return this.to('GetReadinessCheckResourceStatus');
    }
    /**
     * Grants permission to get the status of a readiness check (for a resource set)
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/readinesschecks-readinesscheckname-status.html
     */
    toGetReadinessCheckStatus() {
        return this.to('GetReadinessCheckStatus');
    }
    /**
     * Grants permission to get information about a recovery group
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/recoverygroups-recoverygroupname.html
     */
    toGetRecoveryGroup() {
        return this.to('GetRecoveryGroup');
    }
    /**
     * Grants permission to get a readiness summary for a recovery group
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/recoverygroupreadiness-recoverygroupname.html
     */
    toGetRecoveryGroupReadinessSummary() {
        return this.to('GetRecoveryGroupReadinessSummary');
    }
    /**
     * Grants permission to get information about a resource set
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/resourcesets-resourcesetname.html
     */
    toGetResourceSet() {
        return this.to('GetResourceSet');
    }
    /**
     * Grants permission to list cells
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/cells.html
     */
    toListCells() {
        return this.to('ListCells');
    }
    /**
     * Grants permission to list cross account authorizations
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/readinesschecks.html
     */
    toListCrossAccountAuthorizations() {
        return this.to('ListCrossAccountAuthorizations');
    }
    /**
     * Grants permission to list readiness checks
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/readinesschecks.html
     */
    toListReadinessChecks() {
        return this.to('ListReadinessChecks');
    }
    /**
     * Grants permission to list recovery groups
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/recoverygroups.html
     */
    toListRecoveryGroups() {
        return this.to('ListRecoveryGroups');
    }
    /**
     * Grants permission to list resource sets
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/resourcesets.html
     */
    toListResourceSets() {
        return this.to('ListResourceSets');
    }
    /**
     * Grants permission to list readiness rules
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/rules.html
     */
    toListRules() {
        return this.to('ListRules');
    }
    /**
     * Grants permission to list tags for a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/tags-resource-arn.html
     */
    toListTagsForResources() {
        return this.to('ListTagsForResources');
    }
    /**
     * Grants permission to add a tag to a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/tags-resource-arn.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to remove a tag from a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/tags-resource-arn.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to update a cell
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/cells-cellname.html
     */
    toUpdateCell() {
        return this.to('UpdateCell');
    }
    /**
     * Grants permission to update a readiness check
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/readinesschecks-readinesscheckname.html
     */
    toUpdateReadinessCheck() {
        return this.to('UpdateReadinessCheck');
    }
    /**
     * Grants permission to update a recovery group
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/recoverygroups-recoverygroupname.html
     */
    toUpdateRecoveryGroup() {
        return this.to('UpdateRecoveryGroup');
    }
    /**
     * Grants permission to update a resource set
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/resourcesets-resourcesetname.html
     */
    toUpdateResourceSet() {
        return this.to('UpdateResourceSet');
    }
    /**
     * Adds a resource of type readinesscheck to the statement
     *
     * https://docs.aws.amazon.com/r53recovery/latest/dg/recovery-readiness.readiness-checks.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onReadinesscheck(resourceId, account, partition) {
        return this.on(`arn:${partition || Route53RecoveryReadiness.defaultPartition}:route53-recovery-readiness::${account || '*'}:readiness-check/${resourceId}`);
    }
    /**
     * Adds a resource of type resourceset to the statement
     *
     * https://docs.aws.amazon.com/r53recovery/latest/dg/recovery-readiness.readiness-checks.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onResourceset(resourceId, account, partition) {
        return this.on(`arn:${partition || Route53RecoveryReadiness.defaultPartition}:route53-recovery-readiness::${account || '*'}:resource-set/${resourceId}`);
    }
    /**
     * Adds a resource of type cell to the statement
     *
     * https://docs.aws.amazon.com/r53recovery/latest/dg/recovery-readiness.recovery-groups.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onCell(resourceId, account, partition) {
        return this.on(`arn:${partition || Route53RecoveryReadiness.defaultPartition}:route53-recovery-readiness::${account || '*'}:cell/${resourceId}`);
    }
    /**
     * Adds a resource of type recoverygroup to the statement
     *
     * https://docs.aws.amazon.com/r53recovery/latest/dg/recovery-readiness.recovery-groups.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onRecoverygroup(resourceId, account, partition) {
        return this.on(`arn:${partition || Route53RecoveryReadiness.defaultPartition}:route53-recovery-readiness::${account || '*'}:recovery-group/${resourceId}`);
    }
}
exports.Route53RecoveryReadiness = Route53RecoveryReadiness;
_a = JSII_RTTI_SYMBOL_1;
Route53RecoveryReadiness[_a] = { fqn: "iam-floyd.Route53RecoveryReadiness", version: "0.438.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicm91dGU1M3JlY292ZXJ5cmVhZGluZXNzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsicm91dGU1M3JlY292ZXJ5cmVhZGluZXNzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQ0Esc0NBQTRDO0FBRTVDOzs7O0dBSUc7QUFDSCxNQUFhLHdCQUF5QixTQUFRLHdCQUFlO0lBRzNEOzs7O09BSUc7SUFDSCxZQUFZLEdBQVk7UUFDdEIsS0FBSyxDQUFDLEdBQUcsQ0FBQyxDQUFDO1FBUk4sa0JBQWEsR0FBRyw0QkFBNEIsQ0FBQztRQStZMUMsb0JBQWUsR0FBb0I7WUFDM0MsS0FBSyxFQUFFO2dCQUNMLFlBQVk7Z0JBQ1osaUNBQWlDO2dCQUNqQyxzQkFBc0I7Z0JBQ3RCLHFCQUFxQjtnQkFDckIsbUJBQW1CO2dCQUNuQixZQUFZO2dCQUNaLGlDQUFpQztnQkFDakMsc0JBQXNCO2dCQUN0QixxQkFBcUI7Z0JBQ3JCLG1CQUFtQjtnQkFDbkIsWUFBWTtnQkFDWixzQkFBc0I7Z0JBQ3RCLHFCQUFxQjtnQkFDckIsbUJBQW1CO2FBQ3BCO1lBQ0QsSUFBSSxFQUFFO2dCQUNKLGdDQUFnQztnQkFDaEMsU0FBUztnQkFDVCx5QkFBeUI7Z0JBQ3pCLG1CQUFtQjtnQkFDbkIsaUNBQWlDO2dCQUNqQyx5QkFBeUI7Z0JBQ3pCLGtCQUFrQjtnQkFDbEIsa0NBQWtDO2dCQUNsQyxnQkFBZ0I7Z0JBQ2hCLFdBQVc7Z0JBQ1gsZ0NBQWdDO2dCQUNoQyxxQkFBcUI7Z0JBQ3JCLG9CQUFvQjtnQkFDcEIsa0JBQWtCO2dCQUNsQixXQUFXO2dCQUNYLHNCQUFzQjthQUN2QjtZQUNELE9BQU8sRUFBRTtnQkFDUCxhQUFhO2dCQUNiLGVBQWU7YUFDaEI7U0FDRixDQUFDO0lBN2FGLENBQUM7SUFFRDs7Ozs7Ozs7OztPQVVHO0lBQ0ksWUFBWTtRQUNqQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsWUFBWSxDQUFDLENBQUM7SUFDL0IsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGlDQUFpQztRQUN0QyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsaUNBQWlDLENBQUMsQ0FBQztJQUNwRCxDQUFDO0lBRUQ7Ozs7Ozs7Ozs7T0FVRztJQUNJLHNCQUFzQjtRQUMzQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsc0JBQXNCLENBQUMsQ0FBQztJQUN6QyxDQUFDO0lBRUQ7Ozs7Ozs7Ozs7T0FVRztJQUNJLHFCQUFxQjtRQUMxQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMscUJBQXFCLENBQUMsQ0FBQztJQUN4QyxDQUFDO0lBRUQ7Ozs7Ozs7Ozs7T0FVRztJQUNJLG1CQUFtQjtRQUN4QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsbUJBQW1CLENBQUMsQ0FBQztJQUN0QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksWUFBWTtRQUNqQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsWUFBWSxDQUFDLENBQUM7SUFDL0IsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGlDQUFpQztRQUN0QyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsaUNBQWlDLENBQUMsQ0FBQztJQUNwRCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksc0JBQXNCO1FBQzNCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDO0lBQ3pDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxxQkFBcUI7UUFDMUIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHFCQUFxQixDQUFDLENBQUM7SUFDeEMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLG1CQUFtQjtRQUN4QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsbUJBQW1CLENBQUMsQ0FBQztJQUN0QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksZ0NBQWdDO1FBQ3JDLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxnQ0FBZ0MsQ0FBQyxDQUFDO0lBQ25ELENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxTQUFTO1FBQ2QsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQzVCLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSx5QkFBeUI7UUFDOUIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHlCQUF5QixDQUFDLENBQUM7SUFDNUMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLG1CQUFtQjtRQUN4QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsbUJBQW1CLENBQUMsQ0FBQztJQUN0QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksaUNBQWlDO1FBQ3RDLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxpQ0FBaUMsQ0FBQyxDQUFDO0lBQ3BELENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSx5QkFBeUI7UUFDOUIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHlCQUF5QixDQUFDLENBQUM7SUFDNUMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGtCQUFrQjtRQUN2QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsa0JBQWtCLENBQUMsQ0FBQztJQUNyQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksa0NBQWtDO1FBQ3ZDLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxrQ0FBa0MsQ0FBQyxDQUFDO0lBQ3JELENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxnQkFBZ0I7UUFDckIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGdCQUFnQixDQUFDLENBQUM7SUFDbkMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLFdBQVc7UUFDaEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLFdBQVcsQ0FBQyxDQUFDO0lBQzlCLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxnQ0FBZ0M7UUFDckMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGdDQUFnQyxDQUFDLENBQUM7SUFDbkQsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHFCQUFxQjtRQUMxQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMscUJBQXFCLENBQUMsQ0FBQztJQUN4QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksb0JBQW9CO1FBQ3pCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDO0lBQ3ZDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxrQkFBa0I7UUFDdkIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGtCQUFrQixDQUFDLENBQUM7SUFDckMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLFdBQVc7UUFDaEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLFdBQVcsQ0FBQyxDQUFDO0lBQzlCLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxzQkFBc0I7UUFDM0IsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHNCQUFzQixDQUFDLENBQUM7SUFDekMsQ0FBQztJQUVEOzs7Ozs7Ozs7O09BVUc7SUFDSSxhQUFhO1FBQ2xCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxhQUFhLENBQUMsQ0FBQztJQUNoQyxDQUFDO0lBRUQ7Ozs7Ozs7Ozs7T0FVRztJQUNJLGVBQWU7UUFDcEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGVBQWUsQ0FBQyxDQUFDO0lBQ2xDLENBQUM7SUFFRDs7Ozs7Ozs7O09BU0c7SUFDSSxZQUFZO1FBQ2pCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxZQUFZLENBQUMsQ0FBQztJQUMvQixDQUFDO0lBRUQ7Ozs7Ozs7OztPQVNHO0lBQ0ksc0JBQXNCO1FBQzNCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDO0lBQ3pDLENBQUM7SUFFRDs7Ozs7Ozs7O09BU0c7SUFDSSxxQkFBcUI7UUFDMUIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHFCQUFxQixDQUFDLENBQUM7SUFDeEMsQ0FBQztJQUVEOzs7Ozs7Ozs7T0FTRztJQUNJLG1CQUFtQjtRQUN4QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsbUJBQW1CLENBQUMsQ0FBQztJQUN0QyxDQUFDO0lBMkNEOzs7Ozs7Ozs7OztPQVdHO0lBQ0ksZ0JBQWdCLENBQUMsVUFBa0IsRUFBRSxPQUFnQixFQUFFLFNBQWtCO1FBQzlFLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxPQUFRLFNBQVMsSUFBSSx3QkFBd0IsQ0FBQyxnQkFBaUIsZ0NBQWlDLE9BQU8sSUFBSSxHQUFJLG9CQUFxQixVQUFXLEVBQUUsQ0FBQyxDQUFDO0lBQ3BLLENBQUM7SUFFRDs7Ozs7Ozs7Ozs7T0FXRztJQUNJLGFBQWEsQ0FBQyxVQUFrQixFQUFFLE9BQWdCLEVBQUUsU0FBa0I7UUFDM0UsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLE9BQVEsU0FBUyxJQUFJLHdCQUF3QixDQUFDLGdCQUFpQixnQ0FBaUMsT0FBTyxJQUFJLEdBQUksaUJBQWtCLFVBQVcsRUFBRSxDQUFDLENBQUM7SUFDakssQ0FBQztJQUVEOzs7Ozs7Ozs7OztPQVdHO0lBQ0ksTUFBTSxDQUFDLFVBQWtCLEVBQUUsT0FBZ0IsRUFBRSxTQUFrQjtRQUNwRSxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsT0FBUSxTQUFTLElBQUksd0JBQXdCLENBQUMsZ0JBQWlCLGdDQUFpQyxPQUFPLElBQUksR0FBSSxTQUFVLFVBQVcsRUFBRSxDQUFDLENBQUM7SUFDekosQ0FBQztJQUVEOzs7Ozs7Ozs7OztPQVdHO0lBQ0ksZUFBZSxDQUFDLFVBQWtCLEVBQUUsT0FBZ0IsRUFBRSxTQUFrQjtRQUM3RSxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsT0FBUSxTQUFTLElBQUksd0JBQXdCLENBQUMsZ0JBQWlCLGdDQUFpQyxPQUFPLElBQUksR0FBSSxtQkFBb0IsVUFBVyxFQUFFLENBQUMsQ0FBQztJQUNuSyxDQUFDOztBQXZmSCw0REF3ZkMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBBY2Nlc3NMZXZlbExpc3QgfSBmcm9tICcuLi9zaGFyZWQvYWNjZXNzLWxldmVsJztcbmltcG9ydCB7IFBvbGljeVN0YXRlbWVudCB9IGZyb20gJy4uL3NoYXJlZCc7XG5cbi8qKlxuICogU3RhdGVtZW50IHByb3ZpZGVyIGZvciBzZXJ2aWNlIFtyb3V0ZTUzLXJlY292ZXJ5LXJlYWRpbmVzc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3NlcnZpY2UtYXV0aG9yaXphdGlvbi9sYXRlc3QvcmVmZXJlbmNlL2xpc3RfYW1hem9ucm91dGU1M3JlY292ZXJ5cmVhZGluZXNzLmh0bWwpLlxuICpcbiAqIEBwYXJhbSBzaWQgW1NJRF0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0lBTS9sYXRlc3QvVXNlckd1aWRlL3JlZmVyZW5jZV9wb2xpY2llc19lbGVtZW50c19zaWQuaHRtbCkgb2YgdGhlIHN0YXRlbWVudFxuICovXG5leHBvcnQgY2xhc3MgUm91dGU1M1JlY292ZXJ5UmVhZGluZXNzIGV4dGVuZHMgUG9saWN5U3RhdGVtZW50IHtcbiAgcHVibGljIHNlcnZpY2VQcmVmaXggPSAncm91dGU1My1yZWNvdmVyeS1yZWFkaW5lc3MnO1xuXG4gIC8qKlxuICAgKiBTdGF0ZW1lbnQgcHJvdmlkZXIgZm9yIHNlcnZpY2UgW3JvdXRlNTMtcmVjb3ZlcnktcmVhZGluZXNzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vc2VydmljZS1hdXRob3JpemF0aW9uL2xhdGVzdC9yZWZlcmVuY2UvbGlzdF9hbWF6b25yb3V0ZTUzcmVjb3ZlcnlyZWFkaW5lc3MuaHRtbCkuXG4gICAqXG4gICAqIEBwYXJhbSBzaWQgW1NJRF0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0lBTS9sYXRlc3QvVXNlckd1aWRlL3JlZmVyZW5jZV9wb2xpY2llc19lbGVtZW50c19zaWQuaHRtbCkgb2YgdGhlIHN0YXRlbWVudFxuICAgKi9cbiAgY29uc3RydWN0b3Ioc2lkPzogc3RyaW5nKSB7XG4gICAgc3VwZXIoc2lkKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBjcmVhdGUgYSBuZXcgY2VsbFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIFBvc3NpYmxlIGNvbmRpdGlvbnM6XG4gICAqIC0gLmlmQXdzUmVxdWVzdFRhZygpXG4gICAqIC0gLmlmQXdzVGFnS2V5cygpXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9yZWNvdmVyeS1yZWFkaW5lc3MvbGF0ZXN0L2FwaS9jZWxscy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9DcmVhdGVDZWxsKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdDcmVhdGVDZWxsJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gY3JlYXRlIGEgY3Jvc3MgYWNjb3VudCBhdXRob3JpemF0aW9uXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3JlY292ZXJ5LXJlYWRpbmVzcy9sYXRlc3QvYXBpL2Nyb3NzYWNjb3VudGF1dGhvcml6YXRpb25zLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0NyZWF0ZUNyb3NzQWNjb3VudEF1dGhvcml6YXRpb24oKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0NyZWF0ZUNyb3NzQWNjb3VudEF1dGhvcml6YXRpb24nKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBjcmVhdGUgYSByZWFkaW5lc3MgY2hlY2tcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBQb3NzaWJsZSBjb25kaXRpb25zOlxuICAgKiAtIC5pZkF3c1JlcXVlc3RUYWcoKVxuICAgKiAtIC5pZkF3c1RhZ0tleXMoKVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vcmVjb3ZlcnktcmVhZGluZXNzL2xhdGVzdC9hcGkvcmVhZGluZXNzY2hlY2tzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0NyZWF0ZVJlYWRpbmVzc0NoZWNrKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdDcmVhdGVSZWFkaW5lc3NDaGVjaycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGNyZWF0ZSBhIHJlY292ZXJ5IGdyb3VwXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogUG9zc2libGUgY29uZGl0aW9uczpcbiAgICogLSAuaWZBd3NSZXF1ZXN0VGFnKClcbiAgICogLSAuaWZBd3NUYWdLZXlzKClcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3JlY292ZXJ5LXJlYWRpbmVzcy9sYXRlc3QvYXBpL3JlY292ZXJ5Z3JvdXBzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0NyZWF0ZVJlY292ZXJ5R3JvdXAoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0NyZWF0ZVJlY292ZXJ5R3JvdXAnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBjcmVhdGUgYSByZXNvdXJjZSBzZXRcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBQb3NzaWJsZSBjb25kaXRpb25zOlxuICAgKiAtIC5pZkF3c1JlcXVlc3RUYWcoKVxuICAgKiAtIC5pZkF3c1RhZ0tleXMoKVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vcmVjb3ZlcnktcmVhZGluZXNzL2xhdGVzdC9hcGkvcmVzb3VyY2VzZXRzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0NyZWF0ZVJlc291cmNlU2V0KCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdDcmVhdGVSZXNvdXJjZVNldCcpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGRlbGV0ZSBhIGNlbGxcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vcmVjb3ZlcnktcmVhZGluZXNzL2xhdGVzdC9hcGkvY2VsbHMtY2VsbG5hbWUuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVsZXRlQ2VsbCgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVsZXRlQ2VsbCcpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGRlbGV0ZSBhIGNyb3NzIGFjY291bnQgYXV0aG9yaXphdGlvblxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9yZWNvdmVyeS1yZWFkaW5lc3MvbGF0ZXN0L2FwaS9jcm9zc2FjY291bnRhdXRob3JpemF0aW9ucy1jcm9zc2FjY291bnRhdXRob3JpemF0aW9uLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0RlbGV0ZUNyb3NzQWNjb3VudEF1dGhvcml6YXRpb24oKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0RlbGV0ZUNyb3NzQWNjb3VudEF1dGhvcml6YXRpb24nKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBkZWxldGUgYSByZWFkaW5lc3MgY2hlY2tcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vcmVjb3ZlcnktcmVhZGluZXNzL2xhdGVzdC9hcGkvcmVhZGluZXNzY2hlY2tzLXJlYWRpbmVzc2NoZWNrbmFtZS5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9EZWxldGVSZWFkaW5lc3NDaGVjaygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVsZXRlUmVhZGluZXNzQ2hlY2snKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBkZWxldGUgYSByZWNvdmVyeSBncm91cFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9yZWNvdmVyeS1yZWFkaW5lc3MvbGF0ZXN0L2FwaS9yZWNvdmVyeWdyb3Vwcy1yZWNvdmVyeWdyb3VwbmFtZS5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9EZWxldGVSZWNvdmVyeUdyb3VwKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdEZWxldGVSZWNvdmVyeUdyb3VwJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZGVsZXRlIGEgcmVzb3VyY2Ugc2V0XG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3JlY292ZXJ5LXJlYWRpbmVzcy9sYXRlc3QvYXBpL3Jlc291cmNlc2V0cy1yZXNvdXJjZXNldG5hbWUuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVsZXRlUmVzb3VyY2VTZXQoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0RlbGV0ZVJlc291cmNlU2V0Jyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZ2V0IGFyY2hpdGVjdHVyZSByZWNvbW1lbmRhdGlvbnMgZm9yIGEgcmVjb3ZlcnkgZ3JvdXBcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9yZWNvdmVyeS1yZWFkaW5lc3MvbGF0ZXN0L2FwaS9yZWNvdmVyeWdyb3Vwcy1yZWNvdmVyeWdyb3VwbmFtZS1hcmNoaXRlY3R1cmVyZWNvbW1lbmRhdGlvbnMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvR2V0QXJjaGl0ZWN0dXJlUmVjb21tZW5kYXRpb25zKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdHZXRBcmNoaXRlY3R1cmVSZWNvbW1lbmRhdGlvbnMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBnZXQgaW5mb3JtYXRpb24gYWJvdXQgYSBjZWxsXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vcmVjb3ZlcnktcmVhZGluZXNzL2xhdGVzdC9hcGkvY2VsbHMtY2VsbG5hbWUuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvR2V0Q2VsbCgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnR2V0Q2VsbCcpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGdldCBhIHJlYWRpbmVzcyBzdW1tYXJ5IGZvciBhIGNlbGxcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9yZWNvdmVyeS1yZWFkaW5lc3MvbGF0ZXN0L2FwaS9jZWxscmVhZGluZXNzLWNlbGxuYW1lLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0dldENlbGxSZWFkaW5lc3NTdW1tYXJ5KCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdHZXRDZWxsUmVhZGluZXNzU3VtbWFyeScpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGdldCBpbmZvcm1hdGlvbiBhYm91dCBhIHJlYWRpbmVzcyBjaGVja1xuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3JlY292ZXJ5LXJlYWRpbmVzcy9sYXRlc3QvYXBpL3JlYWRpbmVzc2NoZWNrcy1yZWFkaW5lc3NjaGVja25hbWUuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvR2V0UmVhZGluZXNzQ2hlY2soKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0dldFJlYWRpbmVzc0NoZWNrJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZ2V0IHRoZSByZWFkaW5lc3Mgc3RhdHVzIGZvciBhbiBpbmRpdmlkdWFsIHJlc291cmNlXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vcmVjb3ZlcnktcmVhZGluZXNzL2xhdGVzdC9hcGkvcmVhZGluZXNzY2hlY2tzLXJlYWRpbmVzc2NoZWNrbmFtZS1yZXNvdXJjZS1yZXNvdXJjZWlkZW50aWZpZXItc3RhdHVzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0dldFJlYWRpbmVzc0NoZWNrUmVzb3VyY2VTdGF0dXMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0dldFJlYWRpbmVzc0NoZWNrUmVzb3VyY2VTdGF0dXMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBnZXQgdGhlIHN0YXR1cyBvZiBhIHJlYWRpbmVzcyBjaGVjayAoZm9yIGEgcmVzb3VyY2Ugc2V0KVxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3JlY292ZXJ5LXJlYWRpbmVzcy9sYXRlc3QvYXBpL3JlYWRpbmVzc2NoZWNrcy1yZWFkaW5lc3NjaGVja25hbWUtc3RhdHVzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0dldFJlYWRpbmVzc0NoZWNrU3RhdHVzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdHZXRSZWFkaW5lc3NDaGVja1N0YXR1cycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGdldCBpbmZvcm1hdGlvbiBhYm91dCBhIHJlY292ZXJ5IGdyb3VwXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vcmVjb3ZlcnktcmVhZGluZXNzL2xhdGVzdC9hcGkvcmVjb3Zlcnlncm91cHMtcmVjb3Zlcnlncm91cG5hbWUuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvR2V0UmVjb3ZlcnlHcm91cCgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnR2V0UmVjb3ZlcnlHcm91cCcpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGdldCBhIHJlYWRpbmVzcyBzdW1tYXJ5IGZvciBhIHJlY292ZXJ5IGdyb3VwXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vcmVjb3ZlcnktcmVhZGluZXNzL2xhdGVzdC9hcGkvcmVjb3Zlcnlncm91cHJlYWRpbmVzcy1yZWNvdmVyeWdyb3VwbmFtZS5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9HZXRSZWNvdmVyeUdyb3VwUmVhZGluZXNzU3VtbWFyeSgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnR2V0UmVjb3ZlcnlHcm91cFJlYWRpbmVzc1N1bW1hcnknKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBnZXQgaW5mb3JtYXRpb24gYWJvdXQgYSByZXNvdXJjZSBzZXRcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9yZWNvdmVyeS1yZWFkaW5lc3MvbGF0ZXN0L2FwaS9yZXNvdXJjZXNldHMtcmVzb3VyY2VzZXRuYW1lLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0dldFJlc291cmNlU2V0KCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdHZXRSZXNvdXJjZVNldCcpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGxpc3QgY2VsbHNcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9yZWNvdmVyeS1yZWFkaW5lc3MvbGF0ZXN0L2FwaS9jZWxscy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0Q2VsbHMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0xpc3RDZWxscycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGxpc3QgY3Jvc3MgYWNjb3VudCBhdXRob3JpemF0aW9uc1xuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3JlY292ZXJ5LXJlYWRpbmVzcy9sYXRlc3QvYXBpL3JlYWRpbmVzc2NoZWNrcy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0Q3Jvc3NBY2NvdW50QXV0aG9yaXphdGlvbnMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0xpc3RDcm9zc0FjY291bnRBdXRob3JpemF0aW9ucycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGxpc3QgcmVhZGluZXNzIGNoZWNrc1xuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3JlY292ZXJ5LXJlYWRpbmVzcy9sYXRlc3QvYXBpL3JlYWRpbmVzc2NoZWNrcy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0UmVhZGluZXNzQ2hlY2tzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdMaXN0UmVhZGluZXNzQ2hlY2tzJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gbGlzdCByZWNvdmVyeSBncm91cHNcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9yZWNvdmVyeS1yZWFkaW5lc3MvbGF0ZXN0L2FwaS9yZWNvdmVyeWdyb3Vwcy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0UmVjb3ZlcnlHcm91cHMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0xpc3RSZWNvdmVyeUdyb3VwcycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGxpc3QgcmVzb3VyY2Ugc2V0c1xuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3JlY292ZXJ5LXJlYWRpbmVzcy9sYXRlc3QvYXBpL3Jlc291cmNlc2V0cy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0UmVzb3VyY2VTZXRzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdMaXN0UmVzb3VyY2VTZXRzJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gbGlzdCByZWFkaW5lc3MgcnVsZXNcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9yZWNvdmVyeS1yZWFkaW5lc3MvbGF0ZXN0L2FwaS9ydWxlcy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0UnVsZXMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0xpc3RSdWxlcycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGxpc3QgdGFncyBmb3IgYSByZXNvdXJjZVxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3JlY292ZXJ5LXJlYWRpbmVzcy9sYXRlc3QvYXBpL3RhZ3MtcmVzb3VyY2UtYXJuLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0xpc3RUYWdzRm9yUmVzb3VyY2VzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdMaXN0VGFnc0ZvclJlc291cmNlcycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGFkZCBhIHRhZyB0byBhIHJlc291cmNlXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogVGFnZ2luZ1xuICAgKlxuICAgKiBQb3NzaWJsZSBjb25kaXRpb25zOlxuICAgKiAtIC5pZkF3c1RhZ0tleXMoKVxuICAgKiAtIC5pZkF3c1JlcXVlc3RUYWcoKVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vcmVjb3ZlcnktcmVhZGluZXNzL2xhdGVzdC9hcGkvdGFncy1yZXNvdXJjZS1hcm4uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvVGFnUmVzb3VyY2UoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1RhZ1Jlc291cmNlJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gcmVtb3ZlIGEgdGFnIGZyb20gYSByZXNvdXJjZVxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFRhZ2dpbmdcbiAgICpcbiAgICogUG9zc2libGUgY29uZGl0aW9uczpcbiAgICogLSAuaWZBd3NUYWdLZXlzKClcbiAgICogLSAuaWZBd3NSZXF1ZXN0VGFnKClcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3JlY292ZXJ5LXJlYWRpbmVzcy9sYXRlc3QvYXBpL3RhZ3MtcmVzb3VyY2UtYXJuLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1VudGFnUmVzb3VyY2UoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1VudGFnUmVzb3VyY2UnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byB1cGRhdGUgYSBjZWxsXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogUG9zc2libGUgY29uZGl0aW9uczpcbiAgICogLSAuaWZBd3NUYWdLZXlzKClcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3JlY292ZXJ5LXJlYWRpbmVzcy9sYXRlc3QvYXBpL2NlbGxzLWNlbGxuYW1lLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1VwZGF0ZUNlbGwoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1VwZGF0ZUNlbGwnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byB1cGRhdGUgYSByZWFkaW5lc3MgY2hlY2tcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBQb3NzaWJsZSBjb25kaXRpb25zOlxuICAgKiAtIC5pZkF3c1RhZ0tleXMoKVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vcmVjb3ZlcnktcmVhZGluZXNzL2xhdGVzdC9hcGkvcmVhZGluZXNzY2hlY2tzLXJlYWRpbmVzc2NoZWNrbmFtZS5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9VcGRhdGVSZWFkaW5lc3NDaGVjaygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnVXBkYXRlUmVhZGluZXNzQ2hlY2snKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byB1cGRhdGUgYSByZWNvdmVyeSBncm91cFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIFBvc3NpYmxlIGNvbmRpdGlvbnM6XG4gICAqIC0gLmlmQXdzVGFnS2V5cygpXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9yZWNvdmVyeS1yZWFkaW5lc3MvbGF0ZXN0L2FwaS9yZWNvdmVyeWdyb3Vwcy1yZWNvdmVyeWdyb3VwbmFtZS5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9VcGRhdGVSZWNvdmVyeUdyb3VwKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdVcGRhdGVSZWNvdmVyeUdyb3VwJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gdXBkYXRlIGEgcmVzb3VyY2Ugc2V0XG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogUG9zc2libGUgY29uZGl0aW9uczpcbiAgICogLSAuaWZBd3NUYWdLZXlzKClcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3JlY292ZXJ5LXJlYWRpbmVzcy9sYXRlc3QvYXBpL3Jlc291cmNlc2V0cy1yZXNvdXJjZXNldG5hbWUuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvVXBkYXRlUmVzb3VyY2VTZXQoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1VwZGF0ZVJlc291cmNlU2V0Jyk7XG4gIH1cblxuICBwcm90ZWN0ZWQgYWNjZXNzTGV2ZWxMaXN0OiBBY2Nlc3NMZXZlbExpc3QgPSB7XG4gICAgV3JpdGU6IFtcbiAgICAgICdDcmVhdGVDZWxsJyxcbiAgICAgICdDcmVhdGVDcm9zc0FjY291bnRBdXRob3JpemF0aW9uJyxcbiAgICAgICdDcmVhdGVSZWFkaW5lc3NDaGVjaycsXG4gICAgICAnQ3JlYXRlUmVjb3ZlcnlHcm91cCcsXG4gICAgICAnQ3JlYXRlUmVzb3VyY2VTZXQnLFxuICAgICAgJ0RlbGV0ZUNlbGwnLFxuICAgICAgJ0RlbGV0ZUNyb3NzQWNjb3VudEF1dGhvcml6YXRpb24nLFxuICAgICAgJ0RlbGV0ZVJlYWRpbmVzc0NoZWNrJyxcbiAgICAgICdEZWxldGVSZWNvdmVyeUdyb3VwJyxcbiAgICAgICdEZWxldGVSZXNvdXJjZVNldCcsXG4gICAgICAnVXBkYXRlQ2VsbCcsXG4gICAgICAnVXBkYXRlUmVhZGluZXNzQ2hlY2snLFxuICAgICAgJ1VwZGF0ZVJlY292ZXJ5R3JvdXAnLFxuICAgICAgJ1VwZGF0ZVJlc291cmNlU2V0J1xuICAgIF0sXG4gICAgUmVhZDogW1xuICAgICAgJ0dldEFyY2hpdGVjdHVyZVJlY29tbWVuZGF0aW9ucycsXG4gICAgICAnR2V0Q2VsbCcsXG4gICAgICAnR2V0Q2VsbFJlYWRpbmVzc1N1bW1hcnknLFxuICAgICAgJ0dldFJlYWRpbmVzc0NoZWNrJyxcbiAgICAgICdHZXRSZWFkaW5lc3NDaGVja1Jlc291cmNlU3RhdHVzJyxcbiAgICAgICdHZXRSZWFkaW5lc3NDaGVja1N0YXR1cycsXG4gICAgICAnR2V0UmVjb3ZlcnlHcm91cCcsXG4gICAgICAnR2V0UmVjb3ZlcnlHcm91cFJlYWRpbmVzc1N1bW1hcnknLFxuICAgICAgJ0dldFJlc291cmNlU2V0JyxcbiAgICAgICdMaXN0Q2VsbHMnLFxuICAgICAgJ0xpc3RDcm9zc0FjY291bnRBdXRob3JpemF0aW9ucycsXG4gICAgICAnTGlzdFJlYWRpbmVzc0NoZWNrcycsXG4gICAgICAnTGlzdFJlY292ZXJ5R3JvdXBzJyxcbiAgICAgICdMaXN0UmVzb3VyY2VTZXRzJyxcbiAgICAgICdMaXN0UnVsZXMnLFxuICAgICAgJ0xpc3RUYWdzRm9yUmVzb3VyY2VzJ1xuICAgIF0sXG4gICAgVGFnZ2luZzogW1xuICAgICAgJ1RhZ1Jlc291cmNlJyxcbiAgICAgICdVbnRhZ1Jlc291cmNlJ1xuICAgIF1cbiAgfTtcblxuICAvKipcbiAgICogQWRkcyBhIHJlc291cmNlIG9mIHR5cGUgcmVhZGluZXNzY2hlY2sgdG8gdGhlIHN0YXRlbWVudFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vcjUzcmVjb3ZlcnkvbGF0ZXN0L2RnL3JlY292ZXJ5LXJlYWRpbmVzcy5yZWFkaW5lc3MtY2hlY2tzLmh0bWxcbiAgICpcbiAgICogQHBhcmFtIHJlc291cmNlSWQgLSBJZGVudGlmaWVyIGZvciB0aGUgcmVzb3VyY2VJZC5cbiAgICogQHBhcmFtIGFjY291bnQgLSBBY2NvdW50IG9mIHRoZSByZXNvdXJjZTsgZGVmYXVsdHMgdG8gZW1wdHkgc3RyaW5nOiBhbGwgYWNjb3VudHMuXG4gICAqIEBwYXJhbSBwYXJ0aXRpb24gLSBQYXJ0aXRpb24gb2YgdGhlIEFXUyBhY2NvdW50IFthd3MsIGF3cy1jbiwgYXdzLXVzLWdvdl07IGRlZmF1bHRzIHRvIGBhd3NgLCB1bmxlc3MgdXNpbmcgdGhlIENESywgd2hlcmUgdGhlIGRlZmF1bHQgaXMgdGhlIGN1cnJlbnQgU3RhY2sncyBwYXJ0aXRpb24uXG4gICAqXG4gICAqIFBvc3NpYmxlIGNvbmRpdGlvbnM6XG4gICAqIC0gLmlmQXdzUmVzb3VyY2VUYWcoKVxuICAgKi9cbiAgcHVibGljIG9uUmVhZGluZXNzY2hlY2socmVzb3VyY2VJZDogc3RyaW5nLCBhY2NvdW50Pzogc3RyaW5nLCBwYXJ0aXRpb24/OiBzdHJpbmcpIHtcbiAgICByZXR1cm4gdGhpcy5vbihgYXJuOiR7IHBhcnRpdGlvbiB8fCBSb3V0ZTUzUmVjb3ZlcnlSZWFkaW5lc3MuZGVmYXVsdFBhcnRpdGlvbiB9OnJvdXRlNTMtcmVjb3ZlcnktcmVhZGluZXNzOjokeyBhY2NvdW50IHx8ICcqJyB9OnJlYWRpbmVzcy1jaGVjay8keyByZXNvdXJjZUlkIH1gKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBBZGRzIGEgcmVzb3VyY2Ugb2YgdHlwZSByZXNvdXJjZXNldCB0byB0aGUgc3RhdGVtZW50XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9yNTNyZWNvdmVyeS9sYXRlc3QvZGcvcmVjb3ZlcnktcmVhZGluZXNzLnJlYWRpbmVzcy1jaGVja3MuaHRtbFxuICAgKlxuICAgKiBAcGFyYW0gcmVzb3VyY2VJZCAtIElkZW50aWZpZXIgZm9yIHRoZSByZXNvdXJjZUlkLlxuICAgKiBAcGFyYW0gYWNjb3VudCAtIEFjY291bnQgb2YgdGhlIHJlc291cmNlOyBkZWZhdWx0cyB0byBlbXB0eSBzdHJpbmc6IGFsbCBhY2NvdW50cy5cbiAgICogQHBhcmFtIHBhcnRpdGlvbiAtIFBhcnRpdGlvbiBvZiB0aGUgQVdTIGFjY291bnQgW2F3cywgYXdzLWNuLCBhd3MtdXMtZ292XTsgZGVmYXVsdHMgdG8gYGF3c2AsIHVubGVzcyB1c2luZyB0aGUgQ0RLLCB3aGVyZSB0aGUgZGVmYXVsdCBpcyB0aGUgY3VycmVudCBTdGFjaydzIHBhcnRpdGlvbi5cbiAgICpcbiAgICogUG9zc2libGUgY29uZGl0aW9uczpcbiAgICogLSAuaWZBd3NSZXNvdXJjZVRhZygpXG4gICAqL1xuICBwdWJsaWMgb25SZXNvdXJjZXNldChyZXNvdXJjZUlkOiBzdHJpbmcsIGFjY291bnQ/OiBzdHJpbmcsIHBhcnRpdGlvbj86IHN0cmluZykge1xuICAgIHJldHVybiB0aGlzLm9uKGBhcm46JHsgcGFydGl0aW9uIHx8IFJvdXRlNTNSZWNvdmVyeVJlYWRpbmVzcy5kZWZhdWx0UGFydGl0aW9uIH06cm91dGU1My1yZWNvdmVyeS1yZWFkaW5lc3M6OiR7IGFjY291bnQgfHwgJyonIH06cmVzb3VyY2Utc2V0LyR7IHJlc291cmNlSWQgfWApO1xuICB9XG5cbiAgLyoqXG4gICAqIEFkZHMgYSByZXNvdXJjZSBvZiB0eXBlIGNlbGwgdG8gdGhlIHN0YXRlbWVudFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vcjUzcmVjb3ZlcnkvbGF0ZXN0L2RnL3JlY292ZXJ5LXJlYWRpbmVzcy5yZWNvdmVyeS1ncm91cHMuaHRtbFxuICAgKlxuICAgKiBAcGFyYW0gcmVzb3VyY2VJZCAtIElkZW50aWZpZXIgZm9yIHRoZSByZXNvdXJjZUlkLlxuICAgKiBAcGFyYW0gYWNjb3VudCAtIEFjY291bnQgb2YgdGhlIHJlc291cmNlOyBkZWZhdWx0cyB0byBlbXB0eSBzdHJpbmc6IGFsbCBhY2NvdW50cy5cbiAgICogQHBhcmFtIHBhcnRpdGlvbiAtIFBhcnRpdGlvbiBvZiB0aGUgQVdTIGFjY291bnQgW2F3cywgYXdzLWNuLCBhd3MtdXMtZ292XTsgZGVmYXVsdHMgdG8gYGF3c2AsIHVubGVzcyB1c2luZyB0aGUgQ0RLLCB3aGVyZSB0aGUgZGVmYXVsdCBpcyB0aGUgY3VycmVudCBTdGFjaydzIHBhcnRpdGlvbi5cbiAgICpcbiAgICogUG9zc2libGUgY29uZGl0aW9uczpcbiAgICogLSAuaWZBd3NSZXNvdXJjZVRhZygpXG4gICAqL1xuICBwdWJsaWMgb25DZWxsKHJlc291cmNlSWQ6IHN0cmluZywgYWNjb3VudD86IHN0cmluZywgcGFydGl0aW9uPzogc3RyaW5nKSB7XG4gICAgcmV0dXJuIHRoaXMub24oYGFybjokeyBwYXJ0aXRpb24gfHwgUm91dGU1M1JlY292ZXJ5UmVhZGluZXNzLmRlZmF1bHRQYXJ0aXRpb24gfTpyb3V0ZTUzLXJlY292ZXJ5LXJlYWRpbmVzczo6JHsgYWNjb3VudCB8fCAnKicgfTpjZWxsLyR7IHJlc291cmNlSWQgfWApO1xuICB9XG5cbiAgLyoqXG4gICAqIEFkZHMgYSByZXNvdXJjZSBvZiB0eXBlIHJlY292ZXJ5Z3JvdXAgdG8gdGhlIHN0YXRlbWVudFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vcjUzcmVjb3ZlcnkvbGF0ZXN0L2RnL3JlY292ZXJ5LXJlYWRpbmVzcy5yZWNvdmVyeS1ncm91cHMuaHRtbFxuICAgKlxuICAgKiBAcGFyYW0gcmVzb3VyY2VJZCAtIElkZW50aWZpZXIgZm9yIHRoZSByZXNvdXJjZUlkLlxuICAgKiBAcGFyYW0gYWNjb3VudCAtIEFjY291bnQgb2YgdGhlIHJlc291cmNlOyBkZWZhdWx0cyB0byBlbXB0eSBzdHJpbmc6IGFsbCBhY2NvdW50cy5cbiAgICogQHBhcmFtIHBhcnRpdGlvbiAtIFBhcnRpdGlvbiBvZiB0aGUgQVdTIGFjY291bnQgW2F3cywgYXdzLWNuLCBhd3MtdXMtZ292XTsgZGVmYXVsdHMgdG8gYGF3c2AsIHVubGVzcyB1c2luZyB0aGUgQ0RLLCB3aGVyZSB0aGUgZGVmYXVsdCBpcyB0aGUgY3VycmVudCBTdGFjaydzIHBhcnRpdGlvbi5cbiAgICpcbiAgICogUG9zc2libGUgY29uZGl0aW9uczpcbiAgICogLSAuaWZBd3NSZXNvdXJjZVRhZygpXG4gICAqL1xuICBwdWJsaWMgb25SZWNvdmVyeWdyb3VwKHJlc291cmNlSWQ6IHN0cmluZywgYWNjb3VudD86IHN0cmluZywgcGFydGl0aW9uPzogc3RyaW5nKSB7XG4gICAgcmV0dXJuIHRoaXMub24oYGFybjokeyBwYXJ0aXRpb24gfHwgUm91dGU1M1JlY292ZXJ5UmVhZGluZXNzLmRlZmF1bHRQYXJ0aXRpb24gfTpyb3V0ZTUzLXJlY292ZXJ5LXJlYWRpbmVzczo6JHsgYWNjb3VudCB8fCAnKicgfTpyZWNvdmVyeS1ncm91cC8keyByZXNvdXJjZUlkIH1gKTtcbiAgfVxufVxuIl19