"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Tiros = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [tiros](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awstiros.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Tiros extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [tiros](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awstiros.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'tiros';
        this.accessLevelList = {
            Write: [
                'CreateQuery',
                'ExtendQuery'
            ],
            Read: [
                'GetQueryAnswer',
                'GetQueryExplanation'
            ]
        };
    }
    /**
     * Grants permission to create a VPC reachability query
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/vpc/latest/reachability/security_iam_required-API-permissions.html
     */
    toCreateQuery() {
        return this.to('CreateQuery');
    }
    /**
     * Grants permission to extend a VPC reachability query to include the calling principals account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/vpc/latest/reachability/security_iam_required-API-permissions.html
     */
    toExtendQuery() {
        return this.to('ExtendQuery');
    }
    /**
     * Grants permission to get VPC reachability query answers
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/vpc/latest/reachability/security_iam_required-API-permissions.html
     */
    toGetQueryAnswer() {
        return this.to('GetQueryAnswer');
    }
    /**
     * Grants permission to get VPC reachability query explanations
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/vpc/latest/reachability/security_iam_required-API-permissions.html
     */
    toGetQueryExplanation() {
        return this.to('GetQueryExplanation');
    }
}
exports.Tiros = Tiros;
_a = JSII_RTTI_SYMBOL_1;
Tiros[_a] = { fqn: "iam-floyd.Tiros", version: "0.438.0" };
//# sourceMappingURL=data:application/json;base64,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