#!/usr/bin/env python
# -*- mode: Python; coding: utf-8 -*-


try:
    from setuptools import setup, Extension
except ImportError:
    from distutils.core import setup


setup(
    name="Caroline-presentation",
    version="0.2.3",
    description="Caroline open-source Python framework for interactive web/HTML-based science presentations",
    long_description=open("README.md").read(),
    long_description_content_type="text/markdown",
    license="BSD3",
    keywords=[
        "presentation",
        "science presentations",
        "HTML5 + JS presentations",
        "Python-based HTML presentation generator",
        "audience interaction",
        "interactive presentations",
        "interactive figures",
        "collaboration tools",
        "quiz in presentation",
    ],
    classifiers=[
        "Programming Language :: Python",
        "Programming Language :: Python :: 3",
        "Intended Audience :: Science/Research",
        "Intended Audience :: Education",
        "Topic :: Education",
        "Topic :: Education :: Computer Aided Instruction (CAI)",
        "Topic :: Communications :: Conferencing",
        "Topic :: Multimedia :: Graphics :: Presentation",
        "Topic :: Multimedia :: Graphics :: Viewers",
        "License :: OSI Approved :: BSD License",
        "Development Status :: 4 - Beta",
    ],
    url="https://github.com/nikolasibalic/Caroline",
    download_url="https://github.com/nikolasibalic/Caroline/archive/refs/tags/v0.2.3.tar.gz",
    author="Nikola Sibalic",
    author_email="nikolasibalic@physics.org",
    packages=[
        "caroline",
        "caroline.example",
        "caroline.template",
        "caroline.template_quiz",
        "caroline.folder2presentation",
        "caroline.preview",
    ],
    package_data={
        "caroline": [
            "html/*",
            "html_dist/*",
            "html_dist/fonts/*",
            "html_dist/images/*",
            "html_dist/images/caroline.ico",
            "html_dist/js/*",
            "html_dist/js/mathjax/*",
            "html_dist/js/mathjax/a11y/*",
            "html_dist/js/mathjax/adaptors/*",
            "html_dist/js/mathjax/input/*",
            "html_dist/js/mathjax/input/mml/*",
            "html_dist/js/mathjax/input/tex/extensions/*",
            "html_dist/js/mathjax/output/*",
            "html_dist/js/mathjax/output/chtml/fonts/*",
            "html_dist/js/mathjax/output/chtml/fonts/woff-v2/*",
            "html_dist/js/mathjax/output/svg/fonts/*",
            "html_dist/js/mathjax/sre/*",
            "html_dist/js/mathjax/sre/mathmaps/*",
            "html_dist/js/mathjax/sre/mathmaps/en/*",
            "html_dist/js/mathjax/sre/mathmaps/en/functions/*",
            "html_dist/js/mathjax/sre/mathmaps/en/symbols/*",
            "html_dist/js/mathjax/sre/mathmaps/en/units/*",
            "html_dist/js/mathjax/sre/mathmaps/es/*",
            "html_dist/js/mathjax/sre/mathmaps/es/functions/*",
            "html_dist/js/mathjax/sre/mathmaps/es/symbols/*",
            "html_dist/js/mathjax/sre/mathmaps/es/units/*",
            "html_dist/js/mathjax/sre/mathmaps/fr/*",
            "html_dist/js/mathjax/sre/mathmaps/fr/functions/*",
            "html_dist/js/mathjax/sre/mathmaps/fr/symbols/*",
            "html_dist/js/mathjax/sre/mathmaps/fr/units/*",
            "html_dist/js/mathjax/sre/mathmaps/nemeth/*",
            "html_dist/js/mathjax/sre/mathmaps/nemeth/functions/*",
            "html_dist/js/mathjax/sre/mathmaps/nemeth/symbols/*",
            "html_dist/js/mathjax/sre/mathmaps/nemeth/units/*",
            "html_dist/js/mathjax/ui/*",
            "html_dist/style/*",
        ],
        "caroline.example": [
            "presentation.html",
            "presentation_audience.html",
            "presentation_files/*",
        ],
        "caroline.template": ["presentation.html", "presentation_files/*"],
        "caroline.template_quiz": [
            "presentation.html",
            "presentation_audience.html",
            "presentation_files/*",
        ],
    },
    install_requires=[
        "markdown>=3.3.0",
        "numpy>=1.16.0",
        "jinja2>=3.0",
        "Pygments>=2.9.0",
        "flask>=2.0.0",
        "flask-socketio>=5.1.0",
        "pymdown-extensions>=8.0",
        "flask-cors>=3.0.0",
        "Pillow>=8.0",
        "qrcode>=7.3",
    ],
    zip_safe=False,
)
