from __future__ import annotations

from prettyqt.qt import QtCore
from prettyqt.utils import bidict


TYPE = bidict(
    none=QtCore.QEvent.None_,
    action_added=QtCore.QEvent.ActionAdded,
    action_changed=QtCore.QEvent.ActionChanged,
    action_removed=QtCore.QEvent.ActionRemoved,
    activation_change=QtCore.QEvent.ActivationChange,
    application_activate=QtCore.QEvent.ApplicationActivate,
    application_deactivate=QtCore.QEvent.ApplicationDeactivate,
    application_font_change=QtCore.QEvent.ApplicationFontChange,
    application_layout_direction_change=QtCore.QEvent.ApplicationLayoutDirectionChange,
    application_palette_change=QtCore.QEvent.ApplicationPaletteChange,
    application_state_change=QtCore.QEvent.ApplicationStateChange,
    application_window_icon_change=QtCore.QEvent.ApplicationWindowIconChange,
    child_added=QtCore.QEvent.ChildAdded,
    child_polished=QtCore.QEvent.ChildPolished,
    child_removed=QtCore.QEvent.ChildRemoved,
    clipboard=QtCore.QEvent.Clipboard,
    close=QtCore.QEvent.Close,
    close_software_input_panel=QtCore.QEvent.CloseSoftwareInputPanel,
    contents_rect_change=QtCore.QEvent.ContentsRectChange,
    context_menu=QtCore.QEvent.ContextMenu,
    cursor_change=QtCore.QEvent.CursorChange,
    deferred_delete=QtCore.QEvent.DeferredDelete,
    drag_enter=QtCore.QEvent.DragEnter,
    drag_leave=QtCore.QEvent.DragLeave,
    drag_move=QtCore.QEvent.DragMove,
    drop=QtCore.QEvent.Drop,
    dynamic_property_change=QtCore.QEvent.DynamicPropertyChange,
    enabled_change=QtCore.QEvent.EnabledChange,
    enter=QtCore.QEvent.Enter,
    # enter_edit_focus=QtCore.QEvent.EnterEditFocus,
    enter_whats_this_mode=QtCore.QEvent.EnterWhatsThisMode,
    expose=QtCore.QEvent.Expose,
    file_open=QtCore.QEvent.FileOpen,
    focus_in=QtCore.QEvent.FocusIn,
    focus_out=QtCore.QEvent.FocusOut,
    focus_about_to_change=QtCore.QEvent.FocusAboutToChange,
    font_change=QtCore.QEvent.FontChange,
    gesture=QtCore.QEvent.Gesture,
    gesture_override=QtCore.QEvent.GestureOverride,
    grab_keyboard=QtCore.QEvent.GrabKeyboard,
    grab_mouse=QtCore.QEvent.GrabMouse,
    graphics_scene_context_menu=QtCore.QEvent.GraphicsSceneContextMenu,
    graphics_scene_drag_enter=QtCore.QEvent.GraphicsSceneDragEnter,
    graphics_scene_drag_leave=QtCore.QEvent.GraphicsSceneDragLeave,
    graphics_scene_drag_move=QtCore.QEvent.GraphicsSceneDragMove,
    graphics_scene_drop=QtCore.QEvent.GraphicsSceneDrop,
    graphics_scene_help=QtCore.QEvent.GraphicsSceneHelp,
    graphics_scene_hover_enter=QtCore.QEvent.GraphicsSceneHoverEnter,
    graphics_scene_hover_leave=QtCore.QEvent.GraphicsSceneHoverLeave,
    graphics_scene_hover_move=QtCore.QEvent.GraphicsSceneHoverMove,
    graphics_scene_mouse_double_click=QtCore.QEvent.GraphicsSceneMouseDoubleClick,
    graphics_scene_mouse_move=QtCore.QEvent.GraphicsSceneMouseMove,
    graphics_scene_mouse_press=QtCore.QEvent.GraphicsSceneMousePress,
    graphics_scene_mouse_release=QtCore.QEvent.GraphicsSceneMouseRelease,
    graphics_scene_move=QtCore.QEvent.GraphicsSceneMove,
    graphics_scene_resize=QtCore.QEvent.GraphicsSceneResize,
    graphics_scene_wheel=QtCore.QEvent.GraphicsSceneWheel,
    hide=QtCore.QEvent.Hide,
    hide_to_parent=QtCore.QEvent.HideToParent,
    hover_enter=QtCore.QEvent.HoverEnter,
    hover_leave=QtCore.QEvent.HoverLeave,
    hover_move=QtCore.QEvent.HoverMove,
    icon_drag=QtCore.QEvent.IconDrag,
    icon_text_change=QtCore.QEvent.IconTextChange,
    input_method=QtCore.QEvent.InputMethod,
    input_method_query=QtCore.QEvent.InputMethodQuery,
    keyboard_layout_change=QtCore.QEvent.KeyboardLayoutChange,
    key_press=QtCore.QEvent.KeyPress,
    key_release=QtCore.QEvent.KeyRelease,
    language_change=QtCore.QEvent.LanguageChange,
    layout_direction_change=QtCore.QEvent.LayoutDirectionChange,
    layout_request=QtCore.QEvent.LayoutRequest,
    leave=QtCore.QEvent.Leave,
    # leave_edit_focus=QtCore.QEvent.LeaveEditFocus,
    leave_whats_this_mode=QtCore.QEvent.LeaveWhatsThisMode,
    locale_change=QtCore.QEvent.LocaleChange,
    non_client_area_mouse_button_dbl_click=QtCore.QEvent.NonClientAreaMouseButtonDblClick,
    non_client_area_mouse_button_press=QtCore.QEvent.NonClientAreaMouseButtonPress,
    non_client_area_mouse_button_release=QtCore.QEvent.NonClientAreaMouseButtonRelease,
    non_client_area_mouse_move=QtCore.QEvent.NonClientAreaMouseMove,
    mac_size_change=QtCore.QEvent.MacSizeChange,
    meta_call=QtCore.QEvent.MetaCall,
    # invoke_method=QtCore.QEvent.invokeMethod,
    modified_change=QtCore.QEvent.ModifiedChange,
    mouse_button_dbl_click=QtCore.QEvent.MouseButtonDblClick,
    mouse_button_press=QtCore.QEvent.MouseButtonPress,
    mouse_button_release=QtCore.QEvent.MouseButtonRelease,
    mouse_move=QtCore.QEvent.MouseMove,
    mouse_tracking_change=QtCore.QEvent.MouseTrackingChange,
    move=QtCore.QEvent.Move,
    # native_gesture=QtCore.QEvent.NativeGesture,
    orientation_change=QtCore.QEvent.OrientationChange,
    paint=QtCore.QEvent.Paint,
    palette_change=QtCore.QEvent.PaletteChange,
    parent_about_to_change=QtCore.QEvent.ParentAboutToChange,
    parent_change=QtCore.QEvent.ParentChange,
    platform_panel=QtCore.QEvent.PlatformPanel,
    platform_surface=QtCore.QEvent.PlatformSurface,
    polish=QtCore.QEvent.Polish,
    polish_request=QtCore.QEvent.PolishRequest,
    query_whats_this=QtCore.QEvent.QueryWhatsThis,
    read_only_change=QtCore.QEvent.ReadOnlyChange,
    request_software_input_panel=QtCore.QEvent.RequestSoftwareInputPanel,
    resize=QtCore.QEvent.Resize,
    scroll_prepare=QtCore.QEvent.ScrollPrepare,
    scroll=QtCore.QEvent.Scroll,
    shortcut=QtCore.QEvent.Shortcut,
    shortcut_override=QtCore.QEvent.ShortcutOverride,
    show=QtCore.QEvent.Show,
    show_to_parent=QtCore.QEvent.ShowToParent,
    sock_act=QtCore.QEvent.SockAct,
    state_machine_signal=QtCore.QEvent.StateMachineSignal,
    # signal_event=QtCore.QEvent.SignalEvent,
    state_machine_wrapped=QtCore.QEvent.StateMachineWrapped,
    # wrapped_event=QtCore.QEvent.WrappedEvent,
    status_tip=QtCore.QEvent.StatusTip,
    style_change=QtCore.QEvent.StyleChange,
    tablet_move=QtCore.QEvent.TabletMove,
    tablet_press=QtCore.QEvent.TabletPress,
    tablet_release=QtCore.QEvent.TabletRelease,
    tablet_enter_proximity=QtCore.QEvent.TabletEnterProximity,
    tablet_leave_proximity=QtCore.QEvent.TabletLeaveProximity,
    tablet_tracking_change=QtCore.QEvent.TabletTrackingChange,
    thread_change=QtCore.QEvent.ThreadChange,
    # move_to_thread=QtCore.QEvent.moveToThread,
    timer=QtCore.QEvent.Timer,
    tool_bar_change=QtCore.QEvent.ToolBarChange,
    tool_tip=QtCore.QEvent.ToolTip,
    tool_tip_change=QtCore.QEvent.ToolTipChange,
    touch_begin=QtCore.QEvent.TouchBegin,
    touch_cancel=QtCore.QEvent.TouchCancel,
    touch_end=QtCore.QEvent.TouchEnd,
    touch_update=QtCore.QEvent.TouchUpdate,
    ungrab_keyboard=QtCore.QEvent.UngrabKeyboard,
    ungrab_mouse=QtCore.QEvent.UngrabMouse,
    update_later=QtCore.QEvent.UpdateLater,
    update_request=QtCore.QEvent.UpdateRequest,
    whats_this=QtCore.QEvent.WhatsThis,
    whats_this_clicked=QtCore.QEvent.WhatsThisClicked,
    wheel=QtCore.QEvent.Wheel,
    win_event_act=QtCore.QEvent.WinEventAct,
    window_activate=QtCore.QEvent.WindowActivate,
    window_blocked=QtCore.QEvent.WindowBlocked,
    window_deactivate=QtCore.QEvent.WindowDeactivate,
    window_icon_change=QtCore.QEvent.WindowIconChange,
    window_state_change=QtCore.QEvent.WindowStateChange,
    window_title_change=QtCore.QEvent.WindowTitleChange,
    window_unblocked=QtCore.QEvent.WindowUnblocked,
    win_id_change=QtCore.QEvent.WinIdChange,
    z_order_change=QtCore.QEvent.ZOrderChange,
)


class Event(QtCore.QEvent):
    def __repr__(self):
        return f"{type(self).__name__}({self.type()})"
