[![DOI](https://zenodo.org/badge/165746996.svg)](https://zenodo.org/badge/latestdoi/165746996)
[![PyPI version](https://badge.fury.io/py/pml-pinn.svg)](https://badge.fury.io/py/pml-pinn)
# Physics-informed neural networks package
Welcome to the PML repository for physics-informed neural networks. We will use this repository to disseminate our research in this exciting topic.

## Install

To install the stable version just do:
```
pip install pml-pinn
```

### Develop mode

To install in develop mode, clone this repository and do a pip install:
```
git clone https://github.com/PML-UCF/pinn.git
cd pinn
pip install -e .
```

## Citing this repository

Please, cite this repository using: 

    @misc{2019_pinn,
        author    = {Felipe A. C. Viana and Renato G. Nascimento and Yigit Yucesan and Arinan Dourado},
        title     = {Physics-informed neural networks package},
        month     = Aug,
        year      = 2019,
        doi       = {10.5281/zenodo.3356877},
        version   = {0.0.3},
        publisher = {Zenodo},
        url       = {https://github.com/PML-UCF/pinn}
        }
The corresponding reference entry should look like:

F. A. C. Viana, R. G. Nascimento, Y. Yucesan, and A. Dourado, Physics-informed neural networks package, v0.0.3, Aug. 2019. doi:10.5281/zenodo.3356877, URL https://github.com/PML-UCF/pinn.

## Publications

### Journal papers
- A. Dourado and F. A. C. Viana, "[Physics-informed neural networks for missing physics estimation in cumulative damage models: a case study in corrosion fatigue](https://asmedigitalcollection.asme.org/computingengineering/article-abstract/doi/10.1115/1.4047173/1083614/Physics-informed-neural-networks-for-missing)," ASME Journal of Computing and Information Science in Engineering, Online first, 2020. (DOI: 10.1115/1.4047173).

- Y. A. Yucesan and F. A. C. Viana, "[A physics-informed neural network for wind turbine main bearing fatigue](http://www.phmsociety.org/node/2736)," International Journal of Prognostics and Health Management, Vol. 11 (1), 2020. (ISSN: 2153-2648).


### Conference papers
- A. Dourado and F. A. C. Viana, "[Physics-informed neural networks for bias compensation in corrosion-fatigue](https://arc.aiaa.org/doi/abs/10.2514/6.2020-1149)," AIAA SciTech Forum, Orlando, USA, January 6-10, 2020, AIAA 2020-1149 (DOI: 10.2514/6.2020-1149).

- Y. A. Yucesan and F. A. C. Viana, "[A hybrid model for main bearing fatigue prognosis based on physics and machine learning](https://arc.aiaa.org/doi/abs/10.2514/6.2020-1412)," AIAA SciTech Forum, Orlando, USA, January 6-10, 2020, AIAA 2020-1412 (DOI: 10.2514/6.2020-1412). 

- A. Dourado and F. A. C. Viana, "[Physics-Informed Neural Networks for Corrosion-Fatigue Prognosis](http://phmpapers.org/index.php/phmconf/article/view/814)," Proceedings of the Annual Conference of the PHM Society, Scottsdale,USA, September 21-26, 2019.

- Y. A. Yucesan and F. A. C. Viana, "[Wind turbine main bearing fatigue life estimation with physics-informed neural networks](http://phmpapers.org/index.php/phmconf/article/view/807)," Proceedings of the Annual Conference of the PHM Society, Vol. 11 (1), Scottsdale, USA, September 21-26, 2019 (DOI:10.36001/phmconf.2019.v11i1.807).

- R.G. Nascimento and F. A. C. Viana, "[Fleet prognosis with physics-informed recurrent neural networks](http://www.dpi-proceedings.com/index.php/shm2019/article/view/32301)," The 12th International Workshop on Structural Health Monitoring, Stanford, USA, September 10-12, 2019 (DOI:10.12783/shm2019/32301).
