# mypy-boto3-resource-groups

[![PyPI - mypy-boto3-resource-groups](https://img.shields.io/pypi/v/mypy-boto3-resource-groups.svg?color=blue)](https://pypi.org/project/mypy-boto3-resource-groups)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-resource-groups.svg?color=blue)](https://pypi.org/project/mypy-boto3-resource-groups)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

- [mypy-boto3-resource-groups](#mypy-boto3-resource-groups)
  - [How to use](#how-to-use)
  - [Automated type discovery](#automated-type-discovery)


Type annotations for
[boto3.ResourceGroups 1.13.26](https://boto3.amazonaws.com/v1/documentation/api/1.13.26/reference/services/resource-groups.html#ResourceGroups) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 2.0.3](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-resource-groups](#mypy-boto3-resource-groups)
  - [How to use](#how-to-use)
    - [Type checking](#type-checking)
  - [How it works](#how-it-works)

## How to use

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `ResourceGroups` service.

```bash
python -m pip install boto3-stubs[resource-groups]

# update installed packages index for automated type discovery
python -m mypy_boto3
```

Use `boto3` with `mypy_boto3_resource_groups` in your project and enjoy type checking and auto-complete.

```python
import boto3

from mypy_boto3_resource_groups import ResourceGroupsClient

# Now mypy can check if your code is valid.
client: ResourceGroupsClient = boto3.client("resource-groups")

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: ResourceGroupsClient = session.client("resource-groups")



# Annotated paginators are included as well

import mypy_boto3_resource_groups.paginator as resource_groups_paginators

list_group_resources_paginator: resource_groups_paginators.ListGroupResourcesPaginator = client.get_paginator("list_group_resources")
list_groups_paginator: resource_groups_paginators.ListGroupsPaginator = client.get_paginator("list_groups")
search_resources_paginator: resource_groups_paginators.SearchResourcesPaginator = client.get_paginator("search_resources")
```

## Automated type discovery

`mypy_boto3` package can generate index for `mypy_boto3_resource_groups` and other installed services.

```bash
# Run this command when you add or remove service packages
python -m mypy_boto3
```

Generated index provides overloads for `boto3.client` and `boto3.service`,
`boto3.Session.client` and `boto3.Session.resource` functions,
so explicit type annotations are not needed.

- `mypy` supports function overloads as expected
- `PyCharm` also supports function overloads, but consumes a lot of RAM, use carefully
- `VSCode` does not currently support function overloads

Also, generated index allows you to import types from `mypy_boto3`:

```python
# you can replace imports
import mypy_boto3_resource_groups as resource_groups
from mypy_boto3_resource_groups import ResourceGroupsClient

# with these
from mypy_boto3 import resource_groups
from mypy_boto3.resource_groups import ResourceGroupsClient
```