# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['taiga_stats']

package_data = \
{'': ['*']}

install_requires = \
['matplotlib>=2.1.0,<3.0.0',
 'numpy>=1.13.3,<2.0.0',
 'python-taiga>=0.9.0,<0.10.0']

entry_points = \
{'console_scripts': ['taiga-stats = taiga_stats.__main__:main']}

setup_kwargs = {
    'name': 'taiga-stats',
    'version': '1.0.2',
    'description': 'Generate statistics from Taiga and produce burnup diagrams, CFDs, dependency graphs and more.',
    'long_description': '# Taiga Stats - Your Taiga Statistics Tool\n[![PyPI version](https://badge.fury.io/py/taiga-stats.svg)](https://badge.fury.io/py/taiga-stats)\n[![Supported Python versions](https://img.shields.io/pypi/pyversions/taiga-stats)](#)\n[![License](https://img.shields.io/pypi/l/taiga-stats)](https://github.com/erikw/taiga-stats/blob/master/LICENSE)\n\nThis is a script for all you "Kanban masters" who use Taiga and are interested in visualizing progress and generate some automated statistics and graphs.\n\n[Taiga](https://taiga.io/) is an Open Source virtual Scrum and Kanban board that is popular for managing projects and work. We use a physical whiteboard at work but I mirror the status of stories in Taiga so that I can collect some statistics and generate diagrams and graphs using this tool I wrote.\n\n# Features\n\n```console\n$ taiga-stats --help\nusage: taiga-stats [-h] [--url URL] [--auth-token AUTH_TOKEN]\n                   {config_template,list_projects,list_us_statuses,burnup,store_daily,points_sum,cfd,deps_dot_nodes,deps_dot}\n                   ...\n\nTaiga statistic tool. Default values for many options can be set config file;\nsee the command \'config_template\'.\n\npositional arguments:\n  {config_template,list_projects,list_us_statuses,burnup,store_daily,points_sum,cfd,deps_dot_nodes,deps_dot}\n                        Commands. Run $(taiga-stats <command> -h) for more\n                        info about a command.\n    config_template     Generate a template configuration file.\n    list_projects       List all found project IDs and names on the server\n                        that you have access to read.\n    list_us_statuses    List all the ID and names of User Story statuses.\n    burnup              Print burn(up|down) statistics. Typically used for\n                        entering in an Excel sheet or such that plots a\n                        burnup.\n    store_daily         Store the current state of a project on file so that\n                        the CFD command can generate a diagram with this data.\n    points_sum          Print out the sum of points in User Story statuses.\n    cfd                 Generate a Cumulative Flow Diagram from stored data.\n    deps_dot_nodes      Print User Story nodes in .dot file format.\n    deps_dot            Print US in .dot file format with dependencies too!\n                        Create a custom attribute for User Stories named\n                        \'Depends On\' by going to Settings>Attributes>Custom\n                        Fields. Then go to a User Story and put in a comma\n                        separated list of stories that this story depends on\n                        e.g. \'#123,#456\'.\n\noptional arguments:\n  -h, --help            show this help message and exit\n  --url URL             URL to Taiga server.\n  --auth-token AUTH_TOKEN\n                        Authentication token. Instructions on how to get one\n                        is found at\n                        https://docs.taiga.io/api.html#_authentication\n```\n\n## Cumulative Flow Diagram\n\nFrom a [CFD](http://brodzinski.com/2013/07/cumulative-flow-diagram.html) a lot of interesting insights about your team\'s progress [can be found](http://paulklipp.com/images/Interpreting_a_Cumulative_Flow_Diagram.jpg). However I\'m not found of repetitive work like counting and entering numbers in an Excel sheet. This had to be automated! Therefore I deiced to write this script to save data on a daily basis with a cron job and a function for generating this diagram. This diagram can the be put on a TV visible in the hallways.\n\n\nThis is an example diagram generated from [mock data](sample_data/cfd_example.dat):\n\n![Example CFD](https://raw.githubusercontent.com/erikw/taiga-stats/master/img/cfd_example.png)\n\nTextual annotations can be put in the plot by manually editing the `.dat file`.\n\n\nAlso a target date for the project deadline can be specified. Then a line will be drawn showing the ideal work pace towards this date, as seen below where the target finish date is in week 46.\n\n![Example CFD with ideal pace](https://raw.githubusercontent.com/erikw/taiga-stats/master/img/cfd_example_ideal_pace.png)\n\n\nTo save the data and generate the diagram each working day I have this cronjob:\n\n```console\n$ crontab -l | grep taiga\n0 18 * * 1-5            $HOME/bin/taiga-stats-cron.sh\n```\n\nand the script `taiga-stats-cron.sh`:\n\n```bash\n#!/usr/bin/env sh\n\ntaiga-stats store_daily --tag some_feature_tag\ntaiga-stats cfd --tag some_feature_tag\n```\n\n## User Story Dependency Graph\n\nSome stories requires other to be completed before they can be started. I thought it would be handy if you could keep track of these dependencies in Taiga but simply writing for each US a list of other stories that this story depends on. Then from this information a [.dot file](sample_data/dependencies_example.dot) can be generated that should how you user stories depends on each other. This graph is very useful for work planning i.e. what to start with and how much parallelization is possible and at what stages.\n\n![US Dependency Graph](https://raw.githubusercontent.com/erikw/taiga-stats/master/img/dependencies_example.png)\n\nThe stories that are marked as Done in Taiga have a green color in the graph.\n\n\n### How to set up the dependency feature\n\nFirst create a new custom filed in taiga named `Depends On` under Settings > Attributes > Custom Fields:\n\n![Custom Field](https://raw.githubusercontent.com/erikw/taiga-stats/master/img/taiga_custom_field.png)\n\n\nThen go to your User Stories and enter some dependencies as demonstrated below.\n\n![US dependency](https://raw.githubusercontent.com/erikw/taiga-stats/master/img/us_depends_on.png)\n\n\nThen run the script and generate a png file.\n\n\n```console\n$ taiga-stats deps_dot\n$ dot -T png -o ./dependencies.png ./dependencies.dot\n```\n\n\n# Setup\n\n## Installation\n```console\n$ pip install taiga-stats\n$ taiga-stats -h\n```\n\nTo use this tool, you need to supply\n* `--url` to your taiga server e.g. `https://api.taiga.io/`\n* `--auth-token` that you need to obtain according to the [official instructions](https://docs.taiga.io/api.html#_authentication).\n\nIt\'s recommended to put these 2 values in the below described `taiga-stats.conf` file for easier usage of this tool!\n\n## Config file\nIt is tedious to have to specify the server URL and the authentication token everytime. Also you typically work with some project at a time and would like to have default values for the project to use and maybe which tag to filter on. You can genearte a configuration file to set these default values.\n\n```console\n$ taiga-stats config_template\n$ mv ./taiga.conf.template ~/.taiga-stats.conf\n$ vi ~/.taiga-stats.conf\n```\n\n\n# Development\n* Make sure to `$ poetry shell` before using tools like pyright LSP, so that it can find the installed dependency modules\n* Reference for how to structure a python projec: https://realpython.com/pypi-publish-python-package/\n\n## Setup from Git\n* Clone this git\n```console\n$ git clone https://github.com/erikw/taiga-stats.git\n$ cd taiga-stats\n```\n* Install Poetry\n* Numpy install issues as of 2021-10-31\n* `$ poetry install` did not work with numpy on macOS. Solution from https://github.com/python-poetry/poetry/issues/3196#issuecomment-769753478\n```console\n$ pyenv local 3.9.7\n$ poetry env use 3.9.7\n$ poetry env use 3.9.7\n$ poetry config experimental.new-installer false\n$ poetry install\n```\n\n* Install dependencies\n```console\n$ poetry install\n```\n* Now taiga-stats should work!\n```console\n$ poetry run taiga-stats -h\n$ # or\n$ bin/taiga-stats.sh\n```\n* To install locally:\n```console\n$ poetry build\n$ pip install dist/taiga_stats-*.whl\n```\n\n\n## Releasing\n```console\n$ vi -p pyproject.toml CHANGELOG.md  # Update version.\n$ poetry build\n$ ls -l dist/\n$ poetry publish\n```\n\nor\n\n```console\n$ vi -p pyproject.toml CHANGELOG.md  # Update version.\n$ poetry publish --build\n```\n',
    'author': 'Erik Westrup',
    'author_email': 'erik.westrup@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/erikw/taiga-stats',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<3.10.0',
}


setup(**setup_kwargs)
