"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PolicyStatementWithResources = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const _3_actions_1 = require("./3-actions");
/**
 * (experimental) Adds "resource" functionality to the Policy Statement.
 *
 * @experimental
 */
class PolicyStatementWithResources extends _3_actions_1.PolicyStatementWithActions {
    constructor() {
        super(...arguments);
        this.useNotResources = false;
        /**
         * @experimental
         */
        this.resources = [];
        /**
         * @experimental
         */
        this.skipAutoResource = false;
        this.cdkResourcesApplied = false;
    }
    /**
     * (experimental) Injects resources into the statement.
     *
     * Only relevant for the main package. In CDK mode this only calls super.
     *
     * @experimental
     */
    toJSON() {
        // @ts-ignore only available after swapping 1-base
        if (typeof this.addResources == 'function') {
            this.cdkApplyResources();
            return super.toJSON();
        }
        const mode = this.useNotResources ? 'NotResource' : 'Resource';
        const statement = super.toJSON();
        const self = this;
        this.ensureResource();
        if (this.resources.length) {
            const resources = this.resources.filter((elem, pos) => {
                return self.resources.indexOf(elem) == pos;
            });
            statement[mode] = resources.length > 1 ? resources : resources[0];
        }
        return statement;
    }
    /**
     * @experimental
     */
    toStatementJson() {
        this.ensureResource();
        this.cdkApplyResources();
        // @ts-ignore only available after swapping 1-base
        return super.toStatementJson();
    }
    cdkApplyResources() {
        if (!this.cdkResourcesApplied) {
            const mode = this.useNotResources ? 'addNotResources' : 'addResources';
            const self = this;
            const uniqueResources = this.resources.filter((elem, pos) => {
                return self.resources.indexOf(elem) == pos;
            });
            // @ts-ignore only available after swapping 1-base
            this[mode](...uniqueResources);
            this.cdkResourcesApplied = true;
        }
    }
    /**
     * (experimental) Switches the statement to use [`NotResource`](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_notresource.html).
     *
     * @experimental
     */
    notResources() {
        this.useNotResources = true;
        return this;
    }
    /**
     * (experimental) Checks weather any resource was applied to the policy.
     *
     * @experimental
     */
    hasResources() {
        return this.resources.length > 0;
    }
    /**
     * (experimental) Limit statement to specified resources.
     *
     * To allow all resources, pass `*`
     *
     * @experimental
     */
    on(...arns) {
        this.resources.push(...arns);
        return this;
    }
    /**
     * (experimental) Add all resources (`*`) to the statement.
     *
     * This is the default behavior, unless the statement has principals.
     *
     * @experimental
     */
    onAllResources() {
        this.resources.push('*');
        return this;
    }
    ensureResource() {
        if (this.hasResources())
            return;
        // @ts-ignore only available after swapping 1-base
        if (this.hasResource)
            return;
        // @ts-ignore only available after swapping 1-base
        if (this.hasPrincipal)
            return; //assume policies may not have resources
        if (this.skipAutoResource)
            return;
        // a statement requires resources. if none was added, we assume the user wants all resources
        this.onAllResources();
    }
    /**
     * (experimental) Dummy method. Will be overridden by 6-principal.ts.
     *
     * We just need it here so we can reference it in method `ensureResource`
     *
     * @experimental
     */
    hasPrincipals() {
        return false;
    }
}
exports.PolicyStatementWithResources = PolicyStatementWithResources;
_a = JSII_RTTI_SYMBOL_1;
PolicyStatementWithResources[_a] = { fqn: "iam-floyd.PolicyStatementWithResources", version: "0.178.0" };
//# sourceMappingURL=data:application/json;base64,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