# Changelog

## [Unreleased](https://github.com/bunq/sdk_python/tree/HEAD)

[Full Changelog](https://github.com/bunq/sdk_python/compare/1.14.0...HEAD)

**Implemented enhancements:**

-  Add a test for oauth\_authorization\_uri [\#145](https://github.com/bunq/sdk_python/issues/145)
- Update tests with Type Hints \(and other small Type Hint improvements\) [\#139](https://github.com/bunq/sdk_python/issues/139)
- Complete OAuth/PSD2 implementation [\#136](https://github.com/bunq/sdk_python/issues/136)
- Allow for a looser range of runtime dependency versions in conformance with semver backward compatibility guarantees [\#107](https://github.com/bunq/sdk_python/issues/107)
- Updated dependencies, and made them more flexible [\#146](https://github.com/bunq/sdk_python/pull/146) ([angelomelonas](https://github.com/angelomelonas))
- Added type hints for tests [\#141](https://github.com/bunq/sdk_python/pull/141) ([angelomelonas](https://github.com/angelomelonas))

**Fixed bugs:**

- Add missing \_user\_payment\_service\_provider variable with the value None to session\_server [\#135](https://github.com/bunq/sdk_python/pull/135) ([siccovansas](https://github.com/siccovansas))

**Closed issues:**

- Breaking changes since v1.13.0 [\#142](https://github.com/bunq/sdk_python/issues/142)
- Is this repository even maintained?  [\#140](https://github.com/bunq/sdk_python/issues/140)
- AttributeError: 'SessionServer' object has no attribute '\_user\_payment\_service\_provider' [\#134](https://github.com/bunq/sdk_python/issues/134)
- cannot import name 'ApiContext' from 'bunq.sdk.context' [\#132](https://github.com/bunq/sdk_python/issues/132)
- The CHANGELOG is out of date [\#131](https://github.com/bunq/sdk_python/issues/131)
- Error in class conversion since BillingInvoice does not exist  [\#124](https://github.com/bunq/sdk_python/issues/124)

**Merged pull requests:**

- Update CHANGELOG with breaking changes [\#143](https://github.com/bunq/sdk_python/pull/143) ([angelomelonas](https://github.com/angelomelonas))
- sdk\_python\#136 complete Oauth/PSD2 implementation [\#138](https://github.com/bunq/sdk_python/pull/138) ([angelomelonas](https://github.com/angelomelonas))
- update setup.py: only python 3.7 is supported. [\#133](https://github.com/bunq/sdk_python/pull/133) ([csdenboer](https://github.com/csdenboer))

## [1.14.0](https://github.com/bunq/sdk_python/tree/1.14.0) (2020-08-04)

[Full Changelog](https://github.com/bunq/sdk_python/compare/1.13.1...1.14.0)

## [1.13.1](https://github.com/bunq/sdk_python/tree/1.13.1) (2020-02-21)

[Full Changelog](https://github.com/bunq/sdk_python/compare/1.13.0...1.13.1)

**Implemented enhancements:**

- Add type hint. [\#89](https://github.com/bunq/sdk_python/issues/89)
- Python SDK PSD2 [\#123](https://github.com/bunq/sdk_python/pull/123) ([angelomelonas](https://github.com/angelomelonas))

**Fixed bugs:**

- Fix notification adapter and test. [\#126](https://github.com/bunq/sdk_python/pull/126) ([NickvandeGroes](https://github.com/NickvandeGroes))

**Closed issues:**

- Dependencies severely out of date \(and vulnerable: CVEs\) [\#121](https://github.com/bunq/sdk_python/issues/121)
- Typo in EXCEPTIONS.md [\#110](https://github.com/bunq/sdk_python/issues/110)

**Merged pull requests:**

- feature/fix\_typo: fix typo. [\#129](https://github.com/bunq/sdk_python/pull/129) ([angelomelonas](https://github.com/angelomelonas))
- Feature/dependency upgrades [\#128](https://github.com/bunq/sdk_python/pull/128) ([angelomelonas](https://github.com/angelomelonas))
- Add internal NotificationFilters [\#127](https://github.com/bunq/sdk_python/pull/127) ([angelomelonas](https://github.com/angelomelonas))

## [1.13.0](https://github.com/bunq/sdk_python/tree/1.13.0) (2020-02-19)

[Full Changelog](https://github.com/bunq/sdk_python/compare/1.10.16...1.13.0)

**Implemented enhancements:**

- Python SDK Refactor [\#117](https://github.com/bunq/sdk_python/pull/117) ([angelomelonas](https://github.com/angelomelonas))

## [1.10.16](https://github.com/bunq/sdk_python/tree/1.10.16) (2019-06-17)

[Full Changelog](https://github.com/bunq/sdk_python/compare/1.10.2...1.10.16)

**Closed issues:**

- Fix README.md preventing from uploading a new version of sdk [\#113](https://github.com/bunq/sdk_python/issues/113)

**Merged pull requests:**

- Markdown fix. \(bunq/sdk\_python\#113\) [\#114](https://github.com/bunq/sdk_python/pull/114) ([kojoru](https://github.com/kojoru))

## [1.10.2](https://github.com/bunq/sdk_python/tree/1.10.2) (2019-05-22)

[Full Changelog](https://github.com/bunq/sdk_python/compare/1.10.1...1.10.2)

**Closed issues:**

- MonetaryAccountJoint.list not availeble [\#112](https://github.com/bunq/sdk_python/issues/112)

## [1.10.1](https://github.com/bunq/sdk_python/tree/1.10.1) (2019-03-22)

[Full Changelog](https://github.com/bunq/sdk_python/compare/1.10.0...1.10.1)

## [1.10.0](https://github.com/bunq/sdk_python/tree/1.10.0) (2019-03-22)

[Full Changelog](https://github.com/bunq/sdk_python/compare/1.1.0...1.10.0)

**Closed issues:**

- Minimum Python version to 3.5.3 [\#108](https://github.com/bunq/sdk_python/issues/108)

**Merged pull requests:**

- Edits to allow Python 3.5.3 as minimum [\#109](https://github.com/bunq/sdk_python/pull/109) ([eavanvalkenburg](https://github.com/eavanvalkenburg))

## [1.1.0](https://github.com/bunq/sdk_python/tree/1.1.0) (2018-10-05)

[Full Changelog](https://github.com/bunq/sdk_python/compare/1.0.1...1.1.0)

**Closed issues:**

- Setting the Status of ShareInviteBankInquiry to ACCEPTED causes error at reciver [\#105](https://github.com/bunq/sdk_python/issues/105)

**Merged pull requests:**

- Bunq/sdk\_python\#78/remove config dep [\#106](https://github.com/bunq/sdk_python/pull/106) ([OGKevin](https://github.com/OGKevin))

## [1.0.1](https://github.com/bunq/sdk_python/tree/1.0.1) (2018-09-01)

[Full Changelog](https://github.com/bunq/sdk_python/compare/1.0.0...1.0.1)

## [1.0.0](https://github.com/bunq/sdk_python/tree/1.0.0) (2018-07-24)

[Full Changelog](https://github.com/bunq/sdk_python/compare/0.13.1...1.0.0)

**Implemented enhancements:**

- \[python\] Update examples in readme [\#87](https://github.com/bunq/sdk_python/issues/87)
- It is not possible to refresh userContext data  [\#79](https://github.com/bunq/sdk_python/issues/79)
- Optimise test framework [\#78](https://github.com/bunq/sdk_python/issues/78)
- Add more example scripts [\#68](https://github.com/bunq/sdk_python/issues/68)
- Auto save the session after automatic session reset has been executed  [\#65](https://github.com/bunq/sdk_python/issues/65)
- Add optional parameters to constructor  [\#55](https://github.com/bunq/sdk_python/issues/55)
- Monetary account joint cannot be retrieved. [\#52](https://github.com/bunq/sdk_python/issues/52)
- Endpoint HTTP methods should not be static [\#41](https://github.com/bunq/sdk_python/issues/41)
- Name field for pointer counterparty [\#29](https://github.com/bunq/sdk_python/issues/29)
- Added method to refresh user context data. \(bunq/sdk\_python\#79\) [\#80](https://github.com/bunq/sdk_python/pull/80) ([OGKevin](https://github.com/OGKevin))

**Fixed bugs:**

- bunq-sdk 0.12.4 package on PyPI contains code from 0.13.0 [\#88](https://github.com/bunq/sdk_python/issues/88)
- Can not construct a BunqMeTabEntry to create a BunqMeTab [\#77](https://github.com/bunq/sdk_python/issues/77)
- ImportError: cannot import name 'JSONDecodeError' [\#72](https://github.com/bunq/sdk_python/issues/72)

**Closed issues:**

- Update Sandbox API key procedure [\#100](https://github.com/bunq/sdk_python/issues/100)
- Python 3.4.2: ImportError: cannot import name 'context'  \(cyclic import?\) [\#73](https://github.com/bunq/sdk_python/issues/73)

**Merged pull requests:**

- Oauth bunq/sdk\_python\#102 [\#103](https://github.com/bunq/sdk_python/pull/103) ([OGKevin](https://github.com/OGKevin))
- Update Sandbox API key procedure. \(bunq/sdk\_python\#100\) [\#101](https://github.com/bunq/sdk_python/pull/101) ([sandervdo](https://github.com/sandervdo))
- Updated readme to point to tinker for examples. \(bunq/sdk\_python\#87\) [\#95](https://github.com/bunq/sdk_python/pull/95) ([OGKevin](https://github.com/OGKevin))
- Fix monetary account joint retrieval bunq/sdk\_python\#52 [\#94](https://github.com/bunq/sdk_python/pull/94) ([OGKevin](https://github.com/OGKevin))
- Fix supperfouls fields error bunq/sdk\_python\#77 [\#91](https://github.com/bunq/sdk_python/pull/91) ([OGKevin](https://github.com/OGKevin))
- Auto update bunq context bunq/sdk\_python\#65 [\#86](https://github.com/bunq/sdk_python/pull/86) ([OGKevin](https://github.com/OGKevin))
- Increased min python version to 3.6. \(bunq/sdk\_python\#73\) [\#85](https://github.com/bunq/sdk_python/pull/85) ([OGKevin](https://github.com/OGKevin))
- Replace examples with tinker bunq/sdk\_pyhton\#68 [\#84](https://github.com/bunq/sdk_python/pull/84) ([OGKevin](https://github.com/OGKevin))
- Use ValueError isntead of JsonDecodeError. \(bunq/sdk\_python\#72\) [\#83](https://github.com/bunq/sdk_python/pull/83) ([OGKevin](https://github.com/OGKevin))
- Optimise test framework auto topup bunq/sdk\_python\#78 [\#81](https://github.com/bunq/sdk_python/pull/81) ([OGKevin](https://github.com/OGKevin))

## [0.13.1](https://github.com/bunq/sdk_python/tree/0.13.1) (2018-05-30)

[Full Changelog](https://github.com/bunq/sdk_python/compare/0.13.0...0.13.1)

**Closed issues:**

- Bunq sdk release request [\#97](https://github.com/bunq/sdk_python/issues/97)
- reopening of question \#12 generated.Payment.FIELD\_COUNTERPARTY\_ALIAS not working with IBAN [\#96](https://github.com/bunq/sdk_python/issues/96)
- Update samples and readme [\#93](https://github.com/bunq/sdk_python/issues/93)
- bunq.sdk.exception.BunqException: ApiContext has not been loaded. Please load ApiContext in BunqContext [\#92](https://github.com/bunq/sdk_python/issues/92)
- Sample for reading/using shared accounts [\#90](https://github.com/bunq/sdk_python/issues/90)
- Add oath support. [\#102](https://github.com/bunq/sdk_python/issues/102)
- Move to new sandbox env.  [\#98](https://github.com/bunq/sdk_python/issues/98)

**Merged pull requests:**

- Move to new sandbox bunq/sdk\_python\#98 [\#99](https://github.com/bunq/sdk_python/pull/99) ([OGKevin](https://github.com/OGKevin))

## [0.13.0](https://github.com/bunq/sdk_python/tree/0.13.0) (2018-03-20)

[Full Changelog](https://github.com/bunq/sdk_python/compare/0.12.4...0.13.0)

**Implemented enhancements:**

- Add zappr integration for better quality control  [\#62](https://github.com/bunq/sdk_python/issues/62)
- Add more information to template [\#60](https://github.com/bunq/sdk_python/issues/60)
- Add response id to error messages from failed requests  [\#59](https://github.com/bunq/sdk_python/issues/59)

**Fixed bugs:**

- Token request ideal is missing id attribute in response. [\#67](https://github.com/bunq/sdk_python/issues/67)
- Field ID is missing from MasterCardAction [\#54](https://github.com/bunq/sdk_python/issues/54)
- TokenQrRequestIdeal returns the wrong type [\#53](https://github.com/bunq/sdk_python/issues/53)

**Closed issues:**

- bunq update 7  [\#75](https://github.com/bunq/sdk_python/issues/75)

**Merged pull requests:**

- Regenerate code for release [\#74](https://github.com/bunq/sdk_python/pull/74) ([OGKevin](https://github.com/OGKevin))
- Regenerated code to add object types. \(bunq/sdk\_python\#53\) [\#70](https://github.com/bunq/sdk_python/pull/70) ([OGKevin](https://github.com/OGKevin))
- Bunq/sdk python\#67 add missing token qr id field [\#69](https://github.com/bunq/sdk_python/pull/69) ([OGKevin](https://github.com/OGKevin))
- Added missing id field to mastercard action. \(bunq/sdk\_python\#54\) [\#66](https://github.com/bunq/sdk_python/pull/66) ([OGKevin](https://github.com/OGKevin))
- Feature/bunq/sdk python\#59 add response id to request error [\#64](https://github.com/bunq/sdk_python/pull/64) ([OGKevin](https://github.com/OGKevin))
- Configure Zappr [\#63](https://github.com/bunq/sdk_python/pull/63) ([OGKevin](https://github.com/OGKevin))
- \(bunq/sdk\_python\#60\) improve issue and pr template [\#61](https://github.com/bunq/sdk_python/pull/61) ([OGKevin](https://github.com/OGKevin))
- Bunq update 7  [\#76](https://github.com/bunq/sdk_python/pull/76) ([OGKevin](https://github.com/OGKevin))

## [0.12.4](https://github.com/bunq/sdk_python/tree/0.12.4) (2017-12-21)

[Full Changelog](https://github.com/bunq/sdk_python/compare/0.12.3...0.12.4)

**Implemented enhancements:**

- Make sure received signatures headers are correctly cased [\#51](https://github.com/bunq/sdk_python/issues/51)
- Introduce from\_json method  [\#50](https://github.com/bunq/sdk_python/issues/50)
- Return base class from createFromJsonString [\#49](https://github.com/bunq/sdk_python/issues/49)
- CHANGELOG.md is empty [\#46](https://github.com/bunq/sdk_python/issues/46)
- Improve decoder to recognise child object  [\#42](https://github.com/bunq/sdk_python/issues/42)
- Generated CHANGELOG.md :clap:. \(bunq/sdk\_python\#46\) [\#47](https://github.com/bunq/sdk_python/pull/47) ([OGKevin](https://github.com/OGKevin))

**Closed issues:**

- Python doesn't want CamelCase  [\#45](https://github.com/bunq/sdk_python/issues/45)

**Merged pull requests:**

- Feature/make sure headers are correctly cased bunq/sdk python\#51 [\#57](https://github.com/bunq/sdk_python/pull/57) ([OGKevin](https://github.com/OGKevin))
- Feature/improve decoder bunq/sdk python\#42 [\#56](https://github.com/bunq/sdk_python/pull/56) ([OGKevin](https://github.com/OGKevin))
- Renamed camelCase methods. \(bunq/sdk\_python\#45\) [\#48](https://github.com/bunq/sdk_python/pull/48) ([OGKevin](https://github.com/OGKevin))

## [0.12.3](https://github.com/bunq/sdk_python/tree/0.12.3) (2017-11-15)

[Full Changelog](https://github.com/bunq/sdk_python/compare/0.12.2...0.12.3)

**Implemented enhancements:**

- Callback models for holding callback data [\#40](https://github.com/bunq/sdk_python/issues/40)
- Feature/callback models bunq/sdk python\#40 [\#43](https://github.com/bunq/sdk_python/pull/43) ([OGKevin](https://github.com/OGKevin))

**Fixed bugs:**

- ScheduledPayment causes decode error due to Typo [\#44](https://github.com/bunq/sdk_python/issues/44)

## [0.12.2](https://github.com/bunq/sdk_python/tree/0.12.2) (2017-11-08)

[Full Changelog](https://github.com/bunq/sdk_python/compare/0.12.0...0.12.2)

**Implemented enhancements:**

- Add missing fields for cvc endpoint [\#37](https://github.com/bunq/sdk_python/issues/37)
- Missing CARD GENERATED CVC2 endpoint  [\#33](https://github.com/bunq/sdk_python/issues/33)
- More flexibility for sessionContext handling [\#31](https://github.com/bunq/sdk_python/issues/31)
- Added cvc\_endpoint. \#33 [\#34](https://github.com/bunq/sdk_python/pull/34) ([OGKevin](https://github.com/OGKevin))
- Added isSessionExpired\(\) method \#31. [\#32](https://github.com/bunq/sdk_python/pull/32) ([OGKevin](https://github.com/OGKevin))

**Fixed bugs:**

- DraftPayment object field causes converter error  [\#36](https://github.com/bunq/sdk_python/issues/36)

**Merged pull requests:**

- Feature/fix draft payment object \#36 [\#39](https://github.com/bunq/sdk_python/pull/39) ([OGKevin](https://github.com/OGKevin))
- Feature/add missing cvc fields \#37 [\#38](https://github.com/bunq/sdk_python/pull/38) ([OGKevin](https://github.com/OGKevin))

## [0.12.0](https://github.com/bunq/sdk_python/tree/0.12.0) (2017-10-11)

[Full Changelog](https://github.com/bunq/sdk_python/compare/0.11.0...0.12.0)

**Implemented enhancements:**

- Add strictly typed BunqResponses [\#27](https://github.com/bunq/sdk_python/issues/27)
- Better error handling  [\#25](https://github.com/bunq/sdk_python/issues/25)
- Add Pagination [\#20](https://github.com/bunq/sdk_python/issues/20)
- Marked all files in generated dir as generated code. [\#24](https://github.com/bunq/sdk_python/pull/24) ([OGKevin](https://github.com/OGKevin))

**Merged pull requests:**

- cleanup after 27-strictly-typed-response [\#30](https://github.com/bunq/sdk_python/pull/30) ([dnl-blkv](https://github.com/dnl-blkv))
- Add strictly typed responses; fix circular dependencies; improve namespaces [\#28](https://github.com/bunq/sdk_python/pull/28) ([dnl-blkv](https://github.com/dnl-blkv))
- Feature/exception handler [\#26](https://github.com/bunq/sdk_python/pull/26) ([OGKevin](https://github.com/OGKevin))

## [0.11.0](https://github.com/bunq/sdk_python/tree/0.11.0) (2017-09-06)

[Full Changelog](https://github.com/bunq/sdk_python/compare/0.10.0...0.11.0)

**Implemented enhancements:**

- Ignore generated code for reviews  [\#22](https://github.com/bunq/sdk_python/issues/22)
- Feature/git attributes [\#23](https://github.com/bunq/sdk_python/pull/23) ([OGKevin](https://github.com/OGKevin))
- Add pagination [\#21](https://github.com/bunq/sdk_python/pull/21) ([dnl-blkv](https://github.com/dnl-blkv))

## [0.10.0](https://github.com/bunq/sdk_python/tree/0.10.0) (2017-08-22)

[Full Changelog](https://github.com/bunq/sdk_python/compare/0.9.1...0.10.0)

**Implemented enhancements:**

- Add proxy support to Python SDK [\#16](https://github.com/bunq/sdk_python/issues/16)
- Break the SDK's dependence on the bunq.conf file [\#11](https://github.com/bunq/sdk_python/issues/11)
- Response is missing response headers and pagination [\#9](https://github.com/bunq/sdk_python/issues/9)
- cleanup tests \[\#18\] [\#19](https://github.com/bunq/sdk_python/pull/19) ([dnl-blkv](https://github.com/dnl-blkv))
- Changed test class name [\#14](https://github.com/bunq/sdk_python/pull/14) ([OGKevin](https://github.com/OGKevin))
- Load and Save an ApiContext from and to JSON Data [\#13](https://github.com/bunq/sdk_python/pull/13) ([PJUllrich](https://github.com/PJUllrich))
- \#9 Introduce BunqResponse [\#10](https://github.com/bunq/sdk_python/pull/10) ([dnl-blkv](https://github.com/dnl-blkv))

**Closed issues:**

- Tests need a minor cleanup [\#18](https://github.com/bunq/sdk_python/issues/18)

**Merged pull requests:**

- Add proxy support \[\#16\] [\#17](https://github.com/bunq/sdk_python/pull/17) ([dnl-blkv](https://github.com/dnl-blkv))

## [0.9.1](https://github.com/bunq/sdk_python/tree/0.9.1) (2017-08-07)

[Full Changelog](https://github.com/bunq/sdk_python/compare/4fb168bb3e1ed40b0b8ca00c8156b384debf2e29...0.9.1)

**Implemented enhancements:**

- Submit this as package to PyPi [\#2](https://github.com/bunq/sdk_python/issues/2)
- Readme for tests [\#5](https://github.com/bunq/sdk_python/pull/5) ([OGKevin](https://github.com/OGKevin))
- Uploaded to PyPi [\#4](https://github.com/bunq/sdk_python/pull/4) ([OGKevin](https://github.com/OGKevin))
- Add first series of unit-tests [\#1](https://github.com/bunq/sdk_python/pull/1) ([OGKevin](https://github.com/OGKevin))

**Fixed bugs:**

- Add Threadsafety for x-bunq-server-signature [\#7](https://github.com/bunq/sdk_python/issues/7)



\* *This Changelog was automatically generated by [github_changelog_generator](https://github.com/github-changelog-generator/github-changelog-generator)*
