/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.common.statistics;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.projector.common.statistics.DoubleValue;
import org.jetbrains.projector.common.statistics.LongValue;
import org.jetbrains.projector.common.statistics.RoundingStrategy;
import org.jetbrains.projector.common.statistics.StatsValue;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u0016*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0003\u0016\u0017\u0018B/\b\u0002\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0012J\u0018\u0010\u0013\u001a\f0\u0014R\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0015\u001a\u00020\rR\u0012\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/projector/common/statistics/Rate;", "ValueType", "", "", "value", "Lorg/jetbrains/projector/common/statistics/StatsValue;", "unit", "", "name", "roundingStrategy", "Lorg/jetbrains/projector/common/statistics/RoundingStrategy;", "(Lorg/jetbrains/projector/common/statistics/StatsValue;Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/projector/common/statistics/RoundingStrategy;)V", "lastTimeStampMs", "", "Ljava/lang/Double;", "add", "", "measurement", "(Ljava/lang/Number;)V", "reset", "Lorg/jetbrains/projector/common/statistics/Rate$ResetResult;", "currentTimeStampMs", "Companion", "Data", "ResetResult", "projector-common"})
public final class Rate<ValueType extends Number> {
    private Double lastTimeStampMs;
    private final StatsValue<ValueType> value;
    private final String unit;
    private final String name;
    private final RoundingStrategy roundingStrategy;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final void add(@NotNull ValueType measurement) {
        Intrinsics.checkNotNullParameter(measurement, (String)"measurement");
        this.value.add(measurement);
    }

    @NotNull
    public final ResetResult reset(double currentTimeStampMs) {
        Data data;
        Double lastMs = this.lastTimeStampMs;
        this.lastTimeStampMs = currentTimeStampMs;
        if (lastMs == null) {
            return new ResetResult(Data.Empty.INSTANCE);
        }
        double delta = currentTimeStampMs - lastMs;
        if (delta == 0.0) {
            data = Data.Empty.INSTANCE;
        } else {
            ValueType resetValue = this.value.reset();
            data = new Data.Success(((Number)resetValue).doubleValue() / delta, delta);
        }
        Data data2 = data;
        return new ResetResult(data2);
    }

    private Rate(StatsValue<ValueType> value, String unit, String name, RoundingStrategy roundingStrategy) {
        this.value = value;
        this.unit = unit;
        this.name = name;
        this.roundingStrategy = roundingStrategy;
    }

    public /* synthetic */ Rate(StatsValue value, String unit, String name, RoundingStrategy roundingStrategy, DefaultConstructorMarker $constructor_marker) {
        this(value, unit, name, roundingStrategy);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Lorg/jetbrains/projector/common/statistics/Rate$ResetResult;", "", "data", "Lorg/jetbrains/projector/common/statistics/Rate$Data;", "(Lorg/jetbrains/projector/common/statistics/Rate;Lorg/jetbrains/projector/common/statistics/Rate$Data;)V", "getData", "()Lorg/jetbrains/projector/common/statistics/Rate$Data;", "generateString", "", "separator", "projector-common"})
    public final class ResetResult {
        @NotNull
        private final Data data;

        @NotNull
        public final String generateString(@NotNull String separator) {
            Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
            return Rate.this.name + " rate:" + separator + this.data.generateString(Rate.this.roundingStrategy, Rate.this.unit, separator);
        }

        @NotNull
        public final Data getData() {
            return this.data;
        }

        public ResetResult(Data data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.data = data;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\t\nB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\u0004H&\u0082\u0001\u0002\u000b\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/projector/common/statistics/Rate$Data;", "", "()V", "generateString", "", "roundingStrategy", "Lorg/jetbrains/projector/common/statistics/RoundingStrategy;", "unit", "separator", "Empty", "Success", "Lorg/jetbrains/projector/common/statistics/Rate$Data$Empty;", "Lorg/jetbrains/projector/common/statistics/Rate$Data$Success;", "projector-common"})
    public static abstract class Data {
        @NotNull
        public abstract String generateString(@NotNull RoundingStrategy var1, @Nullable String var2, @NotNull String var3);

        private Data() {
        }

        public /* synthetic */ Data(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/projector/common/statistics/Rate$Data$Empty;", "Lorg/jetbrains/projector/common/statistics/Rate$Data;", "()V", "generateString", "", "roundingStrategy", "Lorg/jetbrains/projector/common/statistics/RoundingStrategy;", "unit", "separator", "projector-common"})
        public static final class Empty
        extends Data {
            @NotNull
            public static final Empty INSTANCE;

            @Override
            @NotNull
            public String generateString(@NotNull RoundingStrategy roundingStrategy, @Nullable String unit, @NotNull String separator) {
                Intrinsics.checkNotNullParameter((Object)roundingStrategy, (String)"roundingStrategy");
                Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
                return "no data" + separator + "(no delta data)";
            }

            private Empty() {
                super(null);
            }

            static {
                Empty empty;
                INSTANCE = empty = new Empty();
            }
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\"\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0015\u001a\u00020\u0011H\u0016J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/projector/common/statistics/Rate$Data$Success;", "Lorg/jetbrains/projector/common/statistics/Rate$Data;", "ratePerMs", "", "deltaMs", "(DD)V", "getDeltaMs", "()D", "getRatePerMs", "component1", "component2", "copy", "equals", "", "other", "", "generateString", "", "roundingStrategy", "Lorg/jetbrains/projector/common/statistics/RoundingStrategy;", "unit", "separator", "hashCode", "", "toString", "Companion", "projector-common"})
        public static final class Success
        extends Data {
            private final double ratePerMs;
            private final double deltaMs;
            private static final RoundingStrategy.FractionDigits deltaRounding;
            @NotNull
            public static final Companion Companion;

            @Override
            @NotNull
            public String generateString(@NotNull RoundingStrategy roundingStrategy, @Nullable String unit, @NotNull String separator) {
                String string;
                Intrinsics.checkNotNullParameter((Object)roundingStrategy, (String)"roundingStrategy");
                Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
                String string2 = unit;
                if (string2 == null) {
                    string = "";
                } else {
                    String string3 = unit;
                    boolean bl = false;
                    String string4 = string3;
                    if (string4 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    string = ' ' + ((Object)StringsKt.trim((CharSequence)string4)).toString();
                }
                String postfix = string;
                return roundingStrategy.round(this.ratePerMs * (double)1000) + postfix + " per second" + separator + '(' + Success.Companion.roundDeltaMs(this.deltaMs) + ')';
            }

            public final double getRatePerMs() {
                return this.ratePerMs;
            }

            public final double getDeltaMs() {
                return this.deltaMs;
            }

            public Success(double ratePerMs, double deltaMs) {
                super(null);
                this.ratePerMs = ratePerMs;
                this.deltaMs = deltaMs;
            }

            static {
                Companion = new Companion(null);
                deltaRounding = new RoundingStrategy.FractionDigits(1);
            }

            public final double component1() {
                return this.ratePerMs;
            }

            public final double component2() {
                return this.deltaMs;
            }

            @NotNull
            public final Success copy(double ratePerMs, double deltaMs) {
                return new Success(ratePerMs, deltaMs);
            }

            public static /* synthetic */ Success copy$default(Success success, double d, double d2, int n, Object object) {
                if ((n & 1) != 0) {
                    d = success.ratePerMs;
                }
                if ((n & 2) != 0) {
                    d2 = success.deltaMs;
                }
                return success.copy(d, d2);
            }

            @NotNull
            public String toString() {
                return "Success(ratePerMs=" + this.ratePerMs + ", deltaMs=" + this.deltaMs + ")";
            }

            public int hashCode() {
                return Double.hashCode(this.ratePerMs) * 31 + Double.hashCode(this.deltaMs);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Success)) break block3;
                        Success success = (Success)object;
                        if (Double.compare(this.ratePerMs, success.ratePerMs) != 0 || Double.compare(this.deltaMs, success.deltaMs) != 0) break block3;
                    }
                    return true;
                }
                return false;
            }

            @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/projector/common/statistics/Rate$Data$Success$Companion;", "", "()V", "deltaRounding", "Lorg/jetbrains/projector/common/statistics/RoundingStrategy$FractionDigits;", "roundDeltaMs", "", "deltaMs", "", "projector-common"})
            public static final class Companion {
                private final String roundDeltaMs(double deltaMs) {
                    return deltaRounding.round(deltaMs / (double)1000) + " seconds";
                }

                private Companion() {
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0007J(\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0007\u00a8\u0006\r"}, d2={"Lorg/jetbrains/projector/common/statistics/Rate$Companion;", "", "()V", "createForDouble", "Lorg/jetbrains/projector/common/statistics/Rate;", "", "name", "", "roundingStrategy", "Lorg/jetbrains/projector/common/statistics/RoundingStrategy;", "unit", "createForLong", "", "projector-common"})
    public static final class Companion {
        @NotNull
        public final Rate<Double> createForDouble(@NotNull String name, @NotNull RoundingStrategy roundingStrategy, @Nullable String unit) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)roundingStrategy, (String)"roundingStrategy");
            return new Rate<Double>(new DoubleValue(), unit, name, roundingStrategy, null);
        }

        public static /* synthetic */ Rate createForDouble$default(Companion companion, String string, RoundingStrategy roundingStrategy, String string2, int n, Object object) {
            if ((n & 4) != 0) {
                string2 = null;
            }
            return companion.createForDouble(string, roundingStrategy, string2);
        }

        @NotNull
        public final Rate<Long> createForLong(@NotNull String name, @NotNull RoundingStrategy roundingStrategy, @Nullable String unit) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)roundingStrategy, (String)"roundingStrategy");
            return new Rate<Long>(new LongValue(), unit, name, roundingStrategy, null);
        }

        public static /* synthetic */ Rate createForLong$default(Companion companion, String string, RoundingStrategy roundingStrategy, String string2, int n, Object object) {
            if ((n & 4) != 0) {
                string2 = null;
            }
            return companion.createForLong(string, roundingStrategy, string2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

