/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.server.core.convert.toAwt;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.projector.common.protocol.toServer.ClientMouseEvent;
import org.jetbrains.projector.common.protocol.toServer.ClientWheelEvent;
import org.jetbrains.projector.common.protocol.toServer.MouseModifier;
import org.jetbrains.projector.server.core.ReadyClientSettings;
import org.jetbrains.projector.server.core.convert.toAwt.MouseKt;
import org.jetbrains.projector.server.core.convert.toAwt.MouseKt$WhenMappings;
import org.jetbrains.projector.server.core.convert.toClient.ConvertKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u0000F\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\u001a \u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\t\u001a.\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u001e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u0012\u0010\u001a\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00070\u001bH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"DEFAULT_SCROLL_AMOUNT", "", "PIXEL_DELTA_ENOUGH_FOR_SCROLLING", "PIXEL_PER_UNIT", "TOUCH_PIXEL_PER_UNIT", "mouseModifierMask", "", "Lorg/jetbrains/projector/common/protocol/toServer/MouseModifier;", "calculateNewTouchState", "Lorg/jetbrains/projector/server/core/ReadyClientSettings$TouchState;", "shiftedMessage", "Lorg/jetbrains/projector/common/protocol/toServer/ClientMouseEvent;", "message", "currentTouchState", "createMouseEvent", "Ljava/awt/event/MouseEvent;", "source", "Ljava/awt/Component;", "event", "previousTouchState", "newTouchState", "connectionMillis", "", "createMouseWheelEvent", "Ljava/awt/event/MouseWheelEvent;", "Lorg/jetbrains/projector/common/protocol/toServer/ClientWheelEvent;", "toMouseInt", "", "projector-server-core"})
public final class MouseKt {
    private static final int DEFAULT_SCROLL_AMOUNT = 1;
    private static final int PIXEL_PER_UNIT = 100;
    private static final int TOUCH_PIXEL_PER_UNIT = 300;
    private static final int PIXEL_DELTA_ENOUGH_FOR_SCROLLING = 10;
    private static final Map<MouseModifier, Integer> mouseModifierMask = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)MouseModifier.ALT_KEY, (Object)512), TuplesKt.to((Object)MouseModifier.CTRL_KEY, (Object)128), TuplesKt.to((Object)MouseModifier.SHIFT_KEY, (Object)64), TuplesKt.to((Object)MouseModifier.META_KEY, (Object)256)});

    @Nullable
    public static final ReadyClientSettings.TouchState calculateNewTouchState(@NotNull ClientMouseEvent shiftedMessage, @NotNull ClientMouseEvent message, @NotNull ReadyClientSettings.TouchState currentTouchState) {
        ReadyClientSettings.TouchState touchState;
        Intrinsics.checkNotNullParameter((Object)shiftedMessage, (String)"shiftedMessage");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)currentTouchState, (String)"currentTouchState");
        calculateNewTouchState.1 $fun$isEnoughDeltaForScrolling$1 = calculateNewTouchState.1.INSTANCE;
        switch (MouseKt$WhenMappings.$EnumSwitchMapping$0[shiftedMessage.getMouseEventType().ordinal()]) {
            case 1: {
                touchState = ReadyClientSettings.TouchState.Released.INSTANCE;
                break;
            }
            case 2: {
                touchState = new ReadyClientSettings.TouchState.OnlyPressed(message.getTimeStamp(), shiftedMessage.getX(), shiftedMessage.getY());
                break;
            }
            case 3: {
                ReadyClientSettings.TouchState touchState2 = currentTouchState;
                if (touchState2 instanceof ReadyClientSettings.TouchState.Scrolling) {
                    ReadyClientSettings.TouchState.Scrolling scrolling;
                    boolean bl = $fun$isEnoughDeltaForScrolling$1.invoke((ReadyClientSettings.TouchState.Scrolling)currentTouchState, shiftedMessage.getX(), shiftedMessage.getY());
                    if (bl) {
                        scrolling = new ReadyClientSettings.TouchState.Scrolling(((ReadyClientSettings.TouchState.Scrolling)currentTouchState).getInitialX(), ((ReadyClientSettings.TouchState.Scrolling)currentTouchState).getInitialY(), shiftedMessage.getX(), shiftedMessage.getY());
                    } else if (!bl) {
                        scrolling = null;
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    touchState = scrolling;
                    break;
                }
                if (touchState2 instanceof ReadyClientSettings.TouchState.Dragging) {
                    touchState = ReadyClientSettings.TouchState.Dragging.INSTANCE;
                    break;
                }
                if (touchState2 instanceof ReadyClientSettings.TouchState.OnlyPressed) {
                    boolean bl;
                    boolean bl2 = bl = ((ReadyClientSettings.TouchState.OnlyPressed)currentTouchState).getConnectionMillis() + 500 < shiftedMessage.getTimeStamp();
                    if (bl) {
                        touchState = ReadyClientSettings.TouchState.Dragging.INSTANCE;
                        break;
                    }
                    if (!bl) {
                        touchState = new ReadyClientSettings.TouchState.Scrolling(((ReadyClientSettings.TouchState.OnlyPressed)currentTouchState).getLastX(), ((ReadyClientSettings.TouchState.OnlyPressed)currentTouchState).getLastY(), shiftedMessage.getX(), shiftedMessage.getY());
                        break;
                    }
                    throw new NoWhenBranchMatchedException();
                }
                if (touchState2 instanceof ReadyClientSettings.TouchState.Released) {
                    touchState = ReadyClientSettings.TouchState.Released.INSTANCE;
                    break;
                }
                throw new NoWhenBranchMatchedException();
            }
            default: {
                touchState = currentTouchState;
            }
        }
        return touchState;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final MouseEvent createMouseEvent(@NotNull Component source, @NotNull ClientMouseEvent event, @NotNull ReadyClientSettings.TouchState previousTouchState, @NotNull ReadyClientSettings.TouchState newTouchState, long connectionMillis) {
        int n;
        int n2;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)previousTouchState, (String)"previousTouchState");
        Intrinsics.checkNotNullParameter((Object)newTouchState, (String)"newTouchState");
        Point locationOnScreen = source.getLocationOnScreen();
        switch (MouseKt$WhenMappings.$EnumSwitchMapping$1[event.getMouseEventType().ordinal()]) {
            case 1: {
                n2 = 503;
                break;
            }
            case 2: {
                n2 = 501;
                break;
            }
            case 3: {
                n2 = 502;
                break;
            }
            case 4: {
                n2 = 500;
                break;
            }
            case 5: {
                n2 = 505;
                break;
            }
            case 6: {
                n2 = 506;
                break;
            }
            case 7: {
                if (previousTouchState instanceof ReadyClientSettings.TouchState.WithCoordinates && newTouchState instanceof ReadyClientSettings.TouchState.Scrolling) {
                    void wheelDelta;
                    int deltaY;
                    int deltaX = ((ReadyClientSettings.TouchState.Scrolling)newTouchState).getLastX() - ((ReadyClientSettings.TouchState.WithCoordinates)((Object)previousTouchState)).getLastX();
                    var $fun$isHorizontal$1 = new Function0<Boolean>(deltaX, deltaY = ((ReadyClientSettings.TouchState.Scrolling)newTouchState).getLastY() - ((ReadyClientSettings.TouchState.WithCoordinates)((Object)previousTouchState)).getLastY()){
                        final /* synthetic */ int $deltaX;
                        final /* synthetic */ int $deltaY;

                        public final boolean invoke() {
                            int n = this.$deltaX;
                            boolean bl = false;
                            int n2 = Math.abs(n);
                            n = this.$deltaY;
                            bl = false;
                            return n2 > Math.abs(n);
                        }
                        {
                            this.$deltaX = n;
                            this.$deltaY = n2;
                            super(0);
                        }
                    };
                    Pair pair = $fun$isHorizontal$1.invoke() ? TuplesKt.to((Object)deltaX, (Object)(MouseKt.toMouseInt(event.getModifiers()) | 0x40)) : TuplesKt.to((Object)deltaY, (Object)MouseKt.toMouseInt(event.getModifiers()));
                    int n3 = ((Number)pair.component1()).intValue();
                    int modifiers = ((Number)pair.component2()).intValue();
                    void negatedWheelDelta = -wheelDelta;
                    double normalizedWheelDelta = (double)negatedWheelDelta / (double)300;
                    int notNullNormalizedWheelDelta = (int)ConvertKt.roundToInfinity(normalizedWheelDelta);
                    return new MouseWheelEvent(source, 507, connectionMillis + (long)event.getTimeStamp(), modifiers, ((ReadyClientSettings.TouchState.Scrolling)newTouchState).getInitialX() - locationOnScreen.x, ((ReadyClientSettings.TouchState.Scrolling)newTouchState).getInitialY() - locationOnScreen.y, ((ReadyClientSettings.TouchState.Scrolling)newTouchState).getInitialX() - locationOnScreen.x, ((ReadyClientSettings.TouchState.Scrolling)newTouchState).getInitialY() - locationOnScreen.y, 0, false, 0, 1, notNullNormalizedWheelDelta, normalizedWheelDelta);
                }
                n2 = 506;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        int id2 = n2;
        switch (MouseKt$WhenMappings.$EnumSwitchMapping$2[event.getMouseEventType().ordinal()]) {
            case 1: 
            case 2: {
                n = 0;
                break;
            }
            default: {
                n = event.getButton() + 1;
            }
        }
        int awtEventButton = n;
        int modifiers = MouseKt.toMouseInt(event.getModifiers());
        int buttonModifier = awtEventButton == 0 || event.getMouseEventType() == ClientMouseEvent.MouseEventType.UP ? 0 : InputEvent.getMaskForButton(awtEventButton);
        boolean canTriggerPopup = awtEventButton == 3 && id2 == 501;
        return new MouseEvent(source, id2, connectionMillis + (long)event.getTimeStamp(), modifiers | buttonModifier, event.getX() - locationOnScreen.x, event.getY() - locationOnScreen.y, event.getClickCount(), canTriggerPopup, awtEventButton);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final MouseWheelEvent createMouseWheelEvent(@NotNull Component source, @NotNull ClientWheelEvent event, long connectionMillis) {
        void mode;
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        createMouseWheelEvent.1 $fun$isHorizontal$1 = createMouseWheelEvent.1.INSTANCE;
        Pair pair2 = $fun$isHorizontal$1.invoke(event) ? TuplesKt.to((Object)event.getDeltaX(), (Object)(MouseKt.toMouseInt(event.getModifiers()) | 0x40)) : TuplesKt.to((Object)event.getDeltaY(), (Object)MouseKt.toMouseInt(event.getModifiers()));
        double d = ((Number)pair2.component1()).doubleValue();
        int modifiers = ((Number)pair2.component2()).intValue();
        switch (MouseKt$WhenMappings.$EnumSwitchMapping$3[event.getMode().ordinal()]) {
            case 1: {
                void wheelDelta;
                pair = TuplesKt.to((Object)0, (Object)((double)(wheelDelta / (double)100)));
                break;
            }
            case 2: {
                void wheelDelta;
                pair = TuplesKt.to((Object)0, (Object)((double)wheelDelta));
                break;
            }
            case 3: {
                void wheelDelta;
                pair = TuplesKt.to((Object)1, (Object)((double)wheelDelta));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Pair pair3 = pair;
        int n = ((Number)pair3.component1()).intValue();
        double normalizedWheelDelta = ((Number)pair3.component2()).doubleValue();
        int notNullNormalizedWheelDelta = (int)ConvertKt.roundToInfinity(normalizedWheelDelta);
        Point locationOnScreen = source.getLocationOnScreen();
        return new MouseWheelEvent(source, 507, connectionMillis + (long)event.getTimeStamp(), modifiers, event.getX() - locationOnScreen.x, event.getY() - locationOnScreen.y, event.getX() - locationOnScreen.x, event.getY() - locationOnScreen.y, 0, false, (int)mode, 1, notNullNormalizedWheelDelta, normalizedWheelDelta);
    }

    /*
     * WARNING - void declaration
     */
    private static final int toMouseInt(Set<? extends MouseModifier> $this$toMouseInt) {
        void $this$fold$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Iterable iterable = $this$toMouseInt;
        Map<MouseModifier, Integer> map = mouseModifierMask;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p1;
            MouseModifier mouseModifier = (MouseModifier)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Integer n = ((Number)MapsKt.getValue(map, (Object)p1)).intValue();
            collection.add(n);
        }
        $this$map$iv = (List)destination$iv$iv;
        int initial$iv = 0;
        boolean $i$f$fold = false;
        int accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void p2;
            int n = ((Number)element$iv).intValue();
            int p1 = accumulator$iv;
            boolean bl = false;
            accumulator$iv = p1 | p2;
        }
        return accumulator$iv;
    }
}

