/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.server.core.ij;

import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.projector.common.protocol.data.UserKeymap;
import org.jetbrains.projector.server.core.ij.IdeaStateKt;
import org.jetbrains.projector.server.core.ij.KeymapSetter;
import org.jetbrains.projector.server.core.ij.KeymapSetter$WhenMappings;
import org.jetbrains.projector.util.logging.Logger;
import org.jetbrains.projector.util.logging.LoggerKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\f\u0010\t\u001a\u00020\n*\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/projector/server/core/ij/KeymapSetter;", "", "()V", "logger", "Lorg/jetbrains/projector/util/logging/Logger;", "setKeymap", "", "keymap", "Lorg/jetbrains/projector/common/protocol/data/UserKeymap;", "toKeyMapManagerFieldName", "", "projector-server-core"})
public final class KeymapSetter {
    private static final Logger logger;
    @NotNull
    public static final KeymapSetter INSTANCE;

    private final String toKeyMapManagerFieldName(UserKeymap $this$toKeyMapManagerFieldName) {
        String string;
        switch (KeymapSetter$WhenMappings.$EnumSwitchMapping$0[$this$toKeyMapManagerFieldName.ordinal()]) {
            case 1: {
                string = "X_WINDOW_KEYMAP";
                break;
            }
            case 2: {
                string = "MAC_OS_X_10_5_PLUS_KEYMAP";
                break;
            }
            case 3: {
                string = "GNOME_KEYMAP";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    public final void setKeymap(@NotNull UserKeymap keymap) {
        Intrinsics.checkNotNullParameter((Object)keymap, (String)"keymap");
        IdeaStateKt.invokeWhenIdeaIsInitialized$default("set keymap to match user's OS (" + keymap + ')', null, (Function1)new Function1<ClassLoader, Unit>(keymap){
            final /* synthetic */ UserKeymap $keymap;

            public final void invoke(@NotNull ClassLoader ideaClassLoader) {
                Intrinsics.checkNotNullParameter((Object)ideaClassLoader, (String)"ideaClassLoader");
                SwingUtilities.invokeLater(new Runnable(this, ideaClassLoader){
                    final /* synthetic */ setKeymap.1 this$0;
                    final /* synthetic */ ClassLoader $ideaClassLoader;

                    public final void run() {
                        Class<?> keymapManagerClass = Class.forName("com.intellij.openapi.keymap.KeymapManager", false, this.$ideaClassLoader);
                        Object object = keymapManagerClass.getDeclaredField(KeymapSetter.access$toKeyMapManagerFieldName(KeymapSetter.INSTANCE, this.this$0.$keymap)).get(null);
                        if (object == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                        }
                        String userKeymapName = (String)object;
                        Class<?> keymapManagerExClass = Class.forName("com.intellij.openapi.keymap.ex.KeymapManagerEx", false, this.$ideaClassLoader);
                        Object keymapManagerExInstance = keymapManagerExClass.getDeclaredMethod("getInstanceEx", new Class[0]).invoke(null, new Object[0]);
                        if (keymapManagerExInstance == null) {
                            Logger.DefaultImpls.error$default((Logger)KeymapSetter.access$getLogger$p(KeymapSetter.INSTANCE), null, (Function0)setKeymap.1.INSTANCE, (int)1, null);
                            return;
                        }
                        Object keymapInstance = keymapManagerClass.getDeclaredMethod("getKeymap", String.class).invoke(keymapManagerExInstance, userKeymapName);
                        if (keymapInstance == null) {
                            Logger.DefaultImpls.error$default((Logger)KeymapSetter.access$getLogger$p(KeymapSetter.INSTANCE), null, (Function0)((Function0)new Function0<String>(userKeymapName){
                                final /* synthetic */ String $userKeymapName;

                                @NotNull
                                public final String invoke() {
                                    return "getKeymap(" + this.$userKeymapName + ") == null - skipping setting keymap";
                                }
                                {
                                    this.$userKeymapName = string;
                                    super(0);
                                }
                            }), (int)1, null);
                            return;
                        }
                        Class<?> keymapClass = Class.forName("com.intellij.openapi.keymap.Keymap", false, this.$ideaClassLoader);
                        keymapManagerExClass.getDeclaredMethod("setActiveKeymap", keymapClass).invoke(keymapManagerExInstance, keymapInstance);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$ideaClassLoader = classLoader;
                    }
                });
            }
            {
                this.$keymap = userKeymap;
                super(1);
            }
        }, 2, null);
    }

    private KeymapSetter() {
    }

    static {
        KeymapSetter keymapSetter;
        INSTANCE = keymapSetter = new KeymapSetter();
        boolean $i$f$Logger = false;
        String string = Reflection.getOrCreateKotlinClass(KeymapSetter.class).getSimpleName();
        Intrinsics.checkNotNull((Object)string);
        logger = LoggerKt.Logger((String)string);
    }

    public static final /* synthetic */ String access$toKeyMapManagerFieldName(KeymapSetter $this, UserKeymap $this$access_u24toKeyMapManagerFieldName) {
        return $this.toKeyMapManagerFieldName($this$access_u24toKeyMapManagerFieldName);
    }

    public static final /* synthetic */ Logger access$getLogger$p(KeymapSetter $this) {
        KeymapSetter keymapSetter = $this;
        return logger;
    }
}

