/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.server.core.util;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty0;
import org.java_websocket.WebSocket;
import org.java_websocket.WebSocketImpl;
import org.java_websocket.WebSocketServerFactory;
import org.java_websocket.drafts.Draft;
import org.java_websocket.drafts.Draft_6455;
import org.java_websocket.enums.CloseHandshakeType;
import org.java_websocket.enums.HandshakeState;
import org.java_websocket.framing.Framedata;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.handshake.ClientHandshakeBuilder;
import org.java_websocket.handshake.HandshakeBuilder;
import org.java_websocket.handshake.Handshakedata;
import org.java_websocket.handshake.ServerHandshake;
import org.java_websocket.handshake.ServerHandshakeBuilder;
import org.java_websocket.server.WebSocketServer;
import org.java_websocket.util.Charsetfunctions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.projector.server.core.util.GetRequestResult;
import org.jetbrains.projector.server.core.util.HostAddressKt;
import org.jetbrains.projector.server.core.util.HttpWsServer;
import org.jetbrains.projector.server.core.util.HttpWsServer$wasStarted$2;
import org.jetbrains.projector.server.core.util.HttpWsServerKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000g\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006*\u0001\u000f\b&\u0018\u0000 .2\u00020\u0001:\u0002./B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J)\u0010\u0011\u001a\u00020\u00122!\u0010\u0013\u001a\u001d\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u00020\u00120\u0014J\u001e\u0010\u0019\u001a\u00020\u00122\b\u0010\u001a\u001a\u0004\u0018\u00010\u00152\n\u0010\u001b\u001a\u00060\u001cj\u0002`\u001dH&J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H&J\b\u0010\"\u001a\u00020\u0012H&J\u0010\u0010#\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u0015H&J\u0018\u0010$\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u00152\u0006\u0010%\u001a\u00020&H&J\u0018\u0010$\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u00152\u0006\u0010%\u001a\u00020!H&J\u0010\u0010'\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u0015H&J\u000e\u0010(\u001a\u00020\u00122\u0006\u0010)\u001a\u00020*J\u0006\u0010+\u001a\u00020\u0012J\u0012\u0010,\u001a\u00020\u00122\b\b\u0002\u0010-\u001a\u00020\u0003H\u0007R\u001b\u0010\b\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010\u00a8\u00060"}, d2={"Lorg/jetbrains/projector/server/core/util/HttpWsServer;", "", "port", "", "(I)V", "host", "Ljava/net/InetAddress;", "(Ljava/net/InetAddress;I)V", "wasStarted", "", "getWasStarted", "()Z", "wasStarted$delegate", "Lkotlin/reflect/KProperty0;", "webSocketServer", "org/jetbrains/projector/server/core/util/HttpWsServer$webSocketServer$1", "Lorg/jetbrains/projector/server/core/util/HttpWsServer$webSocketServer$1;", "forEachOpenedConnection", "", "action", "Lkotlin/Function1;", "Lorg/java_websocket/WebSocket;", "Lkotlin/ParameterName;", "name", "client", "onError", "connection", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onGetRequest", "Lorg/jetbrains/projector/server/core/util/GetRequestResult;", "path", "", "onStart", "onWsClose", "onWsMessage", "message", "Ljava/nio/ByteBuffer;", "onWsOpen", "setWebSocketFactory", "factory", "Lorg/java_websocket/WebSocketServerFactory;", "start", "stop", "timeout", "Companion", "HttpDraft", "projector-server-core"})
public abstract class HttpWsServer {
    private final webSocketServer.1 webSocketServer;
    @NotNull
    private final KProperty0 wasStarted$delegate;
    private static final String PATH_FIELD = "X-My-Path";
    private static final Companion.HTTP_CONNECTION_ATTACHMENT.1 HTTP_CONNECTION_ATTACHMENT;
    @NotNull
    private static final Companion Companion;

    public final boolean getWasStarted() {
        KProperty0 kProperty0 = this.wasStarted$delegate;
        HttpWsServer httpWsServer = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Boolean)kProperty0.get();
    }

    public final void start() {
        this.webSocketServer.start();
    }

    @JvmOverloads
    public final void stop(int timeout) {
        this.webSocketServer.stop(timeout);
    }

    public static /* synthetic */ void stop$default(HttpWsServer httpWsServer, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: stop");
        }
        if ((n2 & 1) != 0) {
            n = 0;
        }
        httpWsServer.stop(n);
    }

    @JvmOverloads
    public final void stop() {
        HttpWsServer.stop$default(this, 0, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void forEachOpenedConnection(@NotNull Function1<? super WebSocket, Unit> action) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Collection collection = this.webSocketServer.getConnections();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"webSocketServer.connections");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            WebSocket p1 = (WebSocket)element$iv$iv;
            boolean bl = false;
            if (!p1.isOpen()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            action.invoke(element$iv);
        }
    }

    public final void setWebSocketFactory(@NotNull WebSocketServerFactory factory) {
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        this.webSocketServer.setWebSocketFactory(factory);
    }

    public abstract void onStart();

    public abstract void onError(@Nullable WebSocket var1, @NotNull Exception var2);

    public abstract void onWsOpen(@NotNull WebSocket var1);

    public abstract void onWsClose(@NotNull WebSocket var1);

    public abstract void onWsMessage(@NotNull WebSocket var1, @NotNull String var2);

    public abstract void onWsMessage(@NotNull WebSocket var1, @NotNull ByteBuffer var2);

    @NotNull
    public abstract GetRequestResult onGetRequest(@NotNull String var1);

    public HttpWsServer(@NotNull InetAddress host, int port) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.webSocketServer = new WebSocketServer(this, host, port, new InetSocketAddress(host, port), CollectionsKt.listOf((Object[])new Draft[]{new HttpDraft(), (Draft)new Draft_6455()})){
            private volatile Boolean wasInitialized;
            private final ReentrantLock lock;
            private final Condition condition;
            final /* synthetic */ HttpWsServer this$0;
            final /* synthetic */ InetAddress $host;
            final /* synthetic */ int $port;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final boolean getWasStarted() {
                while (this.wasInitialized == null) {
                    Lock lock = this.lock;
                    boolean bl = false;
                    boolean bl2 = false;
                    lock.lock();
                    try {
                        boolean bl3 = false;
                        if (this.wasInitialized != null) {
                            Boolean bl4 = this.wasInitialized;
                            Intrinsics.checkNotNull((Object)bl4);
                            boolean bl5 = bl4;
                            return bl5;
                        }
                        this.condition.await();
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        lock.unlock();
                    }
                }
                Boolean bl = this.wasInitialized;
                Intrinsics.checkNotNull((Object)bl);
                return bl;
            }

            public void onOpen(@NotNull WebSocket conn, @NotNull ClientHandshake handshake) {
                block1: {
                    boolean bl;
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
                        Intrinsics.checkNotNullParameter((Object)handshake, (String)"handshake");
                        bl = HttpWsServerKt.access$isHttp$p(handshake);
                        if (!bl) break block0;
                        HttpWsServer.access$Companion();
                        conn.setAttachment((Object)HttpWsServer.access$getHTTP_CONNECTION_ATTACHMENT$cp());
                        conn.close();
                        break block1;
                    }
                    if (bl) break block1;
                    this.this$0.onWsOpen(conn);
                }
            }

            public void onClose(@NotNull WebSocket conn, int code2, @NotNull String reason, boolean remote) {
                Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
                Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
                Companion this_$iv = HttpWsServer.access$Companion();
                boolean $i$f$onlyForWs = false;
                if (conn.getAttachment() != HttpWsServer.access$getHTTP_CONNECTION_ATTACHMENT$cp()) {
                    boolean bl = false;
                    this.this$0.onWsClose(conn);
                }
            }

            public void onMessage(@NotNull WebSocket conn, @NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                Companion this_$iv = HttpWsServer.access$Companion();
                boolean $i$f$onlyForWs = false;
                if (conn.getAttachment() != HttpWsServer.access$getHTTP_CONNECTION_ATTACHMENT$cp()) {
                    boolean bl = false;
                    this.this$0.onWsMessage(conn, message);
                }
            }

            public void onMessage(@NotNull WebSocket conn, @NotNull ByteBuffer message) {
                Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                this.this$0.onWsMessage(conn, message);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onError(@Nullable WebSocket conn, @NotNull Exception ex) {
                Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
                this.this$0.onError(conn, ex);
                if (ex instanceof SocketException) {
                    Lock lock = this.lock;
                    boolean bl = false;
                    boolean bl2 = false;
                    lock.lock();
                    try {
                        boolean bl3 = false;
                        this.wasInitialized = false;
                        this.condition.signal();
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        lock.unlock();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onStart() {
                this.this$0.onStart();
                Lock lock = this.lock;
                boolean bl = false;
                boolean bl2 = false;
                lock.lock();
                try {
                    boolean bl3 = false;
                    this.wasInitialized = true;
                    this.condition.signal();
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    lock.unlock();
                }
            }
            {
                this.this$0 = this$0;
                this.$host = $captured_local_variable$1;
                this.$port = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4);
                this.lock = new ReentrantLock();
                this.condition = this.lock.newCondition();
                this.setReuseAddr(true);
                this.setTcpNoDelay(true);
            }
        };
        this.wasStarted$delegate = new HttpWsServer$wasStarted$2(this.webSocketServer);
    }

    public HttpWsServer(int port) {
        this(HostAddressKt.getWildcardHostAddress(), port);
    }

    static {
        Companion = new Companion(null);
        HTTP_CONNECTION_ATTACHMENT = new Object(){};
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\b\u0010\f\u001a\u00020\u0001H\u0016J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\u00182\u0006\u0010\u000b\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0014H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020!H\u0016J\u0018\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u000fH\u0016J\b\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u0012H\u0016\u00a8\u0006*"}, d2={"Lorg/jetbrains/projector/server/core/util/HttpWsServer$HttpDraft;", "Lorg/java_websocket/drafts/Draft;", "(Lorg/jetbrains/projector/server/core/util/HttpWsServer;)V", "acceptHandshakeAsClient", "", "request", "Lorg/java_websocket/handshake/ClientHandshake;", "response", "Lorg/java_websocket/handshake/ServerHandshake;", "acceptHandshakeAsServer", "Lorg/java_websocket/enums/HandshakeState;", "handshakedata", "copyInstance", "createBinaryFrame", "framedata", "Lorg/java_websocket/framing/Framedata;", "createFrames", "binary", "Ljava/nio/ByteBuffer;", "mask", "", "text", "", "createHandshake", "", "Lorg/java_websocket/handshake/Handshakedata;", "withcontent", "getCloseHandshakeType", "Lorg/java_websocket/enums/CloseHandshakeType;", "postProcessHandshakeRequestAsClient", "Lorg/java_websocket/handshake/ClientHandshakeBuilder;", "postProcessHandshakeResponseAsServer", "Lorg/java_websocket/handshake/HandshakeBuilder;", "Lorg/java_websocket/handshake/ServerHandshakeBuilder;", "processFrame", "webSocketImpl", "Lorg/java_websocket/WebSocketImpl;", "frame", "reset", "", "translateFrame", "buffer", "projector-server-core"})
    private final class HttpDraft
    extends Draft {
        @NotNull
        public HandshakeState acceptHandshakeAsServer(@NotNull ClientHandshake handshakedata) {
            HandshakeState handshakeState;
            Intrinsics.checkNotNullParameter((Object)handshakedata, (String)"handshakedata");
            boolean bl = HttpWsServerKt.access$isHttp$p(handshakedata);
            if (bl) {
                handshakeState = HandshakeState.MATCHED;
            } else if (!bl) {
                handshakeState = HandshakeState.NOT_MATCHED;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return handshakeState;
        }

        @NotNull
        public HandshakeBuilder postProcessHandshakeResponseAsServer(@NotNull ClientHandshake request, @NotNull ServerHandshakeBuilder response) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            Companion;
            response.put(HttpWsServer.PATH_FIELD, request.getResourceDescriptor());
            return (HandshakeBuilder)response;
        }

        @NotNull
        public List<ByteBuffer> createHandshake(@NotNull Handshakedata handshakedata, boolean withcontent) {
            Intrinsics.checkNotNullParameter((Object)handshakedata, (String)"handshakedata");
            Companion;
            String string = handshakedata.getFieldValue(HttpWsServer.PATH_FIELD);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"handshakedata.getFieldValue(PATH_FIELD)");
            GetRequestResult result = HttpWsServer.this.onGetRequest(string);
            byte[] header = Charsetfunctions.asciiBytes((String)("HTTP/1.0 " + result.getStatusCode() + ' ' + result.getStatusText() + "\r\n" + "Mime-Version: 1.0\r\n" + "Content-Type: " + result.getContentType() + "\r\n" + "Content-Length: " + result.getContent().length + "\r\n" + "Connection: close\r\n" + "\r\n"));
            ByteBuffer bytebuffer = ByteBuffer.allocate(result.getContent().length + header.length);
            bytebuffer.put(header);
            bytebuffer.put(result.getContent());
            bytebuffer.flip();
            return CollectionsKt.listOf((Object)bytebuffer);
        }

        @NotNull
        public CloseHandshakeType getCloseHandshakeType() {
            return CloseHandshakeType.NONE;
        }

        @NotNull
        public Draft copyInstance() {
            return this;
        }

        public void reset() {
        }

        @NotNull
        public Void translateFrame(@NotNull ByteBuffer buffer) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            Void void_ = Companion.failNoFrames();
            throw new KotlinNothingValueException();
        }

        @NotNull
        public Void processFrame(@NotNull WebSocketImpl webSocketImpl, @NotNull Framedata frame) {
            Intrinsics.checkNotNullParameter((Object)webSocketImpl, (String)"webSocketImpl");
            Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
            Void void_ = Companion.failNoFrames();
            throw new KotlinNothingValueException();
        }

        @NotNull
        public Void createBinaryFrame(@NotNull Framedata framedata) {
            Intrinsics.checkNotNullParameter((Object)framedata, (String)"framedata");
            Void void_ = Companion.failNoFrames();
            throw new KotlinNothingValueException();
        }

        @NotNull
        public Void createFrames(@NotNull ByteBuffer binary, boolean mask) {
            Intrinsics.checkNotNullParameter((Object)binary, (String)"binary");
            Void void_ = Companion.failNoFrames();
            throw new KotlinNothingValueException();
        }

        @NotNull
        public Void createFrames(@NotNull String text, boolean mask) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Void void_ = Companion.failNoFrames();
            throw new KotlinNothingValueException();
        }

        @NotNull
        public Void postProcessHandshakeRequestAsClient(@NotNull ClientHandshakeBuilder request) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Void void_ = Companion.failNoClient();
            throw new KotlinNothingValueException();
        }

        @NotNull
        public Void acceptHandshakeAsClient(@NotNull ClientHandshake request, @NotNull ServerHandshake response) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            Void void_ = Companion.failNoClient();
            throw new KotlinNothingValueException();
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0004\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0002J\b\u0010\n\u001a\u00020\tH\u0002J\u001f\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u0010H\u0082\bR\u0010\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/projector/server/core/util/HttpWsServer$Companion;", "", "()V", "HTTP_CONNECTION_ATTACHMENT", "org/jetbrains/projector/server/core/util/HttpWsServer$Companion$HTTP_CONNECTION_ATTACHMENT$1", "Lorg/jetbrains/projector/server/core/util/HttpWsServer$Companion$HTTP_CONNECTION_ATTACHMENT$1;", "PATH_FIELD", "", "failNoClient", "", "failNoFrames", "onlyForWs", "", "connection", "Lorg/java_websocket/WebSocket;", "block", "Lkotlin/Function0;", "projector-server-core"})
    private static final class Companion {
        private final Void failNoFrames() {
            throw (Throwable)new UnsupportedOperationException("This draft doesn't work with frames");
        }

        private final Void failNoClient() {
            throw (Throwable)new UnsupportedOperationException("This draft can't be used on a client");
        }

        private final void onlyForWs(WebSocket connection, Function0<Unit> block) {
            int $i$f$onlyForWs = 0;
            if (connection.getAttachment() != HTTP_CONNECTION_ATTACHMENT) {
                block.invoke();
            }
        }

        private Companion() {
        }

        public static final /* synthetic */ void access$onlyForWs(Companion $this, WebSocket connection, Function0 block) {
            $this.onlyForWs(connection, (Function0<Unit>)block);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

