/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.server.service;

import java.awt.Font;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.projector.awt.font.PFontManager;
import org.jetbrains.projector.awt.service.FontProvider;
import org.jetbrains.projector.server.service.ProjectorFontProvider;
import sun.font.Font2D;
import sun.font.PhysicalFont;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0011\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020\u00042\u0006\u0010D\u001a\u00020\u000f2\u0006\u0010E\u001a\u00020\u000fH\u0016J\u0010\u0010F\u001a\u00020G2\u0006\u0010C\u001a\u00020\u0004H\u0002J\u0018\u0010H\u001a\u00020 2\u0006\u0010I\u001a\u00020\u00042\u0006\u0010J\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R!\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00198BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001b\u0010\u001cR\u001b\u0010\u001f\u001a\u00020 8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010\u001e\u001a\u0004\b!\u0010\"R\u001b\u0010$\u001a\u00020 8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010\u001e\u001a\u0004\b%\u0010\"R\u0014\u0010'\u001a\u00020 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\"R\u001a\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00040*8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u001b\u0010-\u001a\u00020 8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b/\u0010\u001e\u001a\u0004\b.\u0010\"R\u001b\u00100\u001a\u00020 8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b2\u0010\u001e\u001a\u0004\b1\u0010\"R\u001a\u00103\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u0010\u001cR\u001b\u00105\u001a\u00020 8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b7\u0010\u001e\u001a\u0004\b6\u0010\"R\u001b\u00108\u001a\u00020 8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b:\u0010\u001e\u001a\u0004\b9\u0010\"R\u001b\u0010;\u001a\u00020 8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b=\u0010\u001e\u001a\u0004\b<\u0010\"R\u001b\u0010>\u001a\u00020 8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b@\u0010\u001e\u001a\u0004\b?\u0010\"\u00a8\u0006K"}, d2={"Lorg/jetbrains/projector/server/service/ProjectorFontProvider;", "Lorg/jetbrains/projector/awt/service/FontProvider;", "()V", "DEFAULT_BI_NAME", "", "DEFAULT_BI_PATH", "DEFAULT_B_NAME", "DEFAULT_B_PATH", "DEFAULT_FONT_NAME", "DEFAULT_FONT_PATH", "DEFAULT_RI_NAME", "DEFAULT_RI_PATH", "DEFAULT_R_NAME", "DEFAULT_R_PATH", "DEFAULT_SIZE", "", "MONO_BI_NAME", "MONO_BI_PATH", "MONO_B_NAME", "MONO_B_PATH", "MONO_RI_NAME", "MONO_RI_PATH", "MONO_R_NAME", "MONO_R_PATH", "allInstalledFonts", "", "Ljava/awt/Font;", "getAllInstalledFonts", "()Ljava/util/List;", "allInstalledFonts$delegate", "Lkotlin/Lazy;", "defaultBold", "Lsun/font/PhysicalFont;", "getDefaultBold", "()Lsun/font/PhysicalFont;", "defaultBold$delegate", "defaultBoldItalic", "getDefaultBoldItalic", "defaultBoldItalic$delegate", "defaultPhysicalFont", "getDefaultPhysicalFont", "defaultPlatformFont", "", "getDefaultPlatformFont", "()[Ljava/lang/String;", "defaultRegular", "getDefaultRegular", "defaultRegular$delegate", "defaultRegularItalic", "getDefaultRegularItalic", "defaultRegularItalic$delegate", "installedFonts", "getInstalledFonts", "monoBold", "getMonoBold", "monoBold$delegate", "monoBoldItalic", "getMonoBoldItalic", "monoBoldItalic$delegate", "monoRegular", "getMonoRegular", "monoRegular$delegate", "monoRegularItalic", "getMonoRegularItalic", "monoRegularItalic$delegate", "findFont2D", "Lsun/font/Font2D;", "name", "style", "fallback", "isMonospacedFont", "", "loadFont", "fontName", "fontPath", "projector-server"})
public final class ProjectorFontProvider
implements FontProvider {
    private static final Lazy defaultRegular$delegate;
    private static final Lazy defaultRegularItalic$delegate;
    private static final Lazy defaultBold$delegate;
    private static final Lazy defaultBoldItalic$delegate;
    private static final Lazy monoRegular$delegate;
    private static final Lazy monoRegularItalic$delegate;
    private static final Lazy monoBold$delegate;
    private static final Lazy monoBoldItalic$delegate;
    private static final Lazy allInstalledFonts$delegate;
    private static final String DEFAULT_R_NAME = "Default-R";
    private static final String DEFAULT_R_PATH = "/fonts/Default-R.ttf";
    private static final String DEFAULT_RI_NAME = "Default-RI";
    private static final String DEFAULT_RI_PATH = "/fonts/Default-RI.ttf";
    private static final String DEFAULT_B_NAME = "Default-B";
    private static final String DEFAULT_B_PATH = "/fonts/Default-B.ttf";
    private static final String DEFAULT_BI_NAME = "Default-BI";
    private static final String DEFAULT_BI_PATH = "/fonts/Default-BI.ttf";
    private static final String MONO_R_NAME = "Mono-R";
    private static final String MONO_R_PATH = "/fonts/Mono-R.ttf";
    private static final String MONO_RI_NAME = "Mono-RI";
    private static final String MONO_RI_PATH = "/fonts/Mono-RI.ttf";
    private static final String MONO_B_NAME = "Mono-B";
    private static final String MONO_B_PATH = "/fonts/Mono-B.ttf";
    private static final String MONO_BI_NAME = "Mono-BI";
    private static final String MONO_BI_PATH = "/fonts/Mono-BI.ttf";
    private static final String DEFAULT_FONT_NAME = "Default-R";
    private static final String DEFAULT_FONT_PATH = "/fonts/Default-R.ttf";
    private static final int DEFAULT_SIZE = 12;
    @NotNull
    public static final ProjectorFontProvider INSTANCE;

    private final PhysicalFont getDefaultRegular() {
        Lazy lazy = defaultRegular$delegate;
        ProjectorFontProvider projectorFontProvider = this;
        Object var3_3 = null;
        boolean bl = false;
        return (PhysicalFont)lazy.getValue();
    }

    private final PhysicalFont getDefaultRegularItalic() {
        Lazy lazy = defaultRegularItalic$delegate;
        ProjectorFontProvider projectorFontProvider = this;
        Object var3_3 = null;
        boolean bl = false;
        return (PhysicalFont)lazy.getValue();
    }

    private final PhysicalFont getDefaultBold() {
        Lazy lazy = defaultBold$delegate;
        ProjectorFontProvider projectorFontProvider = this;
        Object var3_3 = null;
        boolean bl = false;
        return (PhysicalFont)lazy.getValue();
    }

    private final PhysicalFont getDefaultBoldItalic() {
        Lazy lazy = defaultBoldItalic$delegate;
        ProjectorFontProvider projectorFontProvider = this;
        Object var3_3 = null;
        boolean bl = false;
        return (PhysicalFont)lazy.getValue();
    }

    private final PhysicalFont getMonoRegular() {
        Lazy lazy = monoRegular$delegate;
        ProjectorFontProvider projectorFontProvider = this;
        Object var3_3 = null;
        boolean bl = false;
        return (PhysicalFont)lazy.getValue();
    }

    private final PhysicalFont getMonoRegularItalic() {
        Lazy lazy = monoRegularItalic$delegate;
        ProjectorFontProvider projectorFontProvider = this;
        Object var3_3 = null;
        boolean bl = false;
        return (PhysicalFont)lazy.getValue();
    }

    private final PhysicalFont getMonoBold() {
        Lazy lazy = monoBold$delegate;
        ProjectorFontProvider projectorFontProvider = this;
        Object var3_3 = null;
        boolean bl = false;
        return (PhysicalFont)lazy.getValue();
    }

    private final PhysicalFont getMonoBoldItalic() {
        Lazy lazy = monoBoldItalic$delegate;
        ProjectorFontProvider projectorFontProvider = this;
        Object var3_3 = null;
        boolean bl = false;
        return (PhysicalFont)lazy.getValue();
    }

    private final List<Font> getAllInstalledFonts() {
        Lazy lazy = allInstalledFonts$delegate;
        ProjectorFontProvider projectorFontProvider = this;
        Object var3_3 = null;
        boolean bl = false;
        return (List)lazy.getValue();
    }

    @NotNull
    public List<Font> getInstalledFonts() {
        return this.getAllInstalledFonts();
    }

    @NotNull
    public PhysicalFont getDefaultPhysicalFont() {
        return this.getDefaultRegular();
    }

    @NotNull
    public String[] getDefaultPlatformFont() {
        return new String[]{"Default-R", "/fonts/Default-R.ttf"};
    }

    @NotNull
    public Font2D findFont2D(@NotNull String name, int style, int fallback) {
        Font2D font2D;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (this.isMonospacedFont(name)) {
            Font2D font2D2;
            switch (style) {
                case 3: {
                    font2D2 = this.getMonoBoldItalic();
                    break;
                }
                case 1: {
                    font2D2 = this.getMonoBold();
                    break;
                }
                case 2: {
                    font2D2 = this.getMonoRegularItalic();
                    break;
                }
                default: {
                    font2D2 = this.getMonoRegular();
                }
            }
            return font2D2;
        }
        switch (style) {
            case 3: {
                font2D = this.getDefaultBoldItalic();
                break;
            }
            case 1: {
                font2D = this.getDefaultBold();
                break;
            }
            case 2: {
                font2D = this.getDefaultRegularItalic();
                break;
            }
            default: {
                font2D = this.getDefaultRegular();
            }
        }
        return font2D;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isMonospacedFont(String name) {
        String string = name;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        if (StringsKt.contains$default((CharSequence)string3, (CharSequence)"mono", (boolean)false, (int)2, null)) return true;
        string = name;
        bl = false;
        String string4 = string;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toLowerCase()");
        if (!Intrinsics.areEqual((Object)string5, (Object)"menlo")) return false;
        return true;
    }

    private final PhysicalFont loadFont(String fontName, String fontPath) {
        File file = File.createTempFile(fontName, ".ttf");
        boolean bl = false;
        boolean bl2 = false;
        File $this$apply = file;
        boolean bl3 = false;
        $this$apply.deleteOnExit();
        File tempFile = file;
        InputStream link = PFontManager.class.getResourceAsStream(fontPath);
        File file2 = tempFile;
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"tempFile");
        Files.copy(link, file2.getAbsoluteFile().toPath(), StandardCopyOption.REPLACE_EXISTING);
        Object[] objectArray = PFontManager.INSTANCE.createFont2D(tempFile, 0, false, false, null);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"PFontManager.createFont2\u2026FONT, false, false, null)");
        Object object = ArraysKt.single((Object[])objectArray);
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type sun.font.PhysicalFont");
        }
        return (PhysicalFont)object;
    }

    private ProjectorFontProvider() {
    }

    static {
        ProjectorFontProvider projectorFontProvider;
        INSTANCE = projectorFontProvider = new ProjectorFontProvider();
        defaultRegular$delegate = LazyKt.lazy((Function0)defaultRegular.2.INSTANCE);
        defaultRegularItalic$delegate = LazyKt.lazy((Function0)defaultRegularItalic.2.INSTANCE);
        defaultBold$delegate = LazyKt.lazy((Function0)defaultBold.2.INSTANCE);
        defaultBoldItalic$delegate = LazyKt.lazy((Function0)defaultBoldItalic.2.INSTANCE);
        monoRegular$delegate = LazyKt.lazy((Function0)monoRegular.2.INSTANCE);
        monoRegularItalic$delegate = LazyKt.lazy((Function0)monoRegularItalic.2.INSTANCE);
        monoBold$delegate = LazyKt.lazy((Function0)monoBold.2.INSTANCE);
        monoBoldItalic$delegate = LazyKt.lazy((Function0)monoBoldItalic.2.INSTANCE);
        allInstalledFonts$delegate = LazyKt.lazy((Function0)allInstalledFonts.2.INSTANCE);
    }

    public static final /* synthetic */ PhysicalFont access$loadFont(ProjectorFontProvider $this, String fontName, String fontPath) {
        return $this.loadFont(fontName, fontPath);
    }

    public static final /* synthetic */ PhysicalFont access$getDefaultRegular$p(ProjectorFontProvider $this) {
        return $this.getDefaultRegular();
    }

    public static final /* synthetic */ PhysicalFont access$getDefaultRegularItalic$p(ProjectorFontProvider $this) {
        return $this.getDefaultRegularItalic();
    }

    public static final /* synthetic */ PhysicalFont access$getDefaultBold$p(ProjectorFontProvider $this) {
        return $this.getDefaultBold();
    }

    public static final /* synthetic */ PhysicalFont access$getDefaultBoldItalic$p(ProjectorFontProvider $this) {
        return $this.getDefaultBoldItalic();
    }

    public static final /* synthetic */ PhysicalFont access$getMonoRegular$p(ProjectorFontProvider $this) {
        return $this.getMonoRegular();
    }

    public static final /* synthetic */ PhysicalFont access$getMonoRegularItalic$p(ProjectorFontProvider $this) {
        return $this.getMonoRegularItalic();
    }

    public static final /* synthetic */ PhysicalFont access$getMonoBold$p(ProjectorFontProvider $this) {
        return $this.getMonoBold();
    }

    public static final /* synthetic */ PhysicalFont access$getMonoBoldItalic$p(ProjectorFontProvider $this) {
        return $this.getMonoBoldItalic();
    }
}

