/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.awt.image;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.Map;
import javax.swing.UIManager;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.projector.awt.PWindow;
import org.jetbrains.projector.awt.data.AwtImageInfo;
import org.jetbrains.projector.awt.data.AwtPaintType;
import org.jetbrains.projector.awt.font.PFontManager;
import org.jetbrains.projector.awt.image.AffineTransformUrilKt;
import org.jetbrains.projector.awt.image.PGraphics2D;
import org.jetbrains.projector.awt.image.PGraphicsDevice;
import org.jetbrains.projector.awt.image.PVolatileImage;
import org.jetbrains.projector.awt.image.ShapeUtilKt;
import org.jetbrains.projector.awt.service.Defaults;
import org.jetbrains.projector.awt.service.DrawEventQueue;
import org.jetbrains.projector.awt.service.ImageCacher;
import org.jetbrains.projector.util.logging.Logger;
import org.jetbrains.projector.util.logging.LoggerKt;
import sun.font.FontDesignMetrics;
import sun.java2d.NullSurfaceData;
import sun.java2d.SunGraphics2D;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u009c\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010$\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b%\u0018\u0000 \u00bb\u00012\u00020\u0001:\u0002\u00bb\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0002\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB?\b\u0012\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u000e\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\u0002\u0010\u0014BY\b\u0002\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u0012\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u000e\u0012\u0006\u0010\u001b\u001a\u00020\u001c\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u001dJ0\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020)2\u0006\u0010,\u001a\u00020)H\u0002J\u0018\u0010-\u001a\u00020%2\u000e\u0010\u0017\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030.H\u0016J(\u0010/\u001a\u00020%2\u0006\u0010(\u001a\u0002002\u0006\u0010*\u001a\u0002002\u0006\u0010+\u001a\u0002002\u0006\u0010,\u001a\u000200H\u0016J\u0012\u00101\u001a\u00020%2\b\u00102\u001a\u0004\u0018\u00010\u001aH\u0016J(\u00103\u001a\u00020%2\u0006\u0010(\u001a\u0002002\u0006\u0010*\u001a\u0002002\u0006\u00104\u001a\u0002002\u0006\u00105\u001a\u000200H\u0016J8\u00106\u001a\u00020%2\u0006\u0010(\u001a\u0002002\u0006\u0010*\u001a\u0002002\u0006\u0010+\u001a\u0002002\u0006\u0010,\u001a\u0002002\u0006\u00107\u001a\u0002002\u0006\u00108\u001a\u000200H\u0016J\b\u00109\u001a\u00020:H\u0016J\b\u0010;\u001a\u00020%H\u0016J\u0010\u0010<\u001a\u00020%2\u0006\u00102\u001a\u00020\u001aH\u0016J8\u0010=\u001a\u00020%2\u0006\u0010(\u001a\u0002002\u0006\u0010*\u001a\u0002002\u0006\u0010+\u001a\u0002002\u0006\u0010,\u001a\u0002002\u0006\u0010>\u001a\u0002002\u0006\u0010?\u001a\u000200H\u0016J \u0010@\u001a\u00020%2\u0006\u0010A\u001a\u00020B2\u0006\u0010(\u001a\u00020C2\u0006\u0010*\u001a\u00020CH\u0016J$\u0010D\u001a\u00020E2\b\u0010F\u001a\u0004\u0018\u00010G2\u0006\u0010H\u001a\u00020\f2\b\u0010I\u001a\u0004\u0018\u00010JH\u0016J6\u0010D\u001a\u00020E2\b\u0010F\u001a\u0004\u0018\u00010G2\u0006\u0010(\u001a\u0002002\u0006\u0010*\u001a\u0002002\b\u0010K\u001a\u0004\u0018\u00010\u000e2\b\u0010L\u001a\u0004\u0018\u00010JH\u0016J,\u0010D\u001a\u00020E2\b\u0010F\u001a\u0004\u0018\u00010G2\u0006\u0010(\u001a\u0002002\u0006\u0010*\u001a\u0002002\b\u0010L\u001a\u0004\u0018\u00010JH\u0016JF\u0010D\u001a\u00020E2\b\u0010F\u001a\u0004\u0018\u00010G2\u0006\u0010(\u001a\u0002002\u0006\u0010*\u001a\u0002002\u0006\u0010+\u001a\u0002002\u0006\u0010,\u001a\u0002002\b\u0010K\u001a\u0004\u0018\u00010\u000e2\b\u0010L\u001a\u0004\u0018\u00010JH\u0016J<\u0010D\u001a\u00020E2\b\u0010F\u001a\u0004\u0018\u00010G2\u0006\u0010(\u001a\u0002002\u0006\u0010*\u001a\u0002002\u0006\u0010+\u001a\u0002002\u0006\u0010,\u001a\u0002002\b\u0010L\u001a\u0004\u0018\u00010JH\u0016Jf\u0010D\u001a\u00020E2\b\u0010F\u001a\u0004\u0018\u00010G2\u0006\u0010M\u001a\u0002002\u0006\u0010N\u001a\u0002002\u0006\u0010O\u001a\u0002002\u0006\u0010P\u001a\u0002002\u0006\u0010Q\u001a\u0002002\u0006\u0010R\u001a\u0002002\u0006\u0010S\u001a\u0002002\u0006\u0010T\u001a\u0002002\b\u0010K\u001a\u0004\u0018\u00010\u000e2\b\u0010L\u001a\u0004\u0018\u00010JH\u0016J\\\u0010D\u001a\u00020E2\b\u0010F\u001a\u0004\u0018\u00010G2\u0006\u0010M\u001a\u0002002\u0006\u0010N\u001a\u0002002\u0006\u0010O\u001a\u0002002\u0006\u0010P\u001a\u0002002\u0006\u0010Q\u001a\u0002002\u0006\u0010R\u001a\u0002002\u0006\u0010S\u001a\u0002002\u0006\u0010T\u001a\u0002002\b\u0010L\u001a\u0004\u0018\u00010JH\u0016J*\u0010D\u001a\u00020%2\b\u0010F\u001a\u0004\u0018\u00010U2\u0006\u0010V\u001a\u00020W2\u0006\u0010(\u001a\u0002002\u0006\u0010*\u001a\u000200H\u0016J(\u0010X\u001a\u00020%2\u0006\u0010Y\u001a\u0002002\u0006\u0010Z\u001a\u0002002\u0006\u0010[\u001a\u0002002\u0006\u0010\\\u001a\u000200H\u0016J(\u0010]\u001a\u00020%2\u0006\u0010(\u001a\u0002002\u0006\u0010*\u001a\u0002002\u0006\u0010+\u001a\u0002002\u0006\u0010,\u001a\u000200H\u0016J \u0010^\u001a\u00020%2\u0006\u0010_\u001a\u00020`2\u0006\u0010a\u001a\u00020`2\u0006\u0010b\u001a\u000200H\u0016J \u0010c\u001a\u00020%2\u0006\u0010_\u001a\u00020`2\u0006\u0010a\u001a\u00020`2\u0006\u0010b\u001a\u000200H\u0016J\u0018\u0010d\u001a\u00020%2\u0006\u0010F\u001a\u00020e2\u0006\u0010H\u001a\u00020\fH\u0016J\u0018\u0010f\u001a\u00020%2\u0006\u0010F\u001a\u00020g2\u0006\u0010H\u001a\u00020\fH\u0016J8\u0010h\u001a\u00020%2\u0006\u0010(\u001a\u0002002\u0006\u0010*\u001a\u0002002\u0006\u0010+\u001a\u0002002\u0006\u0010,\u001a\u0002002\u0006\u0010i\u001a\u0002002\u0006\u0010j\u001a\u000200H\u0016J \u0010k\u001a\u00020%2\u0006\u0010l\u001a\u00020m2\u0006\u0010(\u001a\u00020C2\u0006\u0010*\u001a\u00020CH\u0016J \u0010k\u001a\u00020%2\u0006\u0010l\u001a\u00020m2\u0006\u0010(\u001a\u0002002\u0006\u0010*\u001a\u000200H\u0016J \u0010k\u001a\u00020%2\u0006\u0010n\u001a\u00020o2\u0006\u0010(\u001a\u00020C2\u0006\u0010*\u001a\u00020CH\u0016J \u0010k\u001a\u00020%2\u0006\u0010n\u001a\u00020o2\u0006\u0010(\u001a\u0002002\u0006\u0010*\u001a\u000200H\u0016J\"\u0010p\u001a\u00020E2\b\u0010F\u001a\u0004\u0018\u00010G2\u0006\u0010q\u001a\u00020r2\u0006\u0010s\u001a\u00020oH\u0002J\u0010\u0010t\u001a\u00020%2\u0006\u00102\u001a\u00020\u001aH\u0016J8\u0010u\u001a\u00020%2\u0006\u0010(\u001a\u0002002\u0006\u0010*\u001a\u0002002\u0006\u0010+\u001a\u0002002\u0006\u0010,\u001a\u0002002\u0006\u0010>\u001a\u0002002\u0006\u0010?\u001a\u000200H\u0016J(\u0010v\u001a\u00020%2\u0006\u0010(\u001a\u0002002\u0006\u0010*\u001a\u0002002\u0006\u0010+\u001a\u0002002\u0006\u0010,\u001a\u000200H\u0016J \u0010w\u001a\u00020%2\u0006\u0010_\u001a\u00020`2\u0006\u0010a\u001a\u00020`2\u0006\u0010b\u001a\u000200H\u0016J(\u0010x\u001a\u00020%2\u0006\u0010(\u001a\u0002002\u0006\u0010*\u001a\u0002002\u0006\u0010+\u001a\u0002002\u0006\u0010,\u001a\u000200H\u0016J8\u0010y\u001a\u00020%2\u0006\u0010(\u001a\u0002002\u0006\u0010*\u001a\u0002002\u0006\u0010+\u001a\u0002002\u0006\u0010,\u001a\u0002002\u0006\u0010i\u001a\u0002002\u0006\u0010j\u001a\u000200H\u0016J\b\u0010z\u001a\u00020\u000eH\u0016J\n\u0010{\u001a\u0004\u0018\u00010\u001aH\u0016J\n\u0010|\u001a\u0004\u0018\u00010}H\u0016J\b\u0010~\u001a\u00020\u000eH\u0016J\b\u0010\u007f\u001a\u00020\u0016H\u0016J\n\u0010\u0080\u0001\u001a\u00030\u0081\u0001H\u0016J\t\u0010\u0082\u0001\u001a\u00020\u0013H\u0016J\n\u0010\u0083\u0001\u001a\u00030\u0084\u0001H\u0016J\u0013\u0010\u0083\u0001\u001a\u00030\u0084\u00012\u0007\u0010\u0085\u0001\u001a\u00020\u0013H\u0016J\t\u0010\u0086\u0001\u001a\u00020\u001fH\u0016J\t\u0010\u0087\u0001\u001a\u00020\u0010H\u0016J\u0016\u0010\u0088\u0001\u001a\u0005\u0018\u00010\u0089\u00012\b\u0010\u008a\u0001\u001a\u00030\u008b\u0001H\u0016J\t\u0010\u008c\u0001\u001a\u00020\u0018H\u0016J\t\u0010\u008d\u0001\u001a\u00020\u001cH\u0016J\t\u0010\u008e\u0001\u001a\u00020\fH\u0016J#\u0010\u008f\u0001\u001a\u00020E2\u0007\u0010\u0090\u0001\u001a\u00020}2\u0006\u00102\u001a\u00020\u001a2\u0007\u0010\u0091\u0001\u001a\u00020EH\u0016JA\u0010\u0092\u0001\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u0002002\u0006\u0010*\u001a\u0002002\u0006\u0010+\u001a\u0002002\u0006\u0010,\u001a\u0002002\u0006\u0010>\u001a\u0002002\u0006\u0010?\u001a\u000200H\u0002J)\u0010\u0093\u0001\u001a\u00020%2\u001d\b\u0004\u0010\u0094\u0001\u001a\u0016\u0012\u0005\u0012\u00030\u0096\u0001\u0012\u0004\u0012\u00020%0\u0095\u0001\u00a2\u0006\u0003\b\u0097\u0001H\u0082\bJ1\u0010\u0098\u0001\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u0002002\u0006\u0010*\u001a\u0002002\u0006\u0010+\u001a\u0002002\u0006\u0010,\u001a\u000200H\u0002J)\u0010\u0099\u0001\u001a\u00020%2\u001d\b\u0004\u0010\u0094\u0001\u001a\u0016\u0012\u0005\u0012\u00030\u0096\u0001\u0012\u0004\u0012\u00020%0\u0095\u0001\u00a2\u0006\u0003\b\u0097\u0001H\u0082\bJ)\u0010\u009a\u0001\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010_\u001a\u00020`2\u0006\u0010a\u001a\u00020`2\u0006\u0010b\u001a\u000200H\u0002JA\u0010\u009b\u0001\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u0002002\u0006\u0010*\u001a\u0002002\u0006\u0010+\u001a\u0002002\u0006\u0010,\u001a\u0002002\u0006\u0010i\u001a\u0002002\u0006\u0010j\u001a\u000200H\u0002J\u001a\u0010\u009c\u0001\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0007\u0010\u009d\u0001\u001a\u00020\u001aH\u0002J)\u0010\u009c\u0001\u001a\u00020%2\u001d\b\u0004\u0010\u0094\u0001\u001a\u0016\u0012\u0005\u0012\u00030\u0096\u0001\u0012\u0004\u0012\u00020%0\u0095\u0001\u00a2\u0006\u0003\b\u0097\u0001H\u0082\bJ!\u0010\u009e\u0001\u001a\u00020%2\u0006\u0010n\u001a\u00020o2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)H\u0002J\u0012\u0010\u009f\u0001\u001a\u00020%2\u0007\u0010\u00a0\u0001\u001a\u00020)H\u0016J\"\u0010\u009f\u0001\u001a\u00020%2\u0007\u0010\u00a1\u0001\u001a\u00020)2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)H\u0016J\u001b\u0010\u00a2\u0001\u001a\u00020%2\u0007\u0010\u00a3\u0001\u001a\u00020)2\u0007\u0010\u00a4\u0001\u001a\u00020)H\u0016J\u0014\u0010\u00a5\u0001\u001a\u00020%2\t\u0010\u00a6\u0001\u001a\u0004\u0018\u00010\u000eH\u0016J\u0013\u0010\u00a7\u0001\u001a\u00020%2\b\u00102\u001a\u0004\u0018\u00010\u001aH\u0016J)\u0010\u00a7\u0001\u001a\u00020%2\u0006\u0010(\u001a\u0002002\u0006\u0010*\u001a\u0002002\u0006\u00104\u001a\u0002002\u0006\u00105\u001a\u000200H\u0016J\u0014\u0010\u00a8\u0001\u001a\u00020%2\t\u0010\u00a6\u0001\u001a\u0004\u0018\u00010\u000eH\u0016J\u0012\u0010\u00a9\u0001\u001a\u00020%2\u0007\u0010\u00aa\u0001\u001a\u00020\u0016H\u0016J\u0013\u0010\u00ab\u0001\u001a\u00020%2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0013\u0010\u00ac\u0001\u001a\u00020%2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\t\u0010\u00ad\u0001\u001a\u00020%H\u0016J!\u0010\u00ae\u0001\u001a\u00020%2\n\u0010\u008a\u0001\u001a\u0005\u0018\u00010\u008b\u00012\n\u0010\u00af\u0001\u001a\u0005\u0018\u00010\u0089\u0001H\u0016J\u0019\u0010\u00b0\u0001\u001a\u00020%2\u000e\u0010\u0017\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030.H\u0016J\u0011\u0010\u00b1\u0001\u001a\u00020%2\u0006\u00102\u001a\u00020\u001cH\u0016J\u0012\u0010\u00b2\u0001\u001a\u00020%2\u0007\u0010\u00b3\u0001\u001a\u00020\fH\u0016J\u0012\u0010\u00b4\u0001\u001a\u00020%2\u0007\u0010\u00a6\u0001\u001a\u00020\u000eH\u0016J\u001b\u0010\u00b5\u0001\u001a\u00020%2\u0007\u0010\u00b6\u0001\u001a\u00020)2\u0007\u0010\u00b7\u0001\u001a\u00020)H\u0016J\u0011\u0010\u000b\u001a\u00020%2\u0007\u0010\u00b8\u0001\u001a\u00020\fH\u0016J\u0019\u0010\u00b9\u0001\u001a\u00020%2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)H\u0016J\u0019\u0010\u00b9\u0001\u001a\u00020%2\u0006\u0010(\u001a\u0002002\u0006\u0010*\u001a\u000200H\u0016J\r\u0010\u00ba\u0001\u001a\u00020\u001a*\u00020\u001aH\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001e\u001a\u00020\u001f8BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00bc\u0001"}, d2={"Lorg/jetbrains/projector/awt/image/PGraphics2D;", "Ljava/awt/Graphics2D;", "target", "Lorg/jetbrains/projector/awt/image/PVolatileImage$Descriptor;", "(Lorg/jetbrains/projector/awt/image/PVolatileImage$Descriptor;)V", "component", "Ljava/awt/Component;", "Lorg/jetbrains/projector/awt/PWindow$Descriptor;", "(Ljava/awt/Component;Lorg/jetbrains/projector/awt/PWindow$Descriptor;)V", "drawEventQueue", "Lorg/jetbrains/projector/awt/service/DrawEventQueue;", "transform", "Ljava/awt/geom/AffineTransform;", "backgroundColor", "Ljava/awt/Color;", "paint", "Ljava/awt/Paint;", "foregroundColor", "font", "Ljava/awt/Font;", "(Lorg/jetbrains/projector/awt/service/DrawEventQueue;Ljava/awt/geom/AffineTransform;Ljava/awt/Color;Ljava/awt/Paint;Ljava/awt/Color;Ljava/awt/Font;)V", "backingComposite", "Ljava/awt/Composite;", "hints", "Ljava/awt/RenderingHints;", "identitySpaceClip", "Ljava/awt/Shape;", "stroke", "Ljava/awt/Stroke;", "(Lorg/jetbrains/projector/awt/service/DrawEventQueue;Ljava/awt/Composite;Ljava/awt/RenderingHints;Ljava/awt/Shape;Ljava/awt/geom/AffineTransform;Ljava/awt/Color;Ljava/awt/Paint;Ljava/awt/Color;Ljava/awt/Stroke;Ljava/awt/Font;)V", "backingFontRenderContext", "Ljava/awt/font/FontRenderContext;", "getBackingFontRenderContext", "()Ljava/awt/font/FontRenderContext;", "getDrawEventQueue", "()Lorg/jetbrains/projector/awt/service/DrawEventQueue;", "addPaintRectCommand", "", "paintType", "Lorg/jetbrains/projector/awt/data/AwtPaintType;", "x", "", "y", "width", "height", "addRenderingHints", "", "clearRect", "", "clip", "s", "clipRect", "w", "h", "copyArea", "dx", "dy", "create", "Ljava/awt/Graphics;", "dispose", "draw", "drawArc", "startAngle", "arcAngle", "drawGlyphVector", "g", "Ljava/awt/font/GlyphVector;", "", "drawImage", "", "img", "Ljava/awt/Image;", "xform", "obs", "Ljava/awt/image/ImageObserver;", "bgcolor", "observer", "dx1", "dy1", "dx2", "dy2", "sx1", "sy1", "sx2", "sy2", "Ljava/awt/image/BufferedImage;", "op", "Ljava/awt/image/BufferedImageOp;", "drawLine", "x1", "y1", "x2", "y2", "drawOval", "drawPolygon", "xPoints", "", "yPoints", "nPoints", "drawPolyline", "drawRenderableImage", "Ljava/awt/image/renderable/RenderableImage;", "drawRenderedImage", "Ljava/awt/image/RenderedImage;", "drawRoundRect", "arcWidth", "arcHeight", "drawString", "iterator", "Ljava/text/AttributedCharacterIterator;", "str", "", "extractImage", "awtImageInfo", "Lorg/jetbrains/projector/awt/data/AwtImageInfo;", "methodName", "fill", "fillArc", "fillOval", "fillPolygon", "fillRect", "fillRoundRect", "getBackground", "getClip", "getClipBounds", "Ljava/awt/Rectangle;", "getColor", "getComposite", "getDeviceConfiguration", "Ljava/awt/GraphicsConfiguration;", "getFont", "getFontMetrics", "Ljava/awt/FontMetrics;", "newFont", "getFontRenderContext", "getPaint", "getRenderingHint", "", "hintKey", "Ljava/awt/RenderingHints$Key;", "getRenderingHints", "getStroke", "getTransform", "hit", "rect", "onStroke", "paintArc", "paintArea", "command", "Lkotlin/Function1;", "Lorg/jetbrains/projector/awt/service/DrawEventQueue$CommandBuilder;", "Lkotlin/ExtensionFunctionType;", "paintOval", "paintPlain", "paintPolygon", "paintRoundRect", "paintShape", "shape", "paintString", "rotate", "radians", "theta", "scale", "sx", "sy", "setBackground", "color", "setClip", "setColor", "setComposite", "comp", "setFont", "setPaint", "setPaintMode", "setRenderingHint", "hintValue", "setRenderingHints", "setStroke", "setTransform", "tx", "setXORMode", "shear", "shx", "shy", "Tx", "translate", "untransformShape", "Companion", "projector-awt"})
public final class PGraphics2D
extends Graphics2D {
    private FontRenderContext backingFontRenderContext;
    @NotNull
    private final DrawEventQueue drawEventQueue;
    private Composite backingComposite;
    private final RenderingHints hints;
    private Shape identitySpaceClip;
    private final AffineTransform transform;
    private Color backgroundColor;
    private Paint paint;
    private Color foregroundColor;
    private Stroke stroke;
    private Font font;
    private static final Logger logger;
    private static final RenderingHints defaultRenderingHints;
    @Nullable
    private static final Object defaultAa;
    @NotNull
    public static final Companion Companion;

    private final FontRenderContext getBackingFontRenderContext() {
        AffineTransform currentTransform = PGraphics2D.Companion.getWithoutTranslation(this.transform);
        Object currentAa = PGraphics2D.Companion.extractTextAntiAliasingHint(this.hints);
        Object currentFm = PGraphics2D.Companion.extractFractionalMetricsHint(this.hints);
        if (Intrinsics.areEqual((Object)this.backingFontRenderContext.getTransform(), (Object)currentTransform) ^ true || Intrinsics.areEqual((Object)this.backingFontRenderContext.getAntiAliasingHint(), (Object)currentAa) ^ true || Intrinsics.areEqual((Object)this.backingFontRenderContext.getFractionalMetricsHint(), (Object)currentFm) ^ true) {
            this.backingFontRenderContext = new FontRenderContext(currentTransform, currentAa, currentFm);
        }
        return this.backingFontRenderContext;
    }

    private final void paintPlain(Function1<? super DrawEventQueue.CommandBuilder, Unit> command) {
        int $i$f$paintPlain = 0;
        command.invoke((Object)this.getDrawEventQueue().buildCommand());
    }

    private final void paintShape(Function1<? super DrawEventQueue.CommandBuilder, Unit> command) {
        int $i$f$paintShape = 0;
        command.invoke((Object)this.getDrawEventQueue().buildCommand().setClip(this.identitySpaceClip).setTransform(AffineTransformUrilKt.toList(this.transform)).setStroke(this.stroke).setPaint(this.paint).setComposite(this.backingComposite));
    }

    private final void paintArea(Function1<? super DrawEventQueue.CommandBuilder, Unit> command) {
        int $i$f$paintArea = 0;
        command.invoke((Object)this.getDrawEventQueue().buildCommand().setClip(this.identitySpaceClip).setTransform(AffineTransformUrilKt.toList(this.transform)).setComposite(this.backingComposite));
    }

    private final void paintString(String str, double x, double y) {
        if (StringsKt.isBlank((CharSequence)str)) {
            return;
        }
        FontDesignMetrics metrics = FontDesignMetrics.getMetrics(this.font, this.getBackingFontRenderContext());
        int desiredWidth = metrics.stringWidth(str);
        this.drawEventQueue.buildCommand().setClip(this.identitySpaceClip).setTransform(AffineTransformUrilKt.toList(this.transform)).setFont(this.font).setPaint(this.paint).setComposite(this.backingComposite).drawString(str, x, y, desiredWidth);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Graphics create() {
        void $this$apply;
        RenderingHints renderingHints = PGraphics2D.Companion.makeHints(null);
        boolean bl = false;
        boolean bl2 = false;
        RenderingHints renderingHints2 = renderingHints;
        Composite composite = this.backingComposite;
        DrawEventQueue drawEventQueue = this.drawEventQueue;
        boolean bl3 = false;
        $this$apply.add(this.hints);
        Unit unit = Unit.INSTANCE;
        Shape shape = this.identitySpaceClip;
        Font font = this.font;
        Stroke stroke = this.stroke;
        Color color = this.foregroundColor;
        Paint paint = this.paint;
        Color color2 = this.backgroundColor;
        AffineTransform affineTransform = new AffineTransform(this.transform);
        Shape shape2 = shape != null ? ShapeUtilKt.copy(shape) : null;
        RenderingHints renderingHints3 = renderingHints;
        Composite composite2 = composite;
        DrawEventQueue drawEventQueue2 = drawEventQueue;
        return new PGraphics2D(drawEventQueue2, composite2, renderingHints3, shape2, affineTransform, color2, paint, color, stroke, font);
    }

    @Override
    public void draw(@NotNull Shape s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        this.paintShape(AwtPaintType.DRAW, s);
    }

    @Override
    public void drawRenderedImage(@NotNull RenderedImage img, @NotNull AffineTransform xform) {
        Intrinsics.checkNotNullParameter((Object)img, (String)"img");
        Intrinsics.checkNotNullParameter((Object)xform, (String)"xform");
        PGraphics2D this_$iv = this;
        boolean $i$f$paintPlain = false;
        DrawEventQueue.CommandBuilder $this$paintPlain = this_$iv.getDrawEventQueue().buildCommand();
        boolean bl = false;
        $this$paintPlain.drawRenderedImage();
    }

    @Override
    public void drawRenderableImage(@NotNull RenderableImage img, @NotNull AffineTransform xform) {
        Intrinsics.checkNotNullParameter((Object)img, (String)"img");
        Intrinsics.checkNotNullParameter((Object)xform, (String)"xform");
        PGraphics2D this_$iv = this;
        boolean $i$f$paintPlain = false;
        DrawEventQueue.CommandBuilder $this$paintPlain = this_$iv.getDrawEventQueue().buildCommand();
        boolean bl = false;
        $this$paintPlain.drawRenderableImage();
    }

    @Override
    public void drawString(@NotNull String str, int x, int y) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        this.paintString(str, x, y);
    }

    @Override
    public void drawString(@NotNull String str, float x, float y) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        this.paintString(str, x, y);
    }

    @Override
    public void drawString(@NotNull AttributedCharacterIterator iterator, int x, int y) {
        Intrinsics.checkNotNullParameter((Object)iterator, (String)"iterator");
        this.drawString(iterator, (float)x, (float)y);
    }

    @Override
    public void drawString(@NotNull AttributedCharacterIterator iterator, float x, float y) {
        Intrinsics.checkNotNullParameter((Object)iterator, (String)"iterator");
        if (iterator.getBeginIndex() != iterator.getEndIndex()) {
            TextLayout tl = new TextLayout(iterator, this.getBackingFontRenderContext());
            tl.draw(this, x, y);
        }
    }

    @Override
    public void drawGlyphVector(@NotNull GlyphVector g, float x, float y) {
        Shape shape;
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Shape shape2 = shape = g.getOutline(x, y);
        Intrinsics.checkNotNullExpressionValue((Object)shape2, (String)"shape");
        this.fill(shape2);
    }

    private final void paintShape(AwtPaintType paintType, Shape shape) {
        Shape shape2 = shape;
        if (shape2 instanceof Rectangle2D) {
            this.addPaintRectCommand(paintType, ((Rectangle2D)shape).getX(), ((Rectangle2D)shape).getY(), ((Rectangle2D)shape).getWidth(), ((Rectangle2D)shape).getHeight());
        } else {
            PGraphics2D this_$iv = this;
            boolean $i$f$paintShape = false;
            DrawEventQueue.CommandBuilder $this$paintShape = this_$iv.getDrawEventQueue().buildCommand().setClip(this_$iv.identitySpaceClip).setTransform(AffineTransformUrilKt.toList(this_$iv.transform)).setStroke(this_$iv.stroke).setPaint(this_$iv.paint).setComposite(this_$iv.backingComposite);
            boolean bl = false;
            $this$paintShape.paintPath(paintType, shape);
        }
    }

    @Override
    public void fill(@NotNull Shape s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        this.paintShape(AwtPaintType.FILL, s);
    }

    @Override
    public boolean hit(@NotNull Rectangle rect, @NotNull Shape s, boolean onStroke) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        return false;
    }

    @Override
    @NotNull
    public GraphicsConfiguration getDeviceConfiguration() {
        return PGraphicsDevice.INSTANCE.getDefaultConfiguration();
    }

    @Override
    public void setComposite(@NotNull Composite comp) {
        Intrinsics.checkNotNullParameter((Object)comp, (String)"comp");
        this.backingComposite = comp;
    }

    @Override
    public void setPaint(@Nullable Paint paint) {
        if (paint == null) {
            return;
        }
        if (paint instanceof Color) {
            this.setColor((Color)paint);
        } else {
            this.paint = paint;
        }
    }

    @Override
    public void setStroke(@NotNull Stroke s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        this.stroke = s;
    }

    @Override
    public void setRenderingHint(@Nullable RenderingHints.Key hintKey, @Nullable Object hintValue) {
        if (hintKey == null || hintValue == null) {
            return;
        }
        ((Map)this.hints).put(hintKey, hintValue);
    }

    @Override
    @Nullable
    public Object getRenderingHint(@NotNull RenderingHints.Key hintKey) {
        Intrinsics.checkNotNullParameter((Object)hintKey, (String)"hintKey");
        return this.hints.get(hintKey);
    }

    @Override
    public void setRenderingHints(@NotNull Map<?, ?> hints) {
        Intrinsics.checkNotNullParameter(hints, (String)"hints");
        RenderingHints renderingHints = this.hints;
        boolean bl = false;
        boolean bl2 = false;
        RenderingHints $this$apply = renderingHints;
        boolean bl3 = false;
        $this$apply.clear();
        $this$apply.putAll(hints);
    }

    @Override
    public void addRenderingHints(@NotNull Map<?, ?> hints) {
        Intrinsics.checkNotNullParameter(hints, (String)"hints");
        this.hints.putAll(hints);
    }

    @Override
    @NotNull
    public RenderingHints getRenderingHints() {
        Object object = this.hints.clone();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.awt.RenderingHints");
        }
        return (RenderingHints)object;
    }

    @Override
    public void translate(int x, int y) {
        this.translate((double)x, (double)y);
    }

    @Override
    public void translate(double x, double y) {
        this.transform.translate(x, y);
    }

    @Override
    public void rotate(double radians) {
        this.transform.rotate(radians);
    }

    @Override
    public void rotate(double theta, double x, double y) {
        this.transform.rotate(theta, x, y);
    }

    @Override
    public void scale(double sx, double sy) {
        this.transform.scale(sx, sy);
    }

    @Override
    public void shear(double shx, double shy) {
        this.transform.shear(shx, shy);
    }

    @Override
    public void transform(@NotNull AffineTransform Tx) {
        Intrinsics.checkNotNullParameter((Object)Tx, (String)"Tx");
        this.transform.concatenate(Tx);
    }

    @Override
    public void setTransform(@NotNull AffineTransform tx) {
        Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
        this.transform.setTransform(tx);
    }

    @Override
    @NotNull
    public AffineTransform getTransform() {
        return new AffineTransform(this.transform);
    }

    @Override
    @NotNull
    public Paint getPaint() {
        return this.paint;
    }

    @Override
    @NotNull
    public Composite getComposite() {
        return this.backingComposite;
    }

    @Override
    public void setBackground(@Nullable Color color) {
        if (color == null) {
            return;
        }
        this.backgroundColor = color;
    }

    @Override
    @NotNull
    public Color getBackground() {
        return this.backgroundColor;
    }

    @Override
    @NotNull
    public Stroke getStroke() {
        return this.stroke;
    }

    @Override
    @NotNull
    public FontRenderContext getFontRenderContext() {
        return this.getBackingFontRenderContext();
    }

    @Override
    @NotNull
    public Color getColor() {
        return this.foregroundColor;
    }

    @Override
    public void setColor(@Nullable Color color) {
        if (color == null) {
            return;
        }
        this.paint = color;
        this.foregroundColor = color;
    }

    @Override
    public void setPaintMode() {
        AlphaComposite alphaComposite = AlphaComposite.SrcOver;
        Intrinsics.checkNotNullExpressionValue((Object)alphaComposite, (String)"AlphaComposite.SrcOver");
        this.setComposite(alphaComposite);
    }

    @Override
    public void setXORMode(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
    }

    @Override
    @NotNull
    public Font getFont() {
        Font font = this.getFontMetrics().getFont();
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"fontMetrics.font");
        return font;
    }

    @Override
    public void setFont(@Nullable Font font) {
        if (font == null) {
            return;
        }
        this.font = font;
    }

    @Override
    @NotNull
    public FontMetrics getFontMetrics() {
        FontDesignMetrics fontDesignMetrics = FontDesignMetrics.getMetrics(this.font, this.getBackingFontRenderContext());
        Intrinsics.checkNotNullExpressionValue((Object)fontDesignMetrics, (String)"FontDesignMetrics.getMet\u2026backingFontRenderContext)");
        return fontDesignMetrics;
    }

    @Override
    @NotNull
    public FontMetrics getFontMetrics(@NotNull Font newFont) {
        Intrinsics.checkNotNullParameter((Object)newFont, (String)"newFont");
        if (Intrinsics.areEqual((Object)newFont, (Object)this.font)) {
            return this.getFontMetrics();
        }
        FontDesignMetrics fontDesignMetrics = FontDesignMetrics.getMetrics(newFont, this.getBackingFontRenderContext());
        Intrinsics.checkNotNullExpressionValue((Object)fontDesignMetrics, (String)"FontDesignMetrics.getMet\u2026backingFontRenderContext)");
        return fontDesignMetrics;
    }

    @Override
    @Nullable
    public Rectangle getClipBounds() {
        Shape shape = this.identitySpaceClip;
        return shape != null && (shape = this.untransformShape(shape)) != null ? shape.getBounds() : null;
    }

    @Override
    public void clipRect(int x, int y, int w, int h) {
        this.clip(new Rectangle(x, y, w, h));
    }

    @Override
    public void setClip(int x, int y, int w, int h) {
        this.setClip(new Rectangle(x, y, w, h));
    }

    private final Shape untransformShape(Shape $this$untransformShape) {
        AffineTransform affineTransform = this.transform.createInverse();
        Intrinsics.checkNotNullExpressionValue((Object)affineTransform, (String)"transform.createInverse()");
        return AffineTransformUrilKt.transformShape($this$untransformShape, affineTransform);
    }

    @Override
    @Nullable
    public Shape getClip() {
        try {
            Shape shape = this.identitySpaceClip;
            return shape != null ? this.untransformShape(shape) : null;
        }
        catch (NoninvertibleTransformException e) {
            logger.error((Throwable)e, (Function0)getClip.1.INSTANCE);
            return null;
        }
    }

    @Override
    public void clip(@Nullable Shape s) {
        if (s == null) {
            this.identitySpaceClip = null;
            return;
        }
        Shape identitySpaceShape = AffineTransformUrilKt.transformShape(s, this.transform);
        if (Intrinsics.areEqual((Object)identitySpaceShape, (Object)this.identitySpaceClip)) {
            return;
        }
        Rectangle rectangle = identitySpaceShape.getBounds();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"identitySpaceShape.bounds");
        rectangle.isEmpty();
        Shape shape = this.identitySpaceClip;
        if (shape != null) {
            Shape shape2 = shape;
            boolean bl = false;
            boolean bl2 = false;
            Shape it = shape2;
            boolean bl3 = false;
            Shape intersection = ShapeUtilKt.intersectShapes(it, identitySpaceShape, true, true);
            Rectangle rectangle2 = intersection.getBounds();
            Intrinsics.checkNotNullExpressionValue((Object)rectangle2, (String)"intersection.bounds");
            rectangle2.isEmpty();
            identitySpaceShape = intersection;
        }
        this.identitySpaceClip = identitySpaceShape;
    }

    @Override
    public void setClip(@Nullable Shape s) {
        Shape identitySpaceShape;
        Shape shape = s;
        Shape shape2 = identitySpaceShape = shape != null ? AffineTransformUrilKt.transformShape(shape, this.transform) : null;
        if (Intrinsics.areEqual((Object)identitySpaceShape, (Object)this.identitySpaceClip)) {
            return;
        }
        this.identitySpaceClip = identitySpaceShape;
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        PGraphics2D this_$iv = this;
        boolean $i$f$paintArea = false;
        DrawEventQueue.CommandBuilder $this$paintArea = this_$iv.getDrawEventQueue().buildCommand().setClip(this_$iv.identitySpaceClip).setTransform(AffineTransformUrilKt.toList(this_$iv.transform)).setComposite(this_$iv.backingComposite);
        boolean bl = false;
        $this$paintArea.copyArea(x, y, width, height, dx, dy);
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        PGraphics2D this_$iv = this;
        boolean $i$f$paintShape = false;
        DrawEventQueue.CommandBuilder $this$paintShape = this_$iv.getDrawEventQueue().buildCommand().setClip(this_$iv.identitySpaceClip).setTransform(AffineTransformUrilKt.toList(this_$iv.transform)).setStroke(this_$iv.stroke).setPaint(this_$iv.paint).setComposite(this_$iv.backingComposite);
        boolean bl = false;
        $this$paintShape.drawLine(x1, y1, x2, y2);
    }

    private final void addPaintRectCommand(AwtPaintType paintType, double x, double y, double width, double height) {
        if (width <= 0.0 || height <= 0.0) {
            return;
        }
        PGraphics2D this_$iv = this;
        boolean $i$f$paintShape = false;
        DrawEventQueue.CommandBuilder $this$paintShape = this_$iv.getDrawEventQueue().buildCommand().setClip(this_$iv.identitySpaceClip).setTransform(AffineTransformUrilKt.toList(this_$iv.transform)).setStroke(this_$iv.stroke).setPaint(this_$iv.paint).setComposite(this_$iv.backingComposite);
        boolean bl = false;
        $this$paintShape.paintRect(paintType, x, y, width, height);
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        this.addPaintRectCommand(AwtPaintType.FILL, x, y, width, height);
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        Composite c = this.getComposite();
        Paint p = this.getPaint();
        AlphaComposite alphaComposite = AlphaComposite.Src;
        Intrinsics.checkNotNullExpressionValue((Object)alphaComposite, (String)"AlphaComposite.Src");
        this.setComposite(alphaComposite);
        this.setColor(this.getBackground());
        this.fillRect(x, y, width, height);
        this.setPaint(p);
        this.setComposite(c);
    }

    private final void paintRoundRect(AwtPaintType paintType, int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if (width <= 0 || height <= 0) {
            return;
        }
        PGraphics2D this_$iv = this;
        boolean $i$f$paintShape = false;
        DrawEventQueue.CommandBuilder $this$paintShape = this_$iv.getDrawEventQueue().buildCommand().setClip(this_$iv.identitySpaceClip).setTransform(AffineTransformUrilKt.toList(this_$iv.transform)).setStroke(this_$iv.stroke).setPaint(this_$iv.paint).setComposite(this_$iv.backingComposite);
        boolean bl = false;
        $this$paintShape.paintRoundRect(paintType, x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.paintRoundRect(AwtPaintType.DRAW, x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.paintRoundRect(AwtPaintType.FILL, x, y, width, height, arcWidth, arcHeight);
    }

    private final void paintOval(AwtPaintType paintType, int x, int y, int width, int height) {
        if (width <= 0 || height <= 0) {
            return;
        }
        PGraphics2D this_$iv = this;
        boolean $i$f$paintShape = false;
        DrawEventQueue.CommandBuilder $this$paintShape = this_$iv.getDrawEventQueue().buildCommand().setClip(this_$iv.identitySpaceClip).setTransform(AffineTransformUrilKt.toList(this_$iv.transform)).setStroke(this_$iv.stroke).setPaint(this_$iv.paint).setComposite(this_$iv.backingComposite);
        boolean bl = false;
        $this$paintShape.paintOval(paintType, x, y, width, height);
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        this.paintOval(AwtPaintType.DRAW, x, y, width, height);
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        this.paintOval(AwtPaintType.FILL, x, y, width, height);
    }

    private final void paintArc(AwtPaintType paintType, int x, int y, int width, int height, int startAngle, int arcAngle) {
        if (width <= 0 || height <= 0) {
            return;
        }
        PGraphics2D this_$iv = this;
        boolean $i$f$paintShape = false;
        DrawEventQueue.CommandBuilder $this$paintShape = this_$iv.getDrawEventQueue().buildCommand().setClip(this_$iv.identitySpaceClip).setTransform(AffineTransformUrilKt.toList(this_$iv.transform)).setStroke(this_$iv.stroke).setPaint(this_$iv.paint).setComposite(this_$iv.backingComposite);
        boolean bl = false;
        $this$paintShape.paintArc(paintType, x, y, width, height, startAngle, arcAngle);
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.paintArc(AwtPaintType.DRAW, x, y, width, height, startAngle, arcAngle);
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.paintArc(AwtPaintType.FILL, x, y, width, height, startAngle, arcAngle);
    }

    @Override
    public void drawPolyline(@NotNull int[] xPoints, @NotNull int[] yPoints, int nPoints) {
        Intrinsics.checkNotNullParameter((Object)xPoints, (String)"xPoints");
        Intrinsics.checkNotNullParameter((Object)yPoints, (String)"yPoints");
        if (nPoints <= 0) {
            return;
        }
        PGraphics2D this_$iv = this;
        boolean $i$f$paintShape = false;
        DrawEventQueue.CommandBuilder $this$paintShape = this_$iv.getDrawEventQueue().buildCommand().setClip(this_$iv.identitySpaceClip).setTransform(AffineTransformUrilKt.toList(this_$iv.transform)).setStroke(this_$iv.stroke).setPaint(this_$iv.paint).setComposite(this_$iv.backingComposite);
        boolean bl = false;
        $this$paintShape.drawPolyline(CollectionsKt.zip((Iterable)ArraysKt.take((int[])xPoints, (int)nPoints), (Iterable)ArraysKt.take((int[])yPoints, (int)nPoints)));
    }

    private final void paintPolygon(AwtPaintType paintType, int[] xPoints, int[] yPoints, int nPoints) {
        if (nPoints <= 0) {
            return;
        }
        PGraphics2D this_$iv = this;
        boolean $i$f$paintShape = false;
        DrawEventQueue.CommandBuilder $this$paintShape = this_$iv.getDrawEventQueue().buildCommand().setClip(this_$iv.identitySpaceClip).setTransform(AffineTransformUrilKt.toList(this_$iv.transform)).setStroke(this_$iv.stroke).setPaint(this_$iv.paint).setComposite(this_$iv.backingComposite);
        boolean bl = false;
        $this$paintShape.paintPolygon(paintType, CollectionsKt.zip((Iterable)ArraysKt.take((int[])xPoints, (int)nPoints), (Iterable)ArraysKt.take((int[])yPoints, (int)nPoints)));
    }

    @Override
    public void drawPolygon(@NotNull int[] xPoints, @NotNull int[] yPoints, int nPoints) {
        Intrinsics.checkNotNullParameter((Object)xPoints, (String)"xPoints");
        Intrinsics.checkNotNullParameter((Object)yPoints, (String)"yPoints");
        this.paintPolygon(AwtPaintType.DRAW, xPoints, yPoints, nPoints);
    }

    @Override
    public void fillPolygon(@NotNull int[] xPoints, @NotNull int[] yPoints, int nPoints) {
        Intrinsics.checkNotNullParameter((Object)xPoints, (String)"xPoints");
        Intrinsics.checkNotNullParameter((Object)yPoints, (String)"yPoints");
        this.paintPolygon(AwtPaintType.FILL, xPoints, yPoints, nPoints);
    }

    @Override
    public boolean drawImage(@Nullable Image img, @NotNull AffineTransform xform, @Nullable ImageObserver obs) {
        Intrinsics.checkNotNullParameter((Object)xform, (String)"xform");
        AwtImageInfo.Transformation info = new AwtImageInfo.Transformation(AffineTransformUrilKt.toList(xform));
        return this.extractImage(img, info, "drawImage(img, xform, obs)");
    }

    @Override
    public void drawImage(@Nullable BufferedImage img, @NotNull BufferedImageOp op, int x, int y) {
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        if (img == null) {
            return;
        }
        this.drawImage(op.filter(img, null), new AffineTransform(1.0, 0.0, 0.0, 1.0, (double)x, (double)y), null);
    }

    @Override
    public boolean drawImage(@Nullable Image img, int x, int y, @Nullable ImageObserver observer) {
        return this.drawImage(img, x, y, null, observer);
    }

    @Override
    public boolean drawImage(@Nullable Image img, int x, int y, @Nullable Color bgcolor, @Nullable ImageObserver observer) {
        Color color = bgcolor;
        AwtImageInfo.Point info = new AwtImageInfo.Point(x, y, color != null ? Integer.valueOf(color.getRGB()) : null);
        return this.extractImage(img, info, "drawImage(img, x, y, bgcolor, observer)");
    }

    @Override
    public boolean drawImage(@Nullable Image img, int x, int y, int width, int height, @Nullable ImageObserver observer) {
        return this.drawImage(img, x, y, width, height, null, observer);
    }

    @Override
    public boolean drawImage(@Nullable Image img, int x, int y, int width, int height, @Nullable Color bgcolor, @Nullable ImageObserver observer) {
        Color color = bgcolor;
        AwtImageInfo.Rectangle info = new AwtImageInfo.Rectangle(x, y, width, height, color != null ? Integer.valueOf(color.getRGB()) : null);
        return this.extractImage(img, info, "drawImage(img, x, y, w, h, bgcolor, observer)");
    }

    @Override
    public boolean drawImage(@Nullable Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, @Nullable ImageObserver observer) {
        return this.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, null, observer);
    }

    @Override
    public boolean drawImage(@Nullable Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, @Nullable Color bgcolor, @Nullable ImageObserver observer) {
        Color color = bgcolor;
        AwtImageInfo.Area info = new AwtImageInfo.Area(dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, color != null ? Integer.valueOf(color.getRGB()) : null);
        return this.extractImage(img, info, "drawImage(img, d..., s..., bgcolor, observer)");
    }

    private final boolean extractImage(Image img, AwtImageInfo awtImageInfo, String methodName) {
        if (img == null) {
            return true;
        }
        PGraphics2D this_$iv = this;
        boolean $i$f$paintArea = false;
        DrawEventQueue.CommandBuilder $this$paintArea = this_$iv.getDrawEventQueue().buildCommand().setClip(this_$iv.identitySpaceClip).setTransform(AffineTransformUrilKt.toList(this_$iv.transform)).setComposite(this_$iv.backingComposite);
        boolean bl = false;
        $this$paintArea.drawImage(ImageCacher.Companion.getInstance().getImageId(img, methodName), awtImageInfo);
        return true;
    }

    @Override
    public void dispose() {
    }

    @NotNull
    public final DrawEventQueue getDrawEventQueue() {
        return this.drawEventQueue;
    }

    private PGraphics2D(DrawEventQueue drawEventQueue, Composite backingComposite, RenderingHints hints, Shape identitySpaceClip, AffineTransform transform, Color backgroundColor, Paint paint, Color foregroundColor, Stroke stroke, Font font) {
        this.drawEventQueue = drawEventQueue;
        this.backingComposite = backingComposite;
        this.hints = hints;
        this.identitySpaceClip = identitySpaceClip;
        this.transform = transform;
        this.backgroundColor = backgroundColor;
        this.paint = paint;
        this.foregroundColor = foregroundColor;
        this.stroke = stroke;
        this.font = font;
        this.backingFontRenderContext = new FontRenderContext(PGraphics2D.Companion.getWithoutTranslation(this.transform), PGraphics2D.Companion.extractTextAntiAliasingHint(this.hints), PGraphics2D.Companion.extractFractionalMetricsHint(this.hints));
    }

    public PGraphics2D(@NotNull PVolatileImage.Descriptor target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this((DrawEventQueue)DrawEventQueue.Companion.getCreateOffScreen().invoke((Object)target), new AffineTransform(), null, null, null, null);
    }

    public PGraphics2D(@NotNull Component component, @NotNull PWindow.Descriptor target) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        DrawEventQueue drawEventQueue = (DrawEventQueue)DrawEventQueue.Companion.getCreateOnScreen().invoke((Object)target);
        GraphicsConfiguration graphicsConfiguration = component.getGraphicsConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)graphicsConfiguration, (String)"component.graphicsConfiguration");
        AffineTransform affineTransform = graphicsConfiguration.getDefaultTransform();
        Intrinsics.checkNotNullExpressionValue((Object)affineTransform, (String)"component.graphicsConfiguration.defaultTransform");
        this(drawEventQueue, affineTransform, component.getBackground(), component.getForeground(), component.getForeground(), component.getFont());
    }

    private PGraphics2D(DrawEventQueue drawEventQueue, AffineTransform transform, Color backgroundColor, Paint paint, Color foregroundColor, Font font) {
        Color color;
        Paint paint2;
        AlphaComposite alphaComposite = AlphaComposite.SrcOver;
        Intrinsics.checkNotNullExpressionValue((Object)alphaComposite, (String)"AlphaComposite.SrcOver");
        Composite composite = alphaComposite;
        RenderingHints renderingHints = PGraphics2D.Companion.makeHints(null);
        Color color2 = backgroundColor;
        if (color2 == null) {
            color2 = Defaults.INSTANCE.getBACKGROUND_COLOR_ARGB();
        }
        if ((paint2 = paint) == null) {
            paint2 = Defaults.INSTANCE.getFOREGROUND_COLOR_ARGB();
        }
        if ((color = foregroundColor) == null) {
            color = Defaults.INSTANCE.getFOREGROUND_COLOR_ARGB();
        }
        Stroke stroke = Defaults.INSTANCE.getSTROKE();
        Font font2 = font;
        if (font2 == null) {
            font2 = (Font)ArraysKt.first((Object[])PFontManager.INSTANCE.getAllInstalledFonts());
        }
        this(drawEventQueue, composite, renderingHints, null, transform, color2, paint2, color, stroke, font2);
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$Logger = false;
        String string = Reflection.getOrCreateKotlinClass(PGraphics2D.class).getSimpleName();
        Intrinsics.checkNotNull((Object)string);
        logger = LoggerKt.Logger((String)string);
        RenderingHints renderingHints = defaultRenderingHints = new SunGraphics2D(NullSurfaceData.theInstance, Color.BLACK, Color.WHITE, (Font)ArraysKt.first((Object[])PFontManager.INSTANCE.getAllInstalledFonts())).getRenderingHints();
        Intrinsics.checkNotNullExpressionValue((Object)renderingHints, (String)"defaultRenderingHints");
        defaultAa = PGraphics2D.Companion.extractTextAntiAliasingHint(renderingHints);
    }

    public static final /* synthetic */ void access$setIdentitySpaceClip$p(PGraphics2D $this, Shape shape) {
        $this.identitySpaceClip = shape;
    }

    public static final /* synthetic */ void access$setStroke$p(PGraphics2D $this, Stroke stroke) {
        $this.stroke = stroke;
    }

    public static final /* synthetic */ void access$setPaint$p(PGraphics2D $this, Paint paint) {
        $this.paint = paint;
    }

    public static final /* synthetic */ void access$setBackingComposite$p(PGraphics2D $this, Composite composite) {
        $this.backingComposite = composite;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000f\u001a\n \b*\u0004\u0018\u00010\u00010\u00012\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J\u0018\u0010\u0011\u001a\n \b*\u0004\u0018\u00010\u00010\u00012\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J\u001c\u0010\u0012\u001a\u00020\u00072\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0002\b\u0003\u0018\u00010\u0013H\u0002R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\u00020\f*\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/projector/awt/image/PGraphics2D$Companion;", "", "()V", "defaultAa", "getDefaultAa", "()Ljava/lang/Object;", "defaultRenderingHints", "Ljava/awt/RenderingHints;", "kotlin.jvm.PlatformType", "logger", "Lorg/jetbrains/projector/util/logging/Logger;", "withoutTranslation", "Ljava/awt/geom/AffineTransform;", "getWithoutTranslation", "(Ljava/awt/geom/AffineTransform;)Ljava/awt/geom/AffineTransform;", "extractFractionalMetricsHint", "hints", "extractTextAntiAliasingHint", "makeHints", "", "Ljava/awt/RenderingHints$Key;", "projector-awt"})
    public static final class Companion {
        private final Object extractTextAntiAliasingHint(RenderingHints hints) {
            Object object;
            Object object2 = hints.get(RenderingHints.KEY_TEXT_ANTIALIASING);
            if (object2 == null) {
                object2 = object = UIManager.getDefaults().get(RenderingHints.KEY_TEXT_ANTIALIASING);
            }
            if (object2 == null) {
                object = RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT;
            }
            return object;
        }

        private final Object extractFractionalMetricsHint(RenderingHints hints) {
            Object object;
            Object object2 = hints.get(RenderingHints.KEY_FRACTIONALMETRICS);
            if (object2 == null) {
                object2 = object = UIManager.getDefaults().get(RenderingHints.KEY_FRACTIONALMETRICS);
            }
            if (object2 == null) {
                object = RenderingHints.VALUE_FRACTIONALMETRICS_DEFAULT;
            }
            return object;
        }

        private final AffineTransform getWithoutTranslation(AffineTransform $this$withoutTranslation) {
            AffineTransform affineTransform = new AffineTransform($this$withoutTranslation);
            boolean bl = false;
            boolean bl2 = false;
            AffineTransform $this$apply = affineTransform;
            boolean bl3 = false;
            $this$apply.setTransform($this$apply.getScaleX(), $this$apply.getShearY(), $this$apply.getShearX(), $this$apply.getScaleY(), 0.0, 0.0);
            return affineTransform;
        }

        @Nullable
        public final Object getDefaultAa() {
            return defaultAa;
        }

        private final RenderingHints makeHints(Map<RenderingHints.Key, ?> hints) {
            RenderingHints renderingHints;
            block0: {
                renderingHints = new RenderingHints(null);
                boolean bl = false;
                boolean bl2 = false;
                RenderingHints $this$apply = renderingHints;
                boolean bl3 = false;
                $this$apply.add(defaultRenderingHints);
                Map<RenderingHints.Key, ?> map = hints;
                if (map == null) break block0;
                Map<RenderingHints.Key, ?> map2 = map;
                boolean bl4 = false;
                boolean bl5 = false;
                Map<RenderingHints.Key, ?> it = map2;
                boolean bl6 = false;
                $this$apply.putAll(it);
            }
            return renderingHints;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

