/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.awt.image;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.ImageCapabilities;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.ColorModel;
import java.awt.image.VolatileImage;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.projector.awt.image.PGraphicsDevice;
import org.jetbrains.projector.awt.image.PGraphicsEnvironment;
import org.jetbrains.projector.awt.image.PVolatileImage;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0006H\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\n\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\n\u001a\u00020\u0006H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0010H\u0016\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/projector/awt/image/PGraphicsConfiguration;", "Ljava/awt/GraphicsConfiguration;", "()V", "createCompatibleVolatileImage", "Ljava/awt/image/VolatileImage;", "width", "", "height", "caps", "Ljava/awt/ImageCapabilities;", "transparency", "getBounds", "Ljava/awt/Rectangle;", "getColorModel", "Ljava/awt/image/ColorModel;", "getDefaultTransform", "Ljava/awt/geom/AffineTransform;", "getDevice", "Ljava/awt/GraphicsDevice;", "getNormalizingTransform", "projector-awt"})
public final class PGraphicsConfiguration
extends GraphicsConfiguration {
    @NotNull
    public static final PGraphicsConfiguration INSTANCE;

    @Override
    @NotNull
    public GraphicsDevice getDevice() {
        return PGraphicsDevice.INSTANCE;
    }

    @Override
    @Nullable
    public ColorModel getColorModel() {
        return ColorModel.getRGBdefault();
    }

    @Override
    @Nullable
    public ColorModel getColorModel(int transparency) {
        return this.getColorModel();
    }

    @Override
    @NotNull
    public AffineTransform getDefaultTransform() {
        return new AffineTransform();
    }

    @Override
    @NotNull
    public AffineTransform getNormalizingTransform() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (graphicsEnvironment == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.projector.awt.image.PGraphicsEnvironment");
        }
        PGraphicsEnvironment ge = (PGraphicsEnvironment)graphicsEnvironment;
        double xScale = ge.getXResolution() / 72.0;
        double yScale = ge.getYResolution() / 72.0;
        return new AffineTransform(xScale, 0.0, 0.0, yScale, 0.0, 0.0);
    }

    @Override
    @NotNull
    public Rectangle getBounds() {
        return new Rectangle(PGraphicsDevice.INSTANCE.getClientScreenBounds());
    }

    @Override
    @NotNull
    public VolatileImage createCompatibleVolatileImage(int width, int height, @Nullable ImageCapabilities caps, int transparency) {
        return new PVolatileImage(width, height, transparency, caps);
    }

    private PGraphicsConfiguration() {
    }

    static {
        PGraphicsConfiguration pGraphicsConfiguration;
        INSTANCE = pGraphicsConfiguration = new PGraphicsConfiguration();
    }
}

