/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.awt.image;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u001a&\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005\u001a&\u0010\r\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005\u001a\n\u0010\u000e\u001a\u00020\u0001*\u00020\u0001\u00a8\u0006\u000f"}, d2={"intersectByArea", "Ljava/awt/Shape;", "s1", "s2", "keep1", "", "keep2", "intersectRectShape", "r", "Ljava/awt/geom/Rectangle2D;", "s", "keepR", "keepS", "intersectShapes", "copy", "projector-awt"})
public final class ShapeUtilKt {
    @NotNull
    public static final Shape intersectShapes(@NotNull Shape s1, @NotNull Shape s2, boolean keep1, boolean keep2) {
        Shape shape;
        Intrinsics.checkNotNullParameter((Object)s1, (String)"s1");
        Intrinsics.checkNotNullParameter((Object)s2, (String)"s2");
        if (s1 instanceof Rectangle2D && s2 instanceof Rectangle2D) {
            Rectangle2D rectangle2D = ((Rectangle2D)s1).createIntersection((Rectangle2D)s2);
            Intrinsics.checkNotNullExpressionValue((Object)rectangle2D, (String)"s1.createIntersection(s2)");
            shape = rectangle2D;
        } else {
            shape = s1 instanceof Rectangle2D ? ShapeUtilKt.intersectRectShape((Rectangle2D)s1, s2, keep1, keep2) : (s2 instanceof Rectangle2D ? ShapeUtilKt.intersectRectShape((Rectangle2D)s2, s1, keep2, keep1) : ShapeUtilKt.intersectByArea(s1, s2, keep1, keep2));
        }
        return shape;
    }

    @NotNull
    public static final Shape intersectRectShape(@NotNull Rectangle2D r, @NotNull Shape s, boolean keepR, boolean keepS) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        if (r.contains(s.getBounds2D())) {
            if (keepS) {
                return new GeneralPath(s);
            }
            return s;
        }
        return ShapeUtilKt.intersectByArea(r, s, keepR, keepS);
    }

    /*
     * WARNING - void declaration
     */
    private static final Shape intersectByArea(Shape s1, Shape s2, boolean keep1, boolean keep2) {
        Shape shape;
        void a1;
        Area area;
        Pair pair = !keep1 && s1 instanceof Area ? TuplesKt.to((Object)s1, (Object)s2) : (!keep2 && s2 instanceof Area ? TuplesKt.to((Object)s2, (Object)s1) : TuplesKt.to((Object)new Area(s1), (Object)s2));
        Area area2 = (Area)pair.component1();
        Shape remainingShape = (Shape)pair.component2();
        Shape shape2 = remainingShape;
        if (!(shape2 instanceof Area)) {
            shape2 = null;
        }
        if ((area = (Area)shape2) == null) {
            area = new Area(remainingShape);
        }
        Area a2 = area;
        a1.intersect(a2);
        if (a1.isRectangular()) {
            Rectangle rectangle = a1.getBounds();
            Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"a1.bounds");
            shape = rectangle;
        } else {
            shape = (Shape)a1;
        }
        return shape;
    }

    @NotNull
    public static final Shape copy(@NotNull Shape $this$copy) {
        Intrinsics.checkNotNullParameter((Object)$this$copy, (String)"$this$copy");
        Shape shape = $this$copy;
        return shape instanceof Rectangle2D ? (Shape)new Rectangle2D.Double(((Rectangle2D)$this$copy).getX(), ((Rectangle2D)$this$copy).getY(), ((Rectangle2D)$this$copy).getWidth(), ((Rectangle2D)$this$copy).getHeight()) : (Shape)new GeneralPath($this$copy);
    }
}

