/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.protobuf.internal;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.SerializationException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\f\u0010\u0010\u001a\u00060\u0004j\u0002`\u0005H\u0004J\f\u0010\u0011\u001a\u00060\u0004j\u0002`\u0005H\u0004J\u0014\u0010\u0012\u001a\u00020\u000f2\n\u0010\u0013\u001a\u00060\u0004j\u0002`\u0005H\u0004J1\u0010\u0014\u001a\u0002H\u0015\"\u0004\b\u0000\u0010\u00152\n\u0010\u0013\u001a\u00060\u0004j\u0002`\u00052\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0017H\u0084\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0018R\u0018\u0010\u0003\u001a\u00060\u0004j\u0002`\u00058DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\u00060\u0004j\u0002`\u00058DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0012\u0010\n\u001a\u00020\u000b8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0019"}, d2={"Lkotlinx/serialization/protobuf/internal/ProtobufTaggedBase;", "", "()V", "currentTag", "", "Lkotlinx/serialization/protobuf/internal/ProtoDesc;", "getCurrentTag", "()J", "currentTagOrDefault", "getCurrentTagOrDefault", "stackSize", "", "tagsStack", "", "expand", "", "popTag", "popTagOrDefault", "pushTag", "tag", "tagBlock", "E", "block", "Lkotlin/Function0;", "(JLkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "kotlinx-serialization-protobuf"})
public abstract class ProtobufTaggedBase {
    private long[] tagsStack = new long[8];
    @JvmField
    protected int stackSize = -1;

    protected final long getCurrentTag() {
        return this.tagsStack[this.stackSize];
    }

    protected final long getCurrentTagOrDefault() {
        return this.stackSize == -1 ? 19500L : this.tagsStack[this.stackSize];
    }

    protected final long popTagOrDefault() {
        long l;
        if (this.stackSize == -1) {
            l = 19500L;
        } else {
            int n = this.stackSize;
            this.stackSize = n + -1;
            l = this.tagsStack[n];
        }
        return l;
    }

    protected final void pushTag(long tag) {
        if (tag == 19500L) {
            return;
        }
        ProtobufTaggedBase protobufTaggedBase = this;
        ++protobufTaggedBase.stackSize;
        int idx = protobufTaggedBase.stackSize;
        if (this.stackSize >= this.tagsStack.length) {
            this.expand();
        }
        this.tagsStack[idx] = tag;
    }

    private final void expand() {
        long[] lArray = this.tagsStack;
        int n = this.tagsStack.length * 2;
        boolean bl = false;
        long[] lArray2 = Arrays.copyOf(lArray, n);
        Intrinsics.checkNotNullExpressionValue((Object)lArray2, (String)"java.util.Arrays.copyOf(this, newSize)");
        this.tagsStack = lArray2;
    }

    protected final long popTag() {
        if (this.stackSize >= 0) {
            int n = this.stackSize;
            this.stackSize = n + -1;
            return this.tagsStack[n];
        }
        throw (Throwable)new SerializationException("No tag in stack for requested element");
    }

    protected final <E> E tagBlock(long tag, @NotNull Function0<? extends E> block) {
        int $i$f$tagBlock = 0;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.pushTag(tag);
        return (E)block.invoke();
    }
}

