"""Add user <-> portal/puppet mappings to db

Revision ID: 3355b59b191c
Revises: 8e0f1142c8d5
Create Date: 2019-08-17 23:42:13.755036

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '3355b59b191c'
down_revision = '8e0f1142c8d5'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('contact',
    sa.Column('user', sa.String(length=255), nullable=False),
    sa.Column('contact', sa.String(length=255), nullable=False),
    sa.Column('in_community', sa.Boolean(), server_default=sa.false(), nullable=False),
    sa.ForeignKeyConstraint(['contact'], ['puppet.fbid'], ),
    sa.PrimaryKeyConstraint('user', 'contact')
    )
    op.create_table('user_portal',
    sa.Column('user', sa.String(length=255), nullable=False),
    sa.Column('portal', sa.String(length=255), nullable=False),
    sa.Column('portal_receiver', sa.String(length=255), nullable=False),
    sa.Column('in_community', sa.Boolean(), server_default=sa.false(), nullable=False),
    sa.ForeignKeyConstraint(['portal', 'portal_receiver'], ['portal.fbid', 'portal.fb_receiver'], onupdate='CASCADE', ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('user', 'portal', 'portal_receiver')
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('user_portal')
    op.drop_table('contact')
    # ### end Alembic commands ###
