import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DialogflowCxFlowConfig extends cdktf.TerraformMetaArguments {
    /**
     * The description of the flow. The maximum length is 500 characters. If exceeded, the request is rejected.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#description DialogflowCxFlow#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * The human-readable name of the flow.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#display_name DialogflowCxFlow#display_name}
     *
     * @stability stable
     */
    readonly displayName: string;
    /**
     * The language of the following fields in flow: Flow.event_handlers.trigger_fulfillment.messages Flow.event_handlers.trigger_fulfillment.conditional_cases Flow.transition_routes.trigger_fulfillment.messages Flow.transition_routes.trigger_fulfillment.conditional_cases If not specified, the agent's default language is used. Many languages are supported. Note: languages must be enabled in the agent before they can be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#language_code DialogflowCxFlow#language_code}
     *
     * @stability stable
     */
    readonly languageCode?: string;
    /**
     * The agent to create a flow for.  Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#parent DialogflowCxFlow#parent}
     *
     * @stability stable
     */
    readonly parent?: string;
    /**
     * A flow's transition route group serve two purposes: They are responsible for matching the user's first utterances in the flow.
     *
     * They are inherited by every page's [transition route groups][Page.transition_route_groups]. Transition route groups defined in the page have higher priority than those defined in the flow.
     * Format:projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>/transitionRouteGroups/<TransitionRouteGroup ID>.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#transition_route_groups DialogflowCxFlow#transition_route_groups}
     *
     * @stability stable
     */
    readonly transitionRouteGroups?: string[];
    /**
     * event_handlers block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#event_handlers DialogflowCxFlow#event_handlers}
     *
     * @stability stable
     */
    readonly eventHandlers?: DialogflowCxFlowEventHandlers[];
    /**
     * nlu_settings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#nlu_settings DialogflowCxFlow#nlu_settings}
     *
     * @stability stable
     */
    readonly nluSettings?: DialogflowCxFlowNluSettings;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#timeouts DialogflowCxFlow#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DialogflowCxFlowTimeouts;
    /**
     * transition_routes block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#transition_routes DialogflowCxFlow#transition_routes}
     *
     * @stability stable
     */
    readonly transitionRoutes?: DialogflowCxFlowTransitionRoutes[];
}
/**
 * @stability stable
 */
export interface DialogflowCxFlowEventHandlersTriggerFulfillmentMessagesText {
    /**
     * A collection of text responses.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#text DialogflowCxFlow#text}
     *
     * @stability stable
     */
    readonly text?: string[];
}
/**
 * @stability stable
 */
export declare class DialogflowCxFlowEventHandlersTriggerFulfillmentMessagesTextOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _text?;
    /**
     * @stability stable
     */
    get text(): string[] | undefined;
    /**
     * @stability stable
     */
    set text(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetText(): void;
    /**
     * @stability stable
     */
    get textInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface DialogflowCxFlowEventHandlersTriggerFulfillmentMessages {
    /**
     * text block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#text DialogflowCxFlow#text}
     *
     * @stability stable
     */
    readonly text?: DialogflowCxFlowEventHandlersTriggerFulfillmentMessagesText;
}
/**
 * @stability stable
 */
export interface DialogflowCxFlowEventHandlersTriggerFulfillment {
    /**
     * Whether Dialogflow should return currently queued fulfillment response messages in streaming APIs.
     *
     * If a webhook is specified, it happens before Dialogflow invokes webhook. Warning: 1) This flag only affects streaming API. Responses are still queued and returned once in non-streaming API. 2) The flag can be enabled in any fulfillment but only the first 3 partial responses will be returned. You may only want to apply it to fulfillments that have slow webhooks.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#return_partial_responses DialogflowCxFlow#return_partial_responses}
     *
     * @stability stable
     */
    readonly returnPartialResponses?: boolean | cdktf.IResolvable;
    /**
     * The tag used by the webhook to identify which fulfillment is being called.
     *
     * This field is required if webhook is specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#tag DialogflowCxFlow#tag}
     *
     * @stability stable
     */
    readonly tag?: string;
    /**
     * The webhook to call. Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/webhooks/<Webhook ID>.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#webhook DialogflowCxFlow#webhook}
     *
     * @stability stable
     */
    readonly webhook?: string;
    /**
     * messages block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#messages DialogflowCxFlow#messages}
     *
     * @stability stable
     */
    readonly messages?: DialogflowCxFlowEventHandlersTriggerFulfillmentMessages[];
}
/**
 * @stability stable
 */
export declare class DialogflowCxFlowEventHandlersTriggerFulfillmentOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _returnPartialResponses?;
    /**
     * @stability stable
     */
    get returnPartialResponses(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set returnPartialResponses(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetReturnPartialResponses(): void;
    /**
     * @stability stable
     */
    get returnPartialResponsesInput(): boolean | cdktf.IResolvable | undefined;
    private _tag?;
    /**
     * @stability stable
     */
    get tag(): string | undefined;
    /**
     * @stability stable
     */
    set tag(value: string | undefined);
    /**
     * @stability stable
     */
    resetTag(): void;
    /**
     * @stability stable
     */
    get tagInput(): string | undefined;
    private _webhook?;
    /**
     * @stability stable
     */
    get webhook(): string | undefined;
    /**
     * @stability stable
     */
    set webhook(value: string | undefined);
    /**
     * @stability stable
     */
    resetWebhook(): void;
    /**
     * @stability stable
     */
    get webhookInput(): string | undefined;
    private _messages?;
    /**
     * @stability stable
     */
    get messages(): DialogflowCxFlowEventHandlersTriggerFulfillmentMessages[] | undefined;
    /**
     * @stability stable
     */
    set messages(value: DialogflowCxFlowEventHandlersTriggerFulfillmentMessages[] | undefined);
    /**
     * @stability stable
     */
    resetMessages(): void;
    /**
     * @stability stable
     */
    get messagesInput(): DialogflowCxFlowEventHandlersTriggerFulfillmentMessages[] | undefined;
}
/**
 * @stability stable
 */
export interface DialogflowCxFlowEventHandlers {
    /**
     * The name of the event to handle.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#event DialogflowCxFlow#event}
     *
     * @stability stable
     */
    readonly event?: string;
    /**
     * The target flow to transition to.  Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#target_flow DialogflowCxFlow#target_flow}
     *
     * @stability stable
     */
    readonly targetFlow?: string;
    /**
     * The target page to transition to.  Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>/pages/<Page ID>.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#target_page DialogflowCxFlow#target_page}
     *
     * @stability stable
     */
    readonly targetPage?: string;
    /**
     * trigger_fulfillment block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#trigger_fulfillment DialogflowCxFlow#trigger_fulfillment}
     *
     * @stability stable
     */
    readonly triggerFulfillment?: DialogflowCxFlowEventHandlersTriggerFulfillment;
}
/**
 * @stability stable
 */
export interface DialogflowCxFlowNluSettings {
    /**
     * To filter out false positive results and still get variety in matched natural language inputs for your agent, you can tune the machine learning classification threshold.
     *
     * If the returned score value is less than the threshold value, then a no-match event will be triggered. The score values range from 0.0 (completely uncertain) to 1.0 (completely certain). If set to 0.0, the default of 0.3 is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#classification_threshold DialogflowCxFlow#classification_threshold}
     *
     * @stability stable
     */
    readonly classificationThreshold?: number;
    /**
     * Indicates NLU model training mode.
     *
     * MODEL_TRAINING_MODE_AUTOMATIC: NLU model training is automatically triggered when a flow gets modified. User can also manually trigger model training in this mode.
     * MODEL_TRAINING_MODE_MANUAL: User needs to manually trigger NLU model training. Best for large flows whose models take long time to train. Possible values: ["MODEL_TRAINING_MODE_AUTOMATIC", "MODEL_TRAINING_MODE_MANUAL"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#model_training_mode DialogflowCxFlow#model_training_mode}
     *
     * @stability stable
     */
    readonly modelTrainingMode?: string;
    /**
     * Indicates the type of NLU model. MODEL_TYPE_STANDARD: Use standard NLU model. MODEL_TYPE_ADVANCED: Use advanced NLU model. Possible values: ["MODEL_TYPE_STANDARD", "MODEL_TYPE_ADVANCED"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#model_type DialogflowCxFlow#model_type}
     *
     * @stability stable
     */
    readonly modelType?: string;
}
/**
 * @stability stable
 */
export declare class DialogflowCxFlowNluSettingsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _classificationThreshold?;
    /**
     * @stability stable
     */
    get classificationThreshold(): number | undefined;
    /**
     * @stability stable
     */
    set classificationThreshold(value: number | undefined);
    /**
     * @stability stable
     */
    resetClassificationThreshold(): void;
    /**
     * @stability stable
     */
    get classificationThresholdInput(): number | undefined;
    private _modelTrainingMode?;
    /**
     * @stability stable
     */
    get modelTrainingMode(): string | undefined;
    /**
     * @stability stable
     */
    set modelTrainingMode(value: string | undefined);
    /**
     * @stability stable
     */
    resetModelTrainingMode(): void;
    /**
     * @stability stable
     */
    get modelTrainingModeInput(): string | undefined;
    private _modelType?;
    /**
     * @stability stable
     */
    get modelType(): string | undefined;
    /**
     * @stability stable
     */
    set modelType(value: string | undefined);
    /**
     * @stability stable
     */
    resetModelType(): void;
    /**
     * @stability stable
     */
    get modelTypeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DialogflowCxFlowTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#create DialogflowCxFlow#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#delete DialogflowCxFlow#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#update DialogflowCxFlow#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export declare class DialogflowCxFlowTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string | undefined;
    /**
     * @stability stable
     */
    set update(value: string | undefined);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesText {
    /**
     * A collection of text responses.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#text DialogflowCxFlow#text}
     *
     * @stability stable
     */
    readonly text?: string[];
}
/**
 * @stability stable
 */
export declare class DialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesTextOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _text?;
    /**
     * @stability stable
     */
    get text(): string[] | undefined;
    /**
     * @stability stable
     */
    set text(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetText(): void;
    /**
     * @stability stable
     */
    get textInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface DialogflowCxFlowTransitionRoutesTriggerFulfillmentMessages {
    /**
     * text block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#text DialogflowCxFlow#text}
     *
     * @stability stable
     */
    readonly text?: DialogflowCxFlowTransitionRoutesTriggerFulfillmentMessagesText;
}
/**
 * @stability stable
 */
export interface DialogflowCxFlowTransitionRoutesTriggerFulfillment {
    /**
     * Whether Dialogflow should return currently queued fulfillment response messages in streaming APIs.
     *
     * If a webhook is specified, it happens before Dialogflow invokes webhook. Warning: 1) This flag only affects streaming API. Responses are still queued and returned once in non-streaming API. 2) The flag can be enabled in any fulfillment but only the first 3 partial responses will be returned. You may only want to apply it to fulfillments that have slow webhooks.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#return_partial_responses DialogflowCxFlow#return_partial_responses}
     *
     * @stability stable
     */
    readonly returnPartialResponses?: boolean | cdktf.IResolvable;
    /**
     * The tag used by the webhook to identify which fulfillment is being called.
     *
     * This field is required if webhook is specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#tag DialogflowCxFlow#tag}
     *
     * @stability stable
     */
    readonly tag?: string;
    /**
     * The webhook to call. Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/webhooks/<Webhook ID>.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#webhook DialogflowCxFlow#webhook}
     *
     * @stability stable
     */
    readonly webhook?: string;
    /**
     * messages block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#messages DialogflowCxFlow#messages}
     *
     * @stability stable
     */
    readonly messages?: DialogflowCxFlowTransitionRoutesTriggerFulfillmentMessages[];
}
/**
 * @stability stable
 */
export declare class DialogflowCxFlowTransitionRoutesTriggerFulfillmentOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _returnPartialResponses?;
    /**
     * @stability stable
     */
    get returnPartialResponses(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set returnPartialResponses(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetReturnPartialResponses(): void;
    /**
     * @stability stable
     */
    get returnPartialResponsesInput(): boolean | cdktf.IResolvable | undefined;
    private _tag?;
    /**
     * @stability stable
     */
    get tag(): string | undefined;
    /**
     * @stability stable
     */
    set tag(value: string | undefined);
    /**
     * @stability stable
     */
    resetTag(): void;
    /**
     * @stability stable
     */
    get tagInput(): string | undefined;
    private _webhook?;
    /**
     * @stability stable
     */
    get webhook(): string | undefined;
    /**
     * @stability stable
     */
    set webhook(value: string | undefined);
    /**
     * @stability stable
     */
    resetWebhook(): void;
    /**
     * @stability stable
     */
    get webhookInput(): string | undefined;
    private _messages?;
    /**
     * @stability stable
     */
    get messages(): DialogflowCxFlowTransitionRoutesTriggerFulfillmentMessages[] | undefined;
    /**
     * @stability stable
     */
    set messages(value: DialogflowCxFlowTransitionRoutesTriggerFulfillmentMessages[] | undefined);
    /**
     * @stability stable
     */
    resetMessages(): void;
    /**
     * @stability stable
     */
    get messagesInput(): DialogflowCxFlowTransitionRoutesTriggerFulfillmentMessages[] | undefined;
}
/**
 * @stability stable
 */
export interface DialogflowCxFlowTransitionRoutes {
    /**
     * The condition to evaluate against form parameters or session parameters.
     *
     * At least one of intent or condition must be specified. When both intent and condition are specified, the transition can only happen when both are fulfilled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#condition DialogflowCxFlow#condition}
     *
     * @stability stable
     */
    readonly condition?: string;
    /**
     * The unique identifier of an Intent.
     *
     * Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/intents/<Intent ID>. Indicates that the transition can only happen when the given intent is matched. At least one of intent or condition must be specified. When both intent and condition are specified, the transition can only happen when both are fulfilled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#intent DialogflowCxFlow#intent}
     *
     * @stability stable
     */
    readonly intent?: string;
    /**
     * The target flow to transition to.  Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#target_flow DialogflowCxFlow#target_flow}
     *
     * @stability stable
     */
    readonly targetFlow?: string;
    /**
     * The target page to transition to.  Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/flows/<Flow ID>/pages/<Page ID>.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#target_page DialogflowCxFlow#target_page}
     *
     * @stability stable
     */
    readonly targetPage?: string;
    /**
     * trigger_fulfillment block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html#trigger_fulfillment DialogflowCxFlow#trigger_fulfillment}
     *
     * @stability stable
     */
    readonly triggerFulfillment?: DialogflowCxFlowTransitionRoutesTriggerFulfillment;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html google_dialogflow_cx_flow}.
 *
 * @stability stable
 */
export declare class DialogflowCxFlow extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/dialogflow_cx_flow.html google_dialogflow_cx_flow} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DialogflowCxFlowConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string | undefined;
    /**
     * @stability stable
     */
    set description(value: string | undefined);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _languageCode?;
    /**
     * @stability stable
     */
    get languageCode(): string | undefined;
    /**
     * @stability stable
     */
    set languageCode(value: string | undefined);
    /**
     * @stability stable
     */
    resetLanguageCode(): void;
    /**
     * @stability stable
     */
    get languageCodeInput(): string | undefined;
    /**
     * @stability stable
     */
    get name(): string;
    private _parent?;
    /**
     * @stability stable
     */
    get parent(): string | undefined;
    /**
     * @stability stable
     */
    set parent(value: string | undefined);
    /**
     * @stability stable
     */
    resetParent(): void;
    /**
     * @stability stable
     */
    get parentInput(): string | undefined;
    private _transitionRouteGroups?;
    /**
     * @stability stable
     */
    get transitionRouteGroups(): string[] | undefined;
    /**
     * @stability stable
     */
    set transitionRouteGroups(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetTransitionRouteGroups(): void;
    /**
     * @stability stable
     */
    get transitionRouteGroupsInput(): string[] | undefined;
    private _eventHandlers?;
    /**
     * @stability stable
     */
    get eventHandlers(): DialogflowCxFlowEventHandlers[] | undefined;
    /**
     * @stability stable
     */
    set eventHandlers(value: DialogflowCxFlowEventHandlers[] | undefined);
    /**
     * @stability stable
     */
    resetEventHandlers(): void;
    /**
     * @stability stable
     */
    get eventHandlersInput(): DialogflowCxFlowEventHandlers[] | undefined;
    private _nluSettings?;
    private __nluSettingsOutput;
    /**
     * @stability stable
     */
    get nluSettings(): DialogflowCxFlowNluSettingsOutputReference;
    /**
     * @stability stable
     */
    putNluSettings(value: DialogflowCxFlowNluSettings | undefined): void;
    /**
     * @stability stable
     */
    resetNluSettings(): void;
    /**
     * @stability stable
     */
    get nluSettingsInput(): DialogflowCxFlowNluSettings | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): DialogflowCxFlowTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DialogflowCxFlowTimeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DialogflowCxFlowTimeouts | undefined;
    private _transitionRoutes?;
    /**
     * @stability stable
     */
    get transitionRoutes(): DialogflowCxFlowTransitionRoutes[] | undefined;
    /**
     * @stability stable
     */
    set transitionRoutes(value: DialogflowCxFlowTransitionRoutes[] | undefined);
    /**
     * @stability stable
     */
    resetTransitionRoutes(): void;
    /**
     * @stability stable
     */
    get transitionRoutesInput(): DialogflowCxFlowTransitionRoutes[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
