import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface NetworkManagementConnectivityTestConfig extends cdktf.TerraformMetaArguments {
    /**
     * The user-supplied description of the Connectivity Test. Maximum of 512 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test.html#description NetworkManagementConnectivityTest#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Resource labels to represent user-provided metadata.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test.html#labels NetworkManagementConnectivityTest#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Unique name for the connectivity test.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test.html#name NetworkManagementConnectivityTest#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test.html#project NetworkManagementConnectivityTest#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * IP Protocol of the test. When not provided, "TCP" is assumed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test.html#protocol NetworkManagementConnectivityTest#protocol}
     *
     * @stability stable
     */
    readonly protocol?: string;
    /**
     * Other projects that may be relevant for reachability analysis. This is applicable to scenarios where a test can cross project boundaries.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test.html#related_projects NetworkManagementConnectivityTest#related_projects}
     *
     * @stability stable
     */
    readonly relatedProjects?: string[];
    /**
     * destination block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test.html#destination NetworkManagementConnectivityTest#destination}
     *
     * @stability stable
     */
    readonly destination: NetworkManagementConnectivityTestDestination;
    /**
     * source block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test.html#source NetworkManagementConnectivityTest#source}
     *
     * @stability stable
     */
    readonly source: NetworkManagementConnectivityTestSource;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test.html#timeouts NetworkManagementConnectivityTest#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: NetworkManagementConnectivityTestTimeouts;
}
/**
 * @stability stable
 */
export interface NetworkManagementConnectivityTestDestination {
    /**
     * A Compute Engine instance URI.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test.html#instance NetworkManagementConnectivityTest#instance}
     *
     * @stability stable
     */
    readonly instance?: string;
    /**
     * The IP address of the endpoint, which can be an external or internal IP.
     *
     * An IPv6 address is only allowed when the test's
     * destination is a global load balancer VIP.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test.html#ip_address NetworkManagementConnectivityTest#ip_address}
     *
     * @stability stable
     */
    readonly ipAddress?: string;
    /**
     * A Compute Engine network URI.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test.html#network NetworkManagementConnectivityTest#network}
     *
     * @stability stable
     */
    readonly network?: string;
    /**
     * The IP protocol port of the endpoint. Only applicable when protocol is TCP or UDP.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test.html#port NetworkManagementConnectivityTest#port}
     *
     * @stability stable
     */
    readonly port?: number;
    /**
     * Project ID where the endpoint is located.
     *
     * The Project ID can be
     * derived from the URI if you provide a VM instance or network URI.
     * The following are two cases where you must provide the project ID:
     * 1. Only the IP address is specified, and the IP address is within
     * a GCP project. 2. When you are using Shared VPC and the IP address
     * that you provide is from the service project. In this case, the
     * network that the IP address resides in is defined in the host
     * project.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test.html#project_id NetworkManagementConnectivityTest#project_id}
     *
     * @stability stable
     */
    readonly projectId?: string;
}
/**
 * @stability stable
 */
export declare class NetworkManagementConnectivityTestDestinationOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _instance?;
    /**
     * @stability stable
     */
    get instance(): string | undefined;
    /**
     * @stability stable
     */
    set instance(value: string | undefined);
    /**
     * @stability stable
     */
    resetInstance(): void;
    /**
     * @stability stable
     */
    get instanceInput(): string | undefined;
    private _ipAddress?;
    /**
     * @stability stable
     */
    get ipAddress(): string | undefined;
    /**
     * @stability stable
     */
    set ipAddress(value: string | undefined);
    /**
     * @stability stable
     */
    resetIpAddress(): void;
    /**
     * @stability stable
     */
    get ipAddressInput(): string | undefined;
    private _network?;
    /**
     * @stability stable
     */
    get network(): string | undefined;
    /**
     * @stability stable
     */
    set network(value: string | undefined);
    /**
     * @stability stable
     */
    resetNetwork(): void;
    /**
     * @stability stable
     */
    get networkInput(): string | undefined;
    private _port?;
    /**
     * @stability stable
     */
    get port(): number | undefined;
    /**
     * @stability stable
     */
    set port(value: number | undefined);
    /**
     * @stability stable
     */
    resetPort(): void;
    /**
     * @stability stable
     */
    get portInput(): number | undefined;
    private _projectId?;
    /**
     * @stability stable
     */
    get projectId(): string | undefined;
    /**
     * @stability stable
     */
    set projectId(value: string | undefined);
    /**
     * @stability stable
     */
    resetProjectId(): void;
    /**
     * @stability stable
     */
    get projectIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface NetworkManagementConnectivityTestSource {
    /**
     * A Compute Engine instance URI.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test.html#instance NetworkManagementConnectivityTest#instance}
     *
     * @stability stable
     */
    readonly instance?: string;
    /**
     * The IP address of the endpoint, which can be an external or internal IP.
     *
     * An IPv6 address is only allowed when the test's
     * destination is a global load balancer VIP.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test.html#ip_address NetworkManagementConnectivityTest#ip_address}
     *
     * @stability stable
     */
    readonly ipAddress?: string;
    /**
     * A Compute Engine network URI.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test.html#network NetworkManagementConnectivityTest#network}
     *
     * @stability stable
     */
    readonly network?: string;
    /**
     * Type of the network where the endpoint is located. Possible values: ["GCP_NETWORK", "NON_GCP_NETWORK"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test.html#network_type NetworkManagementConnectivityTest#network_type}
     *
     * @stability stable
     */
    readonly networkType?: string;
    /**
     * The IP protocol port of the endpoint. Only applicable when protocol is TCP or UDP.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test.html#port NetworkManagementConnectivityTest#port}
     *
     * @stability stable
     */
    readonly port?: number;
    /**
     * Project ID where the endpoint is located.
     *
     * The Project ID can be
     * derived from the URI if you provide a VM instance or network URI.
     * The following are two cases where you must provide the project ID:
     *
     * 1. Only the IP address is specified, and the IP address is
     * within a GCP project.
     * 2. When you are using Shared VPC and the IP address
     * that you provide is from the service project. In this case,
     * the network that the IP address resides in is defined in the
     * host project.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test.html#project_id NetworkManagementConnectivityTest#project_id}
     *
     * @stability stable
     */
    readonly projectId?: string;
}
/**
 * @stability stable
 */
export declare class NetworkManagementConnectivityTestSourceOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _instance?;
    /**
     * @stability stable
     */
    get instance(): string | undefined;
    /**
     * @stability stable
     */
    set instance(value: string | undefined);
    /**
     * @stability stable
     */
    resetInstance(): void;
    /**
     * @stability stable
     */
    get instanceInput(): string | undefined;
    private _ipAddress?;
    /**
     * @stability stable
     */
    get ipAddress(): string | undefined;
    /**
     * @stability stable
     */
    set ipAddress(value: string | undefined);
    /**
     * @stability stable
     */
    resetIpAddress(): void;
    /**
     * @stability stable
     */
    get ipAddressInput(): string | undefined;
    private _network?;
    /**
     * @stability stable
     */
    get network(): string | undefined;
    /**
     * @stability stable
     */
    set network(value: string | undefined);
    /**
     * @stability stable
     */
    resetNetwork(): void;
    /**
     * @stability stable
     */
    get networkInput(): string | undefined;
    private _networkType?;
    /**
     * @stability stable
     */
    get networkType(): string | undefined;
    /**
     * @stability stable
     */
    set networkType(value: string | undefined);
    /**
     * @stability stable
     */
    resetNetworkType(): void;
    /**
     * @stability stable
     */
    get networkTypeInput(): string | undefined;
    private _port?;
    /**
     * @stability stable
     */
    get port(): number | undefined;
    /**
     * @stability stable
     */
    set port(value: number | undefined);
    /**
     * @stability stable
     */
    resetPort(): void;
    /**
     * @stability stable
     */
    get portInput(): number | undefined;
    private _projectId?;
    /**
     * @stability stable
     */
    get projectId(): string | undefined;
    /**
     * @stability stable
     */
    set projectId(value: string | undefined);
    /**
     * @stability stable
     */
    resetProjectId(): void;
    /**
     * @stability stable
     */
    get projectIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface NetworkManagementConnectivityTestTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test.html#create NetworkManagementConnectivityTest#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test.html#delete NetworkManagementConnectivityTest#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test.html#update NetworkManagementConnectivityTest#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export declare class NetworkManagementConnectivityTestTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string | undefined;
    /**
     * @stability stable
     */
    set update(value: string | undefined);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test.html google_network_management_connectivity_test}.
 *
 * @stability stable
 */
export declare class NetworkManagementConnectivityTest extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/network_management_connectivity_test.html google_network_management_connectivity_test} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: NetworkManagementConnectivityTestConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string | undefined;
    /**
     * @stability stable
     */
    set description(value: string | undefined);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string | undefined;
    /**
     * @stability stable
     */
    set project(value: string | undefined);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _protocol?;
    /**
     * @stability stable
     */
    get protocol(): string | undefined;
    /**
     * @stability stable
     */
    set protocol(value: string | undefined);
    /**
     * @stability stable
     */
    resetProtocol(): void;
    /**
     * @stability stable
     */
    get protocolInput(): string | undefined;
    private _relatedProjects?;
    /**
     * @stability stable
     */
    get relatedProjects(): string[] | undefined;
    /**
     * @stability stable
     */
    set relatedProjects(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetRelatedProjects(): void;
    /**
     * @stability stable
     */
    get relatedProjectsInput(): string[] | undefined;
    private _destination?;
    private __destinationOutput;
    /**
     * @stability stable
     */
    get destination(): NetworkManagementConnectivityTestDestinationOutputReference;
    /**
     * @stability stable
     */
    putDestination(value: NetworkManagementConnectivityTestDestination): void;
    /**
     * @stability stable
     */
    get destinationInput(): NetworkManagementConnectivityTestDestination | undefined;
    private _source?;
    private __sourceOutput;
    /**
     * @stability stable
     */
    get source(): NetworkManagementConnectivityTestSourceOutputReference;
    /**
     * @stability stable
     */
    putSource(value: NetworkManagementConnectivityTestSource): void;
    /**
     * @stability stable
     */
    get sourceInput(): NetworkManagementConnectivityTestSource | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): NetworkManagementConnectivityTestTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: NetworkManagementConnectivityTestTimeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): NetworkManagementConnectivityTestTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
