import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
/**
 * (experimental) Statement provider for service [deepracer](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsdeepracer.html).
 *
 * @experimental
 */
export declare class Deepracer extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [deepracer](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsdeepracer.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to clone existing DeepRacer models.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-console-train-evaluate-models.html#deepracer-clone-trained-model
     *
     * @experimental
     */
    toCloneReinforcementLearningModel(): this;
    /**
     * (experimental) Grants permission to create resources needed by DeepRacer on behalf of the user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-training-model.html
     *
     * @experimental
     */
    toCreateAccountResources(): this;
    /**
     * (experimental) Grants permission to submit DeepRacer models to be evaluated for leaderboards.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-submit-model-to-leaderboard.html
     *
     * @experimental
     */
    toCreateLeaderboardSubmission(): this;
    /**
     * (experimental) Grants permission to create reinforcement learning models for DeepRacer.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-training-model.html
     *
     * @experimental
     */
    toCreateReinforcementLearningModel(): this;
    /**
     * (experimental) Grants permission to delete resources created by DeepRacer on behalf of the user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-training-model.html
     *
     * @experimental
     */
    toDeleteAccountResources(): this;
    /**
     * (experimental) Grants permission to delete DeepRacer models.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-training-model.html
     *
     * @experimental
     */
    toDeleteModel(): this;
    /**
     * (experimental) Grants permission to retrieve the resources created by DeepRacer on behalf of the user.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-training-model.html
     *
     * @experimental
     */
    toGetAccountResources(): this;
    /**
     * (experimental) Grants permission to retrieve the user's alias for submitting DeepRacer models to leaderboards.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-submit-model-to-leaderboard.html
     *
     * @experimental
     */
    toGetAlias(): this;
    /**
     * (experimental) Grants permission to retrieve information about existing DeepRacer models' evaluation jobs.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-test-in-simulator.html
     *
     * @experimental
     */
    toGetEvaluation(): this;
    /**
     * (experimental) Grants permission to retrieve information about how the latest submitted DeepRacer model for a user performed on a leaderboard.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-submit-model-to-leaderboard.html
     *
     * @experimental
     */
    toGetLatestUserSubmission(): this;
    /**
     * (experimental) Grants permission to retrieve information about leaderboards.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-submit-model-to-leaderboard.html
     *
     * @experimental
     */
    toGetLeaderboard(): this;
    /**
     * (experimental) Grants permission to retrieve information about existing DeepRacer models.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-training-model.html
     *
     * @experimental
     */
    toGetModel(): this;
    /**
     * (experimental) Grants permission to retrieve information about the performance of a user's DeepRacer model that got placed on a leaderboard.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-submit-model-to-leaderboard.html
     *
     * @experimental
     */
    toGetRankedUserSubmission(): this;
    /**
     * (experimental) Grants permission to retrieve information about DeepRacer tracks.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-console-train-evaluate-models.html
     *
     * @experimental
     */
    toGetTrack(): this;
    /**
     * (experimental) Grants permission to retrieve information about existing DeepRacer models' training job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-training-model.html
     *
     * @experimental
     */
    toGetTrainingJob(): this;
    /**
     * (experimental) Grants permission to list DeepRacer models' evaluation jobs.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-test-in-simulator.html
     *
     * @experimental
     */
    toListEvaluations(): this;
    /**
     * (experimental) Grants permission to list all the submissions of DeepRacer models of a user on a leaderboard.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-submit-model-to-leaderboard.html
     *
     * @experimental
     */
    toListLeaderboardSubmissions(): this;
    /**
     * (experimental) Grants permission to list all the available leaderboards.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-submit-model-to-leaderboard.html
     *
     * @experimental
     */
    toListLeaderboards(): this;
    /**
     * (experimental) Grants permission to list all existing DeepRacer models.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-training-model.html
     *
     * @experimental
     */
    toListModels(): this;
    /**
     * (experimental) Grants permission to list all DeepRacer tracks.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-console-train-evaluate-models.html
     *
     * @experimental
     */
    toListTracks(): this;
    /**
     * (experimental) Grants permission to list DeepRacer models' training jobs.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-training-model.html
     *
     * @experimental
     */
    toListTrainingJobs(): this;
    /**
     * (experimental) Grants permission to set the user's alias for submitting DeepRacer models to leaderboards.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-submit-model-to-leaderboard.html
     *
     * @experimental
     */
    toSetAlias(): this;
    /**
     * (experimental) Grants permission to evaluate DeepRacer models in a simulated environment.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-test-in-simulator.html
     *
     * @experimental
     */
    toStartEvaluation(): this;
    /**
     * (experimental) Grants permission to stop DeepRacer model evaluations.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-test-in-simulator.html
     *
     * @experimental
     */
    toStopEvaluation(): this;
    /**
     * (experimental) Grants permission to stop training DeepRacer models.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-training-model.html
     *
     * @experimental
     */
    toStopTrainingReinforcementLearningModel(): this;
    /**
     * (experimental) Grants permission to test reward functions for correctness.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-console-train-evaluate-models.html#deepracer-train-models-define-reward-function
     *
     * @experimental
     */
    toTestRewardFunction(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type reinforcement_learning_model to the statement.
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-training-model.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onReinforcementLearningModel(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type training_job to the statement.
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-training-model.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onTrainingJob(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type evaluation_job to the statement.
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-test-in-simulator.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onEvaluationJob(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type leaderboard_evaluation_job to the statement.
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-submit-model-to-leaderboard.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onLeaderboardEvaluationJob(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type track to the statement.
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-console-train-evaluate-models.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onTrack(resourceId: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type leaderboard to the statement.
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-submit-model-to-leaderboard.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onLeaderboard(resourceId: string, region?: string, partition?: string): this;
}
