"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Lookoutmetrics = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * (experimental) Statement provider for service [lookoutmetrics](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonlookoutformetrics.html).
 *
 * @experimental
 */
class Lookoutmetrics extends shared_1.PolicyStatement {
    /**
     * (experimental) Statement provider for service [lookoutmetrics](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonlookoutformetrics.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid) {
        super(sid);
        /**
         * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
         *
         * @experimental
         */
        this.servicePrefix = 'lookoutmetrics';
        /**
         * @experimental
         */
        this.accessLevelList = {
            "Write": [
                "ActivateAnomalyDetector",
                "BackTestAnomalyDetector",
                "CreateAlert",
                "CreateAnomalyDetector",
                "CreateMetricSet",
                "DeleteAlert",
                "DeleteAnomalyDetector",
                "PutFeedback",
                "UpdateAnomalyDetector",
                "UpdateMetricSet"
            ],
            "Read": [
                "DescribeAlert",
                "DescribeAnomalyDetectionExecutions",
                "DescribeAnomalyDetector",
                "DescribeMetricSet",
                "GetAnomalyGroup",
                "GetDataQualityMetrics",
                "GetFeedback",
                "GetSampleData"
            ],
            "List": [
                "ListAlerts",
                "ListAnomalyDetectors",
                "ListAnomalyGroupSummaries",
                "ListAnomalyGroupTimeSeries",
                "ListMetricSets"
            ]
        };
    }
    /**
     * (experimental) Grants permission to activate an anomaly detector.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_ActivateAnomalyDetector.html
     *
     * @experimental
     */
    toActivateAnomalyDetector() {
        return this.to('ActivateAnomalyDetector');
    }
    /**
     * (experimental) Grants permission to run a backtest with an anomaly detector.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_BackTestAnomalyDetector.html
     *
     * @experimental
     */
    toBackTestAnomalyDetector() {
        return this.to('BackTestAnomalyDetector');
    }
    /**
     * (experimental) Grants permission to create an alert for an anomaly detector.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_CreateAlert.html
     *
     * @experimental
     */
    toCreateAlert() {
        return this.to('CreateAlert');
    }
    /**
     * (experimental) Grants permission to create an anomaly detector.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_CreateAnomalyDetector.html
     *
     * @experimental
     */
    toCreateAnomalyDetector() {
        return this.to('CreateAnomalyDetector');
    }
    /**
     * (experimental) Grants permission to create a dataset.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_CreateMetricSet.html
     *
     * @experimental
     */
    toCreateMetricSet() {
        return this.to('CreateMetricSet');
    }
    /**
     * (experimental) Grants permission to delete an alert.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_DeleteAlert.html
     *
     * @experimental
     */
    toDeleteAlert() {
        return this.to('DeleteAlert');
    }
    /**
     * (experimental) Grants permission to delete an anomaly detector.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_DeleteAnomalyDetector.html
     *
     * @experimental
     */
    toDeleteAnomalyDetector() {
        return this.to('DeleteAnomalyDetector');
    }
    /**
     * (experimental) Grants permission to get details about an alert.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_DescribeAlert.html
     *
     * @experimental
     */
    toDescribeAlert() {
        return this.to('DescribeAlert');
    }
    /**
     * (experimental) Grants permission to get information about an anomaly detection job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_DescribeAnomalyDetectionExecutions.html
     *
     * @experimental
     */
    toDescribeAnomalyDetectionExecutions() {
        return this.to('DescribeAnomalyDetectionExecutions');
    }
    /**
     * (experimental) Grants permission to get details about an anomaly detector.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_DescribeAnomalyDetector.html
     *
     * @experimental
     */
    toDescribeAnomalyDetector() {
        return this.to('DescribeAnomalyDetector');
    }
    /**
     * (experimental) Grants permission to get details about a dataset.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_DescribeMetricSet.html
     *
     * @experimental
     */
    toDescribeMetricSet() {
        return this.to('DescribeMetricSet');
    }
    /**
     * (experimental) Grants permission to get details about a group of affected metrics.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_GetAnomalyGroup.html
     *
     * @experimental
     */
    toGetAnomalyGroup() {
        return this.to('GetAnomalyGroup');
    }
    /**
     * (experimental) Grants permission to get data quality metrics for an anomaly detector.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_GetDataQualityMetrics.html
     *
     * @experimental
     */
    toGetDataQualityMetrics() {
        return this.to('GetDataQualityMetrics');
    }
    /**
     * (experimental) Grants permission to get feedback on affected metrics for an anomaly group.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_GetFeedback.html
     *
     * @experimental
     */
    toGetFeedback() {
        return this.to('GetFeedback');
    }
    /**
     * (experimental) Grants permission to get a selection of sample records from an Amazon S3 datasource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_GetSampleData.html
     *
     * @experimental
     */
    toGetSampleData() {
        return this.to('GetSampleData');
    }
    /**
     * (experimental) Grants permission to get a list of alerts for a detector.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_ListAlerts.html
     *
     * @experimental
     */
    toListAlerts() {
        return this.to('ListAlerts');
    }
    /**
     * (experimental) Grants permission to get a list of anomaly detectors.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_ListAnomalyDetectors.html
     *
     * @experimental
     */
    toListAnomalyDetectors() {
        return this.to('ListAnomalyDetectors');
    }
    /**
     * (experimental) Grants permission to get a list of anomaly groups.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_ListAnomalyGroupSummaries.html
     *
     * @experimental
     */
    toListAnomalyGroupSummaries() {
        return this.to('ListAnomalyGroupSummaries');
    }
    /**
     * (experimental) Grants permission to get a list of affected metrics for a measure in an anomaly group.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_ListAnomalyGroupTimeSeries.html
     *
     * @experimental
     */
    toListAnomalyGroupTimeSeries() {
        return this.to('ListAnomalyGroupTimeSeries');
    }
    /**
     * (experimental) Grants permission to get a list of datasets.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_ListMetricSets.html
     *
     * @experimental
     */
    toListMetricSets() {
        return this.to('ListMetricSets');
    }
    /**
     * (experimental) Grants permission to add feedback for an affected metric in an anomaly group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_PutFeedback.html
     *
     * @experimental
     */
    toPutFeedback() {
        return this.to('PutFeedback');
    }
    /**
     * (experimental) Grants permission to update an anomaly detector.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_UpdateAnomalyDetector.html
     *
     * @experimental
     */
    toUpdateAnomalyDetector() {
        return this.to('UpdateAnomalyDetector');
    }
    /**
     * (experimental) Grants permission to update a dataset.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_UpdateMetricSet.html
     *
     * @experimental
     */
    toUpdateMetricSet() {
        return this.to('UpdateMetricSet');
    }
    /**
     * (experimental) Adds a resource of type AnomalyDetector to the statement.
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_AnomalyDetector.html
     *
     * @param anomalyDetectorName - Identifier for the anomalyDetectorName.
     * @param account - Account of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onAnomalyDetector(anomalyDetectorName, account, partition) {
        var arn = 'arn:${Partition}:lookoutmetrics::${Account}:AnomalyDetector:${AnomalyDetectorName}';
        arn = arn.replace('${AnomalyDetectorName}', anomalyDetectorName);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * (experimental) Adds a resource of type MetricSet to the statement.
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/api/API_MetricSet.html
     *
     * @param anomalyDetectorName - Identifier for the anomalyDetectorName.
     * @param metricSetName - Identifier for the metricSetName.
     * @param account - Account of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onMetricSet(anomalyDetectorName, metricSetName, account, partition) {
        var arn = 'arn:${Partition}:lookoutmetrics::${Account}:MetricSet/${AnomalyDetectorName}/${MetricSetName}';
        arn = arn.replace('${AnomalyDetectorName}', anomalyDetectorName);
        arn = arn.replace('${MetricSetName}', metricSetName);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * (experimental) Adds a resource of type Alert to the statement.
     *
     * https://docs.aws.amazon.com/lookoutmetrics/latest/dev/API_Alert.html
     *
     * @param alertName - Identifier for the alertName.
     * @param account - Account of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onAlert(alertName, account, partition) {
        var arn = 'arn:${Partition}:lookoutmetrics::${Account}:Alert:${AlertName}';
        arn = arn.replace('${AlertName}', alertName);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
}
exports.Lookoutmetrics = Lookoutmetrics;
_a = JSII_RTTI_SYMBOL_1;
Lookoutmetrics[_a] = { fqn: "iam-floyd.Lookoutmetrics", version: "0.153.0" };
//# sourceMappingURL=data:application/json;base64,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