import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
/**
 * (experimental) Statement provider for service [ec2messages](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmessagedeliveryservice.html).
 *
 * @experimental
 */
export declare class Ec2messages extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [ec2messages](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmessagedeliveryservice.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to acknowledge a message, ensuring it will not be delivered again.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmessagedeliveryservice.html
     *
     * @experimental
     */
    toAcknowledgeMessage(): this;
    /**
     * (experimental) Grants permission to delete a message.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmessagedeliveryservice.html
     *
     * @experimental
     */
    toDeleteMessage(): this;
    /**
     * (experimental) Grants permission to fail a message, signifying the message could not be processed successfully, ensuring it cannot be replied to or delivered again.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmessagedeliveryservice.html
     *
     * @experimental
     */
    toFailMessage(): this;
    /**
     * (experimental) Grants permission to route traffic to the correct endpoint based on the given destination for the messages.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmessagedeliveryservice.html
     *
     * @experimental
     */
    toGetEndpoint(): this;
    /**
     * (experimental) Grants permission to deliver messages to clients/instances using long polling.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmessagedeliveryservice.html
     *
     * @experimental
     */
    toGetMessages(): this;
    /**
     * (experimental) Grants permission to send replies from clients/instances to upstream service.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmessagedeliveryservice.html
     *
     * @experimental
     */
    toSendReply(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
}
