import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement, Operator } from "../shared";
/**
 * (experimental) Statement provider for service [ses](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonses.html).
 *
 * @experimental
 */
export declare class Ses extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [ses](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonses.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Creates a receipt rule set by cloning an existing one.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_CloneReceiptRuleSet.html
     *
     * @experimental
     */
    toCloneReceiptRuleSet(): this;
    /**
     * (experimental) Creates a new configuration set.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_CreateConfigurationSet.html
     *
     * @experimental
     */
    toCreateConfigurationSet(): this;
    /**
     * (experimental) Creates a configuration set event destination.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_CreateConfigurationSetEventDestination.html
     *
     * @experimental
     */
    toCreateConfigurationSetEventDestination(): this;
    /**
     * (experimental) Creates an association between a configuration set and a custom domain for open and click event tracking.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_CreateConfigurationSetTrackingOptions.html
     *
     * @experimental
     */
    toCreateConfigurationSetTrackingOptions(): this;
    /**
     * (experimental) Creates a new custom verification email template.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_CreateCustomVerificationEmailTemplate.html
     *
     * @experimental
     */
    toCreateCustomVerificationEmailTemplate(): this;
    /**
     * (experimental) Creates a new IP address filter.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_CreateReceiptFilter.html
     *
     * @experimental
     */
    toCreateReceiptFilter(): this;
    /**
     * (experimental) Creates a receipt rule.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_CreateReceiptRule.html
     *
     * @experimental
     */
    toCreateReceiptRule(): this;
    /**
     * (experimental) Creates an empty receipt rule set.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_CreateReceiptRuleSet.html
     *
     * @experimental
     */
    toCreateReceiptRuleSet(): this;
    /**
     * (experimental) Creates an email template.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_CreateTemplate.html
     *
     * @experimental
     */
    toCreateTemplate(): this;
    /**
     * (experimental) Deletes the configuration set.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_DeleteConfigurationSet.html
     *
     * @experimental
     */
    toDeleteConfigurationSet(): this;
    /**
     * (experimental) Deletes a configuration set event destination.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_DeleteConfigurationSetEventDestination.html
     *
     * @experimental
     */
    toDeleteConfigurationSetEventDestination(): this;
    /**
     * (experimental) Deletes an association between a configuration set and a custom domain for open and click event tracking.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_DeleteConfigurationSetTrackingOptions.html
     *
     * @experimental
     */
    toDeleteConfigurationSetTrackingOptions(): this;
    /**
     * (experimental) Deletes an existing custom verification email template.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_DeleteCustomVerificationEmailTemplate.html
     *
     * @experimental
     */
    toDeleteCustomVerificationEmailTemplate(): this;
    /**
     * (experimental) Deletes the specified identity (an email address or a domain) from the list of verified identities.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_DeleteIdentity.html
     *
     * @experimental
     */
    toDeleteIdentity(): this;
    /**
     * (experimental) Deletes the specified identity (an email address or a domain) from the list of verified identities.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_DeleteIdentityPolicy.html
     *
     * @experimental
     */
    toDeleteIdentityPolicy(): this;
    /**
     * (experimental) Deletes the specified IP address filter.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_DeleteReceiptFilter.html
     *
     * @experimental
     */
    toDeleteReceiptFilter(): this;
    /**
     * (experimental) Deletes the specified receipt rule.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_DeleteReceiptRule.html
     *
     * @experimental
     */
    toDeleteReceiptRule(): this;
    /**
     * (experimental) Deletes the specified receipt rule set and all of the receipt rules it contains.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_DeleteReceiptRuleSet.html
     *
     * @experimental
     */
    toDeleteReceiptRuleSet(): this;
    /**
     * (experimental) Deletes an email template.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_DeleteTemplate.html
     *
     * @experimental
     */
    toDeleteTemplate(): this;
    /**
     * (experimental) Deletes the specified email address from the list of verified addresses.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_DeleteVerifiedEmailAddress.html
     *
     * @experimental
     */
    toDeleteVerifiedEmailAddress(): this;
    /**
     * (experimental) Returns the metadata and receipt rules for the receipt rule set that is currently active.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_DescribeActiveReceiptRuleSet.html
     *
     * @experimental
     */
    toDescribeActiveReceiptRuleSet(): this;
    /**
     * (experimental) Returns the details of the specified configuration set.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_DescribeConfigurationSet.html
     *
     * @experimental
     */
    toDescribeConfigurationSet(): this;
    /**
     * (experimental) Returns the details of the specified receipt rule.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_DescribeReceiptRule.html
     *
     * @experimental
     */
    toDescribeReceiptRule(): this;
    /**
     * (experimental) Returns the details of the specified receipt rule set.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_DescribeReceiptRuleSet.html
     *
     * @experimental
     */
    toDescribeReceiptRuleSet(): this;
    /**
     * (experimental) Returns the email sending status of the Amazon SES account for the current region.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_GetAccountSendingEnabled.html
     *
     * @experimental
     */
    toGetAccountSendingEnabled(): this;
    /**
     * (experimental) Returns the custom email verification template for the template name you specify.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_GetCustomVerificationEmailTemplate.html
     *
     * @experimental
     */
    toGetCustomVerificationEmailTemplate(): this;
    /**
     * (experimental) Returns the current status of Easy DKIM signing for an entity.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_GetIdentityDkimAttributes.html
     *
     * @experimental
     */
    toGetIdentityDkimAttributes(): this;
    /**
     * (experimental) Returns the custom MAIL FROM attributes for a list of identities (email addresses and/or domains).
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_GetIdentityMailFromDomainAttributes.html
     *
     * @experimental
     */
    toGetIdentityMailFromDomainAttributes(): this;
    /**
     * (experimental) Given a list of verified identities (email addresses and/or domains), returns a structure describing identity notification attributes.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_GetIdentityNotificationAttributes.html
     *
     * @experimental
     */
    toGetIdentityNotificationAttributes(): this;
    /**
     * (experimental) Returns the requested sending authorization policies for the given identity (an email address or a domain).
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_GetIdentityPolicies.html
     *
     * @experimental
     */
    toGetIdentityPolicies(): this;
    /**
     * (experimental) Given a list of identities (email addresses and/or domains), returns the verification status and (for domain identities) the verification token for each identity.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_GetIdentityVerificationAttributes.html
     *
     * @experimental
     */
    toGetIdentityVerificationAttributes(): this;
    /**
     * (experimental) Returns the user's current sending limits.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_GetSendQuota.html
     *
     * @experimental
     */
    toGetSendQuota(): this;
    /**
     * (experimental) Returns the user's sending statistics.
     *
     * The result is a list of data points, representing the last two weeks of sending activity
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_GetSendStatistics.html
     *
     * @experimental
     */
    toGetSendStatistics(): this;
    /**
     * (experimental) Returns the template object (which includes the Subject line, HTML part and text part) for the template you specify.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_GetTemplate.html
     *
     * @experimental
     */
    toGetTemplate(): this;
    /**
     * (experimental) Returns a list of the configuration sets associated with your Amazon SES account in the current AWS Region.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_ListConfigurationSets.html
     *
     * @experimental
     */
    toListConfigurationSets(): this;
    /**
     * (experimental) Lists the existing custom verification email templates for your account in the current AWS Region.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_ListCustomVerificationEmailTemplates.html
     *
     * @experimental
     */
    toListCustomVerificationEmailTemplates(): this;
    /**
     * (experimental) Returns a list containing all of the identities (email addresses and domains) for your AWS account, regardless of verification status.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_ListIdentities.html
     *
     * @experimental
     */
    toListIdentities(): this;
    /**
     * (experimental) Returns a list of sending authorization policies that are attached to the given identity (an email address or a domain).
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_ListIdentityPolicies.html
     *
     * @experimental
     */
    toListIdentityPolicies(): this;
    /**
     * (experimental) Lists the IP address filters associated with your AWS account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_ListReceiptFilters.html
     *
     * @experimental
     */
    toListReceiptFilters(): this;
    /**
     * (experimental) Lists the receipt rule sets that exist under your AWS account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_ListReceiptRuleSets.html
     *
     * @experimental
     */
    toListReceiptRuleSets(): this;
    /**
     * (experimental) Lists the email templates present in your Amazon SES account in the current AWS Region.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_ListTemplates.html
     *
     * @experimental
     */
    toListTemplates(): this;
    /**
     * (experimental) Returns a list containing all of the email addresses that have been verified.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_ListVerifiedEmailAddresses.html
     *
     * @experimental
     */
    toListVerifiedEmailAddresses(): this;
    /**
     * (experimental) Adds or updates a sending authorization policy for the specified identity (an email address or a domain).
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_PutIdentityPolicy.html
     *
     * @experimental
     */
    toPutIdentityPolicy(): this;
    /**
     * (experimental) Reorders the receipt rules within a receipt rule set.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_ReorderReceiptRuleSet.html
     *
     * @experimental
     */
    toReorderReceiptRuleSet(): this;
    /**
     * (experimental) Generates and sends a bounce message to the sender of an email you received through Amazon SES.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifFromAddress()
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_SendBounce.html
     *
     * @experimental
     */
    toSendBounce(): this;
    /**
     * (experimental) Composes an email message to multiple destinations.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifFeedbackAddress()
     * - .ifFromAddress()
     * - .ifFromDisplayName()
     * - .ifRecipients()
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_SendBulkTemplatedEmail.html
     *
     * @experimental
     */
    toSendBulkTemplatedEmail(): this;
    /**
     * (experimental) Adds an email address to the list of identities for your Amazon SES account in the current AWS Region and attempts to verify it.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifFeedbackAddress()
     * - .ifFromAddress()
     * - .ifFromDisplayName()
     * - .ifRecipients()
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_SendCustomVerificationEmail.html
     *
     * @experimental
     */
    toSendCustomVerificationEmail(): this;
    /**
     * (experimental) Composes an email message based on input data, and then immediately queues the message for sending.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifFeedbackAddress()
     * - .ifFromAddress()
     * - .ifFromDisplayName()
     * - .ifRecipients()
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_SendEmail.html
     *
     * @experimental
     */
    toSendEmail(): this;
    /**
     * (experimental) Sends an email message, with header and content specified by the client.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifFeedbackAddress()
     * - .ifFromAddress()
     * - .ifFromDisplayName()
     * - .ifRecipients()
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_SendRawEmail.html
     *
     * @experimental
     */
    toSendRawEmail(): this;
    /**
     * (experimental) Composes an email message using an email template and immediately queues it for sending.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifFeedbackAddress()
     * - .ifFromAddress()
     * - .ifFromDisplayName()
     * - .ifRecipients()
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_SendTemplatedEmail.html
     *
     * @experimental
     */
    toSendTemplatedEmail(): this;
    /**
     * (experimental) Sets the specified receipt rule set as the active receipt rule set.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_SetActiveReceiptRuleSet.html
     *
     * @experimental
     */
    toSetActiveReceiptRuleSet(): this;
    /**
     * (experimental) Enables or disables Easy DKIM signing of email sent from an identity.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_SetIdentityDkimEnabled.html
     *
     * @experimental
     */
    toSetIdentityDkimEnabled(): this;
    /**
     * (experimental) Given an identity (an email address or a domain), enables or disables whether Amazon SES forwards bounce and complaint notifications as email.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_SetIdentityFeedbackForwardingEnabled.html
     *
     * @experimental
     */
    toSetIdentityFeedbackForwardingEnabled(): this;
    /**
     * (experimental) Given an identity (an email address or a domain), sets whether Amazon SES includes the original email headers in the Amazon Simple Notification Service (Amazon SNS) notifications of a specified type.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_SetIdentityHeadersInNotificationsEnabled.html
     *
     * @experimental
     */
    toSetIdentityHeadersInNotificationsEnabled(): this;
    /**
     * (experimental) Enables or disables the custom MAIL FROM domain setup for a verified identity (an email address or a domain).
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_SetIdentityMailFromDomain.html
     *
     * @experimental
     */
    toSetIdentityMailFromDomain(): this;
    /**
     * (experimental) Given an identity (an email address or a domain), sets the Amazon Simple Notification Service (Amazon SNS) topic to which Amazon SES will publish bounce, complaint, and/or delivery notifications for emails sent with that identity as the Source.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_SetIdentityNotificationTopic.html
     *
     * @experimental
     */
    toSetIdentityNotificationTopic(): this;
    /**
     * (experimental) Sets the position of the specified receipt rule in the receipt rule set.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_SetReceiptRulePosition.html
     *
     * @experimental
     */
    toSetReceiptRulePosition(): this;
    /**
     * (experimental) Creates a preview of the MIME content of an email when provided with a template and a set of replacement data.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_TestRenderTemplate.html
     *
     * @experimental
     */
    toTestRenderTemplate(): this;
    /**
     * (experimental) Enables or disables email sending across your entire Amazon SES account in the current AWS Region.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_UpdateAccountSendingEnabled.html
     *
     * @experimental
     */
    toUpdateAccountSendingEnabled(): this;
    /**
     * (experimental) Updates the event destination of a configuration set.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_UpdateConfigurationSetEventDestination.html
     *
     * @experimental
     */
    toUpdateConfigurationSetEventDestination(): this;
    /**
     * (experimental) Enables or disables the publishing of reputation metrics for emails sent using a specific configuration set in a given AWS Region.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_UpdateConfigurationSetReputationMetricsEnabled.html
     *
     * @experimental
     */
    toUpdateConfigurationSetReputationMetricsEnabled(): this;
    /**
     * (experimental) Enables or disables email sending for messages sent using a specific configuration set in a given AWS Region.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_UpdateConfigurationSetSendingEnabled.html
     *
     * @experimental
     */
    toUpdateConfigurationSetSendingEnabled(): this;
    /**
     * (experimental) Modifies an association between a configuration set and a custom domain for open and click event tracking.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_UpdateConfigurationSetTrackingOptions.html
     *
     * @experimental
     */
    toUpdateConfigurationSetTrackingOptions(): this;
    /**
     * (experimental) Updates an existing custom verification email template.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_UpdateCustomVerificationEmailTemplate.html
     *
     * @experimental
     */
    toUpdateCustomVerificationEmailTemplate(): this;
    /**
     * (experimental) Updates a receipt rule.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_UpdateReceiptRule.html
     *
     * @experimental
     */
    toUpdateReceiptRule(): this;
    /**
     * (experimental) Updates an email template.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_UpdateTemplate.html
     *
     * @experimental
     */
    toUpdateTemplate(): this;
    /**
     * (experimental) Returns a set of DKIM tokens for a domain.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_VerifyDomainDkim.html
     *
     * @experimental
     */
    toVerifyDomainDkim(): this;
    /**
     * (experimental) Verifies a domain.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_VerifyDomainIdentity.html
     *
     * @experimental
     */
    toVerifyDomainIdentity(): this;
    /**
     * (experimental) Verifies an email address.
     *
     * This action causes a confirmation email message to be sent to the specified address. This action is throttled at one request per second
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_VerifyEmailAddress.html
     *
     * @experimental
     */
    toVerifyEmailAddress(): this;
    /**
     * (experimental) Verifies an email address.
     *
     * This action causes a confirmation email message to be sent to the specified address. This action is throttled at one request per second
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_VerifyEmailIdentity.html
     *
     * @experimental
     */
    toVerifyEmailIdentity(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type configuration-set to the statement.
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_ConfigurationSet.html
     *
     * @param configurationSetName - Identifier for the configurationSetName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onConfigurationSet(configurationSetName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type custom-verification-email-template to the statement.
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_CustomVerificationEmailTemplate.html
     *
     * @param customVerificationEmailTemplateName - Identifier for the customVerificationEmailTemplateName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onCustomVerificationEmailTemplate(customVerificationEmailTemplateName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type event-destination to the statement.
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_EventDestination.html
     *
     * @param configurationSetName - Identifier for the configurationSetName.
     * @param eventDestinationName - Identifier for the eventDestinationName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onEventDestination(configurationSetName: string, eventDestinationName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type identity to the statement.
     *
     * @param identityName - Identifier for the identityName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onIdentity(identityName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type receipt-filter to the statement.
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_ReceiptFilter.html
     *
     * @param receiptFilterName - Identifier for the receiptFilterName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onReceiptFilter(receiptFilterName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type receipt-rule to the statement.
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_ReceiptRule.html
     *
     * @param receiptRuleSetName - Identifier for the receiptRuleSetName.
     * @param receiptRuleName - Identifier for the receiptRuleName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onReceiptRule(receiptRuleSetName: string, receiptRuleName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type receipt-rule-set to the statement.
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_ReceiptRuleSetMetadata.html
     *
     * @param receiptRuleSetName - Identifier for the receiptRuleSetName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onReceiptRuleSet(receiptRuleSetName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type template to the statement.
     *
     * https://docs.aws.amazon.com/ses/latest/APIReference/API_Template.html
     *
     * @param templateName - Identifier for the templateName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onTemplate(templateName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) The "Return-Path" address, which specifies where bounces and complaints are sent by email feedback forwarding.
     *
     * https://docs.aws.amazon.com/ses/latest/DeveloperGuide/email-format.html#email-header
     *
     * Applies to actions:
     * - .toSendBulkTemplatedEmail()
     * - .toSendCustomVerificationEmail()
     * - .toSendEmail()
     * - .toSendRawEmail()
     * - .toSendTemplatedEmail()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifFeedbackAddress(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) The "From" address of a message.
     *
     * https://docs.aws.amazon.com/ses/latest/DeveloperGuide/email-format.html#email-header
     *
     * Applies to actions:
     * - .toSendBounce()
     * - .toSendBulkTemplatedEmail()
     * - .toSendCustomVerificationEmail()
     * - .toSendEmail()
     * - .toSendRawEmail()
     * - .toSendTemplatedEmail()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifFromAddress(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) The "From" address that is used as the display name of a message.
     *
     * https://docs.aws.amazon.com/ses/latest/DeveloperGuide/email-format.html#email-header
     *
     * Applies to actions:
     * - .toSendBulkTemplatedEmail()
     * - .toSendCustomVerificationEmail()
     * - .toSendEmail()
     * - .toSendRawEmail()
     * - .toSendTemplatedEmail()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifFromDisplayName(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) The recipient addresses of a message, which include the "To", "CC", and "BCC" addresses.
     *
     * https://docs.aws.amazon.com/ses/latest/DeveloperGuide/email-format.html#email-header
     *
     * Applies to actions:
     * - .toSendBulkTemplatedEmail()
     * - .toSendCustomVerificationEmail()
     * - .toSendEmail()
     * - .toSendRawEmail()
     * - .toSendTemplatedEmail()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifRecipients(value: string | string[], operator?: Operator | string): this;
}
