from django.db import models

from base_app.models import ModelBase


class GeneralAccount(models.Model):
    """
    Model used for storing the dump
    """
    id = models.AutoField(primary_key=True)
    LOAN_ACCT_NUM = models.CharField(max_length=64)
    ACID = models.CharField(max_length=44)
    CURRENT_BAL = models.IntegerField()
    LMS_SCHM_CODE = models.CharField(max_length=20)
    CIF_ID = models.CharField(max_length=200)
    PRIN_DMD_OS = models.IntegerField()
    INT_DMD_OS = models.IntegerField()
    PAST_DUE_FLG = models.CharField(max_length=1)
    CHRGE_OFF_FLG = models.CharField(max_length=1)
    DISB_DATE = models.DateField()
    ACCT_STATUS = models.CharField(max_length=20, null=True)
    PAYOFF_DATE = models.CharField(max_length=320, null=True)
    PMS_SCHM_ID = models.CharField(max_length=320)
    PMS_SCHM_DESC = models.CharField(max_length=320)
    DPD_CNTR = models.IntegerField()
    DPD_ASON_DATE = models.DateField(null=True)
    INST_START_DATE = models.DateField()
    MATURITY_DATE = models.DateField()
    DEBT_GROUP = models.CharField(max_length=20)
    GAC_LAST_CHANGE_TIME = models.DateField()
    GAC_CREATION_TIME = models.DateField()
    GAM_LAST_CHANGE_TIME = models.DateField()
    GAM_CREATION_TIME = models.DateField()


class RoboIdtView(models.Model):
    """
    Model used for storing the dump
    """
    LOAN_ACCT_NUM = models.CharField(max_length=64)
    SHDL_NUM = models.CharField(max_length=8, null=True)
    DMD_FLOW_ID = models.CharField(max_length=20, null=True)
    ACID = models.CharField(max_length=11)
    DMD_EFF_DATE = models.DateField(null=True)
    DMD_SRL_NUM = models.CharField(max_length=2)
    DMD_OVDU_DATE = models.DateField(null=True)
    DMD_AMT = models.BigIntegerField(null=True)
    TOT_ADJ_AMT = models.IntegerField(null=True)
    LAST_ADJ_DATE = models.DateField(null=True)
    WAIVED_AMT = models.BigIntegerField(null=True)
    LAST_WAIVER_ADJ_DATE = models.DateField(null=True)
    LATEFEE_STATUS_FLG = models.CharField(max_length=1, null=True)
    GAM_CREATION_TIME = models.DateField(null=True)
    GAM_LAST_CHANGE_TIME = models.DateField(null=True)
    LDT_CREATION_TIME = models.DateField(null=True)
    LDT_LAST_CHANGE_TIME = models.DateField(null=True)




class RoboClelarshView(models.Model):
    """
    Model used for storing the dump
    """
    LOAN_ACCT_NUM = models.CharField(max_length=64)
    ACID = models.CharField(max_length=11)
    PRIN_CMP = models.IntegerField(null=True)
    INT_CMP = models.IntegerField(null=True)
    CHRG_CMP = models.IntegerField(null=True)
    TOTAL_FLOW = models.IntegerField(null=True)
    REP_SHDL_DATE = models.DateField(null=True)
    SHDL_NUM = models.CharField(max_length=8)
    BANK_ID = models.CharField(max_length=8)
    RCRE_USER_ID = models.CharField(max_length=60)
    RCRE_TIME = models.DateField(null=True)
    LCHG_USER_ID = models.CharField(max_length=60)
    LCHG_TIME = models.DateField(null=True)
    STATUS_FLG = models.CharField(max_length=4, null=True)
    SRL_NUM = models.CharField(max_length=3)


class RoboRepayUplView(models.Model):
    """
    Model used for storing the dump
    """
    FILE_NAME = models.TextField(null=True)
    PAID_DATE = models.DateField(null=True)
    REF_NUM = models.CharField(max_length=240, null=True)
    BANK_ID = models.CharField(max_length=32)
    LOAN_ACCT_NUM = models.CharField(max_length=80, null=True)
    UPLOAD_DATE = models.DateField(null=True)
    CUSTOMER_NAME = models.TextField(null=True)
    LCHG_TIME = models.DateField(null=True)
    DESCRIPTION = models.TextField(null=True)
    SRL_NUM = models.CharField(max_length=60)
    FAIL_REASON = models.TextField(null=True)
    PAID_AMT = models.IntegerField(null=True)
    ACCT_CURRENCY = models.CharField(max_length=12, null=True)
    CUSTOMER_BANK_ACCOUNT = models.CharField(max_length=80, null=True)
    CHEQUE_ID = models.CharField(max_length=80, null=True)
    RCRE_TIME = models.DateField(null=True)
    FAIL_FLG = models.CharField(max_length=60, null=True)
    LCHG_USER_ID = models.CharField(max_length=60, null=True)
    RCRE_USER_ID = models.CharField(max_length=60, null=True)


class RoboChatView(models.Model):
    """
    Model used for storing the dump
    """
    ACID = models.CharField(max_length=44)
    LOAN_ACCT_NUM = models.CharField(max_length=64)
    CHARGE_TYPE = models.CharField(max_length=20)
    SYS_CALC_CHRGE_AMT = models.BigIntegerField()
    USER_CALC_CHRGE_AMT = models.BigIntegerField()
    CHRGE_AMT_COLLECTED = models.BigIntegerField()
    CHRGE_WAIVED = models.BigIntegerField()
    CHARGE_OUTSTANDING = models.IntegerField()
    GAM_CREATION_TIME = models.DateField(null=True)
    GAM_LAST_CHANGE_TIME = models.DateField(null=True)
    CHAT_CREATION_TIME = models.DateField(null=True)
    CHAT_LAST_CHANGE_TIME = models.DateField(null=True)


class RoboEitView(models.Model):
    """
    Model used for storing the dump
    """
    LOAN_ACCT_NUM = models.CharField(max_length=64)
    ACID = models.CharField(max_length=44)
    ACCRUED_UPTO_DATE_CR = models.DateField()
    ACCRUED_UPTO_DATE_DR = models.DateField()
    LAST_ACCRUAL_RUN_DATE_CR = models.DateField()
    LAST_ACCRUAL_RUN_DATE_DR = models.DateField()
    NRML_ACCRUED_AMOUNT_CR = models.BigIntegerField()
    NRML_ACCRUED_AMOUNT_DR = models.BigIntegerField()
    BOOKED_UPTO_DATE_CR = models.DateField()
    BOOKED_UPTO_DATE_DR = models.DateField()
    LAST_BOOK_RUN_DATE_CR = models.DateField()
    LAST_BOOK_RUN_DATE_DR = models.DateField()
    BOOK_FOR_REV_DATE_CR = models.DateField()
    BOOK_FOR_REV_DATE_DR = models.DateField()
    NRML_BOOKED_AMOUNT_CR = models.BigIntegerField()
    NRML_BOOKED_AMOUNT_DR = models.BigIntegerField()
    INTEREST_CALC_UPTO_DATE_CR = models.DateField()
    INTEREST_CALC_UPTO_DATE_DR = models.DateField()
    NRML_INTEREST_AMOUNT_CR = models.BigIntegerField()
    NRML_INTEREST_AMOUNT_DR = models.BigIntegerField()
    LAST_INTEREST_RUN_DATE_CR = models.DateField()
    LAST_INTEREST_RUN_DATE_DR = models.DateField()
    NEXT_INT_RUN_DATE_DR = models.DateField()
    NRML_INT_SUSPENSE_AMT_DR = models.BigIntegerField()
    PENAL_ACCRUED_AMOUNT_DR = models.BigIntegerField()
    PENAL_BOOKED_AMOUNT_DR = models.BigIntegerField()
    PENAL_INTEREST_AMOUNT_DR = models.BigIntegerField()
    PENAL_INT_SUSPENSE_AMT_DR = models.BigIntegerField()
    ACCOUNT_PEGGED_FLG = models.CharField(max_length=1)
    GAM_CREATION_TIME = models.DateField()
    GAM_LAST_CHANGE_TIME = models.DateField()
    EIT_CREATION_TIME = models.DateField()
    EIT_LAST_CHANGE_TIME = models.DateField()


class RoboLrsView(models.Model):
    """
    Model used for storing the dump
    """
    LOAN_ACCT_NUM = models.CharField(max_length=64)
    ACID = models.CharField(max_length=44)
    FLOW_ID = models.CharField(max_length=20)
    NUM_OF_FLOWS = models.IntegerField()
    FLOW_AMT = models.BigIntegerField()
    NUM_OF_DMDS = models.IntegerField()
    NEXT_DMD_DATE = models.DateField()
    NEXT_INT_DMD_DATE = models.DateField(null=True)
    CURRENT_INT_REC_FLG = models.CharField(max_length=1, null=True)
    GAM_CREATION_TIME = models.DateField(null=True)
    GAM_LAST_CHANGE_TIME = models.DateField(null=True)
    LRS_CREATION_TIME = models.DateField(null=True)
    LRS_LAST_CHANGE_TIME = models.DateField()


class MISReportRequestTracking(ModelBase):
    """
    Model used for storing mis request
    """
    report_request = models.CharField(max_length=50)
    filters = models.CharField(max_length=1000)
    status = models.BooleanField(default=False)
    emails = models.CharField(max_length=2000)
    requester = models.CharField(max_length=200, default="")


class RoboLdaView(models.Model):
    LOAN_ACCT_NUM = models.CharField(null=True, max_length=64)
    ACID = models.CharField(null=True, max_length=44)
    SHDL_NUM = models.CharField(null=True, max_length=8)
    DMD_FLOW_ID = models.CharField(null=True, max_length=20)
    DMD_DATE = models.DateField(null=True)
    DMD_SRL_NUM = models.CharField(null=True, max_length=8)
    SRL_NUM = models.CharField(null=True, max_length=12)
    DEL_FLG = models.CharField(null=True, max_length=1)
    ADJ_DATE = models.DateField(null=True)
    ADJ_AMT = models.IntegerField(null=True)
    LCHG_USER_ID = models.CharField(null=True, max_length=60)
    LCHG_TIME = models.DateField(null=True)
    RCRE_USER_ID = models.CharField(null=True, max_length=60)
    RCRE_TIME = models.DateField(null=True)
    OFLOW_ADJ_FLG = models.CharField(null=True, max_length=1)
    TRAN_DATE = models.DateField(null=True)
    TRAN_ID = models.CharField(null=True, max_length=36)
    PART_TRAN_SRL_NUM = models.CharField(null=True, max_length=16)
    TS_CNT = models.IntegerField(null=True)
    BANK_ID = models.CharField(null=True, max_length=32)
    WAIVER_SRL_NUM = models.CharField(null=True, max_length=16)
    WAIVER_RECORD = models.CharField(null=True, max_length=1)
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)


class RoboCxlView(models.Model):
    LOAN_ACCT_NUM = models.CharField(null=True, max_length=64)
    CXL_SRL_NUM = models.CharField(null=True, max_length=48)
    ENTITY_CRE_FLG = models.CharField(null=True, max_length=1)
    DEL_FLG = models.CharField(null=True, max_length=1)
    COMP_B2KID = models.CharField(null=True, max_length=260)
    COMP_B2KID_TYPE = models.CharField(null=True, max_length=40)
    SRL_NUM = models.CharField(null=True, max_length=16)
    CHRG_TRAN_ID = models.CharField(null=True, max_length=36)
    CHRG_PART_TRAN_SRL_NUM = models.CharField(null=True, max_length=16)
    CHRG_TRAN_DATE = models.DateField(null=True)
    PARENT_TRAN_ID = models.CharField(null=True, max_length=36)
    PARENT_TRAN_SRL_NUM = models.CharField(null=True, max_length=16)
    PARENT_TRAN_DATE = models.DateField(null=True)
    EVENT_TYPE = models.CharField(null=True, max_length=20)
    EVENT_ID = models.CharField(null=True, max_length=100)
    SERVICE_SOL_ID = models.CharField(null=True, max_length=32)
    SYSTEM_CALC_AMT = models.IntegerField(null=True)
    ACTUAL_AMT_COLL = models.IntegerField(null=True)
    COLL_CRNCY_CODE = models.CharField(null=True, max_length=12)
    TRAN_PARTICULAR = models.CharField(null=True, max_length=200)
    TRAN_RMKS = models.CharField(null=True, max_length=120)
    REVERSAL_FLG = models.CharField(null=True, max_length=1)
    START_DATE = models.DateField(null=True)
    END_DATE = models.DateField(null=True)
    TARGET_ACID = models.CharField(null=True, max_length=44)
    CUST_ID = models.CharField(null=True, max_length=36)
    CHRG_BORNE_BY_IND = models.CharField(null=True, max_length=1)
    PART_TRAN_TYPE = models.CharField(null=True, max_length=1)
    PTRAN_BUS_TYPE = models.CharField(null=True, max_length=20)
    CHRG_ACID = models.CharField(null=True, max_length=44)
    RATE_CODE1 = models.CharField(null=True, max_length=20)
    RATE_CODE2 = models.CharField(null=True, max_length=20)
    RATE_1 = models.IntegerField(null=True)
    RATE_2 = models.IntegerField(null=True)
    MODIFY_FLG = models.CharField(null=True, max_length=1)
    LCHG_USER_ID = models.CharField(null=True, max_length=60)
    LCHG_TIME = models.DateField(null=True)
    RCRE_USER_ID = models.CharField(null=True, max_length=60)
    RCRE_TIME = models.DateField(null=True)
    CONSOL_DEBIT_PTRAN_FLG = models.CharField(null=True, max_length=1)
    TS_CNT = models.IntegerField(null=True)
    CHRG_RPT_CODE = models.CharField(null=True, max_length=20)
    AMT_WITHOUT_DISCOUNT = models.IntegerField(null=True)
    REC_NOT_EFFECTIVE = models.CharField(null=True, max_length=1)
    CHANNEL_ID = models.CharField(null=True, max_length=20)
    AMT_AFTER_FIRST_LVL_DISC = models.IntegerField(null=True)
    RECORD_TYPE = models.CharField(null=True, max_length=1)
    CONSOLIDATED_TRAN_SRL_NUM = models.IntegerField(null=True)
    CHRG_GL_DATE = models.DateField(null=True)
    PARENT_GL_DATE = models.DateField(null=True)
    BANK_ID = models.CharField(null=True, max_length=32)
    AMT_BEFORE_ADDTNL_DISC = models.IntegerField(null=True)
    CHRG_DEBIT_PART_TRAN_SRL_NUM = models.CharField(null=True, max_length=16)
    DEFAULT_CHRG_CALC_FLG = models.CharField(null=True, max_length=1)
    REL_PRICING_REF_NUM = models.CharField(null=True, max_length=48)
    GL_SEGMENT_STRING = models.CharField(null=True, max_length=200)
    REF_CXL_SRL_NUM = models.CharField(null=True, max_length=48)
    PARENT_CXL_SRL_NUM = models.CharField(null=True, max_length=48)
    PART_CHRG_COLL_FLG = models.CharField(null=True, max_length=1)
    PENDING_CHRG_AMT = models.IntegerField(null=True)
    WAIVER_REASON_CODE = models.CharField(null=True, max_length=20)
    WAIVER_REMARKS = models.CharField(null=True, max_length=120)
    CHRG_REVERSAL_REASON_CODE = models.CharField(null=True, max_length=20)
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)


class RoboLtdView(models.Model):
    LOAN_ACCT_NUM = models.CharField(null=True, max_length=64)
    TRAN_DATE = models.DateField(null=True)
    TRAN_ID = models.CharField(null=True, max_length=36)
    PART_TRAN_SRL_NUM = models.CharField(null=True, max_length=16)
    SHDL_NUM = models.CharField(null=True, max_length=8)
    FLOW_ID = models.CharField(null=True, max_length=20)
    ENTITY_CRE_FLG = models.CharField(null=True, max_length=1)
    DEL_FLG = models.CharField(null=True, max_length=1)
    ACID = models.CharField(null=True, max_length=44)
    VALUE_DATE = models.DateField(null=True)
    FLOW_AMT = models.IntegerField(null=True)
    REVERSAL_FLG = models.CharField(null=True, max_length=1)
    REVERSED_FLG = models.CharField(null=True, max_length=1)
    DMD_OFFSET_FLG = models.CharField(null=True, max_length=1)
    LCHG_USER_ID = models.CharField(null=True, max_length=60)
    LCHG_TIME = models.DateField(null=True)
    RCRE_USER_ID = models.CharField(null=True, max_length=60)
    RCRE_TIME = models.DateField(null=True)
    DMD_DATE = models.DateField(null=True)
    LAST_TRAN_FLG = models.CharField(null=True, max_length=1)
    LOAN_INT_ACID = models.CharField(null=True, max_length=44)
    REVERSAL_REF_ID = models.CharField(null=True, max_length=200)
    TYPE_OF_DMDS = models.CharField(null=True, max_length=1)
    DMD_SRL_NUM = models.CharField(null=True, max_length=8)
    ORIGIN_OF_TRAN = models.CharField(null=True, max_length=20)
    OFLOW_ADJ_FLG = models.CharField(null=True, max_length=1)
    TS_CNT = models.IntegerField(null=True)
    PRINCIPAL_AMT = models.IntegerField(null=True)
    INTEREST_AMT = models.IntegerField(null=True)
    BANKCHARGE_AMT = models.IntegerField(null=True)
    OTHERCHARGE_AMT = models.IntegerField(null=True)
    DMD_SATISFY_FLG = models.CharField(null=True, max_length=1)
    INT_BENEFIT_FLG = models.CharField(null=True, max_length=1)
    ADVANCE_PAYMENT_FLG = models.CharField(null=True, max_length=1)
    TRAN_VALUE_DATE = models.DateField(null=True)
    INT_BENEFIT_DATE = models.DateField(null=True)
    RAISE_DMD_FLG = models.CharField(null=True, max_length=1)
    RAISE_DMD_FOR_AMT = models.IntegerField(null=True)
    DEFERRED_INT_AMT = models.IntegerField(null=True)
    DEMAND_IND = models.CharField(null=True, max_length=1)
    PREPAYMENT_TYPE = models.CharField(null=True, max_length=1)
    INT_COLL_ON_PREPAYMENT_FLG = models.CharField(null=True, max_length=1)
    TRANSFER_TYPE = models.CharField(null=True, max_length=1)
    TOP_DISB_FLG = models.CharField(null=True, max_length=1)
    GL_DATE = models.DateField(null=True)
    BANK_ID = models.CharField(null=True, max_length=32)
    NORMAL_INTEREST_AMT = models.IntegerField(null=True)
    PENAL_INTEREST_AMT = models.IntegerField(null=True)
    OVERDUE_INTEREST_AMT = models.IntegerField(null=True)
    INTEREST_OVERDUE_AMT = models.IntegerField(null=True)
    HOLIDAY_INTEREST_AMT = models.IntegerField(null=True)
    NORMAL_PRINCIPAL_AMT = models.IntegerField(null=True)
    PRINCIPAL_OVERDUE_AMT = models.IntegerField(null=True)
    PLANNED_PREPAY_AMT = models.IntegerField(null=True)
    WAIVER_RECORD = models.CharField(null=True, max_length=1)
    ACCRUED_PENAL_INT_AMT = models.IntegerField(null=True)
    DEFERRED_INT_DMD_AMT = models.IntegerField(null=True)
    EMICAP_DEFERRED_INT = models.IntegerField(null=True)
    COMP_INT_AMT = models.IntegerField(null=True)
    PEN_ON_INT_AMT = models.IntegerField(null=True)
    PEN_ON_PRIN_AMT = models.IntegerField(null=True)
    INT_REFUND_PREPYMNT_FLG = models.CharField(null=True, max_length=1)
    MARGIN_MNY_AMT = models.IntegerField(null=True)
    RETENTION_AMT = models.IntegerField(null=True)
    BUILDER_PROFIT_AMT = models.IntegerField(null=True)
    ADJUST_FROM_SEC_DEP_FLG = models.CharField(null=True, max_length=1)
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)


class RoboCollectionFdv(models.Model):
    TAG = models.CharField(null=True, max_length=3)
    FINANCIER_ID = models.CharField(null=True, max_length=50)
    APPL_ID = models.CharField(null=True, max_length=50)
    CUST_ID = models.CharField(null=True, max_length=50)
    PRINCIPAL_PAID = models.DecimalField(max_digits=17, decimal_places=3, blank=True, null=True)
    INTEREST_PAID = models.DecimalField(max_digits=17, decimal_places=3, blank=True, null=True)
    BCC_PAID = models.DecimalField(max_digits=17, decimal_places=3, blank=True, null=True)
    OTHER_PAID = models.DecimalField(max_digits=17, decimal_places=3, blank=True, null=True)
    PREPAYPENALTY_PAID = models.DecimalField(max_digits=17, decimal_places=3, blank=True, null=True)
    PRINCIPAL_DUE = models.DecimalField(max_digits=17, decimal_places=3, blank=True, null=True)
    INTEREST_DUE = models.DecimalField(max_digits=17, decimal_places=3, blank=True, null=True)
    BCC_DUE = models.DecimalField(max_digits=17, decimal_places=3, blank=True, null=True)
    OTHER_DUE = models.DecimalField(max_digits=17, decimal_places=3, blank=True, null=True)
    PREPAYPENALTY_DUE = models.DecimalField(max_digits=17, decimal_places=3, blank=True, null=True)
    LPC_PAID = models.DecimalField(max_digits=17, decimal_places=3, blank=True, null=True)
    LPC_DUE = models.DecimalField(max_digits=17, decimal_places=3, blank=True, null=True)
    FORMAT = models.CharField(null=True, max_length=60)
    TENTATIVE_FORECLOSURE_AMT = models.DecimalField(max_digits=17, decimal_places=3, blank=True, null=True)
    PREPAYPENALTY_PERCENT = models.DecimalField(max_digits=17, decimal_places=3, blank=True, null=True)
    PRINCIPAL_BALANCE = models.DecimalField(max_digits=17, decimal_places=3, blank=True, null=True)
    INSTALLMENT = models.DecimalField(max_digits=17, decimal_places=3, blank=True, null=True)
    PREPAYMENT_PENALTY = models.DecimalField(max_digits=17, decimal_places=3, blank=True, null=True)
    UNBILLED_INSTALLMENT = models.DecimalField(max_digits=17, decimal_places=3, blank=True, null=True)
    OVERDUE_CHARGES = models.DecimalField(max_digits=17, decimal_places=3, blank=True, null=True)
    ADVICE_OUTSTANDING_REPAYMENT_FEE = models.DecimalField(max_digits=17, decimal_places=3, blank=True, null=True)
    TOTAL_RECEIVABLE = models.DecimalField(max_digits=17, decimal_places=3, blank=True, null=True)
    NET_TOTAL = models.DecimalField(max_digits=17, decimal_places=3, blank=True, null=True)
    REFUNDS = models.DecimalField(max_digits=17, decimal_places=3, blank=True, null=True)
    CLOSURE_DATE = models.DateField(null=True)
    ACCRUED_PENAL_INTEREST = models.CharField(null=True, max_length=100)
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)
