/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.sf.mpxj.CustomField;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.FieldTypeClass;
import net.sf.mpxj.common.Pair;
import net.sf.mpxj.mpp.CustomFieldValueItem;

public class CustomFieldContainer
implements Iterable<CustomField> {
    private final Map<FieldType, CustomField> m_configMap = new HashMap<FieldType, CustomField>();
    private final Map<Integer, CustomFieldValueItem> m_valueMap = new HashMap<Integer, CustomFieldValueItem>();
    private final Map<UUID, CustomFieldValueItem> m_guidMap = new HashMap<UUID, CustomFieldValueItem>();
    private final Map<Pair<FieldTypeClass, String>, FieldType> m_aliasMap = new HashMap<Pair<FieldTypeClass, String>, FieldType>();

    public CustomField getCustomField(FieldType field) {
        return this.m_configMap.computeIfAbsent(field, k -> new CustomField(field, this));
    }

    public int size() {
        return this.m_configMap.values().size();
    }

    @Override
    public Iterator<CustomField> iterator() {
        return this.m_configMap.values().iterator();
    }

    public CustomFieldValueItem getCustomFieldValueItemByUniqueID(int uniqueID) {
        return this.m_valueMap.get(uniqueID);
    }

    public CustomFieldValueItem getCustomFieldValueItemByGuid(UUID guid) {
        return this.m_guidMap.get(guid);
    }

    public void registerValue(CustomFieldValueItem item) {
        this.m_valueMap.put(item.getUniqueID(), item);
        if (item.getGUID() != null) {
            this.m_guidMap.put(item.getGUID(), item);
        }
    }

    public void deregisterValue(CustomFieldValueItem item) {
        this.m_valueMap.remove(item.getUniqueID());
        if (item.getGUID() != null) {
            this.m_guidMap.remove(item.getGUID());
        }
    }

    void registerAlias(FieldType type, String alias) {
        this.m_aliasMap.put(new Pair<FieldTypeClass, String>(type.getFieldTypeClass(), alias), type);
    }

    public FieldType getFieldByAlias(FieldTypeClass typeClass, String alias) {
        return this.m_aliasMap.get(new Pair<FieldTypeClass, String>(typeClass, alias));
    }

    public Stream<CustomField> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }
}

