/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.sf.mpxj.ChildTaskContainer;
import net.sf.mpxj.ProjectEntityWithIDContainer;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.common.PopulatedFields;

public class TaskContainer
extends ProjectEntityWithIDContainer<Task> {
    public TaskContainer(ProjectFile projectFile) {
        super(projectFile);
    }

    public Task add() {
        Task task = new Task(this.m_projectFile, null);
        this.add(task);
        this.m_projectFile.getChildTasks().add(task);
        return task;
    }

    @Override
    public void removed(Task task) {
        List<Task> childTaskList;
        this.m_uniqueIDMap.remove(task.getUniqueID());
        this.m_idMap.remove(task.getID());
        Task parentTask = task.getParentTask();
        if (parentTask != null) {
            parentTask.removeChildTask(task);
        } else {
            this.m_projectFile.getChildTasks().remove(task);
        }
        Iterator iter = this.m_projectFile.getResourceAssignments().iterator();
        while (iter.hasNext()) {
            ResourceAssignment assignment = (ResourceAssignment)iter.next();
            if (assignment.getTask() != task) continue;
            Resource resource = assignment.getResource();
            if (resource != null) {
                resource.removeResourceAssignment(assignment);
            }
            iter.remove();
        }
        while (!(childTaskList = task.getChildTasks()).isEmpty()) {
            this.remove(childTaskList.get(0));
        }
    }

    public void synchronizeTaskIDToHierarchy() {
        int currentID = this.getByID(0) == null ? 1 : 0;
        this.synchroizeTaskIDToHierarchy(this.m_projectFile, currentID);
    }

    private int synchroizeTaskIDToHierarchy(ChildTaskContainer parentTask, int currentID) {
        for (Task task : parentTask.getChildTasks()) {
            task.setID(currentID++);
            currentID = this.synchroizeTaskIDToHierarchy(task, currentID);
        }
        return currentID;
    }

    public void updateStructure() {
        if (this.size() > 1) {
            Collections.sort(this);
            this.m_projectFile.getChildTasks().clear();
            Task lastTask = null;
            int lastLevel = -1;
            boolean autoWbs = this.m_projectFile.getProjectConfig().getAutoWBS();
            boolean autoOutlineNumber = this.m_projectFile.getProjectConfig().getAutoOutlineNumber();
            for (Task task : this) {
                task.clearChildTasks();
                Task parent = null;
                if (!task.getNull()) {
                    int level = NumberHelper.getInt(task.getOutlineLevel());
                    if (lastTask != null) {
                        if (level == lastLevel || task.getNull()) {
                            parent = lastTask.getParentTask();
                            level = lastLevel;
                        } else if (level > lastLevel) {
                            parent = lastTask;
                        } else {
                            while (level <= lastLevel && (parent = lastTask.getParentTask()) != null) {
                                lastLevel = NumberHelper.getInt(parent.getOutlineLevel());
                                lastTask = parent;
                            }
                        }
                    }
                    lastTask = task;
                    lastLevel = level;
                    if (autoWbs || task.getWBS() == null) {
                        task.generateWBS(parent);
                    }
                    if (autoOutlineNumber) {
                        task.generateOutlineNumber(parent);
                    }
                }
                if (parent == null) {
                    this.m_projectFile.getChildTasks().add(task);
                    continue;
                }
                parent.addChildTask(task);
            }
        }
    }

    public Set<TaskField> getPopulatedFields() {
        return new PopulatedFields<TaskField, Task>(this.m_projectFile, TaskField.class, this).getPopulatedFields();
    }

    @Override
    protected int firstUniqueID() {
        Task firstEntity = (Task)this.getByID(0);
        return firstEntity == null ? 1 : 0;
    }
}

