/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.common;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import net.sf.mpxj.AccrueType;
import net.sf.mpxj.Duration;
import net.sf.mpxj.EarnedValueMethod;
import net.sf.mpxj.FieldContainer;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.Priority;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.Rate;
import net.sf.mpxj.TaskType;
import net.sf.mpxj.TimeUnit;

public class PopulatedFields<E extends Enum<E>, T extends FieldContainer> {
    private final Class<E> m_fieldEnumType;
    private final Collection<T> m_collection;
    private final TimeUnit m_defaultDurationUnits;
    private final TaskType m_defaultTaskType;
    private final EarnedValueMethod m_defaultTaskEarnedValueMethod;
    private final AccrueType m_defaultFixedCostAccrual;

    public PopulatedFields(ProjectFile project, Class<E> fieldEnumType, Collection<T> collection) {
        this.m_fieldEnumType = fieldEnumType;
        this.m_collection = collection;
        ProjectProperties props = project.getProjectProperties();
        this.m_defaultDurationUnits = props.getDefaultDurationUnits();
        this.m_defaultTaskType = props.getDefaultTaskType();
        this.m_defaultTaskEarnedValueMethod = props.getDefaultTaskEarnedValueMethod();
        this.m_defaultFixedCostAccrual = props.getDefaultFixedCostAccrual();
    }

    public Set<E> getPopulatedFields() {
        EnumSet<Enum> unusedFields = EnumSet.allOf(this.m_fieldEnumType);
        for (FieldContainer item : this.m_collection) {
            unusedFields.removeIf(e -> this.fieldIsPopulated(item, (FieldType)((Object)e)));
        }
        EnumSet<E> usedFields = EnumSet.allOf(this.m_fieldEnumType);
        usedFields.removeAll(unusedFields);
        return usedFields;
    }

    private boolean fieldIsPopulated(FieldContainer item, FieldType type) {
        Object value = item.getCachedValue(type);
        return value != null && this.fieldIsNotDefaultValue(value, type);
    }

    private boolean fieldIsNotDefaultValue(Object value, FieldType type) {
        boolean result;
        switch (type.getDataType()) {
            case STRING: 
            case NOTES: {
                result = !value.toString().isEmpty();
                break;
            }
            case NUMERIC: 
            case CURRENCY: 
            case PERCENTAGE: 
            case UNITS: 
            case INTEGER: 
            case SHORT: {
                result = ((Number)value).doubleValue() != 0.0;
                break;
            }
            case WORK: 
            case DURATION: {
                if (value instanceof String) {
                    result = !((String)value).isEmpty();
                    break;
                }
                result = ((Duration)value).getDuration() != 0.0;
                break;
            }
            case RATE: {
                result = ((Rate)value).getAmount() != 0.0;
                break;
            }
            case BOOLEAN: {
                result = (Boolean)value;
                break;
            }
            case TIME_UNITS: {
                result = value != this.m_defaultDurationUnits;
                break;
            }
            case TASK_TYPE: {
                result = value != this.m_defaultTaskType;
                break;
            }
            case PRIORITY: {
                result = ((Priority)value).getValue() != 500;
                break;
            }
            case EARNED_VALUE_METHOD: {
                result = value != this.m_defaultTaskEarnedValueMethod;
                break;
            }
            case ACCRUE: {
                result = value != this.m_defaultFixedCostAccrual;
                break;
            }
            default: {
                result = true;
            }
        }
        return result;
    }
}

