/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.json;

import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.sf.mpxj.ActivityCode;
import net.sf.mpxj.ActivityCodeValue;
import net.sf.mpxj.AssignmentField;
import net.sf.mpxj.CostRateTable;
import net.sf.mpxj.CostRateTableEntry;
import net.sf.mpxj.CustomField;
import net.sf.mpxj.DataType;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.DayType;
import net.sf.mpxj.Duration;
import net.sf.mpxj.EarnedValueMethod;
import net.sf.mpxj.FieldContainer;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.Priority;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarDays;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectCalendarWeek;
import net.sf.mpxj.ProjectField;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.Rate;
import net.sf.mpxj.RecurringData;
import net.sf.mpxj.Relation;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceField;
import net.sf.mpxj.ResourceRequestType;
import net.sf.mpxj.SubProject;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.TaskType;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.TimeUnitDefaultsContainer;
import net.sf.mpxj.WorkContour;
import net.sf.mpxj.common.CharsetHelper;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.common.FieldTypeHelper;
import net.sf.mpxj.json.JsonStreamWriter;
import net.sf.mpxj.writer.AbstractProjectWriter;

public final class JsonWriter
extends AbstractProjectWriter {
    private ProjectFile m_projectFile;
    private JsonStreamWriter m_writer;
    private boolean m_pretty;
    private Charset m_encoding = DEFAULT_ENCODING;
    private boolean m_writeAttributeTypes;
    private TimeUnit m_timeUnits;
    private static final Charset DEFAULT_ENCODING = CharsetHelper.UTF8;
    private static final Map<String, DataType> TYPE_MAP = new HashMap<String, DataType>();
    private static final Set<FieldType> IGNORED_FIELDS;
    private static final Set<FieldType> MANDATORY_FIELDS;

    public boolean getPretty() {
        return this.m_pretty;
    }

    public void setPretty(boolean pretty) {
        this.m_pretty = pretty;
    }

    public Charset getEncoding() {
        return this.m_encoding;
    }

    public void setEncoding(Charset encoding) {
        this.m_encoding = encoding;
    }

    public boolean getWriteAttributeTypes() {
        return this.m_writeAttributeTypes;
    }

    public void setWriteAttributeTypes(boolean writeAttributeTypes) {
        this.m_writeAttributeTypes = writeAttributeTypes;
    }

    public void setTimeUnits(TimeUnit value) {
        this.m_timeUnits = value;
    }

    public TimeUnit getTimeUnits() {
        return this.m_timeUnits;
    }

    @Override
    public void write(ProjectFile projectFile, OutputStream stream) throws IOException {
        try {
            this.m_projectFile = projectFile;
            this.m_writer = new JsonStreamWriter(stream, this.m_encoding);
            this.m_writer.setPretty(this.m_pretty);
            this.m_writer.writeStartObject(null);
            this.writeCustomFields();
            this.writeActivityCodes();
            this.writeProperties();
            this.writeCalendars();
            this.writeResources();
            this.writeTasks();
            this.writeAssignments();
            this.m_writer.writeEndObject();
            this.m_writer.flush();
        }
        finally {
            this.m_projectFile = null;
        }
    }

    private void writeCustomFields() throws IOException {
        List sortedCustomFieldsList = this.m_projectFile.getCustomFields().stream().filter(f -> f.getFieldType() != null).sorted(this::compareCustomFields).collect(Collectors.toList());
        this.m_writer.writeStartList("custom_fields");
        for (CustomField field : sortedCustomFieldsList) {
            this.writeCustomField(field);
        }
        this.m_writer.writeEndList();
    }

    private void writeActivityCodes() throws IOException {
        if (!this.m_projectFile.getActivityCodes().isEmpty()) {
            ArrayList<ActivityCode> sortedActivityCodeList = new ArrayList<ActivityCode>(this.m_projectFile.getActivityCodes());
            sortedActivityCodeList.sort(Comparator.comparing(ActivityCode::getName));
            this.m_writer.writeStartList("activity_codes");
            for (ActivityCode code : sortedActivityCodeList) {
                this.writeActivityCode(code);
            }
            this.m_writer.writeEndList();
        }
    }

    private int compareCustomFields(CustomField f1, CustomField f2) {
        FieldType o1 = f1.getFieldType();
        FieldType o2 = f2.getFieldType();
        String name1 = o1.getClass().getSimpleName() + "." + o1.getName() + " " + f1.getAlias();
        String name2 = o2.getClass().getSimpleName() + "." + o2.getName() + " " + f2.getAlias();
        return name1.compareTo(name2);
    }

    private void writeCustomField(CustomField field) throws IOException {
        if (field.getAlias() != null) {
            this.m_writer.writeStartObject(null);
            Integer uniqueID = field.getUniqueID();
            if (uniqueID != FieldTypeHelper.getFieldID(field.getFieldType())) {
                this.m_writer.writeNameValuePair("unique_id", field.getUniqueID());
            }
            this.m_writer.writeNameValuePair("field_type_class", field.getFieldType().getFieldTypeClass().name().toLowerCase());
            this.m_writer.writeNameValuePair("field_type", field.getFieldType().name().toLowerCase());
            this.m_writer.writeNameValuePair("field_alias", field.getAlias());
            if (field.getCustomFieldDataType() != null) {
                this.m_writer.writeNameValuePair("field_data_type", field.getCustomFieldDataType().name().toLowerCase());
            }
            this.m_writer.writeEndObject();
        }
    }

    private void writeProperties() throws IOException {
        this.writeAttributeTypes("property_types", ProjectField.values());
        this.m_writer.writeStartObject("property_values");
        this.writeFields(this.m_projectFile.getProjectProperties(), ProjectField.values());
        this.m_writer.writeEndObject();
    }

    private void writeResources() throws IOException {
        this.writeAttributeTypes("resource_types", ResourceField.values());
        this.m_writer.writeStartList("resources");
        for (Resource resource : this.m_projectFile.getResources()) {
            this.m_writer.writeStartObject(null);
            this.writeFields(resource, ResourceField.values());
            this.writeCostRateTables(resource);
            this.m_writer.writeEndObject();
        }
        this.m_writer.writeEndList();
    }

    private void writeCalendars() throws IOException {
        this.m_writer.writeStartList("calendars");
        for (ProjectCalendar calendar : this.m_projectFile.getCalendars()) {
            this.writeCalendar(calendar);
        }
        this.m_writer.writeEndList();
    }

    private void writeCalendar(ProjectCalendar calendar) throws IOException {
        this.m_writer.writeStartObject(null);
        this.writeMandatoryIntegerField("unique_id", calendar.getUniqueID());
        this.writeMandatoryIntegerField("parent_unique_id", calendar.getParent() == null ? null : calendar.getParent().getUniqueID());
        this.writeStringField("name", calendar.getName());
        this.writeStringField("type", calendar.getType().toString());
        this.writeBooleanField("personal", calendar.getPersonal());
        this.writeIntegerField("minutes_per_day", calendar.getCalendarMinutesPerDay());
        this.writeIntegerField("minutes_per_week", calendar.getCalendarMinutesPerWeek());
        this.writeIntegerField("minutes_per_month", calendar.getCalendarMinutesPerMonth());
        this.writeIntegerField("minutes_per_year", calendar.getCalendarMinutesPerYear());
        this.writeCalendarDays(calendar);
        this.writeCalendarWeeks(calendar);
        this.writeCalendarExceptions(calendar);
        this.m_writer.writeEndObject();
    }

    private void writeCalendarWeeks(ProjectCalendar calendar) throws IOException {
        if (!calendar.getWorkWeeks().isEmpty()) {
            this.m_writer.writeStartList("working_weeks");
            for (ProjectCalendarWeek week : calendar.getWorkWeeks()) {
                this.writeCalendarWeek(week);
            }
            this.m_writer.writeEndList();
        }
    }

    private void writeCalendarWeek(ProjectCalendarWeek week) throws IOException {
        this.m_writer.writeStartObject(null);
        this.writeStringField("name", week.getName());
        this.writeDateField("effective_from", week.getDateRange().getStart());
        this.writeDateField("effective_to", week.getDateRange().getEnd());
        this.writeCalendarDays(week);
        this.m_writer.writeEndObject();
    }

    private void writeCalendarDays(ProjectCalendarDays week) throws IOException {
        for (Day day : Day.values()) {
            this.m_writer.writeStartObject(day.name().toLowerCase());
            this.writeStringField("type", week.getCalendarDayType(day).toString().toLowerCase());
            this.writeCalendarHours(week.getCalendarHours(day));
            this.m_writer.writeEndObject();
        }
    }

    private void writeCalendarHours(ProjectCalendarHours hours) throws IOException {
        if (hours != null && hours.size() != 0) {
            this.m_writer.writeStartList("hours");
            for (DateRange range : hours) {
                this.m_writer.writeStartObject(null);
                this.writeTimeField("from", range.getStart());
                this.writeTimeField("to", range.getEnd());
                this.m_writer.writeEndObject();
            }
            this.m_writer.writeEndList();
        }
    }

    private void writeCalendarExceptions(ProjectCalendar calendar) throws IOException {
        if (!calendar.getCalendarExceptions().isEmpty()) {
            this.m_writer.writeStartList("exceptions");
            for (ProjectCalendarException ex : calendar.getCalendarExceptions()) {
                this.writeCalendarException(ex);
            }
            this.m_writer.writeEndList();
        }
    }

    private void writeCalendarException(ProjectCalendarException ex) throws IOException {
        this.m_writer.writeStartObject(null);
        this.writeCalendarExceptionDetails(ex);
        this.writeCalendarHours(ex);
        this.writeRecurringData(ex.getRecurring());
        this.m_writer.writeEndObject();
    }

    private void writeCalendarExceptionDetails(ProjectCalendarException ex) throws IOException {
        DayType type = ex.getWorking() ? DayType.WORKING : DayType.NON_WORKING;
        this.writeStringField("name", ex.getName());
        if (ex.getRecurring() == null) {
            this.writeDateField("from", ex.getFromDate());
            this.writeDateField("to", ex.getToDate());
        }
        this.writeStringField("type", type.toString().toLowerCase());
    }

    private void writeRecurringData(RecurringData data) throws IOException {
        if (data != null) {
            this.m_writer.writeStartObject("recurrence");
            this.writeStringField("type", data.getRecurrenceType().toString().toLowerCase());
            this.writeDateField("start_date", data.getStartDate());
            this.writeDateField("finish_date", data.getFinishDate());
            this.writeIntegerField("occurrences", data.getOccurrences());
            this.writeIntegerField("frequency", data.getFrequency());
            this.writeBooleanField("relative", data.getRelative());
            this.writeIntegerField("day_number", data.getDayNumber());
            this.writeIntegerField("month_number", data.getMonthNumber());
            this.writeBooleanField("use_end_date", data.getUseEndDate());
            List<Object> weeklyDays = Arrays.stream(Day.values()).filter(data::getWeeklyDay).map(d -> "\"" + d.toString().toLowerCase() + "\"").collect(Collectors.toList());
            if (!weeklyDays.isEmpty()) {
                this.m_writer.writeList("weekly_days", weeklyDays);
            }
            this.m_writer.writeEndObject();
        }
    }

    private void writeTasks() throws IOException {
        this.writeAttributeTypes("task_types", TaskField.values());
        this.m_writer.writeStartList("tasks");
        for (Task task : this.m_projectFile.getChildTasks()) {
            this.writeTask(task);
        }
        this.m_writer.writeEndList();
    }

    private void writeTask(Task task) throws IOException {
        this.m_writer.writeStartObject(null);
        this.writeFields(task, TaskField.values());
        this.m_writer.writeEndObject();
        for (Task child : task.getChildTasks()) {
            this.writeTask(child);
        }
    }

    private void writeAssignments() throws IOException {
        this.writeAttributeTypes("assignment_types", AssignmentField.values());
        this.m_writer.writeStartList("assignments");
        for (ResourceAssignment assignment : this.m_projectFile.getResourceAssignments()) {
            this.m_writer.writeStartObject(null);
            this.writeFields(assignment, AssignmentField.values());
            this.m_writer.writeEndObject();
        }
        this.m_writer.writeEndList();
    }

    private void writeAttributeTypes(String name, FieldType[] types) throws IOException {
        if (this.m_writeAttributeTypes) {
            this.m_writer.writeStartObject(name);
            for (FieldType field : types) {
                this.m_writer.writeNameValuePair(field.name().toLowerCase(), field.getDataType().getValue());
            }
            this.m_writer.writeEndObject();
        }
    }

    private void writeCostRateTables(Resource resource) throws IOException {
        int index;
        boolean tablesArePopulated = false;
        for (index = 0; index < 5 && !(tablesArePopulated = resource.getCostRateTable(index).tableIsPopulated()); ++index) {
        }
        if (tablesArePopulated) {
            this.m_writer.writeStartObject("cost_rate_tables");
            for (index = 0; index < 5; ++index) {
                this.writeCostRateTable(index, resource.getCostRateTable(index));
            }
            this.m_writer.writeEndObject();
        }
    }

    private void writeCostRateTable(int index, CostRateTable table) throws IOException {
        if (table.tableIsPopulated()) {
            this.m_writer.writeStartList(Integer.toString(index));
            for (CostRateTableEntry entry : table) {
                Date endDate;
                Date startDate = entry.getStartDate();
                if (startDate != null && DateHelper.compare(startDate, DateHelper.START_DATE_NA) <= 0) {
                    startDate = null;
                }
                if ((endDate = entry.getEndDate()) != null && DateHelper.compare(DateHelper.END_DATE_NA, endDate) <= 0) {
                    endDate = null;
                }
                this.m_writer.writeStartObject(null);
                this.writeTimestampField("start_date", startDate);
                this.writeTimestampField("end_date", endDate);
                this.writeDoubleField("cost_per_use", entry.getCostPerUse());
                this.m_writer.writeStartObject("rates");
                for (int rateIndex = 0; rateIndex < 5; ++rateIndex) {
                    this.writeCostRate(rateIndex, entry.getRate(rateIndex));
                }
                this.m_writer.writeEndObject();
                this.m_writer.writeEndObject();
            }
            this.m_writer.writeEndList();
        }
    }

    private void writeCostRate(int index, Rate rate) throws IOException {
        if (rate != null && rate.getAmount() != 0.0) {
            this.writeRateField(Integer.toString(index), rate);
        }
    }

    private void writeFields(FieldContainer container, FieldType[] fields) throws IOException {
        for (FieldType field : fields) {
            Object value = container.getCurrentValue(field);
            if (value == null) continue;
            this.writeField(container, field, value);
        }
    }

    private void writeField(FieldContainer container, FieldType field, Object value) throws IOException {
        if (!IGNORED_FIELDS.contains(field)) {
            this.writeField(container, field, field.name().toLowerCase(), field.getDataType(), value);
        }
    }

    private void writeField(FieldContainer container, FieldType fieldType, String fieldName, DataType dataType, Object value) throws IOException {
        switch (dataType) {
            case SHORT: 
            case INTEGER: {
                this.writeIntegerField(fieldType, fieldName, value);
                break;
            }
            case PERCENTAGE: 
            case CURRENCY: 
            case NUMERIC: 
            case UNITS: {
                this.writeDoubleField(fieldName, value);
                break;
            }
            case BOOLEAN: {
                this.writeBooleanField(fieldName, value);
                break;
            }
            case DELAY: 
            case WORK: 
            case DURATION: {
                this.writeDurationField(container, fieldName, value);
                break;
            }
            case DATE: {
                this.writeTimestampField(fieldName, value);
                break;
            }
            case TIME: {
                this.writeTimeField(fieldName, value);
                break;
            }
            case RATE_UNITS: 
            case TIME_UNITS: {
                this.writeTimeUnitsField(fieldName, value);
                break;
            }
            case PRIORITY: {
                this.writePriorityField(fieldName, value);
                break;
            }
            case RELATION_LIST: {
                this.writeRelationList(fieldName, value);
                break;
            }
            case MAP: {
                this.writeMap(fieldName, value);
                break;
            }
            case DATE_RANGE_LIST: {
                this.writeDateRangeList(fieldName, value);
                break;
            }
            case SUBPROJECT: {
                this.writeSubproject(fieldName, value);
                break;
            }
            case RATE: {
                this.writeRateField(fieldName, value);
                break;
            }
            case RESOURCE_REQUEST_TYPE: {
                this.writeResourceRequestTypeField(fieldName, value);
                break;
            }
            case WORK_CONTOUR: {
                this.writeWorkContourField(fieldName, value);
                break;
            }
            case EARNED_VALUE_METHOD: {
                this.writeEarnedValueMethodField(container, fieldName, value);
                break;
            }
            case TASK_TYPE: {
                this.writeTaskTypeField(container, fieldName, value);
                break;
            }
            case ACTIVITY_CODE_LIST: {
                this.writeActivityCodeList(fieldName, value);
                break;
            }
            case BINARY: {
                break;
            }
            default: {
                if (value instanceof Enum) {
                    value = ((Enum)value).name();
                }
                this.writeStringField(fieldName, value);
            }
        }
    }

    private void writeIntegerField(String fieldName, Object value) throws IOException {
        this.writeIntegerField(null, fieldName, value);
    }

    private void writeMandatoryIntegerField(String fieldName, Object value) throws IOException {
        if (value != null) {
            this.m_writer.writeNameValuePair(fieldName, ((Number)value).intValue());
        }
    }

    private void writeIntegerField(FieldType fieldType, String fieldName, Object value) throws IOException {
        int val;
        if (value != null && ((val = ((Number)value).intValue()) != 0 || MANDATORY_FIELDS.contains(fieldType))) {
            this.m_writer.writeNameValuePair(fieldName, val);
        }
    }

    private void writeDoubleField(String fieldName, Object value) throws IOException {
        double val;
        if (value != null && (val = ((Number)value).doubleValue()) != 0.0) {
            this.m_writer.writeNameValuePair(fieldName, val);
        }
    }

    private void writeBooleanField(String fieldName, Object value) throws IOException {
        boolean val;
        if (value != null && (val = ((Boolean)value).booleanValue())) {
            this.m_writer.writeNameValuePair(fieldName, val);
        }
    }

    private void writeDurationField(FieldContainer container, String fieldName, Object value) throws IOException {
        if (value != null) {
            if (value instanceof String) {
                this.m_writer.writeNameValuePair(fieldName + "_text", (String)value);
            } else {
                Duration val = (Duration)value;
                if (val.getDuration() != 0.0) {
                    TimeUnitDefaultsContainer defaults = null;
                    if (container instanceof Task) {
                        defaults = ((Task)container).getEffectiveCalendar();
                    } else if (container instanceof Resource) {
                        defaults = ((Resource)container).getCalendar();
                    }
                    if (defaults == null) {
                        defaults = this.m_projectFile.getProjectProperties();
                    }
                    if (this.m_timeUnits == null) {
                        Duration minutes = val.convertUnits(TimeUnit.MINUTES, defaults);
                        long seconds = (long)(minutes.getDuration() * 60.0);
                        this.m_writer.writeNameValuePair(fieldName, seconds);
                    } else {
                        Duration duration = val.convertUnits(this.m_timeUnits, defaults);
                        this.m_writer.writeNameValuePair(fieldName, duration.getDuration());
                    }
                }
            }
        }
    }

    private void writeTimestampField(String fieldName, Object value) throws IOException {
        if (value != null) {
            if (value instanceof String) {
                this.m_writer.writeNameValuePair(fieldName + "_text", (String)value);
            } else {
                Date val = (Date)value;
                this.m_writer.writeNameValuePair(fieldName, val);
            }
        }
    }

    private void writeDateField(String fieldName, Object value) throws IOException {
        if (value != null) {
            this.m_writer.writeNameValuePairAsDate(fieldName, (Date)value);
        }
    }

    private void writeTimeField(String fieldName, Object value) throws IOException {
        if (value != null) {
            this.m_writer.writeNameValuePairAsTime(fieldName, (Date)value);
        }
    }

    private void writeTimeUnitsField(String fieldName, Object value) throws IOException {
        TimeUnit val;
        if (value != null && (val = (TimeUnit)value) != this.m_projectFile.getProjectProperties().getDefaultDurationUnits()) {
            this.m_writer.writeNameValuePair(fieldName, val.toString());
        }
    }

    private void writePriorityField(String fieldName, Object value) throws IOException {
        if (value != null) {
            this.m_writer.writeNameValuePair(fieldName, ((Priority)value).getValue());
        }
    }

    private void writeRateField(String fieldName, Object value) throws IOException {
        if (value != null && ((Rate)value).getAmount() != 0.0) {
            this.m_writer.writeNameValuePair(fieldName, ((Rate)value).getAmount() + "/" + ((Rate)value).getUnits());
        }
    }

    private void writeMap(String fieldName, Object value) throws IOException {
        Map map = (Map)value;
        this.m_writer.writeStartObject(fieldName);
        for (Map.Entry entry : map.entrySet()) {
            Object entryValue = entry.getValue();
            if (entryValue == null || entryValue instanceof byte[]) continue;
            DataType type = TYPE_MAP.get(entryValue.getClass().getName());
            if (type == null) {
                type = DataType.STRING;
                entryValue = entryValue.toString();
            }
            this.writeField(null, null, (String)entry.getKey(), type, entryValue);
        }
        this.m_writer.writeEndObject();
    }

    private void writeDateRangeList(String fieldName, Object value) throws IOException {
        List list = (List)value;
        this.m_writer.writeStartList(fieldName);
        for (DateRange entry : list) {
            this.m_writer.writeStartObject(null);
            this.writeTimestampField("start", entry.getStart());
            this.writeTimestampField("end", entry.getEnd());
            this.m_writer.writeEndObject();
        }
        this.m_writer.writeEndList();
    }

    private void writeSubproject(String fieldName, Object value) throws IOException {
        SubProject sp = (SubProject)value;
        this.m_writer.writeStartObject(fieldName);
        this.writeStringField("dos_file_name", sp.getDosFileName());
        this.writeStringField("dos_full_path", sp.getDosFullPath());
        this.writeStringField("file_name", sp.getFileName());
        this.writeStringField("full_path", sp.getFullPath());
        this.writeIntegerField("task_unique_id", sp.getTaskUniqueID());
        this.writeIntegerField("unique_id_offset", sp.getUniqueIDOffset());
        this.m_writer.writeStartList("all_external_task_unique_ids");
        for (Integer id : sp.getAllExternalTaskUniqueIDs()) {
            this.m_writer.writeStartObject(null);
            this.writeIntegerField("id", id);
            this.m_writer.writeEndObject();
        }
        this.m_writer.writeEndList();
        this.m_writer.writeEndObject();
    }

    private void writeActivityCode(ActivityCode code) throws IOException {
        this.m_writer.writeStartObject(null);
        this.writeMandatoryIntegerField("unique_id", code.getUniqueID());
        this.writeStringField("scope", (Object)code.getScope());
        this.writeIntegerField("scope_unique_id", code.getScopeUniqueID());
        this.writeMandatoryIntegerField("sequence_number", code.getSequenceNumber());
        this.writeStringField("name", code.getName());
        if (!code.getValues().isEmpty()) {
            this.m_writer.writeStartList("values");
            for (ActivityCodeValue value : code.getValues()) {
                this.writeActivityCodeValue(value);
            }
            this.m_writer.writeEndList();
        }
        this.m_writer.writeEndObject();
    }

    private void writeActivityCodeValue(ActivityCodeValue value) throws IOException {
        this.m_writer.writeStartObject(null);
        this.writeMandatoryIntegerField("unique_id", value.getUniqueID());
        this.writeMandatoryIntegerField("sequence_number", value.getSequenceNumber());
        this.writeStringField("name", value.getName());
        this.writeStringField("desription", value.getDescription());
        this.writeColorField("color", value.getColor());
        if (value.getParent() != null) {
            this.writeIntegerField("parent_unique_id", value.getParent().getUniqueID());
        }
        this.m_writer.writeEndObject();
    }

    private void writeStringField(String fieldName, Object value) throws IOException {
        String val;
        if (value != null && !(val = value.toString()).isEmpty()) {
            this.m_writer.writeNameValuePair(fieldName, val);
        }
    }

    private void writeRelationList(String fieldName, Object value) throws IOException {
        List list = (List)value;
        if (!list.isEmpty()) {
            this.m_writer.writeStartList(fieldName);
            for (Relation relation : list) {
                this.m_writer.writeStartObject(null);
                this.writeIntegerField("task_unique_id", relation.getTargetTask().getUniqueID());
                this.writeDurationField(this.m_projectFile.getProjectProperties(), "lag", relation.getLag());
                this.writeStringField("type", relation.getType());
                this.m_writer.writeEndObject();
            }
            this.m_writer.writeEndList();
        }
    }

    private void writeResourceRequestTypeField(String fieldName, Object value) throws IOException {
        ResourceRequestType type;
        if (value != null && (type = (ResourceRequestType)value) != ResourceRequestType.NONE) {
            this.m_writer.writeNameValuePair(fieldName, type.name());
        }
    }

    private void writeWorkContourField(String fieldName, Object value) throws IOException {
        WorkContour type;
        if (value != null && !(type = (WorkContour)value).isContourFlat()) {
            this.m_writer.writeNameValuePair(fieldName, type.toString());
        }
    }

    private void writeEarnedValueMethodField(FieldContainer container, String fieldName, Object value) throws IOException {
        if (value != null) {
            EarnedValueMethod method = (EarnedValueMethod)value;
            if (container instanceof ProjectProperties || method != this.m_projectFile.getProjectProperties().getDefaultTaskEarnedValueMethod()) {
                this.m_writer.writeNameValuePair(fieldName, method.name());
            }
        }
    }

    private void writeTaskTypeField(FieldContainer container, String fieldName, Object value) throws IOException {
        if (value != null) {
            TaskType type = (TaskType)value;
            if (container instanceof ProjectProperties || type != this.m_projectFile.getProjectProperties().getDefaultTaskType()) {
                this.m_writer.writeNameValuePair(fieldName, type.name());
            }
        }
    }

    private void writeColorField(String name, Color value) throws IOException {
        if (value != null) {
            String stringValue = "000000" + Integer.toHexString(value.getRGB()).toUpperCase();
            stringValue = "#" + stringValue.substring(stringValue.length() - 6);
            this.m_writer.writeNameValuePair(name, stringValue);
        }
    }

    private void writeActivityCodeList(String fieldName, Object value) throws IOException {
        List list = (List)value;
        if (!list.isEmpty()) {
            this.m_writer.writeList(fieldName, list.stream().map(ActivityCodeValue::getUniqueID).collect(Collectors.toList()));
        }
    }

    static {
        TYPE_MAP.put(Boolean.class.getName(), DataType.BOOLEAN);
        TYPE_MAP.put(Date.class.getName(), DataType.DATE);
        TYPE_MAP.put(Double.class.getName(), DataType.NUMERIC);
        TYPE_MAP.put(Duration.class.getName(), DataType.DURATION);
        TYPE_MAP.put(Integer.class.getName(), DataType.INTEGER);
        IGNORED_FIELDS = new HashSet<Enum>(Arrays.asList(AssignmentField.ASSIGNMENT_TASK_GUID, AssignmentField.ASSIGNMENT_RESOURCE_GUID, ResourceField.CALENDAR_GUID, ResourceField.STANDARD_RATE_UNITS, ResourceField.OVERTIME_RATE_UNITS));
        MANDATORY_FIELDS = new HashSet<Enum>(Arrays.asList(TaskField.UNIQUE_ID, TaskField.PARENT_TASK_UNIQUE_ID, ProjectField.DEFAULT_CALENDAR_UNIQUE_ID));
    }
}

