/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import net.sf.mpxj.CustomField;
import net.sf.mpxj.CustomFieldContainer;
import net.sf.mpxj.DataType;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.common.FieldTypeHelper;
import net.sf.mpxj.mpp.EnterpriseCustomFieldDataType;
import net.sf.mpxj.mpp.MPPUtility;

class CustomFieldReader14 {
    private final CustomFieldContainer m_fields;
    private final byte[] m_data;

    public CustomFieldReader14(CustomFieldContainer fields, byte[] data) {
        this.m_fields = fields;
        this.m_data = data;
    }

    public void process() {
        if (this.m_data != null) {
            int offset = 0;
            int aliasBlockSize = MPPUtility.getInt(this.m_data, offset);
            int numberOfAliases = MPPUtility.getInt(this.m_data, offset += 8);
            offset += 4;
            for (int index = 0; index < numberOfAliases && offset < aliasBlockSize; ++index) {
                int fieldID = MPPUtility.getInt(this.m_data, offset);
                int aliasOffset = MPPUtility.getInt(this.m_data, offset += 4) + 4;
                offset += 4;
                if (aliasOffset >= this.m_data.length) continue;
                String alias = MPPUtility.getUnicodeString(this.m_data, aliasOffset);
                this.m_fields.getCustomField(FieldTypeHelper.getInstance(fieldID)).setAlias(alias);
            }
            offset = 4 + aliasBlockSize;
            if (offset + 4 > this.m_data.length) {
                return;
            }
            int unknownBlock1Size = MPPUtility.getInt(this.m_data, offset);
            offset += 4;
            if ((offset += unknownBlock1Size) > this.m_data.length) {
                return;
            }
            if (offset + 4 > this.m_data.length) {
                return;
            }
            int unknownBlock2Size = MPPUtility.getInt(this.m_data, offset);
            offset += 4;
            if ((offset += unknownBlock2Size) > this.m_data.length) {
                return;
            }
            if (offset + 8 > this.m_data.length) {
                return;
            }
            int numberOfDefinitions = MPPUtility.getInt(this.m_data, offset);
            offset += 4;
            offset += 4;
            for (int definitionIndex = 0; definitionIndex < numberOfDefinitions && offset + 88 <= this.m_data.length; ++definitionIndex) {
                FieldType fieldType = FieldTypeHelper.getInstance(MPPUtility.getInt(this.m_data, offset));
                if (fieldType.getDataType() == DataType.CUSTOM) {
                    CustomField customField = this.m_fields.getCustomField(fieldType);
                    int dataTypeValue = MPPUtility.getShort(this.m_data, offset + 12);
                    customField.setCustomFieldDataType(EnterpriseCustomFieldDataType.getDataType(dataTypeValue));
                }
                offset += 88;
            }
        }
    }
}

