/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.sf.mpxj.CustomField;
import net.sf.mpxj.CustomFieldContainer;
import net.sf.mpxj.CustomFieldLookupTable;
import net.sf.mpxj.CustomFieldValueDataType;
import net.sf.mpxj.DataType;
import net.sf.mpxj.Duration;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.FieldTypeClass;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.FieldTypeHelper;
import net.sf.mpxj.common.Pair;
import net.sf.mpxj.mpp.CustomFieldValueItem;
import net.sf.mpxj.mpp.FixedData;
import net.sf.mpxj.mpp.FixedMeta;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.mpp.Props;
import net.sf.mpxj.mpp.Var2Data;
import net.sf.mpxj.mpp.VarMeta9;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;

public class CustomFieldValueReader9 {
    private final DirectoryEntry m_projectDir;
    private final ProjectProperties m_properties;
    private final Props m_projectProps;
    private final CustomFieldContainer m_container;
    private int m_valueUniqueIDCounter;
    private static final Integer VALUE = 1;
    private static final Integer DESCRIPTION = 2;
    private static final Map<DataType, CustomFieldValueDataType> TYPE_MAP = new HashMap<DataType, CustomFieldValueDataType>();

    public CustomFieldValueReader9(DirectoryEntry projectDir, ProjectProperties properties, Props projectProps, CustomFieldContainer container) {
        this.m_projectDir = projectDir;
        this.m_properties = properties;
        this.m_projectProps = projectProps;
        this.m_container = container;
    }

    public void process() throws IOException {
        this.processCustomFieldValues();
        this.processOutlineCodeValues();
    }

    private void processCustomFieldValues() {
        byte[] data = this.m_projectProps.getByteArray(Props.TASK_FIELD_ATTRIBUTES);
        if (data != null) {
            int offset = 0;
            int length = MPPUtility.getInt(data, offset);
            int numberOfValueLists = MPPUtility.getInt(data, offset += 4);
            offset += 4;
            for (int index = 0; index < numberOfValueLists && offset < length; ++index) {
                FieldType field = FieldTypeHelper.getInstance(MPPUtility.getInt(data, offset));
                int valueListOffset = MPPUtility.getInt(data, offset += 4);
                offset += 4;
                if (valueListOffset >= data.length) continue;
                int tempOffset = valueListOffset;
                int dataOffset = MPPUtility.getInt(data, tempOffset += 8) + valueListOffset;
                int endDataOffset = MPPUtility.getInt(data, tempOffset += 4) + valueListOffset;
                int endDescriptionOffset = MPPUtility.getInt(data, tempOffset += 4) + valueListOffset;
                int valuesLength = endDataOffset - dataOffset;
                byte[] values = new byte[valuesLength];
                MPPUtility.getByteArray(data, dataOffset, valuesLength, values, 0);
                int descriptionsLength = endDescriptionOffset - endDataOffset;
                byte[] descriptions = new byte[descriptionsLength];
                MPPUtility.getByteArray(data, endDataOffset, descriptionsLength, descriptions, 0);
                this.populateContainer(field, values, descriptions);
            }
        }
    }

    private void processOutlineCodeValues() throws IOException {
        DirectoryEntry outlineCodeDir = (DirectoryEntry)this.m_projectDir.getEntry("TBkndOutlCode");
        FixedMeta fm = new FixedMeta((InputStream)new DocumentInputStream((DocumentEntry)outlineCodeDir.getEntry("FixedMeta")), 10);
        FixedData fd = new FixedData(fm, (InputStream)new DocumentInputStream((DocumentEntry)outlineCodeDir.getEntry("FixedData")));
        HashMap<Integer, FieldType> map = new HashMap<Integer, FieldType>();
        int items = fm.getItemCount();
        for (int loop = 0; loop < items; ++loop) {
            byte[] data = fd.getByteArrayValue(loop);
            if (data.length < 18) continue;
            int index = MPPUtility.getShort(data, 0);
            int fieldID = MPPUtility.getInt(data, 12);
            FieldType fieldType = FieldTypeHelper.getInstance(fieldID);
            if (fieldType.getFieldTypeClass() == FieldTypeClass.UNKNOWN) continue;
            map.put(index, fieldType);
        }
        VarMeta9 outlineCodeVarMeta = new VarMeta9((InputStream)new DocumentInputStream((DocumentEntry)outlineCodeDir.getEntry("VarMeta")));
        Var2Data outlineCodeVarData = new Var2Data(outlineCodeVarMeta, (InputStream)new DocumentInputStream((DocumentEntry)outlineCodeDir.getEntry("Var2Data")));
        HashMap<FieldType, List> valueMap = new HashMap<FieldType, List>();
        for (Integer id : outlineCodeVarMeta.getUniqueIdentifierArray()) {
            FieldType fieldType = (FieldType)map.get(id);
            String value = outlineCodeVarData.getUnicodeString(id, VALUE);
            String description = outlineCodeVarData.getUnicodeString(id, DESCRIPTION);
            List list = valueMap.computeIfAbsent(fieldType, k -> new ArrayList());
            list.add(new Pair<String, String>(value, description));
        }
        for (Map.Entry entry : valueMap.entrySet()) {
            this.populateContainer((FieldType)entry.getKey(), (List)entry.getValue());
        }
    }

    private void populateContainer(FieldType field, byte[] values, byte[] descriptions) {
        CustomField config = this.m_container.getCustomField(field);
        CustomFieldLookupTable table = config.getLookupTable();
        String fieldTypeName = config.getFieldType().getName();
        table.setGUID(UUID.nameUUIDFromBytes(fieldTypeName.getBytes()));
        List<Object> descriptionList = this.convertType(DataType.STRING, descriptions);
        List<Object> valueList = this.convertType(field.getDataType(), values);
        CustomFieldValueDataType itemType = this.getDataType(field);
        for (int index = 0; index < descriptionList.size(); ++index) {
            CustomFieldValueItem item = new CustomFieldValueItem(++this.m_valueUniqueIDCounter);
            item.setDescription((String)descriptionList.get(index));
            item.setType(itemType);
            item.setGUID(UUID.nameUUIDFromBytes((fieldTypeName + item.getUniqueID()).getBytes()));
            if (index < valueList.size()) {
                item.setValue(valueList.get(index));
            }
            this.m_container.registerValue(item);
            table.add(item);
        }
    }

    private void populateContainer(FieldType field, List<Pair<String, String>> items) {
        CustomField config = this.m_container.getCustomField(field);
        CustomFieldLookupTable table = config.getLookupTable();
        String fieldTypeName = field == null ? "Unknown" : field.getName();
        table.setGUID(UUID.nameUUIDFromBytes(fieldTypeName.getBytes()));
        CustomFieldValueDataType itemType = this.getDataType(field);
        for (Pair<String, String> pair : items) {
            CustomFieldValueItem item = new CustomFieldValueItem(++this.m_valueUniqueIDCounter);
            item.setValue(pair.getFirst());
            item.setDescription(pair.getSecond());
            item.setType(itemType);
            item.setGUID(UUID.nameUUIDFromBytes((fieldTypeName + item.getUniqueID()).getBytes()));
            table.add(item);
        }
    }

    private List<Object> convertType(DataType type, byte[] data) {
        ArrayList<Object> result = new ArrayList<Object>();
        int index = 0;
        block8: while (index < data.length) {
            switch (type) {
                case STRING: {
                    Object value = MPPUtility.getUnicodeString(data, index);
                    result.add(value);
                    index += (((String)value).length() + 1) * 2;
                    continue block8;
                }
                case CURRENCY: {
                    Object value = MPPUtility.getDouble(data, index) / 100.0;
                    result.add(value);
                    index += 8;
                    continue block8;
                }
                case NUMERIC: {
                    Object value = MPPUtility.getDouble(data, index);
                    result.add(value);
                    index += 8;
                    continue block8;
                }
                case DATE: {
                    Object value = MPPUtility.getTimestamp(data, index);
                    result.add(value);
                    index += 4;
                    continue block8;
                }
                case DURATION: {
                    TimeUnit units = MPPUtility.getDurationTimeUnits(MPPUtility.getShort(data, index + 4), this.m_properties.getDefaultDurationUnits());
                    Duration value = MPPUtility.getAdjustedDuration(this.m_properties, MPPUtility.getInt(data, index), units);
                    result.add(value);
                    index += 6;
                    continue block8;
                }
                case BOOLEAN: {
                    Object value = MPPUtility.getShort(data, index) == 1;
                    result.add(value);
                    index += 2;
                    continue block8;
                }
            }
            index = data.length;
        }
        return result;
    }

    private CustomFieldValueDataType getDataType(FieldType field) {
        CustomFieldValueDataType result = null;
        if (field != null) {
            result = TYPE_MAP.get(field.getDataType());
        }
        if (result == null) {
            result = CustomFieldValueDataType.TEXT;
        }
        return result;
    }

    static {
        TYPE_MAP.put(DataType.STRING, CustomFieldValueDataType.TEXT);
        TYPE_MAP.put(DataType.CURRENCY, CustomFieldValueDataType.COST);
        TYPE_MAP.put(DataType.NUMERIC, CustomFieldValueDataType.NUMBER);
        TYPE_MAP.put(DataType.DATE, CustomFieldValueDataType.DATE);
        TYPE_MAP.put(DataType.DURATION, CustomFieldValueDataType.DURATION);
        TYPE_MAP.put(DataType.BOOLEAN, CustomFieldValueDataType.FLAG);
    }
}

