/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.io.InputStream;
import java.util.TreeMap;
import net.sf.mpxj.Day;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.Rate;
import net.sf.mpxj.ScheduleFrom;
import net.sf.mpxj.TaskType;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.mpp.Props;
import org.apache.poi.hpsf.CustomProperties;
import org.apache.poi.hpsf.CustomProperty;
import org.apache.poi.hpsf.DocumentSummaryInformation;
import org.apache.poi.hpsf.PropertySet;
import org.apache.poi.hpsf.SummaryInformation;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;

public final class ProjectPropertiesReader {
    public void process(ProjectFile file, Props props, DirectoryEntry rootDir) throws MPXJException {
        try {
            ProjectProperties ph = file.getProjectProperties();
            ph.setStartDate(props.getTimestamp(Props.PROJECT_START_DATE));
            ph.setFinishDate(props.getTimestamp(Props.PROJECT_FINISH_DATE));
            ph.setScheduleFrom(ScheduleFrom.getInstance(1 - props.getShort(Props.SCHEDULE_FROM)));
            ph.setDefaultStartTime(props.getTime(Props.START_TIME));
            ph.setDefaultEndTime(props.getTime(Props.END_TIME));
            ph.setStatusDate(props.getTimestamp(Props.STATUS_DATE));
            ph.setHyperlinkBase(props.getUnicodeString(Props.HYPERLINK_BASE));
            ph.setDefaultDurationUnits(MPPUtility.getDurationTimeUnits(props.getShort(Props.DURATION_UNITS)));
            ph.setMinutesPerDay(props.getInt(Props.MINUTES_PER_DAY));
            ph.setMinutesPerWeek(props.getInt(Props.MINUTES_PER_WEEK));
            ph.setDefaultOvertimeRate(new Rate(props.getDouble(Props.OVERTIME_RATE), TimeUnit.HOURS));
            ph.setDefaultStandardRate(new Rate(props.getDouble(Props.STANDARD_RATE), TimeUnit.HOURS));
            ph.setDefaultWorkUnits(MPPUtility.getWorkTimeUnits(props.getShort(Props.WORK_UNITS)));
            ph.setSplitInProgressTasks(props.getBoolean(Props.SPLIT_TASKS));
            ph.setUpdatingTaskStatusUpdatesResourceStatus(props.getBoolean(Props.TASK_UPDATES_RESOURCE));
            ph.setCriticalSlackLimit(props.getInt(Props.CRITICAL_SLACK_LIMIT));
            ph.setCurrencyDigits(props.getShort(Props.CURRENCY_DIGITS));
            ph.setCurrencySymbol(props.getUnicodeString(Props.CURRENCY_SYMBOL));
            ph.setCurrencyCode(props.getUnicodeString(Props.CURRENCY_CODE));
            ph.setDefaultTaskType(TaskType.getInstance(props.getShort(Props.DEFAULT_TASK_TYPE)));
            ph.setSymbolPosition(MPPUtility.getSymbolPosition(props.getShort(Props.CURRENCY_PLACEMENT)));
            ph.setWeekStartDay(Day.getInstance(props.getShort(Props.WEEK_START_DAY) + 1));
            ph.setFiscalYearStartMonth(props.getShort(Props.FISCAL_YEAR_START_MONTH));
            ph.setFiscalYearStart(props.getShort(Props.FISCAL_YEAR_START) == 1);
            ph.setDaysPerMonth(props.getShort(Props.DAYS_PER_MONTH));
            ph.setEditableActualCosts(props.getBoolean(Props.EDITABLE_ACTUAL_COSTS));
            ph.setHonorConstraints(!props.getBoolean(Props.HONOR_CONSTRAINTS));
            PropertySet ps = new PropertySet((InputStream)new DocumentInputStream((DocumentEntry)rootDir.getEntry("\u0005SummaryInformation")));
            SummaryInformation summaryInformation = new SummaryInformation(ps);
            ph.setProjectTitle(summaryInformation.getTitle());
            ph.setSubject(summaryInformation.getSubject());
            ph.setAuthor(summaryInformation.getAuthor());
            ph.setKeywords(summaryInformation.getKeywords());
            ph.setComments(summaryInformation.getComments());
            ph.setTemplate(summaryInformation.getTemplate());
            ph.setLastAuthor(summaryInformation.getLastAuthor());
            ph.setRevision(NumberHelper.parseInteger(summaryInformation.getRevNumber()));
            ph.setCreationDate(summaryInformation.getCreateDateTime());
            ph.setLastSaved(summaryInformation.getLastSaveDateTime());
            ph.setShortApplicationName(summaryInformation.getApplicationName());
            ph.setEditingTime((int)summaryInformation.getEditTime());
            ph.setLastPrinted(summaryInformation.getLastPrinted());
            try {
                ps = new PropertySet((InputStream)new DocumentInputStream((DocumentEntry)rootDir.getEntry("\u0005DocumentSummaryInformation")));
            }
            catch (RuntimeException ex) {
                ps = null;
            }
            DocumentSummaryInformation documentSummaryInformation = ps == null ? new DocumentSummaryInformation() : new DocumentSummaryInformation(ps);
            ph.setCategory(documentSummaryInformation.getCategory());
            ph.setPresentationFormat(documentSummaryInformation.getPresentationFormat());
            ph.setManager(documentSummaryInformation.getManager());
            ph.setCompany(documentSummaryInformation.getCompany());
            ph.setContentType(documentSummaryInformation.getContentType());
            ph.setContentStatus(documentSummaryInformation.getContentStatus());
            ph.setLanguage(documentSummaryInformation.getLanguage());
            ph.setDocumentVersion(documentSummaryInformation.getDocumentVersion());
            TreeMap<String, Object> customPropertiesMap = new TreeMap<String, Object>();
            CustomProperties customProperties = documentSummaryInformation.getCustomProperties();
            if (customProperties != null) {
                for (CustomProperty property : customProperties.properties()) {
                    customPropertiesMap.put(property.getName(), property.getValue());
                }
            }
            ph.setCustomProperties(customPropertiesMap);
            ph.setMultipleCriticalPaths(props.getBoolean(Props.MULTIPLE_CRITICAL_PATHS));
            ph.setBaselineDate(props.getTimestamp(Props.BASELINE_DATE));
            ph.setBaselineDate(1, props.getTimestamp(Props.BASELINE1_DATE));
            ph.setBaselineDate(2, props.getTimestamp(Props.BASELINE2_DATE));
            ph.setBaselineDate(3, props.getTimestamp(Props.BASELINE3_DATE));
            ph.setBaselineDate(4, props.getTimestamp(Props.BASELINE4_DATE));
            ph.setBaselineDate(5, props.getTimestamp(Props.BASELINE5_DATE));
            ph.setBaselineDate(6, props.getTimestamp(Props.BASELINE6_DATE));
            ph.setBaselineDate(7, props.getTimestamp(Props.BASELINE7_DATE));
            ph.setBaselineDate(8, props.getTimestamp(Props.BASELINE8_DATE));
            ph.setBaselineDate(9, props.getTimestamp(Props.BASELINE9_DATE));
            ph.setBaselineDate(10, props.getTimestamp(Props.BASELINE10_DATE));
            ph.setNewTasksAreManual(props.getBoolean(Props.NEW_TASKS_ARE_MANUAL));
        }
        catch (Exception ex) {
            throw new MPXJException("Error reading file", ex);
        }
    }
}

