/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpx;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.mpx.LocaleData;
import net.sf.mpxj.mpx.MPXTaskField;
import net.sf.mpxj.mpx.ModelUtility;
import net.sf.mpxj.mpx.Record;

final class TaskModel {
    private final ProjectFile m_parentFile;
    private final boolean[] m_flags = new boolean[153];
    private final int[] m_fields = new int[154];
    private int m_count;
    private String[] m_taskNames;
    private final HashMap<String, Integer> m_taskNumbers = new HashMap();

    TaskModel(ProjectFile file, Locale locale) {
        this.m_parentFile = file;
        this.setLocale(locale);
    }

    void setLocale(Locale locale) {
        this.m_taskNames = LocaleData.getStringArray(locale, "TASK_NAMES");
        this.m_taskNumbers.clear();
        for (int loop = 0; loop < this.m_taskNames.length; ++loop) {
            String name = this.m_taskNames[loop];
            if (name == null) continue;
            this.m_taskNumbers.put(name, loop);
        }
    }

    public int[] getModel() {
        this.m_fields[this.m_count] = -1;
        return this.m_fields;
    }

    public void update(Record record, boolean isText) throws MPXJException {
        int length = record.getLength();
        for (int i = 0; i < length; ++i) {
            if (isText) {
                this.add(this.getTaskCode(record.getString(i)));
                continue;
            }
            this.add(record.getInteger(i));
        }
    }

    private void add(int field) {
        if (field < this.m_flags.length && !this.m_flags[field]) {
            this.m_flags[field] = true;
            this.m_fields[this.m_count] = field;
            ++this.m_count;
        }
    }

    private void populateModel() {
        if (this.m_count != 0) {
            this.m_count = 0;
            Arrays.fill(this.m_flags, false);
        }
        for (Task task : this.m_parentFile.getTasks()) {
            for (int loop = 0; loop < 153; ++loop) {
                if (this.m_flags[loop] || !this.isFieldPopulated(task, MPXTaskField.getMpxjField(loop))) continue;
                this.m_flags[loop] = true;
                this.m_fields[this.m_count] = loop;
                ++this.m_count;
            }
        }
        Arrays.sort(this.m_fields);
        System.arraycopy(this.m_fields, this.m_fields.length - this.m_count, this.m_fields, 0, this.m_count);
    }

    private boolean isFieldPopulated(Task task, TaskField field) {
        boolean result = false;
        if (field != null) {
            Object value = task.getCurrentValue(field);
            switch (field) {
                case NOTES: 
                case SUCCESSORS: {
                    result = false;
                    break;
                }
                case PREDECESSORS: {
                    result = value != null && !((List)value).isEmpty();
                    break;
                }
                default: {
                    result = ModelUtility.isFieldPopulated(field, value);
                }
            }
        }
        return result;
    }

    public String toString() {
        this.populateModel();
        char delimiter = this.m_parentFile.getProjectProperties().getMpxDelimiter();
        StringBuilder textual = new StringBuilder();
        StringBuilder numeric = new StringBuilder();
        textual.append(60);
        numeric.append(61);
        for (int loop = 0; loop < this.m_count; ++loop) {
            int number = this.m_fields[loop];
            textual.append(delimiter);
            numeric.append(delimiter);
            textual.append(this.getTaskField(number));
            numeric.append(number);
        }
        textual.append("\r\n");
        numeric.append("\r\n");
        textual.append((CharSequence)numeric);
        return textual.toString();
    }

    private String getTaskField(int key) {
        String result = null;
        if (key > 0 && key < this.m_taskNames.length) {
            result = this.m_taskNames[key];
        }
        return result;
    }

    private int getTaskCode(String field) throws MPXJException {
        Integer result = this.m_taskNumbers.get(field.trim());
        if (result == null) {
            throw new MPXJException("Invalid task field name " + field);
        }
        return result;
    }
}

