/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.utility.clean;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.mpxj.utility.clean.CleanStrategy;

public class CleanByReplacementStrategy
implements CleanStrategy {
    private final Map<String, String> m_words = new HashMap<String, String>();
    private final Map<Integer, List<String>> m_dictionary = new HashMap<Integer, List<String>>();
    private final Random m_random = new Random(8118055L);
    private static final int MIN_WORD_LENGTH = 3;
    private static final Pattern WORD_PATTERN = Pattern.compile("(\\w+)");

    public CleanByReplacementStrategy() {
        this.loadDictionary();
    }

    @Override
    public String generateReplacementText(String oldText) {
        StringBuilder sb = new StringBuilder(oldText);
        Matcher matcher = WORD_PATTERN.matcher(oldText);
        while (matcher.find()) {
            String word = matcher.group(1);
            if (word.length() <= 3 || !this.isNotNumeric(word)) continue;
            String replacement = this.m_words.computeIfAbsent(word, this::generateReplacementWord);
            int end = matcher.end();
            sb.replace(matcher.start(), end, this.matchCase(word, replacement));
        }
        return sb.toString();
    }

    private boolean isNotNumeric(String word) {
        try {
            Double.parseDouble(word);
            return false;
        }
        catch (Exception ex) {
            return true;
        }
    }

    private String generateReplacementWord(String word) {
        int wordIndex;
        String replacement;
        Integer key = word.length();
        List<String> words = this.m_dictionary.get(key);
        while ((replacement = words.get(wordIndex = this.m_random.nextInt(words.size() - 1))).equalsIgnoreCase(word)) {
        }
        return replacement;
    }

    private String matchCase(String oldWord, String newWord) {
        StringBuilder sb = new StringBuilder(newWord);
        for (int index = 0; index < oldWord.length(); ++index) {
            if (!Character.isUpperCase(oldWord.charAt(index))) continue;
            sb.setCharAt(index, Character.toUpperCase(sb.charAt(index)));
        }
        return sb.toString();
    }

    private void loadDictionary() {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("net/sf/mpxj/utility/clean/words.txt")));){
            while (reader.ready()) {
                this.processWord(reader.readLine());
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void processWord(String word) {
        this.m_dictionary.computeIfAbsent(word.length(), ArrayList::new).add(word);
    }
}

