# This file has been autogenerated by the pywayland scanner

# Copyright © 2008-2011 Kristian Høgsberg
# Copyright © 2010-2011 Intel Corporation
# Copyright © 2012-2013 Collabora, Ltd.
#
# Permission is hereby granted, free of charge, to any person
# obtaining a copy of this software and associated documentation files
# (the "Software"), to deal in the Software without restriction,
# including without limitation the rights to use, copy, modify, merge,
# publish, distribute, sublicense, and/or sell copies of the Software,
# and to permit persons to whom the Software is furnished to do so,
# subject to the following conditions:
#
# The above copyright notice and this permission notice (including the
# next paragraph) shall be included in all copies or substantial
# portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
# BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
# ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
# CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

import enum

from pywayland.protocol_core import Argument, ArgumentType, Global, Interface, Proxy, Resource
from .wl_data_device import WlDataDevice
from .wl_data_source import WlDataSource
from .wl_seat import WlSeat


class WlDataDeviceManager(Interface):
    """Data transfer interface

    The :class:`WlDataDeviceManager` is a singleton global object that provides
    access to inter-client data transfer mechanisms such as copy-and-paste and
    drag-and-drop.  These mechanisms are tied to a
    :class:`~pywayland.protocol.wayland.WlSeat` and this interface lets a
    client get a :class:`~pywayland.protocol.wayland.WlDataDevice`
    corresponding to a :class:`~pywayland.protocol.wayland.WlSeat`.

    Depending on the version bound, the objects created from the bound
    :class:`WlDataDeviceManager` object will have different requirements for
    functioning properly. See :func:`WlDataSource.set_actions()
    <pywayland.protocol.wayland.WlDataSource.set_actions>`,
    :func:`WlDataOffer.accept()
    <pywayland.protocol.wayland.WlDataOffer.accept>` and
    :func:`WlDataOffer.finish()
    <pywayland.protocol.wayland.WlDataOffer.finish>` for details.
    """

    name = "wl_data_device_manager"
    version = 3

    class dnd_action(enum.IntFlag):
        none = 0
        copy = 1
        move = 2
        ask = 4


class WlDataDeviceManagerProxy(Proxy):
    interface = WlDataDeviceManager

    @WlDataDeviceManager.request(
        Argument(ArgumentType.NewId, interface=WlDataSource),
    )
    def create_data_source(self):
        """Create a new data source

        Create a new data source.

        :returns:
            :class:`~pywayland.protocol.wayland.WlDataSource` -- data source to
            create
        """
        id = self._marshal_constructor(0, WlDataSource)
        return id

    @WlDataDeviceManager.request(
        Argument(ArgumentType.NewId, interface=WlDataDevice),
        Argument(ArgumentType.Object, interface=WlSeat),
    )
    def get_data_device(self, seat):
        """Create a new data device

        Create a new data device for a given seat.

        :param seat:
            seat associated with the data device
        :type seat:
            :class:`~pywayland.protocol.wayland.WlSeat`
        :returns:
            :class:`~pywayland.protocol.wayland.WlDataDevice` -- data device to
            create
        """
        id = self._marshal_constructor(1, WlDataDevice, seat)
        return id


class WlDataDeviceManagerResource(Resource):
    interface = WlDataDeviceManager


class WlDataDeviceManagerGlobal(Global):
    interface = WlDataDeviceManager


WlDataDeviceManager._gen_c()
WlDataDeviceManager.proxy_class = WlDataDeviceManagerProxy
WlDataDeviceManager.resource_class = WlDataDeviceManagerResource
WlDataDeviceManager.global_class = WlDataDeviceManagerGlobal
